//
//  WCTLoginTextFieldButtonTableViewCell.m
//  
//
//  Created by Howard on 2016/8/11.
//
//

#import "WCTPasswordTableViewCell.h"

#import "WCTLoginViewController+ResourceDefine.h"
#import "WCTLoginViewController+ParameterDefine.h"
#import "UIView+Appearance.h"

static NSString * const ImageNameButtonShowPassword  = @"WCTLoginViewControllerButtonShowPassword";
static NSString * const ImageNameButtonHidePassword  = @"WCTLoginViewControllerButtonHidePassword";

typedef NS_ENUM(NSUInteger, WCTPasswordTableViewCellTag)
{
    WCTPasswordTableViewCellTag_Hide,
    WCTPasswordTableViewCellTag_Show,
};


//////////////////////////////////////////////////
@interface WCTPasswordTableViewCell () <PPButtonDelegate>
//@property (nonatomic, assign) BOOL showPassword;
@end


@implementation WCTPasswordTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.backgroundColor                  = [UIColor clearColor];

//        self.showPassword = NO;
        
        _textFieldButtonView = [[PPTextFieldButtonView alloc] init];
        
        if(_textFieldButtonView!=nil)
        {
            _textFieldButtonView.ppButtonDetail.delegate = self;
            
            // button state
            _textFieldButtonView.ppButtonDetail.tag = WCTPasswordTableViewCellTag_Hide;
            [_textFieldButtonView.ppButtonDetail setImageWithName:ImageNameButtonShowPassword];
            _textFieldButtonView.textField.secureTextEntry = YES;
            _textFieldButtonView.textField.keyboardType = UIKeyboardTypeASCIICapable;
            _textFieldButtonView.textField.textContentType = @"";
            if (@available(iOS 12.0, *)) {
            } else {
                // Fallback on earlier versions
                _textFieldButtonView.textField.textContentType = @"";
            }

            [_textFieldButtonView setBorderColor:WCTLVC_TextFieldBorderColor];
            [_textFieldButtonView setBorderWidth:1.0];
            
            
            _textFieldButtonView.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
            _textFieldButtonView.textField.textColor = WCTLVC_TextFieldTextColor;
            _textFieldButtonView.textField.text = @"";
            //////////////////////////////////////////////////
            [self.contentView addSubview:_textFieldButtonView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_textFieldButtonView release];
    _textFieldButtonView = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of subView

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    _textFieldButtonView.frame = CGRectMake(self.textFieldButtoViewContentInset.left,
                                            self.textFieldButtoViewContentInset.top,
                                            self.contentView.bounds.size.width-self.textFieldButtoViewContentInset.left-self.textFieldButtoViewContentInset.right,
                                            self.contentView.bounds.size.height-self.textFieldButtoViewContentInset.top-self.textFieldButtoViewContentInset.bottom);
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    _textFieldButtonView.textField.keyboardType = UIKeyboardTypeASCIICapable;
    if (@available(iOS 12.0, *)) {
        _textFieldButtonView.textField.textContentType = @"";
    } else {
        // Fallback on earlier versions
        _textFieldButtonView.textField.textContentType = @"";
    }

    if(ppButton.tag==WCTPasswordTableViewCellTag_Hide)
    {
        self.textFieldButtonView.textField.secureTextEntry = NO;
        self.textFieldButtonView.ppButtonDetail.tag = WCTPasswordTableViewCellTag_Show;
        [self.textFieldButtonView.ppButtonDetail setImageWithName:ImageNameButtonHidePassword];
        self.textFieldButtonView.textField.keyboardType = UIKeyboardTypeASCIICapable;
    }
    else
    {
        self.textFieldButtonView.textField.secureTextEntry = YES;
        self.textFieldButtonView.ppButtonDetail.tag = WCTPasswordTableViewCellTag_Hide;
        [self.textFieldButtonView.ppButtonDetail setImageWithName:ImageNameButtonShowPassword];
        self.textFieldButtonView.textField.keyboardType = UIKeyboardTypeASCIICapable;
    }
    
    [self.textFieldButtonView layoutSubviews];
}


@end
