//
//  WCTLoginViewController.m
//
//
//  Created by Howard on 16/3/28.
//  Copyright (c) 2016年 penpower. All rights reserved.
//

#import "TSMCRegisterViewController.h"

// Define
#import "WCTLoginController+ParameterDefine.h"
#import "WCTLoginController+ResourceDefine.h"
#import "WCTRestClientController+SettingsKey.h"
#import "WCTRestClientController+ParameterDefine.h"
#import "WCTRestClient+ParameterDefine.h"
#import "ResourceDefine.h"
#import "TSMCRegisterViewController+ResourceDefine.h"

// Controller
#import "PPAlertController.h"
#import "PPNetworkReachabilityController.h"
#import "PPNavigationController.h"
#import "WCTRestClientController.h"
#import "WCToastController.h"
#import "WCTLoginController.h"

// View
#import "WCTLoginTextFieldButtonTableViewCell.h"
#import "WCTPasswordTableViewCell.h"

// Category
#import "NSData+AES256.h"
#import "NSString+Additions.h"
#import "UIColor+PropertyDictionary.h"
#import "PPButton+Factory.h"
#import "WCTSettingsKey.h"
#import "NSObject+PPBusyView.h"
#import "WCTRestClientController+Password.h"
#import "WCTRestClientController+Version.h"
#import "NSDate+Format.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, TSMCRegisterViewController_Section_Login_Row)
{
    TSMCRegisterViewController_Section_Login_Row_User,
    TSMCRegisterViewController_Section_Login_Row_Name,
    TSMCRegisterViewController_Section_Login_Row_Password,
    TSMCRegisterViewController_Section_Login_Row_ConfirmPassword,
};

typedef NS_ENUM(NSUInteger, TSMCRegisterViewButtonTag)
{
    TSMCRegisterViewButtonTag_Cancel=0,
    TSMCRegisterViewButtonTag_Create,
};

#define TSMCRegisterViewController_MaxLength 32

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTLoginViewController()

@interface TSMCRegisterViewController ()
<
CustomRectTextFieldDataSource,
PPTextFieldButtonViewDelegate
>

@property(nonatomic,readwrite)        PPSectionController     *ppSectionController;
@property(nonatomic,retain)           NSOperationQueue        *operationQueue;
@property(nonatomic,retain, readwrite)           PPButton                *ppButtonCreate;
@property(nonatomic,retain, readwrite)           PPButton                *ppButtonBack;
@property(nonatomic,retain)           UILabel                 *titleLabel;
@property(nonatomic,retain)           UILabel                 *versionLabel;
@property(nonatomic,retain)           UIImageView             *contentBackgroundImageView;
@property(nonatomic,retain, readwrite)           UIImageView             *logoImageView;
@property(nonatomic,retain, readwrite)           UIView                  *tableHeaderView;
@property(nonatomic,retain, readwrite)           UIView                  *tableFooterView;
@property(nonatomic,retain)           NSIndexPath             *selectedIndexPath;
@property(nonatomic,assign)           BOOL                    secureTextEntry;
@property(nonatomic,retain)           NSDictionary            *errorDictionaries;
@property(nonatomic,assign)           WCTLC_ChangePasswordReason changePasswordReason;

@property(nonatomic,copy)             TripleClickBlock tripleClickBlock;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation TSMCRegisterViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    id object = nil;
    
    if((self=[super init]))
    {
        //////////////////////////////////////////////////
        
        self.view.backgroundColor = [UIColor whiteColor];
        self.ppTableView.tag = WCTLoginViewControllerTableViewTag_LoginForm;

        //////////////////////////////////////////////////
        
        @autoreleasepool
        {
            do
            {
                _operationQueue = [[NSOperationQueue alloc] init];
                if(_operationQueue==nil)
                {
                    break;
                }
                
                [_operationQueue setMaxConcurrentOperationCount:1];
                
                //////////////////////////////////////////////////
                
                _ppSectionController = [[PPSectionController alloc] init];
                if(_ppSectionController==nil)
                {
                    break;
                }

                //////////////////////////////////////////////////
                
                object = self;
                
            }while(0);
            
            //////////////////////////////////////////////////
            
            
            if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
            {
                self.view.backgroundColor = WCTLVC_IPadBackgroundColor;
            }
            
            //////////////////////////////////////////////////
            
            if(object==nil)
            {
                [self release];
            }
        }
    }
    
    return object;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.tripleClickBlock = nil;
    self.registerHandler = nil;
    self.errorMessageHandler = nil;
    //////////////////////////////////////////////////
    
    if(_ppSectionController!=nil)
    {
        [_ppSectionController release];
        _ppSectionController = nil;
    }
    
    //////////////////////////////////////////////////
    
    if(_selectedIndexPath==nil)
    {
        [_selectedIndexPath release];
        _selectedIndexPath = nil;
    }
    
    self.versionString = nil;
    
    //////////////////////////////////////////////////
  
    [_ppButtonCreate release];
    _ppButtonCreate = nil;
    
    [_ppButtonBack release];
    _ppButtonBack = nil;

    [_versionLabel release];
    _versionLabel = nil;

    [_titleLabel release];
    _titleLabel = nil;

    [_contentBackgroundImageView release];
    _contentBackgroundImageView = nil;

    
    [_logoImageView release];
    _logoImageView = nil;
    
    [_tableHeaderView release];
    _tableHeaderView = nil;
    
    [_tableFooterView release];
    _tableFooterView = nil;
    
    [_selectedIndexPath release];
    _selectedIndexPath = nil;
    
    //////////////////////////////////////////////////

    self.errorDictionaries = nil;
    
    //////////////////////////////////////////////////
    
    if(_operationQueue!=nil)
    {
        @synchronized(_operationQueue)
        {
            if([_operationQueue operationCount]>0)
            {
                [_operationQueue cancelAllOperations];
            }
        }
        
        [_operationQueue release];
        _operationQueue = nil;
    }
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    self.singleTapResignFirstResponderEnable = YES;
    
    //////////////////////////////////////////////////
    
    @autoreleasepool
    {
        NSArray *rowModels = [self rowModelsForAccount];
        
        if(rowModels!=nil)
        {
            [self.ppSectionController.sectionModelsForDefault removeAllObjects];
            
            [self.ppSectionController.sectionModelsForDefault addObject:[PPSectionModel sectionModelWithSection:WCTLoginViewController_Section_Login
                                                                                                          title:@""
                                                                                              rowModels:rowModels]];
        }

        //////////////////////////////////////////////////
        
        if(self.backgroundImageView!=nil)
        {
            UIImage *headImage = [UIImage imageWithName:ImageNameWCTLoginViewControllerHeaderBackground];
            
            //////////////////////////////////////////////////
            
            self.logoImageView = [[[UIImageView alloc] initWithImage:headImage] autorelease];
            
            if(self.logoImageView!=nil)
            {
                self.logoImageView.backgroundColor  = [UIColor clearColor];
                self.logoImageView.contentMode      = UIViewContentModeScaleAspectFit;
                
                [self.view addSubview:self.logoImageView];
                
                

                //////////////////////////////////////////////////
                
                _versionLabel = [[UILabel alloc] init];
                
                if(_versionLabel!=nil)
                {
                    [_versionLabel setTextColor:[UIColor whiteColor]];
                }
                
                if(self.versionLabel!=nil)
                {
                    [self.logoImageView addSubview:self.versionLabel];
                }
            }
        }
        
        //////////////////////////////////////////////////
        
        if(self.ppTableView!=nil)
        {
            self.ppTableView.alwaysBounceHorizontal    = NO;
            self.ppTableView.alwaysBounceVertical   = NO;
            self.ppTableView.backgroundColor        = [UIColor clearColor];
            self.ppTableView.dataSource             = self;
            self.ppTableView.delegate               = self;
            self.ppTableView.separatorStyle         = UITableViewCellSeparatorStyleNone;
            [self.view addSubview:self.ppTableView];
            
            //////////////////////////////////////////////////
            
            self.tableHeaderView = [[[UIView alloc] init] autorelease];
            if(self.tableHeaderView!=nil)
            {
                self.titleLabel = [[[UILabel alloc] initWithFrame:CGRectZero] autorelease];
                
                [self.titleLabel setTextColor:WCTLVC_LoginButton_NormalBackgroundColor];
                self.titleLabel.text = TSMCRegisterView_MLS_RegisterAccount;
                [self.titleLabel setFont:[UIFont systemFontOfSize:20]];
                [self.tableHeaderView addSubview:self.titleLabel];
                
                self.ppTableView.tableHeaderView  = self.tableHeaderView;
            }
            
            self.tableFooterView = [[[UIView alloc] init] autorelease];
            
            if(self.tableFooterView!=nil)
            {
                self.ppButtonCreate = [[[PPButton alloc] initWithFrame:UIButtonAdditions_LargeRect] autorelease];
                
                if(self.ppButtonCreate!=nil)
                {
                    self.ppButtonCreate.delegate = self;
                    self.ppButtonCreate.tag      = TSMCRegisterViewButtonTag_Create;
                    
                    [self.ppButtonCreate addControlEvents:UIControlEventTouchUpInside];
                    [self.ppButtonCreate setTitle:TSMCRegisterView_MLS_Create maxWidth:UIButtonAdditions_DefaultMaxWidth];
                    
                    //////////////////////////////////////////////////
                    
                    [self.ppButtonCreate setBackgroundImage:[UIImage imageWithColor:WCTLVC_LoginButton_NormalBackgroundColor]
                                                  forState:UIControlStateNormal];
                    
                    [self.ppButtonCreate setBackgroundImage:[UIImage imageWithColor:WCTLVC_LoginButton_HighlightedBackgroundColor]
                                                  forState:UIControlStateHighlighted];
                    
                    [self.ppButtonCreate setTitleColor:WCTLVC_LoginButton_NormalTextColor forState:UIControlStateNormal];
                    [self.ppButtonCreate setTitleColor:WCTLVC_LoginButton_HighlightedTextColor forState:UIControlStateHighlighted];
                    
                    self.ppButtonCreate.titleLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerLoginButtonFontSize];
                    
                    //////////////////////////////////////////////////
                    
                    [self.tableFooterView addSubview:self.ppButtonCreate];
                }
                
                //////////////////////////////////////////////////
                ///
                self.ppButtonBack = [[[PPButton alloc] initWithFrame:UIButtonAdditions_LargeRect] autorelease];
                
                if(self.ppButtonBack!=nil)
                {
                    self.ppButtonBack.delegate = self;
                    self.ppButtonBack.tag      = TSMCRegisterViewButtonTag_Cancel;
                    
                    [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
                    [self.ppButtonBack setTitle:Common_Cancel maxWidth:UIButtonAdditions_DefaultMaxWidth];
                    
                    //////////////////////////////////////////////////
                    
                    [self.ppButtonBack setBackgroundImage:[UIImage imageWithColor:WCTLVC_LoginButton_NormalBackgroundColor]
                                                  forState:UIControlStateNormal];
                    
                    [self.ppButtonBack setBackgroundImage:[UIImage imageWithColor:WCTLVC_LoginButton_HighlightedBackgroundColor]
                                                  forState:UIControlStateHighlighted];
                    
                    [self.ppButtonBack setTitleColor:WCTLVC_LoginButton_NormalTextColor forState:UIControlStateNormal];
                    [self.ppButtonBack setTitleColor:WCTLVC_LoginButton_HighlightedTextColor forState:UIControlStateHighlighted];
                    
                    self.ppButtonBack.titleLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerLoginButtonFontSize];
                    
                    //////////////////////////////////////////////////
                    
                    [self.tableFooterView addSubview:self.ppButtonBack];
                }
                //////////////////////////////////////////////////
                
                self.ppTableView.tableFooterView  = self.tableFooterView;
            }
            
        }
        
        //////////////////////////////////////////////////
        self.versionLabel.text = self.versionString;

        //////////////////////////////////////////////////
        // !! ios 12這個要放在最後做，不然會先做layoutSubView, 造成layout錯誤
        if(self.navigationController!=nil)
        {
            self.navigationController.navigationBarHidden = YES;
        }
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
 
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [self.ppButtonCreate setDelegate:nil];
    [self.ppButtonCreate removeControlEvents:UIControlEventTouchUpInside];
    [self.ppButtonCreate removeFromSuperview];
    self.ppButtonCreate = nil;
    
    [self.ppButtonBack setDelegate:nil];
    [self.ppButtonBack removeControlEvents:UIControlEventTouchUpInside];
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack = nil;
  
    self.tableFooterView = nil;
    self.tableHeaderView = nil;
    
    [self.titleLabel removeFromSuperview];
    self.titleLabel = nil;
    
    [self.contentBackgroundImageView removeFromSuperview];
    self.contentBackgroundImageView = nil;
    
    [self.logoImageView removeFromSuperview];
    self.logoImageView = nil;
    
    [self.versionLabel removeFromSuperview];
    self.versionLabel = nil;
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}


//================================================================================
//
//================================================================================
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    //////////////////////////////////////////////////

}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    
    [self layoutSubviews];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overriding Methods

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    CGRect viewBounds = CGRectMake(0,
                                   0,
                                   MIN(self.view.bounds.size.width, self.view.bounds.size.height),
                                   MAX(self.view.bounds.size.width, self.view.bounds.size.height));
    CGRect logoImageViewFrame = CGRectZero;
    
    if(self.logoImageView!=nil)
    {
        logoImageViewFrame.size.height  = viewBounds.size.width*(self.logoImageView.image.size.height/self.logoImageView.image.size.width);
        
        logoImageViewFrame.size.width   = viewBounds.size.width;
        
        self.logoImageView.frame = logoImageViewFrame;
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppTableView!=nil)
    {
        CGRect ppTableViewFrame = self.ppTableView.frame;
        
        ppTableViewFrame.size.width = viewBounds.size.width-WCTLoginViewControllerTableViewEdgeInsets.left-WCTLoginViewControllerTableViewEdgeInsets.right;
        
        ppTableViewFrame.origin.x   = WCTLoginViewControllerTableViewEdgeInsets.left;
        ppTableViewFrame.origin.y   = CGRectGetMaxY(logoImageViewFrame)+WCTLoginViewControllerTableViewEdgeInsets.top;
        
        if (@available(iOS 11.0, *)) {
            ppTableViewFrame.size.height = viewBounds.size.height-CGRectGetMaxY(logoImageViewFrame)-WCTLoginViewControllerTableViewEdgeInsets.bottom-WCTLoginViewControllerLoginButtonHeight-self.view.safeAreaInsets.top-self.view.safeAreaInsets.bottom;
        } else {
               ppTableViewFrame.size.height = viewBounds.size.height-CGRectGetMaxY(logoImageViewFrame)-WCTLoginViewControllerTableViewEdgeInsets.bottom-WCTLoginViewControllerLoginButtonHeight;
        }
        
        self.ppTableView.frame = ppTableViewFrame;
    }
    
    //////////////////////////////////////////////////
    
    if(self.contentBackgroundImageView!=nil)
    {
        CGRect contentBackgroundImageViewFrame = CGRectZero;
        
        contentBackgroundImageViewFrame.origin.y     = CGRectGetMaxY(self.logoImageView.frame);
        contentBackgroundImageViewFrame.size.width   = self.contentBackgroundImageView.superview.bounds.size.width;
        contentBackgroundImageViewFrame.size.height  = self.ppTableView.bounds.size.height;
        
        self.contentBackgroundImageView.frame = contentBackgroundImageViewFrame;
    }
    //////////////////////////////////////////////////
    
    if(self.tableFooterView!=nil)
    {

        self.tableHeaderView.bounds = CGRectMake(0,
                                                 0,
                                                 self.ppTableView.bounds.size.width,
                                                 WCTLoginViewControllerLoginButtonHeight);
        
        self.ppTableView.tableHeaderView = self.tableHeaderView;
        
        //////////////////////////////////////////////////
        
        self.titleLabel.frame = CGRectMake(PPTableViewCellDefaultHorizontalGap,
                                           (self.tableHeaderView.bounds.size.height-WCTLoginViewControllerLoginButtonHeight)/2,
                                           self.tableHeaderView.bounds.size.width,
                                           WCTLoginViewControllerLoginButtonHeight);
    }

    //////////////////////////////////////////////////
    
    if(self.tableFooterView!=nil)
    {
        self.tableFooterView.bounds = CGRectMake(0,
                                                 0,
                                                 self.ppTableView.bounds.size.width,
                                                 WCTLoginViewControllerLoginButtonHeight+WCTLoginViewControllerForgetPasswordButtonHeight);
        
        self.ppTableView.tableFooterView = self.tableFooterView;
        
        //////////////////////////////////////////////////
        
        if(self.ppButtonBack!=nil)
        {
            self.ppButtonBack.frame = CGRectMake(PPTableViewCellDefaultHorizontalGap,
                                                 0,
                                                 (self.ppTableView.bounds.size.width-PPTableViewCellDefaultHorizontalGap*3)/2,
                                                 WCTLoginViewControllerLoginButtonHeight);
        }
        
        if(self.ppButtonCreate!=nil)
        {
            self.ppButtonCreate.frame = CGRectMake(CGRectGetMaxX(self.ppButtonBack.frame)+PPTableViewCellDefaultHorizontalGap,
                                                   0,
                                                   (self.ppTableView.bounds.size.width-PPTableViewCellDefaultHorizontalGap*3)/2,
                                                   WCTLoginViewControllerLoginButtonHeight);
        }
    }
    
    //////////////////////////////////////////////////
    
    self.versionLabel.frame = CGRectMake(self.logoImageView.bounds.size.width*0.55,
                                         self.logoImageView.bounds.size.height*0.762,
                                         self.logoImageView.bounds.size.width/3,
                                         self.logoImageView.bounds.size.height/5);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

    



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private show alert


//==============================================================================
// MARK: 顯示只有關閉的alert
//==============================================================================
- (void)showNormalAlertWithMessage:(NSString *)message completeHandler:(void(^)(void))completeHandler
{
    NSAssert([message length]>0, @"message 不能為空");
    
    UIAlertAction *closeAction = [UIAlertAction actionWithTitle:WCTLV_MLS_OK style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
        dispatch_async(dispatch_get_main_queue(), ^{
            if (completeHandler)
            {
                completeHandler();
            }
        });
    }];
    
    PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:@""
                                                                                   message:@""
                                                                            preferredStyle:UIAlertControllerStyleAlert];

    //////////////////////////////////////////////////
    // 訊息靠左顯示
    NSMutableParagraphStyle *paraStyle = [[NSMutableParagraphStyle alloc] init];
    paraStyle.alignment = NSTextAlignmentLeft;
    
    NSMutableAttributedString *atrStr = [[NSMutableAttributedString alloc] initWithString:message
                                                                               attributes:@{NSParagraphStyleAttributeName:paraStyle,
                                                                                            NSFontAttributeName:[UIFont systemFontOfSize:14.0]}];
    
    [ppAlertViewController setValue:atrStr forKey:@"attributedMessage"];
    [paraStyle release];
    [atrStr release];

    //////////////////////////////////////////////////
    [ppAlertViewController addAction:closeAction];    
    [self presentViewController:ppAlertViewController animated:YES completion:nil];
    
}

//==============================================================================
// MARK: 顯示有確定與取消的alert
//==============================================================================
- (void)showConfirmAlertWithMessage:(NSString *)message completeHandler:(void(^)(void))completeHandler
{
    NSAssert([message length]>0, @"message 不能為空");
    
    UIAlertAction *closeAction = [UIAlertAction actionWithTitle:WCTLV_MLS_OK style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        if (completeHandler)
        {
            completeHandler();
        }
    }];
    
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:WCTLV_MLS_Cancel style:UIAlertActionStyleCancel handler:nil];
    
    PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:@""
                                                                                   message:message
                                                                            preferredStyle:UIAlertControllerStyleAlert];
    
    //////////////////////////////////////////////////
    // 訊息靠左顯示
//    NSMutableParagraphStyle *paraStyle = [[NSMutableParagraphStyle alloc] init];
//    paraStyle.alignment = NSTextAlignmentLeft;
//
//    NSMutableAttributedString *atrStr = [[NSMutableAttributedString alloc] initWithString:message
//                                                                               attributes:@{NSParagraphStyleAttributeName:paraStyle,
//                                                                                            NSFontAttributeName:[UIFont systemFontOfSize:14.0]}];
//
//    [ppAlertViewController setValue:atrStr forKey:@"attributedMessage"];
    //////////////////////////////////////////////////
    [ppAlertViewController addAction:cancelAction];
    [ppAlertViewController addAction:closeAction];
    
    [self presentViewController:ppAlertViewController animated:YES completion:nil];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private RowModels Methods

//================================================================================
//
//================================================================================
- (NSArray *)rowModelsForAccount
{
    //////////////////////////////////////////////////

    NSArray *rowModels = @[[PPRowModel rowModelWithRow:TSMCRegisterViewController_Section_Login_Row_User
                                                  text:TSMCRegisterView_MLS_Account
                                            detailText:nil
                                                object:nil],
                           [PPRowModel rowModelWithRow:TSMCRegisterViewController_Section_Login_Row_Name
                                                  text:TSMCRegisterView_MLS_Name
                                            detailText:nil
                                                object:nil],
                           [PPRowModel rowModelWithRow:TSMCRegisterViewController_Section_Login_Row_Password
                                                  text:TSMCRegisterView_MLS_Password
                                            detailText:nil
                                                object:nil],
                           [PPRowModel rowModelWithRow:TSMCRegisterViewController_Section_Login_Row_ConfirmPassword
                                                  text:TSMCRegisterView_MLS_ConfirmPassword
                                            detailText:nil
                                                object:nil]];
    
    return rowModels;
}


//================================================================================
//
//================================================================================
- (PPRowModel *)nickNameRowModel
{
    PPRowModel *userRowModel = [self.ppSectionController rowModelAtIndexPath:[NSIndexPath indexPathForRow:TSMCRegisterViewController_Section_Login_Row_Name inSection:WCTLoginViewController_Section_Login]
                                                                forSearching:NO];
    
    return userRowModel;
}



//================================================================================
//
//================================================================================
- (PPRowModel *)userRowModel
{
    PPRowModel *userRowModel = [self.ppSectionController rowModelAtIndexPath:[NSIndexPath indexPathForRow:TSMCRegisterViewController_Section_Login_Row_User inSection:WCTLoginViewController_Section_Login]
                                                                forSearching:NO];
    
    return userRowModel;
}


//================================================================================
//
//================================================================================
- (PPRowModel *)passwordRowModel
{
    PPRowModel *passwordRowModel = [self.ppSectionController rowModelAtIndexPath:[NSIndexPath indexPathForRow:TSMCRegisterViewController_Section_Login_Row_Password inSection:WCTLoginViewController_Section_Login]
                                                                    forSearching:NO];
    
    return passwordRowModel;
}


//================================================================================
//
//================================================================================
- (PPRowModel *)confirmPasswordRowModel
{
    PPRowModel *passwordRowModel = [self.ppSectionController rowModelAtIndexPath:[NSIndexPath indexPathForRow:TSMCRegisterViewController_Section_Login_Row_ConfirmPassword inSection:WCTLoginViewController_Section_Login]
                                                                    forSearching:NO];
    
    return passwordRowModel;
}


//==============================================================================
//
//==============================================================================
- (BOOL)checkRegisterInfo
{
    PPRowModel *nameModel = [self nickNameRowModel];
    
    if([nameModel.object length]==0)
    {
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:TSMCRegisterViewController_MLS_PleaseEnterName
                                                position:PPToastPositionCenter];
        return NO;
    }
    
    PPRowModel *mailModel = [self userRowModel];
    
    if([mailModel.object length]==0)
    {
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:TSMCRegisterViewController_MLS_PleaseEnterEmail
                                                position:PPToastPositionCenter];
        return NO;
    }

    PPRowModel *passwordModel = [self passwordRowModel];
    PPRowModel *confirmPasswordModel = [self confirmPasswordRowModel];
    
    if([passwordModel.object length]==0||
       [confirmPasswordModel.object length]==0)
    {
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:TSMCRegisterViewController_MLS_PleaseEnterPassword
                                                position:PPToastPositionCenter];
        return NO;
    }

    if ([passwordModel.object isEqualToString:confirmPasswordModel.object]==NO)
    {
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:TSMCRegisterViewController_MLS_PasswordNotMatch
                                                position:PPToastPositionCenter];
        return NO;
    }
    
    return YES;
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private TableViewCell Methods

//================================================================================
//
//================================================================================
- (PPTextFieldTableViewCell *)tableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    PPTextFieldTableViewCell *textFieldTableViewCell = (PPTextFieldTableViewCell *)[tableView dequeueReusableCellWithIdentifier:NSStringFromClass([PPTextFieldTableViewCell class])];
    
    if(textFieldTableViewCell==nil)
    {
        textFieldTableViewCell = [[[PPTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                                  reuseIdentifier:NSStringFromClass([PPTextFieldTableViewCell class])] autorelease];
        textFieldTableViewCell.delegate = self;
        textFieldTableViewCell.textField.dataSource = self;
    }
    
    textFieldTableViewCell.backgroundColor                  = [UIColor clearColor];
    
    [textFieldTableViewCell.textField setBorderColor:WCTLVC_TextFieldBorderColor];
    [textFieldTableViewCell.textField setBorderWidth:1.0];
        
    if([rowModel.object isKindOfClass:[NSString class]]==YES)
    {
        textFieldTableViewCell.textField.text                   = rowModel.object;
    }
    
    textFieldTableViewCell.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
    textFieldTableViewCell.textField.textColor = WCTLVC_TextFieldTextColor;
    
    if([rowModel.text length]>0)
    {
        NSAttributedString *attributedPlaceholder =
        [[NSAttributedString alloc] initWithString:rowModel.text attributes:@{NSForegroundColorAttributeName:WCTLVC_PlaceholderTextColor}];
        textFieldTableViewCell.textField.attributedPlaceholder = attributedPlaceholder;
        [attributedPlaceholder release];
    }
    
    //////////////////////////////////////////////////
    
    textFieldTableViewCell.contentInsets = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);
    
    //////////////////////////////////////////////////
    
    return textFieldTableViewCell;
    
}


//================================================================================
//
//================================================================================
- (WCTLoginTextFieldButtonTableViewCell *)buttonTableViewCellForTableView:(UITableView *)tableView
                                                                 rowModel:(PPRowModel *)rowModel
                                               reusableCellWithIdentifier:(NSString *)reusableCellWithIdentifier

{
    WCTLoginTextFieldButtonTableViewCell *buttonTableViewCell = (WCTLoginTextFieldButtonTableViewCell *)[tableView dequeueReusableCellWithIdentifier:reusableCellWithIdentifier];
    
    //////////////////////////////////////////////////
    
    if(buttonTableViewCell==nil)
    {
        buttonTableViewCell = [[[WCTLoginTextFieldButtonTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                                           reuseIdentifier:reusableCellWithIdentifier] autorelease];
    }
    
    //////////////////////////////////////////////////
    
    if(buttonTableViewCell!=nil)
    {
        buttonTableViewCell.backgroundColor                  = [UIColor clearColor];
        
        //////////////////////////////////////////////////
        
        [buttonTableViewCell.textFieldButtonView setBorderColor:WCTLVC_TextFieldBorderColor];
        [buttonTableViewCell.textFieldButtonView setBorderWidth:1.0];
        
        buttonTableViewCell.textFieldButtonView.textField.dataSource = self;
        buttonTableViewCell.textFieldButtonView.delegate = self;
       
        //////////////////////////////////////////////////

        if([rowModel.object isKindOfClass:[NSString class]]==YES)
        {
            buttonTableViewCell.textFieldButtonView.textField.text                   = rowModel.object;

        }
        else if([rowModel.object isKindOfClass:[NSURLComponents class]]==YES)
        {
            NSURLComponents *components = rowModel.object;
            
            if([[components host] length]>0)
            {
                if([[components path] length]>0)
                {
                    buttonTableViewCell.textFieldButtonView.textField.text = [[components host] stringByAppendingString:[components path]];
                }
                else
                {
                    buttonTableViewCell.textFieldButtonView.textField.text = [components host];
                }
            }
        }
        
      
        
        buttonTableViewCell.textFieldButtonView.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
        buttonTableViewCell.textFieldButtonView.textField.textColor = WCTLVC_TextFieldTextColor;
        
        if([rowModel.text length]>0)
        {
            NSAttributedString *attributedPlaceholder =
            [[NSAttributedString alloc] initWithString:rowModel.text attributes:@{NSForegroundColorAttributeName:WCTLVC_PlaceholderTextColor}];
            buttonTableViewCell.textFieldButtonView.textField.attributedPlaceholder = attributedPlaceholder;
            [attributedPlaceholder release];
        }
        
        //////////////////////////////////////////////////
        
        [buttonTableViewCell.textFieldButtonView.ppButtonDetail addControlEvents:UIControlEventTouchUpInside];
        [buttonTableViewCell.textFieldButtonView.ppButtonDetail setDelegate:self];
        
        //////////////////////////////////////////////////
        
        buttonTableViewCell.textFieldButtoViewContentInset = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);
        
    }
    
    return buttonTableViewCell;
}


//================================================================================
//
//================================================================================
- (PPTextFieldTableViewCell *)nameTableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    PPTextFieldTableViewCell *textFieldTableViewCell = [self tableViewCellForTableView:tableView rowModel:rowModel];
    
    textFieldTableViewCell.selectionStyle = UITableViewCellSelectionStyleNone;
    textFieldTableViewCell.textField.keyboardType = UIKeyboardTypeDefault;
    textFieldTableViewCell.textField.textContentType = UITextContentTypeName;
    textFieldTableViewCell.maxLength = TSMCRegisterViewController_MaxLength;
    return textFieldTableViewCell;
}


//================================================================================
//
//================================================================================
- (PPTextFieldTableViewCell *)userTableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    PPTextFieldTableViewCell *textFieldTableViewCell = [self tableViewCellForTableView:tableView rowModel:rowModel];
    
    textFieldTableViewCell.selectionStyle = UITableViewCellSelectionStyleNone;
    textFieldTableViewCell.textField.keyboardType = UIKeyboardTypeEmailAddress;
    textFieldTableViewCell.textField.textContentType = @"";
    
    return textFieldTableViewCell;
}


//================================================================================
//
//================================================================================
- (WCTPasswordTableViewCell *)passwordTableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    WCTPasswordTableViewCell *passwordTableViewCell = [[WCTPasswordTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:[NSStringFromClass([WCTPasswordTableViewCell class]) stringByAppendingString:@"First"]];
    passwordTableViewCell.textFieldButtoViewContentInset = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);
    passwordTableViewCell.textFieldButtonView.delegate = self;
    passwordTableViewCell.textFieldButtonView.textField.dataSource = self;
    if([rowModel.text length]>0)
    {
        NSAttributedString *attributedPlaceholder =
        [[NSAttributedString alloc] initWithString:rowModel.text attributes:@{NSForegroundColorAttributeName:WCTLVC_PlaceholderTextColor}];
        passwordTableViewCell.textFieldButtonView.textField.attributedPlaceholder = attributedPlaceholder;
        [attributedPlaceholder release];
    }
    return [passwordTableViewCell autorelease];
}



//================================================================================
//
//================================================================================
- (WCTPasswordTableViewCell *)confirmPasswordTableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    WCTPasswordTableViewCell *passwordTableViewCell = [[WCTPasswordTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:[NSStringFromClass([WCTPasswordTableViewCell class]) stringByAppendingString:@"Confirm"]];
    passwordTableViewCell.textFieldButtoViewContentInset = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);
    passwordTableViewCell.textFieldButtonView.delegate = self;
    passwordTableViewCell.textFieldButtonView.textField.dataSource = self;
    if([rowModel.text length]>0)
    {
        NSAttributedString *attributedPlaceholder =
        [[NSAttributedString alloc] initWithString:rowModel.text attributes:@{NSForegroundColorAttributeName:WCTLVC_PlaceholderTextColor}];
        passwordTableViewCell.textFieldButtonView.textField.attributedPlaceholder = attributedPlaceholder;
        [attributedPlaceholder release];
    }
    return [passwordTableViewCell autorelease];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private ViewController Transition Methods

//================================================================================
//
//================================================================================
- (void)pushViewController:(UIViewController *)viewController animated:(BOOL)animated
{
    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        if([[[[UIApplication sharedApplication] keyWindow] rootViewController] isKindOfClass:[UISplitViewController class]]==YES)
        {
            UISplitViewController *splitViewController = (UISplitViewController *)[[[UIApplication sharedApplication] keyWindow] rootViewController];
            
            UINavigationController *navigationController = [[UINavigationController alloc] initWithRootViewController:viewController];
            
            if(splitViewController!=nil && navigationController!=nil)
            {
                splitViewController.viewControllers = @[[splitViewController.viewControllers firstObject],navigationController];
            }
            
            [navigationController release];
        }
    }
    else
    {
        [self.navigationController pushViewController:viewController animated:YES];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - ButtonAction


//==============================================================================
//
//==============================================================================
- (void)onClickCreate
{
    if([self checkRegisterInfo]==NO)
    {
        return ;
    }
    
    [self setBusy:@(YES)];
    
    __block typeof(self) blockSelf = self;
    __block NSError *error = nil;

    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        if(self.registerHandler)
        {
            PPRowModel *nameModel = [self nickNameRowModel];
            PPRowModel *mailModel = [self userRowModel];
            PPRowModel *passwordModel = [self passwordRowModel];

            error = self.registerHandler(nameModel.object, mailModel.object, passwordModel.object);
            [error retain];
        }
        
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(error)
            {
                NSString *errorMessage = nil;
                if(self.errorMessageHandler)
                {
                    errorMessage = self.errorMessageHandler(error);
                }
                
                if(errorMessage==nil)
                {
                    errorMessage =  [error alertMessage];
                }
                [WCToastController showMessageToastFromSuperView:self.view withMessage:errorMessage position:PPToastPositionCenter];
//                UIAlertAction *okAction = [UIAlertAction actionWithTitle:Common_Ok style:UIAlertActionStyleDefault handler:nil];
//                [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
//                                                          title:@""
//                                                        message:errorMessage
//                                         showFromViewController:self
//                                                       animated:YES alertAction:okAction, nil];
            }
            else
            {
                UIAlertAction *okAction = [UIAlertAction actionWithTitle:Common_Ok style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                    
                    [self goBackAnimated:YES];
                }];
                [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                          title:@""
                                                        message:TSMCRegisterViewController_MLS_CreateAccountSuccess
                                         showFromViewController:self
                                                       animated:YES alertAction:okAction, nil];
            }
            [blockSelf setBusy:@(NO)];
        });
    });

}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Methods

//================================================================================
//
//================================================================================
- (void)keyboardWillShowNotification:(NSNotification *)notification
{
    [super keyboardWillShowNotification:notification];
    
    //////////////////////////////////////////////////
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationCurve:[[[notification userInfo] objectForKey:UIKeyboardAnimationCurveUserInfoKey] intValue]];
    [UIView setAnimationDuration:[[[notification userInfo] objectForKey:UIKeyboardAnimationDurationUserInfoKey] doubleValue]];
    
    CGRect keyboardRectBegin    = CGRectZero;
    CGRect keyboardRectEnd      = CGRectZero;
    
    [[[notification userInfo] objectForKey:UIKeyboardFrameBeginUserInfoKey] getValue:&keyboardRectBegin];
    [[[notification userInfo] objectForKey:UIKeyboardFrameEndUserInfoKey] getValue:&keyboardRectEnd];
    
    //////////////////////////////////////////////////
    
    CGRect editTableViewFrame = [self layoutFrame];
    
    //Howard IOS7鍵盤在不同方向,寬高都是同方向
    switch(self.interfaceOrientation)
    {
        case UIInterfaceOrientationLandscapeLeft:
        case UIInterfaceOrientationLandscapeRight:
        {
            editTableViewFrame.size.height = editTableViewFrame.size.height-keyboardRectEnd.size.width-self.logoImageView.frame.size.height-WCTLoginViewControllerTableViewEdgeInsets.top;
            
            break;
        }
        case UIInterfaceOrientationPortrait:
        case UIInterfaceOrientationPortraitUpsideDown:
        default:
        {
            editTableViewFrame.size.height = editTableViewFrame.size.height-keyboardRectEnd.size.height-self.logoImageView.frame.size.height-WCTLoginViewControllerTableViewEdgeInsets.top;
            
            break;
        }
    }
    
    //////////////////////////////////////////////////
    
    editTableViewFrame.size.width = self.view.bounds.size.width-WCTLoginViewControllerTableViewEdgeInsets.left-WCTLoginViewControllerTableViewEdgeInsets.right;
    
    editTableViewFrame.origin.x   = WCTLoginViewControllerTableViewEdgeInsets.left;
    editTableViewFrame.origin.y   = self.logoImageView.frame.origin.y+self.logoImageView.frame.size.height+WCTLoginViewControllerTableViewEdgeInsets.top;
    
    //////////////////////////////////////////////////
    
    self.ppTableView.frame = editTableViewFrame;
    
    [UIView commitAnimations];
    
    //////////////////////////////////////////////////
    
    if(self.ppTableView.contentSize.height>self.ppTableView.bounds.size.height)
    {
        NSArray *cells = [self.ppTableView visibleCells];
        
        for (UITableViewCell *cell in cells)
        {
            UIView *firstResponderView = [cell firstResponderView];
            if(firstResponderView!=nil)
            {
                [self.ppTableView scrollToRowAtIndexPath:[self.ppTableView indexPathForCell:cell]
                                        atScrollPosition:UITableViewScrollPositionMiddle
                                                animated:YES];
                
                break;
            }
        }
    }
}

//================================================================================
//
//================================================================================
- (void)keyboardWillHideNotification:(NSNotification *)notification
{
    CGRect layoytFrame = [self layoutFrame];
    
    layoytFrame.size.width = self.view.bounds.size.width-WCTLoginViewControllerTableViewEdgeInsets.left-WCTLoginViewControllerTableViewEdgeInsets.right;
    
    layoytFrame.origin.x   = WCTLoginViewControllerTableViewEdgeInsets.left;
    layoytFrame.origin.y   = self.logoImageView.frame.origin.y+self.logoImageView.frame.size.height+WCTLoginViewControllerTableViewEdgeInsets.top;
    
    layoytFrame.size.height = self.view.bounds.size.height-self.logoImageView.frame.size.height-WCTLoginViewControllerTableViewEdgeInsets.top-WCTLoginViewControllerTableViewEdgeInsets.bottom-WCTLoginViewControllerLoginButtonHeight;
    
    self.ppTableView.frame = layoytFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    UIView *firstResponderView = [self.ppTableView firstResponderView];
    
    if(firstResponderView!=nil)
    {
        [firstResponderView resignFirstResponder];
    }
    
    //////////////////////////////////////////////////
    
    switch(ppButton.tag)
    {
        case TSMCRegisterViewButtonTag_Create:
        {
            [self onClickCreate];
            break;
        }
        case TSMCRegisterViewButtonTag_Cancel:
        default:
        {
            [self goBackAnimated:YES];
            break;
        }
    }
}



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldTableViewCellDelegate

//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldTableViewCellShouldBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    BOOL result = NO;
    
    do
    {
        NSIndexPath *indexPath = [self.ppTableView indexPathForCell:textFieldTableViewCell];
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.selectedIndexPath = indexPath;
        result = YES;
        
    }while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    do
    {
        NSIndexPath *indexPath = [self.ppTableView indexPathForCell:textFieldTableViewCell];
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rowModel.object = textFieldTableViewCell.textField.text;
        
        //////////////////////////////////////////////////
//
//        [self checkCanLogin];
        
        
    }while(0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldButtonView Delegate Method

//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldButtonViewShouldBeginEditing:(PPTextFieldButtonView *)textFieldButtonView
{
    BOOL result = NO;
    NSUInteger section = 0;
    NSUInteger row = 0;
    
    for(PPSectionModel *sectionModel in [self.ppSectionController sectionModelsForDefault])
    {
        section = [[self.ppSectionController sectionModelsForDefault] indexOfObject:sectionModel];
        
        for(PPRowModel *rowModel in sectionModel.rowModels)
        {
            row = [sectionModel.rowModels indexOfObject:rowModel];
            
            NSIndexPath *indexPath = [NSIndexPath indexPathForRow:row inSection:section];
            
            UITableViewCell *tableViewCell = [self.ppTableView cellForRowAtIndexPath:indexPath];
            
            if([tableViewCell isKindOfClass:[WCTLoginTextFieldButtonTableViewCell class]]==YES)
            {
                WCTLoginTextFieldButtonTableViewCell *textFieldButtonCell = (WCTLoginTextFieldButtonTableViewCell *)tableViewCell;
                
                if(textFieldButtonCell.textFieldButtonView!=textFieldButtonView)
                {
                    continue;
                }
                
                //////////////////////////////////////////////////
                
                self.selectedIndexPath = indexPath;
                
                result = YES;
                
                break;
            }
            else if([tableViewCell isKindOfClass:[WCTPasswordTableViewCell class]]==YES)
            {
                self.selectedIndexPath = indexPath;
                
                result = YES;
                
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(result==YES)
        {
            break;
        }
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldButtonView:(PPTextFieldButtonView *)textFieldButtonView shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    BOOL result = YES;
    
    do
    {
        NSIndexPath *indexPath = nil;
        
        for(UITableViewCell *tableViewCell in [self.ppTableView visibleCells])
        {
            if(tableViewCell.contentView==textFieldButtonView.superview)
            {
                indexPath = [self.ppTableView indexPathForCell:tableViewCell];
                break;
            }
        }
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // serverTextTextField
        if([[rowModel object] isKindOfClass:[NSURLComponents class]]==YES)
        {
            result = (([string rangeOfString:@":"].location==NSNotFound)&&
                      ([string rangeOfString:@" "].location==NSNotFound))?YES:NO;
        }        
        
    }while(0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldButtonViewDidChanged:(PPTextFieldButtonView *)textFieldButtonView
{
    do
    {
        NSIndexPath *indexPath = nil;
        
        for(UITableViewCell *tableViewCell in [self.ppTableView visibleCells])
        {
            if(tableViewCell.contentView==textFieldButtonView.superview)
            {
                indexPath = [self.ppTableView indexPathForCell:tableViewCell];
                break;
            }
        }
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        {
            rowModel.object = textFieldButtonView.textField.text;
        }
        
        //////////////////////////////////////////////////

        
    }while(0);
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CustomRectTextFieldDataSource

//================================================================================
//
//================================================================================
- (CGRect)placeholderRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField
{
    return CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-10, bounds.size.height), 5, 0);
}


//================================================================================
//
//================================================================================
- (CGRect)textRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
{
    return CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-5, bounds.size.height), 5, 0);
}


//================================================================================
//
//================================================================================
- (CGRect)editingRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
{
    return  CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-20, bounds.size.height), 5, 0);
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *tableViewCell = nil;
    
    PPRowModel *rowModel = nil;
    
    do
    {
        rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(indexPath.section==WCTLoginViewController_Section_Login)
        {
            switch(rowModel.row)
            {
        
                case TSMCRegisterViewController_Section_Login_Row_Password:
                {
                    tableViewCell = [self passwordTableViewCellForTableView:tableView rowModel:rowModel];
                    
                    
                    break;
                }

                case TSMCRegisterViewController_Section_Login_Row_ConfirmPassword:
                {
                    tableViewCell = [self confirmPasswordTableViewCellForTableView:tableView rowModel:rowModel];
                    
                    
                    break;
                }
                case TSMCRegisterViewController_Section_Login_Row_Name:
                {
                    tableViewCell = [self nameTableViewCellForTableView:tableView rowModel:rowModel];
                    
                    break;
                }
                case TSMCRegisterViewController_Section_Login_Row_User:
                {
                    tableViewCell = [self userTableViewCellForTableView:tableView rowModel:rowModel];
                    
                    break;
                }
                default:
                {
                    tableViewCell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([UITableViewCell class])];
                    
                    if(tableViewCell==nil)
                    {
                        tableViewCell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([UITableViewCell class])] autorelease];
                    }
                    
                    tableViewCell.textLabel.text = rowModel.text;
                    tableViewCell.textLabel.textColor = WCTLVC_TextFieldTextColor;
                    tableViewCell.textLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerForgetPasswordButtonFontSize];
                    tableViewCell.textLabel.textAlignment = NSTextAlignmentRight;
                    
                    break;
                }
            }
        }
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(tableViewCell==nil)
    {
        tableViewCell = [self tableViewCellForTableView:tableView rowModel:rowModel];
    }
    
    return tableViewCell;
}

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    NSInteger numberOfSection = [self.ppSectionController numberOfSectionsForSearching:NO];
    
    return numberOfSection;
}

//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRowsInSection = [self.ppSectionController numberOfRowsInSection:section forSearching:NO];;
    
    return numberOfRowsInSection;
}

//================================================================================
//
//================================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return [self.ppSectionController titleForHeaderInSection:section forSearching:NO];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate

//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0;
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if(tableView.tag==WCTLoginViewControllerTableViewTag_LoginForm)
    {
        return WCTLoginViewControllerLoginButtonHeight;
    }
    else
    {
        return WCTLoginViewControllerServerListViewCellHeight;
    }
    
}

@end

