//
//  TSMCLoginViewController.m
//  WorldCardTeam_TSMC
//
//  Created by sanhue cheng on 2021/1/14.
//  Copyright © 2021 penpower. All rights reserved.
//

#import "TSMCLoginViewController.h"

#import "ResourceDefine.h"

#import "WCTLoginViewController+ResourceDefine.h"
#import "WCTLoginTextFieldButtonTableViewCell.h"

#import "PPAlertController.h"
#import "WCTLoginController.h"
#import "WCToastController.h"

#import "TSMCRegisterViewController.h"
#import "PPNavigationController.h"
#import "WCTRestClientController.h"
#import "WCTRestClientController+Password.h"
#import "PPSettingsController.h"
#import "PPWebViewController+Dictionary.h"
#import "NSObject+PPBusyView.h"
#import "ForgetPasswordWebViewController.h"
#import "PPSupportController.h"
#import "PPLogControllerExtension.h"

//#import "TSMCHelper.h"
#import "TSMCURLSchemeHandler.h"

// TSMC export log
#import "PPZipController.h"
#import "PPDataConvertFlowController.h"
#import "WCCaptureViewController.h"
#import "WCMapViewController.h"
#import "WCTCardDBController.h"


NSString *TSMCLoginViewController_LoginServer = @"https://worldcardteam.tsmc.com.tw:443";
NSString *TSMCLoginViewController_ManualURL = @"https://tpemmap.tsmc.com.tw/tphone-faq/app/logistics/world-card-team/index.html";


//////////////////////////////////////////////////
@interface TSMCLoginViewController () <NSURLSessionDelegate>
@property (nonatomic, retain) NSString *userManualURLString;
@property (nonatomic, retain) PPRowModel *workingServerRowModel;
@property (nonatomic, retain) PPRowModel *workingPortRowModel;
@property (atomic, assign) BOOL isAWSDKInitialed;
@end

@implementation TSMCLoginViewController


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self removeMainUI];
    
    self.userManualURLString = nil;
    self.workingPortRowModel = nil;
    self.workingServerRowModel = nil;
    self.ppButtonCreateAccount = nil;
    
    self.ppButtonManual = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];    
    //////////////////////////////////////////////////
    ///
    __block typeof(self) blockSelf = self;

    [self enableTripleTapToView:self.logoImageView blockHandler:^(UIView *view) {

        PPAlertController *alertController = [PPAlertController alertControllerWithTitle:@"Debug functions" message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
        BOOL enableLog = [[PPSettingsController numberValueWithKey:TSMCLoginViewControllerSettingsKey_EnableLog] boolValue];
        if(!enableLog)
        {
            [alertController addAction:[UIAlertAction actionWithTitle:@"Enable log" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                [PPLogController shareLogController].toFile = YES;
                [PPLogController shareLogController].toConsole = YES;
                [WCMapViewController logEnable:YES];
                [WCTLoginController logEnable:YES];
                NSString *mailBody = [PPSupportController mailBodyWithLicense:@"TMSC" additionalInfos:nil];
                
                PPLogFuncInfo(@" DeviceInfo:%@", mailBody);
                [PPSettingsController setNumberValue:@(YES) withKey:TSMCLoginViewControllerSettingsKey_EnableLog];
            }]];
        }
        else
        {
            [alertController addAction:[UIAlertAction actionWithTitle:@"Disable log" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                [PPLogController shareLogController].toFile = NO;
                [PPLogController shareLogController].toConsole = NO;
                [WCMapViewController logEnable:NO];
                [WCTLoginController logEnable:NO];
                [PPSettingsController setNumberValue:@(NO) withKey:TSMCLoginViewControllerSettingsKey_EnableLog];
            }]];
        }

        // export log
        [alertController addAction:[UIAlertAction actionWithTitle:@"Extract log" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            [TSMCLoginViewController exportLogToShareFolder];
        }]];
        
        [alertController addAction:[UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:nil]];
        [blockSelf presentViewController:alertController animated:YES completion:nil];

    }];
    //////////////////////////////////////////////////
    [self prepareMainUI];
    [self tsmcConnectionProcess];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    // !!這邊主要是做自動登入，但TSMC要等到有AWSDK通知後才可以做，所以這邊mark掉，等後面再做
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
    ///

}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self disableTripleTapToView:self.logoImageView];
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    
    //////////////////////////////////////////////////
    
    PPButton *ppButtonCreateAccount = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
    
    if(ppButtonCreateAccount!=nil)
    {
        ppButtonCreateAccount.delegate = self;
        ppButtonCreateAccount.tag      = WCTLoginViewControllerButtonTag_CreateAccount;
        [ppButtonCreateAccount setTitle:WCTLV_MLS_Register maxWidth:0.0];
        [ppButtonCreateAccount addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        [ppButtonCreateAccount setTitleColor:WCTLVC_TextFieldTextColor forState:UIControlStateNormal];
        [ppButtonCreateAccount setTitleColor:WCTLVC_TextFieldHighlightedTextColor forState:UIControlStateHighlighted];
        
        ppButtonCreateAccount.titleLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerHelpButtonFontSize];
        ppButtonCreateAccount.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
        ppButtonCreateAccount.contentEdgeInsets = WCTLoginViewControllerHelpButtonEdgeInset;
        
        [ppButtonCreateAccount setEnabled:NO];
        
        //////////////////////////////////////////////////
        
        [self.tableFooterView addSubview:ppButtonCreateAccount];
        self.ppButtonCreateAccount = ppButtonCreateAccount;
    }
    //////////////////////////////////////////////////
    
    PPButton *ppButtonManual = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
    
    if(ppButtonManual!=nil)
    {
        ppButtonManual.delegate = self;
        ppButtonManual.tag      = WCTLoginViewControllerButtonTag_Manual;
        [ppButtonManual setTitle:WCTLV_MLS_Manual maxWidth:0.0];
        [ppButtonManual addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        [ppButtonManual setTitleColor:WCTLVC_TextFieldTextColor forState:UIControlStateNormal];
        [ppButtonManual setTitleColor:WCTLVC_TextFieldHighlightedTextColor forState:UIControlStateHighlighted];
        
        ppButtonManual.titleLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerHelpButtonFontSize];
        ppButtonManual.contentHorizontalAlignment = UIControlContentHorizontalAlignmentRight;
        ppButtonManual.contentEdgeInsets = WCTLoginViewControllerHelpButtonEdgeInset;
        
        [ppButtonManual setEnabled:NO];
        //////////////////////////////////////////////////
        
        [self.view addSubview:ppButtonManual];
        self.ppButtonManual = ppButtonManual;
    }
    
    self.ppButtonHelp.hidden = YES;
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self.ppButtonCreateAccount removeFromSuperview];
    self.ppButtonCreateAccount = nil;
    
    [self.ppButtonManual removeFromSuperview];
    self.ppButtonManual = nil;
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    //////////////////////////////////////////////////
    // TODO: 建立帳號layout
    self.ppButtonCreateAccount.frame = CGRectMake(PPTableViewCellDefaultHorizontalGap*2,
                                                  CGRectGetMaxY(self.ppButtonLogin.frame)+PPTableViewCellDefaultVerticalGap,
                                                  self.tableFooterView.bounds.size.width/2-PPTableViewCellDefaultHorizontalGap*2,
                                                  WCTLoginViewControllerForgetPasswordButtonHeight);
    // TODO: DeviceID，Manual，Report
    //////////////////////////////////////////////////
    CGFloat positionY = self.ppButtonHelp.frame.origin.y;
    CGFloat buttonWidth = (self.view.bounds.size.width)/2;
    
    
    if(self.ppButtonDeviceID!=nil)
    {
        self.ppButtonDeviceID.frame = CGRectMake(0,
                                                 positionY,
                                                 buttonWidth,
                                                 WCTLoginViewControllerDeviceIDButtonHeight);
    }
    
    if(self.ppButtonManual!=nil)
    {
        self.ppButtonManual.frame = CGRectMake(CGRectGetMaxX(self.ppButtonDeviceID.frame),
                                               positionY,
                                               buttonWidth,
                                               WCTLoginViewControllerHelpButtonHeight);
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override Row methods


//================================================================================
//
//================================================================================
- (NSArray *)rowModelsForAccount
{
    //////////////////////////////////////////////////
    
    NSArray *rowModels = @[[PPRowModel rowModelWithRow:WCTLoginViewController_Section_Login_Row_User
                                                  text:WCTLV_MLS_User
                                            detailText:nil
                                                object:self.accountUser],
                           [PPRowModel rowModelWithRow:WCTLoginViewController_Section_Login_Row_Password
                                                  text:WCTLV_MLS_Password
                                            detailText:nil
                                                object:([PPSettingsController integerValueWithKey:WCTLoginViewControllerSettingKey_AutoLogin]==1?[WCTRestClientController decryptAccountPassword]:nil)],
                           [PPRowModel rowModelWithRow:WCTLoginViewController_Section_Login_Row_AutoLogin
                                                  text:WCTLV_MLS_AutoLogin
                                            detailText:nil
                                                object:([PPSettingsController integerValueWithKey:WCTLoginViewControllerSettingKey_AutoLogin]==1?@(YES):@(NO))]];
    
    return rowModels;
}

//================================================================================
//
//================================================================================
- (PPRowModel *)protocolAndPortRowModel
{
    if(self.workingPortRowModel==nil)
    {
        self.workingPortRowModel = [[[PPRowModel alloc] init] autorelease];
        self.workingPortRowModel.row = WCTLoginViewController_Section_Login_Row_ProtocolAndPort;
    }
    
    return self.workingPortRowModel;
}


//================================================================================
//
//================================================================================
- (PPRowModel *)serverRowModel
{
    if(self.workingServerRowModel==nil)
    {
        self.workingServerRowModel = [[[PPRowModel alloc] init] autorelease];
        self.workingServerRowModel.row = WCTLoginViewController_Section_Login_Row_Server;
    }
    
    return self.workingServerRowModel;
}


//==============================================================================
//
//==============================================================================
- (NSURL *)forgotPasswordURL
{
    NSURLComponents *serverComponents = [self serverRowModel].object;
    NSURLComponents *protocolAndPortComponents = [self protocolAndPortRowModel].object;
    
    serverComponents.port = protocolAndPortComponents.port;
    serverComponents.scheme = protocolAndPortComponents.scheme;
    NSString *urlString = [[WCTLoginController completeServerUrlHostString:[WCTLoginController urlPathFromUrlComponents:serverComponents]] stringByAppendingString:@"/#/forgot-password"];
    
    return [NSURL URLWithString:urlString];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override PPButtonDelegate


//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    UIView *firstResponderView = [self.ppTableView firstResponderView];
    
    if(firstResponderView!=nil)
    {
        [firstResponderView resignFirstResponder];
    }
    
    
    switch (ppButton.tag) {
        case WCTLoginViewControllerButtonTag_CreateAccount:
        {
            [self onClickRegister];
            break;
        }
        case WCTLoginViewControllerButtonTag_Manual:
        {
            [self onClickManual];
            break;
        }
        case WCTLoginViewControllerButtonTag_ForgetPassword:
        {
            [self onClickForgetPassword];
            break;
        }
        case WCTLoginViewControllerButtonTag_DeviceID:
        {
            [self onClickDeviceID];
            break;
        }
        default:
        {
            [super ppButton:ppButton controlEvent:controlEvent];
            break;
        }
    }
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override UITableViewDataSource


//==============================================================================
//
//==============================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    
    UITableViewCell *cell = [super tableView:tableView cellForRowAtIndexPath:indexPath];
    
    if(rowModel.row==WCTLoginViewController_Section_Login_Row_ProtocolAndPort||
       rowModel.row==WCTLoginViewController_Section_Login_Row_Server)
    {
        cell.hidden = YES;
    }
    return cell;
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    
    if(rowModel.row==WCTLoginViewController_Section_Login_Row_ProtocolAndPort||
       rowModel.row==WCTLoginViewController_Section_Login_Row_Server)
    {
        return 0;
    }
    else
    {
        return [super tableView:tableView heightForRowAtIndexPath:indexPath];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private


//==============================================================================
//
//==============================================================================
- (void)switchServerURLWithString:(NSString *)string
{
    //    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        NSString *apiURLString = [WCTLoginController autoFillServerAddressString:string];
        [PPSettingsController setStringValue:apiURLString
                                     withKey:WCTRestClientController_SettingsKey_URLAddress];
        
        [[WCTRestClientController shareRestClientController] changeURLAddress:apiURLString withError:nil];
    });
    
}


//==============================================================================
//
//==============================================================================
- (void)tsmcConnectionProcess
{
    [self.ppButtonCreateAccount setEnabled:YES];
    [self.ppButtonManual setEnabled:YES];
    self.userManualURLString = TSMCLoginViewController_ManualURL;
    self.displayServerURLAddress = TSMCLoginViewController_LoginServer;

//    {
//        self.displayServerURLAddress = @"https://app.worldcardcloud.com:443";
//    }

    NSURLComponents *components = [WCTLoginController urlComponentsFromUrlPath:self.displayServerURLAddress];
    [self serverRowModel].object = components;
    [self protocolAndPortRowModel].object = components;
    [self switchServerURLWithString:[self loginURLString]];
    
    [self performSelectorOnMainThread:@selector(checkCanLogin) withObject:nil waitUntilDone:NO];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - NSURLSesstionDelegate


//==============================================================================
//
//==============================================================================
- (void)URLSession:(NSURLSession *)session didReceiveChallenge:(NSURLAuthenticationChallenge *)challenge completionHandler:(void (^)(NSURLSessionAuthChallengeDisposition, NSURLCredential * _Nullable))completionHandler
{
    if([challenge.protectionSpace.host containsString:@"tsmc.com"])
    {
        NSURLCredential *credential = [NSURLCredential credentialForTrust:challenge.protectionSpace.serverTrust];
        
        completionHandler(NSURLSessionAuthChallengeUseCredential, credential);
    }
    else
    {
        if(completionHandler)
        {
            completionHandler(NSURLSessionAuthChallengePerformDefaultHandling, nil);
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ForgetPasswordWebViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (BOOL)forgetPasswordWebViewControllerShouldShowError:(NSError *)error
{
    BOOL showError = YES;
    
    if([self.delegate respondsToSelector:@selector(loginViewControllerShouldShowError:)]==YES)
    {
        showError = [self.delegate loginViewControllerShouldShowError:error];
    }
    
    return showError;
}


//================================================================================
//
//================================================================================
- (NSString *)forgetPasswordWebViewControlerRequestMessageForError:(NSError *)error
{
    NSString *errorMessage = nil;
    NSError *customError = nil;
    
    // find host要客制錯誤
    if([error.domain isEqualToString:NSURLErrorDomain]==YES &&
       error.code==NSURLErrorCannotFindHost)
    {
        customError = PPErrorMake(WCTLoginViewControllerErrorCode_CannotFindHost, WCTLV_MLS_FailedToConnectServer, error);
    }
    else
    {
        customError = error;
    }
    
    if([self.delegate respondsToSelector:@selector(loginViewControllerRequestMessageForError:)]==YES)
    {
        errorMessage = [self.delegate loginViewControllerRequestMessageForError:customError];
    }
    
    return errorMessage;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - ButtonAction


//==============================================================================
//
//==============================================================================
- (void)onClickRegister
{
    TSMCRegisterViewController *registerViewController = [[TSMCRegisterViewController alloc] init];
    registerViewController.versionString = self.versionString;
    
    registerViewController.registerHandler = ^NSError *(NSString *name, NSString *email, NSString *password) {
        
        NSError *error = nil;
        if([self.delegate respondsToSelector:@selector(requestRegisterWithViewController:name:email:password:error:)])
        {
            [self.delegate requestRegisterWithViewController:self name:name email:email password:password error:&error];
        }
        return error;
    };
    
    registerViewController.errorMessageHandler = ^NSString *(NSError *error) {
        
        NSString *errorMessage = nil;
        NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
        switch (statusCode)
        {
            case 401:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error401;
                break;
            }
            case 403:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error403;
                break;
            }
            case 404:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error404;
                break;
            }
            case 415:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error415;
                break;
            }
            case 422:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error422;
                break;
            }
            case 426:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error426;
                break;
            }
            case 441:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error441;
                break;
            }
            case 460:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error460;
                break;
            }
            case 462:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error462;
                break;
            }
            case 469:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error469;
                break;
            }
            case 500:
            {
                errorMessage = TSMCRegisterViewController_MLS_Error500;
                break;
            }
            default:
            {
                errorMessage = [error alertMessage];
                break;
            }
        }
        return errorMessage;
    };
    
    PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:registerViewController];
    
    [self presentViewController:navigationController animated:YES completion:nil];
    [registerViewController release];
    [navigationController release];
}

//==============================================================================
//
//==============================================================================
- (void)onClickManual
{
    if([self.userManualURLString length]==0)
    {
        [WCToastController showMessageToastFromSuperView:self.view withMessage:@"Manual is only available in TSMC network." position:PPToastPositionCenter];
        return;
    }
    
    //    self.userManualURLString = @"https://mail.penpower.com.tw/owa";
    self.userManualURLString = [self.userManualURLString stringByReplacingOccurrencesOfString:@"https" withString:TSMCURLSchemeHandler_CustomScheme];
    
    PPWebViewController *webViewController = [[PPWebViewController alloc] init];
    
    webViewController.webTitle = @"Manual";
    //    webViewController.forceOpenHttps = YES;
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:self.userManualURLString] cachePolicy:NSURLRequestUseProtocolCachePolicy timeoutInterval:30];
    webViewController.request = request;
    webViewController.urlSchemeHandlerDictioanry = @{TSMCURLSchemeHandler_CustomScheme:[TSMCURLSchemeHandler sharedInstance]};
    PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:webViewController];
    [self presentViewController:navigationController animated:YES completion:nil];
    [navigationController release];
    
    [webViewController release];
}


//==============================================================================
//
//==============================================================================
- (void)onClickForgetPassword
{
    NSString *oriForgotPasswordURLString = [[self forgotPasswordURL] absoluteString];
    NSString *forgotPasswordURLString = [oriForgotPasswordURLString stringByReplacingOccurrencesOfString:@"https" withString:TSMCURLSchemeHandler_CustomScheme];
    //////////////////////////////////////////////////
    ForgetPasswordWebViewController *webViewController = [[ForgetPasswordWebViewController alloc] init];
    
    webViewController.hidesBottomBarWhenPushed    = YES;
    
    webViewController.webTitle                    = WCTLV_MLS_ForgetPassword;
    webViewController.acceptURL                   = oriForgotPasswordURLString;
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:forgotPasswordURLString] cachePolicy:NSURLRequestUseProtocolCachePolicy timeoutInterval:30];
    webViewController.request = request;
    webViewController.urlSchemeHandlerDictioanry = @{TSMCURLSchemeHandler_CustomScheme:[TSMCURLSchemeHandler sharedInstance]};
    PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:webViewController];
    [self presentViewController:navigationController animated:YES completion:nil];
    [navigationController release];
    
    [webViewController release];
}


//==============================================================================
//
//==============================================================================
- (void)onClickDeviceID
{
    // MARK: 傳送裝置ID
    
    do
    {
        __block NSString *message = [NSString stringWithFormat:@"%@: %@\n",WCTLV_MLS_DeviceName,[[UIDevice currentDevice] name]];
        
        message = [message stringByAppendingString:[NSString stringWithFormat:@"%@: %@",WCTLV_MLS_DeviceID, [PPSupportController systemUUID]]];
        
        //////////////////////////////////////////////////
        
        UIAlertAction *copyAction = [UIAlertAction actionWithTitle:WCTLV_MLS_Copy style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            [UIPasteboard generalPasteboard].string = message;
            
        }];
        
        if(copyAction==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:WCTLV_MLS_Cancel style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            
        }];
        
        if(cancelAction==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        
        PPAlertController *alertController = [PPAlertController alertControllerWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                                                                  title:WCTLV_MLS_DeviceNameAndID
                                                                                                message:message
                                                                                            alertAction:copyAction,cancelAction,nil];
        
        if(alertController==nil)
        {
            break;
        }
        
        [self presentViewController:alertController animated:YES completion:nil];
    }
    while (0);
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - log


//==============================================================================
//
//==============================================================================
+ (void)exportLogToShareFolder
{

    NSTimeInterval startTimeInterval = [NSDate timeIntervalSinceReferenceDate];
    [self setBusy:@(YES)];
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        //////////////////////////////////////////////////
        
        NSString *zipPassword      = nil;
        NSString* documentPath     = [[WCToolController shareFolderPath] stringByAppendingPathComponent:@"Logs"];
        [WCToolController createDirPath:documentPath];
        NSMutableArray *filePaths  = [[NSMutableArray alloc] init];
        
        //////////////////////////////////////////////////
        // zip db log
        NSString *reportPath = [[WCToolController shareFolderPath] stringByAppendingPathComponent:@"TSMC"];

        if([[NSFileManager defaultManager] fileExistsAtPath:reportPath] == YES)
        {
            NSArray *listOfFiles = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:reportPath error:nil];
            
            if([listOfFiles count] > 0)
            {
                NSString *logZipPath = [documentPath stringByAppendingPathComponent:@"TSMCLogs.zip"];
                
                if([PPZipController zipWithSrcDir:reportPath excludeDirPatterns:nil dstFile:logZipPath password:zipPassword])
                {
                    [filePaths addObject:logZipPath];
                }
            }
        }
        
        //////////////////////////////////////////////////
        // zip restclient log
        
        NSString *wctRestClientLogDirPath = [WCTRestClientController logDirPath];
        
        if([[NSFileManager defaultManager] fileExistsAtPath:wctRestClientLogDirPath] == YES)
        {
            NSArray *listOfFiles = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:wctRestClientLogDirPath error:nil];
            
            if([listOfFiles count] > 0)
            {
                NSString *wctRestClientLogZipPath = [documentPath stringByAppendingPathComponent:@"WCTRestClientLog.zip"];
                
                if([PPZipController zipWithSrcDir:wctRestClientLogDirPath excludeDirPatterns:nil dstFile:wctRestClientLogZipPath password:zipPassword])
                {
                    [filePaths addObject:wctRestClientLogZipPath];
                }
            }
        }
        
        NSString *wctLoginLogDirPath = [WCTLoginController logDirPath];
        
        if([[NSFileManager defaultManager] fileExistsAtPath:wctLoginLogDirPath] == YES)
        {
            NSArray *listOfFiles = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:wctLoginLogDirPath error:nil];
            
            if([listOfFiles count] > 0)
            {
                NSString *wctLoginLogZipPath = [documentPath stringByAppendingPathComponent:@"WCTLoginLog.zip"];
                
                if([PPZipController zipWithSrcDir:wctLoginLogDirPath excludeDirPatterns:nil dstFile:wctLoginLogZipPath password:zipPassword])
                {
                    [filePaths addObject:wctLoginLogDirPath];
                }
            }
        }
        
        //////////////////////////////////////////////////
        // zip WCMapViewController log
        
        NSString *wcMapLogDirPath = [WCMapViewController logDirPath];
        
        if([[NSFileManager defaultManager] fileExistsAtPath:wcMapLogDirPath] == YES)
        {
            NSArray *listOfFiles = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:wcMapLogDirPath error:nil];
            
            if([listOfFiles count] > 0)
            {
                NSString *wcMapLogZipPath = [documentPath stringByAppendingPathComponent:@"WCMapViewLog.zip"];
                
                if([PPZipController zipWithSrcDir:wcMapLogDirPath excludeDirPatterns:nil dstFile:wcMapLogZipPath password:nil])
                {
                    [filePaths addObject:wcMapLogZipPath];
                }
            }
        }

        //////////////////////////////////////////////////
        // zip convert step
        
        NSString *convertLogDirPath = [PPDataConvertFlowController logDirPath];
        
        if([[NSFileManager defaultManager] fileExistsAtPath:convertLogDirPath] == YES)
        {
            NSArray *listOfFiles = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:convertLogDirPath error:nil];
            
            if([listOfFiles count] > 0)
            {
                NSString *convertLogZipPath = [documentPath stringByAppendingPathComponent:@"ConvertLog.zip"];
                
                if([PPZipController zipWithSrcDir:convertLogDirPath excludeDirPatterns:nil dstFile:convertLogZipPath password:zipPassword])
                {
                    [filePaths addObject:convertLogZipPath];
                }
            }
        }
        
        
        //////////////////////////////////////////////////
        // zip capture log
        
//        NSString *captureLogDirPath = [WCCaptureViewController logDirPath];
//        
//        if([[NSFileManager defaultManager] fileExistsAtPath:captureLogDirPath] == YES)
//        {
//            NSArray *listOfFiles = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:captureLogDirPath error:nil];
//            
//            if([listOfFiles count] > 0)
//            {
//                NSString *captureLogZipPath = [documentPath stringByAppendingPathComponent:@"CaptureLog.zip"];
//                
//                if([PPZipController zipWithSrcDir:captureLogDirPath excludeDirPatterns:nil dstFile:captureLogZipPath password:nil])
//                {
//                    [filePaths addObject:captureLogZipPath];
//                }
//            }
//        }


        //////////////////////////////////////////////////
        //  如果處理時間很快，要延後完成，避免busy會閃太快
        NSTimeInterval endTimeInterval = [NSDate timeIntervalSinceReferenceDate];
        if (endTimeInterval - startTimeInterval < 0.5)
        {
            NSTimeInterval sleepTime = (0.5-(endTimeInterval - startTimeInterval));
            [NSThread sleepForTimeInterval:sleepTime];
        }
        
        
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            
            //////////////////////////////////////////////////
            // report with zip files
            [self setBusy:@(NO)];
            [filePaths release];
        });
    });
    

}

@end
