//
//  TSMCContactUsController.m
//  WorldCardTeam_TSMC
//
//  Created by sanhue cheng on 29/08/2023.
//  Copyright © 2023 penpower. All rights reserved.
//

#import "TSMCContactUsController.h"

#import "ResourceDefine.h"

#import "PPURLController+iOS.h"
#import "PPURLController+TSMC.h"

#import "WCToastController.h"
#import "PPSystemInfoController.h"
#import "PPSupportController.h"
#import "PPSettingsController.h"
#import "WCTLoginController.h"
#import "PPNetworkReachabilityController.h"
#import "WCTRestClientController.h"


@implementation TSMCContactUsController



//==============================================================================
//
//==============================================================================
+ (NSDictionary *)contactUsAdditionalInfoWithServerURL:(NSString *)serverURL
{
    //////////////////////////////////////////////////
    NSDictionary *additionalInfos = nil;

    static NSString *ServerURLKey = @"Server URL";
    static NSString *ServerAPIVersionKey = @"API Version";

    NSMutableDictionary *postDictionary = [NSMutableDictionary dictionary];
    [postDictionary setObject:@"" forKey:ServerURLKey];
    [postDictionary setObject:@"" forKey:ServerAPIVersionKey];
    
    NSString *urlString = nil;
    NSString *displayURLString = nil;
    if([serverURL length]==0)
    {
        // 這邊的URL會包含@"/WorldCardTeam"
        urlString = [PPSettingsController stringValueWithKey:WCTRestClientController_SettingsKey_URLAddress];
        if([urlString length]>0)
        {
            // !! 有可能沒有host
            NSURLComponents *urlComponents = [WCTLoginController urlComponentsFromUrlPath:urlString];
            if([[urlComponents host] length]==0)
            {
                urlString = nil;
            }
            else
            {
                displayURLString = [urlString stringByDeletingLastPathComponent];
            }
        }
    }
    else
    {
        // 這邊的URL沒有包含@"/WorldCardTeam"
        displayURLString = serverURL;
        urlString = [WCTLoginController autoFillServerAddressString:serverURL];
    }
    
    
    if ([urlString length]>0)
    {
        if(displayURLString!=nil)
        {
            [postDictionary setObject:displayURLString forKey:ServerURLKey];
        }
        if([PPNetworkReachabilityController checkForInternetConnection]==YES)
        {
            [PPSettingsController setStringValue:urlString
                                         withKey:WCTRestClientController_SettingsKey_URLAddress];
            
            NSError *error = nil;
            if([[WCTRestClientController shareRestClientController] changeURLAddress:urlString withError:&error]==YES)
            {
                // 有URL才可以連線
                WCTRCVersionInfoResponseResult *versionInfoResult = [[WCTRestClientController shareRestClientController] serverVersionWithError:&error];
                
                if (error==nil)
                {
                    NSString *serverVersion = [NSString stringWithFormat:@"%d.%d.%d.%d",
                                               (int)versionInfoResult.data.major,
                                               (int)versionInfoResult.data.minor,
                                               (int)versionInfoResult.data.patch,
                                               (int)versionInfoResult.data.number];
                    if([serverVersion length]>0)
                    {
                        [postDictionary setObject:serverVersion forKey:ServerAPIVersionKey];
                    }
                }
            }
        }
    }
    
    if ([postDictionary count]>0)
    {
        additionalInfos = [PPSupportController additionalInfosDictionaryWithPrevDictionary:nil
                                                                         andPostDictionary:postDictionary];
    }
    
    return additionalInfos;
}


//==============================================================================
//
//==============================================================================
+ (void)showFromViewController:(UIViewController *)viewController
{
    if ([PPURLController canOpenURLWithType:PPURLControllerType_Email]==NO)
    {
        [WCToastController showMessageToastFromSuperView:viewController.view withMessage:Common_EmailFailed position:PPToastPositionCenter];
        return ;
    }
    
    //設定收件人
    NSString *recipients = @"ios_support@penpowerinc.com";

    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        NSString *mailBody = [[PPSupportController mailBodyWithLicense:@"TMSC" additionalInfos:[self contactUsAdditionalInfoWithServerURL:nil]] retain];

        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            [PPURLController tsmc_showFromViewController:viewController
                                             withURLType:PPURLControllerType_Email
                                               parameter:recipients];
            [mailBody release];
        });
    });

}
@end
