﻿#ifndef ___FIRST_IMGENHANCE__
#define ___FIRST_IMGENHANCE__

#import "BitmapDefine.h"

#define MEMORYERROR -1
#define IMAGENOCAPTURE 0 
#define IMAGECAPTURE 1 
#define IMAGEREMOVE 2 
#define IMAGESTART 3 

#define DLLExport __attribute__((visibility("default")))
#define DLLImport

typedef const BITMAPPTR *PCBITMAPPTR;

typedef struct _POINTPTR
{
	int x,y;
} MYPOINT, *PMYPOINT;


////////////////////////////////////////////////////////////////////////////////////////////////////
// API說明:
extern int ImgStable(void **Capram, BITMAPPTR Bmpinput,int fr);
/* 
 fr: frame rate
 return IMAGENOCAPTURE --> 沒事
 return IMAGECAPTURE --> 拍照;
 return IMAGEREMOVE --> 超過設定時間(目前為10張),偵測不到文字;
 return IMAGESTART --> 第一次偵測到文字;
 return MEMORYERROR --> 記憶體不足
 */

extern int HoughTrans_Color_Link(PBITMAPPTR Bmpinput, PMYPOINT Rectpoint);
/*
 return 0 --->沒事
 return MEMORYERROR--> 記憶體不足
 Rectpoints[0]:Left_Bottom
 Rectpoints[1]:Right_Bottom
 Rectpoints[2]:Left_Top
 Rectpoints[3]:Right_Top
*/

extern bool CreateCaptram(void **Capram);  
/* 
 return true--> 沒事 
 return false--> 記憶體不足 
 */

extern void ResetCapRAM(void **Capram1);

extern void DestoryCaptram(void **Capram);

/*

  void *Capram;
  BITMAPPTR Bmpinput;
  int rc;

  if(CreateCaptram(&Capram)==false) 
  {
	//No Enough Memory.
  }

  ...

  rc=ImgStable(&Capram,Bmpinput,2);
  if(rc==IMAGECAPTURE)
  {
	//capture image
  }
  else if(rc==IMAGEREMOVE)
  {
	//show message
  }

  ...

  DestoryCaptram(&Capram);	
*/

// 使用QRCode的方式,請改為HoughTrans_Color_LinkQR()和ImgStableQR()
extern int HoughTrans_Color_LinkQR(PBITMAPPTR Bmpinput, PMYPOINT Rectpoint);
/*
 return 0 --->沒事
 return MEMORYERROR--> 記憶體不足
 Rectpoints[0]:Left_Bottom
 Rectpoints[1]:Right_Bottom
 Rectpoints[2]:Left_Top
 Rectpoints[3]:Right_Top
*/


extern int ImgStableQR(void **Capram,BITMAPPTR Bmpinput,int time_th);

/* 
 time_th: 設定拍攝時間(單位ms)
 return IMAGENOCAPTURE --> 沒事
 return IMAGECAPTURE --> 拍照;
 return IMAGEREMOVE --> 超過設定時間(目前為3000ms),偵測不到文字;
 return IMAGESTART --> 第一次偵測到文字;
 return MEMORYERROR --> 記憶體不足
 */

extern int getQRPosy(void **Capram);

 
#endif