#ifndef ___FIRST_IMGENHANCE__
#define ___FIRST_IMGENHANCE__
#import "BitmapDefine.h"
#import "KernelDefine.h"

typedef const BITMAPPTR *PCBITMAPPTR;


typedef void (*PPERCENT) (int wPercent);


PBITMAPPTR PP_CreateJBuf2Bmp(char* jpgbuf, int nsize, int nScale, bool bGrayLevel);
void PP_DestoryJpeg2Bmp(PBITMAPPTR bitmap);
bool PP_Bmp2Jpeg(void* pVoid, char* szFilename);
short PP_SaveDIBitmap(BITMAPPTR Image, char* szFileName);


// 1.自動取得Bitmap的四個座標點,以便app設置四個預設扭正點.
int HoughTrans_Color(PBITMAPPTR aBmpInput, PMYPOINT aMyPoint);
// [input] aBmpInput : Bitmap資料.
// [input] aMyPoint : 由AP配置size為4的MYPOINT array,將array pointer傳給kernel判斷四個預設扭正點.
// [return] 0:成功 -1:失敗

// 2.從User指定或HoughTrans_Color()取得四個扭正點計算寬和高,以便AllocBMPMem配置記憶體使用.
void getrectWH(MYPOINT aLeft_Bottom, MYPOINT aRight_Bottom, MYPOINT aLeft_Top, MYPOINT aRight_Top,
               int aInputWidth,int aInputHeight,int *aOutWidth,int *aOutHeight);
// [input] aLeft_Bottom : 左下扭正點座標.
// [input] aRight_Bottom : 右下扭正點座標.
// [input] aLeft_Top : 左上扭正點座標.
// [input] aRight_Top : 右上扭正點座標.
// [input] aInputWidth : 原始Bitmap的寬度
// [input] aInputHeight : 原始Bitmap的高度
// [output] aOutWidth : 扭正後Bitmap的寬度
// [output] aOutHeight : 扭正後Bitmap的高度

// 3.由寬和高配置Bitmap(24bits)需要的記憶體.
bool AllocBMPMem(BITMAPPTR *aBmpOutput, int aWidth, int aHeight);
// [output] aBmpOutput : 配置完成的Bitmap記憶體.
// [input] aWidth : 欲配置的Bitmap寬度.
// [input] aHeight : 欲配置的Bitmap高度.
// [return] true:成功 false:失敗

// 4.進行扭正處理.
void QuadrToRect(BITMAPPTR *aBmpInput, BITMAPPTR *aBmpOutput, MYPOINT aLeft_Bottom, MYPOINT aRight_Bottom, MYPOINT aLeft_Top, MYPOINT aRight_Top, PPERCENT lpPercent);
// [input] aBmpInput : 欲扭正Bitmap.
// [output] aBmpOutput : 扭正後Bitmap.
// [input] aLeft_Bottom : 左下扭正點座標.
// [input] aRight_Bottom : 右下扭正點座標.
// [input] aLeft_Top : 左上扭正點座標.
// [input] aRight_Top : 右上扭正點座標.
// [callback] lpPercent : void callbackPercentage(int aPercentage)而aPercentage是1 ~ 10

// 5.進行亮化處理.
bool LightCorrect(BITMAPPTR *aBmpInput, BITMAPPTR *aBmpOutput, PPERCENT lpPercent);
// [input] aBmpInput : 欲亮化Bitmap.
// [output] aBmpOutput : 亮化後Bitmap.
// [callback] lpPercent : void callbackPercentage(int aPercentage)而aPercentage是1 ~ 10
// [return] true:成功 false:失敗

// 6.釋放Bitmap記憶體.
void FreeBMPMem(BITMAPPTR *aBmpInput);
// [input] aBmpInput : 欲釋放Bitmap的記憶體.

// 7.依據指定角度旋轉彩色Bitmap.
bool RotateColorBMP(BITMAPPTR *aBmpInput, BITMAPPTR *aBmpOutput, short aRet);
// [input] aBmpInput : 欲旋轉Bitmap.
// [output] aBmpOutput : 旋轉後Bitmap.
// [input] aRet : 旋轉角度(0, 90, 180, 270).
// [return] true:成功 false:失敗

// 8.從User指定或HoughTrans_Color()取得四個扭正點計算寬和高,以便AllocBMPMem配置記憶體使用.
void getrectWH_DOC(MYPOINT aLeft_Bottom, MYPOINT aRight_Bottom, MYPOINT aLeft_Top, MYPOINT aRight_Top,
                   int aInputWidth,int aInputHeight,int *aOutWidth,int *aOutHeight,int aEDGE);
// [input] aLeft_Bottom : 左下扭正點座標.
// [input] aRight_Bottom : 右下扭正點座標.
// [input] aLeft_Top : 左上扭正點座標.
// [input] aRight_Top : 右上扭正點座標.
// [input] aInputWidth : 原始Bitmap的寬度
// [input] aInputHeight : 原始Bitmap的高度
// [output] aOutWidth : 扭正後Bitmap的寬度
// [output] aOutHeight : 扭正後Bitmap的高度
// [input] aEDGE : 輸出的最長邊.

// 9.自動取得Bitmap的四個座標點,以便app設置四個預設扭正點.
int HoughTrans_Color(PBITMAPPTR aBmpInput, PMYPOINT aMyPoint);
// [input] aBmpInput : Bitmap資料.
// [input] aMyPoint : 由AP配置size為4的MYPOINT array,將array pointer傳給kernel判斷四個預設扭正點.
// [return] 0:成功 -1:失敗

// 10.由寬和高配置Bitmap(32bits)需要的記憶體.
bool AllocBMPMem32(BITMAPPTR *pImage, int width, int height);
// [output] aBmpOutput : 配置完成的Bitmap記憶體.
// [input] aWidth : 欲配置的Bitmap寬度.
// [input] aHeight : 欲配置的Bitmap高度.
// [return] true:成功 false:失敗

#endif
