//#include <vld.h>
#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include "PPWcxfFile.h"
#include "PPFileIo.h"
#include "PPMem.h"
#include "PPMisc.h"


#define PPWCXF_BUFFER_SIZE	8192



CPPWcxfFile::CPPWcxfFile()
{
    CPPMisc oneMisc;
    
    m_LastError = 0;
    oneMisc.Seedit();
    m_outputDebugFileName = NULL;
}

CPPWcxfFile::~CPPWcxfFile()
{
}


#ifdef PPWCXF_IFACE_UNICODE
void *CPPWcxfFile::OpenWCXFFile(PPWCHAR *fileName,PPDWORD mode)
{
    CPPWcxfFInfo *oneInfoP = 0;
    void *tmpFileH = 0;
    PPWString oneWStr;
    
    if ((mode == DEF_WCXF_OPENFILE_MODE_READ) || (mode == DEF_WCXF_OPENFILE_MODE_WRITE))
    {
        if (fileName != 0)
        {
            oneInfoP = new CPPWcxfFInfo();
            if (oneInfoP != 0)
            {
                if (mode == DEF_WCXF_OPENFILE_MODE_WRITE)
                {
                    tmpFileH = m_FileIo.OpenFile(fileName,"wb");
                    
                }else
                {
                    tmpFileH = m_FileIo.OpenFile(fileName,"rb");
                }
                if (tmpFileH == 0)
                {
                    delete oneInfoP;
                    oneInfoP = 0;
                }else
                {
                    oneInfoP->m_FileH = tmpFileH;
                    oneInfoP->m_Mode = (int)mode;
                    
                    oneInfoP->m_FileNameP = new PPWCHAR[oneWStr.wcslen(fileName)+4];
                    if (oneInfoP->m_FileNameP != 0)
                    {
                        oneWStr.wcscpy(oneInfoP->m_FileNameP,fileName);
                    }
                }
            }
        }
    }
    return oneInfoP;
}
#endif

#ifdef PPWCXF_IFACE_ANSI
void *CPPWcxfFile::OpenWCXFFile(char *fileName,PPDWORD mode)
{
    CPPWcxfFInfo *oneInfoP = 0;
    void *tmpFileH = 0;
    PPWString oneWStr;
    
    if ((mode == DEF_WCXF_OPENFILE_MODE_READ) || (mode == DEF_WCXF_OPENFILE_MODE_WRITE))
    {
        if (fileName != 0)
        {
            oneInfoP = new CPPWcxfFInfo();
            if (oneInfoP != 0)
            {
                if (mode == DEF_WCXF_OPENFILE_MODE_WRITE)
                {
                    tmpFileH = m_FileIo.OpenFile(fileName,"wb");
                    
                }else
                {
                    tmpFileH = m_FileIo.OpenFile(fileName,"rb");
                }
                if (tmpFileH == 0)
                {
                    delete oneInfoP;
                    oneInfoP = 0;
                }else
                {
                    oneInfoP->m_FileH = tmpFileH;
                    oneInfoP->m_Mode = (int)mode;
                    
                    oneInfoP->m_FileNameP = new char[strlen(fileName)+4];
                    if (oneInfoP->m_FileNameP != 0)
                    {
                        strcpy(oneInfoP->m_FileNameP,fileName);
                    }
                }
            }
        }
    }
    return oneInfoP;
}
#endif

int  CPPWcxfFile::CloseWCXFFile(void *fileH)
{
    int iRet = 0;
    CPPWcxfFInfo *oneInfoP = (CPPWcxfFInfo*)fileH;
    void *tmpFileH = 0;
    char *tmpCharP = 0;
    
    
    if (oneInfoP != 0)
    {
        if (oneInfoP->m_Mode == DEF_WCXF_OPENFILE_MODE_WRITE)
        {
            WriteToken(oneInfoP->m_FileH,1,"</array>\xa");
            WriteToken(oneInfoP->m_FileH,0,"</dict>\xa");
            WriteToken(oneInfoP->m_FileH,0,"</plist>\xa");
        }
        iRet = m_FileIo.CloseFile(oneInfoP->m_FileH);
        
        if (oneInfoP->m_Mode == DEF_WCXF_OPENFILE_MODE_WRITE)
        {
            // ץ CreateTime T.
            if ((m_kWCXF_R_FileCreateTime_Old.m_Year != m_kWCXF_R_FileCreateTime.m_Year) ||
                (m_kWCXF_R_FileCreateTime_Old.m_Month != m_kWCXF_R_FileCreateTime.m_Month) ||
                (m_kWCXF_R_FileCreateTime_Old.m_Day != m_kWCXF_R_FileCreateTime.m_Day) ||
                (m_kWCXF_R_FileCreateTime_Old.m_Hour != m_kWCXF_R_FileCreateTime.m_Hour) ||
                (m_kWCXF_R_FileCreateTime_Old.m_Minute != m_kWCXF_R_FileCreateTime.m_Minute) ||
                (m_kWCXF_R_FileCreateTime_Old.m_Second != m_kWCXF_R_FileCreateTime.m_Second))
            {
                tmpFileH = m_FileIo.OpenFile(oneInfoP->m_FileNameP,"r+b");
                if (tmpFileH != 0)
                {
                    m_FileIo.FileSeek(tmpFileH,m_kWCXF_R_FileCreateTimePos,SEEK_SET);
                    
                    tmpCharP = GetDateStringA(m_kWCXF_R_FileCreateTime);
                    if (tmpCharP != 0)
                    {
                        m_FileIo.WriteFile(tmpFileH,tmpCharP,1,(int)strlen(tmpCharP));
                        delete [] tmpCharP;
                    }
                    m_FileIo.CloseFile(tmpFileH);
                }
            }
            
        }
        if (oneInfoP->m_FileNameP != 0)
        {
            delete [] oneInfoP->m_FileNameP;
            oneInfoP->m_FileNameP = 0;
        }
        delete oneInfoP;
    }
    return iRet;
}


int  CPPWcxfFile::GetRootInfo(void *fileH)
{
    CPPWcxfFInfo *oneInfoP = (CPPWcxfFInfo*)fileH;
    PPINT64 iOldPos;
    PPINT64 fileLen;
    PPINT64 findPos;
    PPINT64 tmpOffset;
    PPINT64 iStartPos,iEndPos;
    int iFindCount = 0;
    PPCStringW tmpStr;
    PPINT64 iEndPos1 = 0;
    int iOKFlag = 0;
    
    if ((oneInfoP != 0) && (oneInfoP->m_Mode == DEF_WCXF_OPENFILE_MODE_READ))
    {
        if (oneInfoP->m_FileH != 0)
        {
            iOldPos = m_FileIo.GetFilePos(oneInfoP->m_FileH);
            if (m_FileIo.FileSeek(oneInfoP->m_FileH,0,SEEK_END) == 0)
            {
                fileLen = m_FileIo.GetFilePos(oneInfoP->m_FileH);
                m_FileIo.FileSeek(oneInfoP->m_FileH,0,SEEK_SET);
                
                findPos = GetRootKeyPos(oneInfoP->m_FileH,kWCXF_R_CardArray,fileLen);
                if (findPos != -1)
                {
                    tmpOffset = findPos;
                    if (FindInFile(oneInfoP->m_FileH,"<array>",&tmpOffset,0) != 0)
                    {
                        m_kWCXF_R_CardArrayPos = tmpOffset += strlen("<array>");
                        iFindCount++;
                    }
                }
                
                // 2013/03/29 [J۰ʭץRoot ϰ~ by knight
                findPos = GetRootKeyPos(oneInfoP->m_FileH,kWCXF_R_CardCount,fileLen);
                if (findPos != -1)
                {
                    tmpOffset = findPos;
                    m_kWCXF_R_CardCountPos = tmpOffset;
                    
                    if (FindInFile(oneInfoP->m_FileH,"<key>",&tmpOffset,(PPINT64)0) != 0)
                    {
                        iEndPos1 = tmpOffset;
                    }else
                    {
                        iEndPos1 = 0;
                    }
                    
                    tmpOffset = m_kWCXF_R_CardCountPos;
                    iOKFlag = 0;
                    
                    if (FindInFile(oneInfoP->m_FileH,"<integer>",&tmpOffset,iEndPos1) != 0)
                    {
                        iStartPos = tmpOffset + strlen("<integer>");
                        
                        tmpOffset = iStartPos;
                        if (FindInFile(oneInfoP->m_FileH,"</integer>",&tmpOffset,iEndPos1) != 0)
                        {
                            iEndPos = tmpOffset;
                            tmpStr = ReadFilePos(oneInfoP->m_FileH,iStartPos,iEndPos-iStartPos);
                            
                            tmpStr.TrimLeft(" \t\r\n");
                            tmpStr.TrimRight(" \t\r\n");
                            m_kWCXF_R_CardCount = tmpStr.ToValue();
                            iFindCount++;
                            iOKFlag = 1;
                        }
                    }
                    if (iOKFlag == 0)
                    {
                        tmpOffset = m_kWCXF_R_CardCountPos;
                        if (FindInFile(oneInfoP->m_FileH,"<string>",&tmpOffset,iEndPos1) != 0)
                        {
                            iStartPos = tmpOffset + strlen("<string>");
                            
                            tmpOffset = iStartPos;
                            if (FindInFile(oneInfoP->m_FileH,"</string>",&tmpOffset,iEndPos1) != 0)
                            {
                                iEndPos = tmpOffset;
                                tmpStr = ReadFilePos(oneInfoP->m_FileH,iStartPos,iEndPos-iStartPos);
                                
                                tmpStr.TrimLeft(" \t\r\n");
                                tmpStr.TrimRight(" \t\r\n");
                                m_kWCXF_R_CardCount = tmpStr.ToValue();
                                iFindCount++;
                            }
                        }
                    }
                }
                
                // 2013/03/29 [J۰ʭץRoot ϰ~ by knight
                findPos = GetRootKeyPos(oneInfoP->m_FileH,kWCXF_R_FormatVersion,fileLen);
                if (findPos != -1)
                {
                    m_kWCXF_R_FormatVersionPos = findPos;
                    tmpOffset = findPos;
                    
                    if (FindInFile(oneInfoP->m_FileH,"<key>",&tmpOffset,(PPINT64)0) != 0)
                    {
                        iEndPos1 = tmpOffset;
                    }else
                    {
                        iEndPos1 = 0;
                    }
                    tmpOffset = m_kWCXF_R_FormatVersionPos;
                    iOKFlag = 0;
                    
                    if (FindInFile(oneInfoP->m_FileH,"<integer>",&tmpOffset,iEndPos1) != 0)
                    {
                        iStartPos = tmpOffset + strlen("<integer>");
                        
                        tmpOffset = iStartPos;
                        if (FindInFile(oneInfoP->m_FileH,"</integer>",&tmpOffset,0) != 0)
                        {
                            iEndPos = tmpOffset;
                            tmpStr = ReadFilePos(oneInfoP->m_FileH,iStartPos,iEndPos-iStartPos);
                            
                            tmpStr.TrimLeft(" \t\r\n");
                            tmpStr.TrimRight(" \t\r\n");
                            m_kWCXF_R_FormatVersion = tmpStr.ToValue();
                            iFindCount++;
                            iOKFlag = 1;
                        }
                    }
                    
                    if (iOKFlag == 0)
                    {
                        tmpOffset = m_kWCXF_R_FormatVersionPos;
                        if (FindInFile(oneInfoP->m_FileH,"<string>",&tmpOffset,iEndPos1) != 0)
                        {
                            iStartPos = tmpOffset + strlen("<string>");
                            
                            tmpOffset = iStartPos;
                            if (FindInFile(oneInfoP->m_FileH,"</string>",&tmpOffset,iEndPos1) != 0)
                            {
                                iEndPos = tmpOffset;
                                tmpStr = ReadFilePos(oneInfoP->m_FileH,iStartPos,iEndPos-iStartPos);
                                
                                tmpStr.TrimLeft(" \t\r\n");
                                tmpStr.TrimRight(" \t\r\n");
                                m_kWCXF_R_FormatVersion = tmpStr.ToValue();
                                iFindCount++;
                            }
                        }
                    }
                    
                    
                }
                
                findPos = GetRootKeyPos(oneInfoP->m_FileH,kWCXF_R_Generator,fileLen);
                if (findPos != -1)
                {
                    m_kWCXF_R_GeneratorPos = findPos;
                    tmpOffset = findPos;
                    if (FindInFile(oneInfoP->m_FileH,"<string>",&tmpOffset,0) != 0)
                    {
                        iStartPos = tmpOffset + strlen("<string>");
                        
                        tmpOffset = iStartPos;
                        if (FindInFile(oneInfoP->m_FileH,"</string>",&tmpOffset,0) != 0)
                        {
                            iEndPos = tmpOffset;
                            tmpStr = ReadFilePos_UTF8(oneInfoP->m_FileH,iStartPos,iEndPos-iStartPos);
                            tmpStr.TrimLeft(" \t\r\n");
                            tmpStr.TrimRight(" \t\r\n");
                            m_kWCXF_R_Generator = tmpStr;
                            iFindCount++;
                        }
                    }
                }
                
                //oǥiiL,pbTcount.-------------
                findPos = GetRootKeyPos(oneInfoP->m_FileH,kWCXF_R_FileID,fileLen);
                if (findPos != -1)
                {
                    tmpOffset = findPos;
                    if (FindInFile(oneInfoP->m_FileH,"<string>",&tmpOffset,0) != 0)
                    {
                        iStartPos = tmpOffset + strlen("<string>");
                        
                        tmpOffset = iStartPos;
                        if (FindInFile(oneInfoP->m_FileH,"</string>",&tmpOffset,0) != 0)
                        {
                            iEndPos = tmpOffset;
                            tmpStr = ReadFilePos_UTF8(oneInfoP->m_FileH,iStartPos,iEndPos-iStartPos);
                            tmpStr.TrimLeft(" \t\r\n");
                            tmpStr.TrimRight(" \t\r\n");
                            m_kWCXF_R_FileID = tmpStr;
                        }
                    }
                    
                }
                
                //oǥiiL,pbTcount.-------------
                findPos = GetRootKeyPos(oneInfoP->m_FileH,kWCXF_R_FileCreateTime,fileLen);
                if (findPos != -1)
                {
                    tmpOffset = findPos;
                    if (FindInFile(oneInfoP->m_FileH,"<date>",&tmpOffset,0) != 0)
                    {
                        iStartPos = tmpOffset + strlen("<date>");
                        
                        tmpOffset = iStartPos;
                        if (FindInFile(oneInfoP->m_FileH,"</date>",&tmpOffset,0) != 0)
                        {
                            iEndPos = tmpOffset;
                            tmpStr = ReadFilePos_UTF8(oneInfoP->m_FileH,iStartPos,iEndPos-iStartPos);
                            tmpStr.TrimLeft(" \t\r\n");
                            tmpStr.TrimRight(" \t\r\n");
                            ConvertString2PPDate(tmpStr,m_kWCXF_R_FileCreateTime);
                            
                        }
                    }
                    
                }
            }
            //myFileSeek(oneInfoP->m_FileH,iOldPos,FILE_BEGIN);
            m_FileIo.FileSeek(oneInfoP->m_FileH,iOldPos,SEEK_SET);
        }
    }
    if (iFindCount == 4)
    {
        return PPTRUE;
    }else
    {
        return PPFALSE;
    }
}




PPINT64 CPPWcxfFile::GetRootKeyPos(void *hf,const char *keyName,PPINT64 fileLen)
{
    PPINT64 iOldPos;
    PPINT64 retPos = -1;
    PPINT64 tmpOffset;
    
    
    iOldPos = m_FileIo.GetFilePos(hf);
    m_FileIo.FileSeek(hf,0,SEEK_SET);
    
    if (fileLen >= 512*1024) //ɮ׶WL512K
    {
        tmpOffset = 0;
        if (FindInFile(hf,keyName,&tmpOffset,8192) != 0)
        {
            retPos = tmpOffset;
        }else
        {
            tmpOffset = fileLen - 8192;
            if (FindInFile(hf,keyName,&tmpOffset,0) != 0)
            {
                retPos = tmpOffset;
            }
        }
    }else
    {
        tmpOffset = 0;
        if (FindInFile(hf,keyName,&tmpOffset,8192) != 0)
        {
            retPos = tmpOffset;
        }
    }
    m_FileIo.FileSeek(hf,iOldPos,SEEK_SET);
    //myFileSeek(hf,iOldPos,FILE_BEGIN);
    return retPos;
    
}


int CPPWcxfFile::FindInFile(void *fpH,const char *findString,PPINT64 *offset,PPINT64 endOffset)
{
    int tOne,sLen,boundFlag;
    int findIdx,firstFlag;
    PPINT64 oldPos,nowRealPos,oldRealPos;
    PPINT64 readIdx,readCount;
    PPDWORD tmpDWORD;
    unsigned char Buffer[PPWCXF_BUFFER_SIZE];
    
    if (fpH == NULL)
        return 0;
    if (findString == NULL)
        return 0;
    
    sLen = (int)strlen((char*)findString);
    if (sLen <= 0)
        return 0;
    
    /* Cycle until end of file reached: */
    if (*offset != 0)
    {
        if (m_FileIo.FileSeek(fpH,*offset,SEEK_SET) != 0)
        {
            return 0;
        }
    }
    firstFlag = 1;
    findIdx = 0;
    boundFlag = 0;
    
    nowRealPos = m_FileIo.GetFilePos(fpH);
    while(1)
    {
        readIdx = 0;
        
        tmpDWORD = m_FileIo.ReadFile(fpH,Buffer,sizeof(char),PPWCXF_BUFFER_SIZE);
        
        readCount = tmpDWORD;
        //readCount = fread(Buffer,sizeof(unsigned char),PPWMXF_BUFFER_SIZE,fp);
        nowRealPos += readCount;
        while (readCount > readIdx)
        {
            //tOne = fgetc(fp);
            tOne = Buffer[readIdx++];
            if ((char)tOne == findString[findIdx])
            {
                if (firstFlag == 1)
                {
                    oldPos = readIdx - 1;
                    oldRealPos = nowRealPos - readCount + oldPos;
                    firstFlag = 0;
                }
                findIdx ++;
                if (findIdx >= sLen)
                {
                    *offset = oldRealPos;
                    
                    m_FileIo.FileSeek(fpH,*offset,SEEK_SET);
                    return 1;
                }
            }else
            {
                if (firstFlag == 0)
                {
                    if (boundFlag != 0)
                    {
                        firstFlag = 1;
                        findIdx = 0;
                        boundFlag = 0;
                        //fseek(fp,oldRealPos+1,SEEK_SET);
                        //myFileSeek(fpH,oldRealPos+1,FILE_BEGIN);
                        m_FileIo.FileSeek(fpH,oldRealPos+1,SEEK_SET);
                        readCount = PPWCXF_BUFFER_SIZE;
                        nowRealPos = oldRealPos+1;
                        break;
                    }else
                    {
                        readIdx = oldPos+1;
                    }
                }else
                {
                    
                }
                firstFlag = 1;
                findIdx = 0;
                boundFlag = 0;
            }
            if (endOffset != 0)
            {
                if (nowRealPos- readCount +readIdx > endOffset)
                {
                    return 0;
                }
            }
        }
        if (firstFlag == 0)
        {
            boundFlag++;
        }
        if (readCount != PPWCXF_BUFFER_SIZE)
        {
            break;
        }
    }
    return 0;
}


PPCStringW CPPWcxfFile::ReadFilePos(void *hf,PPINT64 startPos,PPINT64 iLen)
{
    char *Buffer = 0;
    PPDWORD realRead;
    PPCStringW tmpStr;
    PPINT64 iOldPos;
    
    tmpStr = "";
    iOldPos = m_FileIo.GetFilePos(hf);
    
    Buffer = CPPMem.new_char((int)(iLen+4));
    if (Buffer != 0)
    {
        if (m_FileIo.FileSeek(hf,startPos,SEEK_SET) == 0)
        {
            realRead = m_FileIo.ReadFile(hf,Buffer,sizeof(char),(int)iLen);
            Buffer[realRead] = 0;
            
            tmpStr = Buffer;
        }
        delete [] Buffer;
    }
    m_FileIo.FileSeek(hf,iOldPos,SEEK_SET);
    
    return tmpStr;
}

PPCStringW CPPWcxfFile::ReadFilePos_UTF8(void *hf,PPINT64 startPos,PPINT64 iLen)
{
    char *Buffer = 0;
    PPDWORD realRead;
    PPCStringW tmpStr;
    PPINT64 iOldPos;
    PPWCHAR *uniBuffer;
    int idx;
    
    tmpStr = "";
    iOldPos = m_FileIo.GetFilePos(hf);
    
    Buffer = CPPMem.new_char((int)(iLen+4));
    if (Buffer != 0)
    {
        uniBuffer = CPPMem.new_PPWCHAR((int)(iLen+4));
        if (uniBuffer != 0)
        {
            if (m_FileIo.FileSeek(hf,startPos,SEEK_SET) == 0)
            {
                realRead = m_FileIo.ReadFile(hf,Buffer,sizeof(char),(int)iLen);
                Buffer[realRead] = 0;
                
                idx = m_Code.PPUTF82Unicode(Buffer,(int)strlen(Buffer),uniBuffer,(int)(PPDWORD)iLen+4);
                //idx = MultiByteToWideChar(CP_UTF8,0,Buffer,strlen(Buffer),uniBuffer,(DWORD)iLen+4);
                if (idx >= 0)
                {
                    uniBuffer[idx] = 0;
                }
                tmpStr = uniBuffer;
            }
            delete [] uniBuffer;
        }
        delete [] Buffer;
    }
    //myFileSeek(hf,iOldPos,FILE_BEGIN);
    m_FileIo.FileSeek(hf,iOldPos,SEEK_SET);
    return tmpStr;
}

void *CPPWcxfFile::ReadFilePosMem(void *hf,PPINT64 startPos,PPINT64 iLen,PPDWORD *retLen)
{
    char *Buffer = 0;
    PPDWORD realRead;
    PPINT64 iOldPos;
    int iErrFlag = 1;
    
    
    iOldPos = m_FileIo.GetFilePos(hf);
    //iOldPos = myGetFilePos(hf);
    //Buffer = (char*)GlobalAlloc(GPTR,sizeof(char)*(DWORD)iLen+4);
    Buffer = CPPMem.new_char((int)(iLen+4));
    if (Buffer != 0)
    {
        if (m_FileIo.FileSeek(hf,startPos,SEEK_SET) == 0)
        {
            realRead = m_FileIo.ReadFile(hf,Buffer,sizeof(char),(int)iLen);
            Buffer[realRead] = 0;
            iErrFlag = 0;
            *retLen = realRead;
        }
    }
    
    m_FileIo.FileSeek(hf,iOldPos,SEEK_SET);
    
    if (iErrFlag == 1)
    {
        if (Buffer != 0)
        {
            delete [] Buffer;
            Buffer = 0;
        }
    }
    return Buffer;
}



PPCStringW CPPWcxfFile::ChangeXMLString(PPCStringW tmpStr)
{
    PPCStringW okString;
    int i;
    PPWCHAR tmpW[2];
    
    okString = "";
    tmpStr.Replace("&amp;","&");
    tmpStr.Replace("&lt;","<");
    tmpStr.Replace("&gt;",">");
    tmpStr.Replace("&quot;","\"");
    tmpStr.Replace("&apos;","'");
    
    tmpW[1] = 0;
    for (i = 0;i < tmpStr.GetLength();i++)
    {
        tmpW[0] = tmpStr.GetAt(i);
        if ((tmpW[0] > 0) && (tmpW[0] <= 0x20))
        {
            if ((tmpW[0] == 0xD) || (tmpW[0] == 0xA) || (tmpW[0] == 0x9) || (tmpW[0] == 0x20))
            {
                okString += tmpW;
            }
        }else
        {
            okString += tmpW;
        }
    }
    return okString;
}

PPCStringW CPPWcxfFile::ChangeXMLString_Write(PPCStringW tmpStr)
{
    PPCStringW okString;
    int i;
    PPWCHAR tmpW[2];
    
    
    okString = "";
    
    tmpStr.Replace("&","&amp;");
    tmpStr.Replace("<","&lt;");
    tmpStr.Replace(">","&gt;");
    tmpStr.Replace("\"","&quot;");
    tmpStr.Replace("'","&apos;");
    
    tmpW[1] = 0;
    for (i = 0;i < tmpStr.GetLength();i++)
    {
        tmpW[0] = tmpStr.GetAt(i);
        if ((tmpW[0] > 0) && (tmpW[0] <= 0x20))
        {
            if ((tmpW[0] == 0xD) || (tmpW[0] == 0xA) || (tmpW[0] == 0x9) || (tmpW[0] == 0x20))
            {
                okString += tmpW;
            }
        }else
        {
            okString += tmpW;
        }
    }
    return okString;
}






void *CPPWcxfFile::ConvertFromBase64(PPCStringW base64Code,unsigned int *outSize)
{
    int iLen,idx;
    char *inBuffer;
    PPWCHAR *wBufferP;
    void *retPtr = 0;
    PPWString oneWStr;
    
    iLen = base64Code.GetLength();
    inBuffer = CPPMem.new_char(iLen+10);
    if (inBuffer != 0)
    {
        wBufferP = CPPMem.new_PPWCHAR(iLen+10);
        if (wBufferP != 0)
        {
            oneWStr.wcscpy(wBufferP,base64Code);
            idx = m_Code.PPUnicode2UTF8(wBufferP,iLen,inBuffer,iLen+10);
            if (idx >= 0)
            {
                inBuffer[idx] = 0;
            }
            retPtr = m_Base64.NewBase64Decode((const char *)inBuffer,idx,(int*)outSize);
            
            delete [] wBufferP;
        }
        delete [] inBuffer;
    }
    return retPtr;
}

int CPPWcxfFile::Convert2WcxfRecord(void *oneDict,WCXFRecord &oneRecord)
{
    int rCount = 0;
    PPCStringW lastKeyStr;
    
    lastKeyStr = "";
    CollectOneCard(oneDict,rCount,oneRecord,lastKeyStr);
    //-- 105 sW ------------------------------------------------------------------------------v---
    FilterFields(oneRecord);
    //-- 105 sW ------------------------------------------------------------------------------^---
    return 1;
}


void CPPWcxfFile::FreeOneRecord(WCXFRecord &oneRecord)
{
    int i,j;
    WCXFRecord_Name *oneNamePtr;
    WCXFRecord_Adrs  *oneAdrsPtr;
    WCXFRecord_AdrsL3 *tmpAdrsL3Ptr;
    WCXFRecord_Company *oneCompanyPtr;
    WCXFRecord_Email *oneEmailPtr;
    WCXFRecord_URL *oneURLPtr;
    WCXFRecord_IM *oneIMPtr;
    WCXFRecord_IML3 *oneIMPL3tr;
    WCXFRecord_Date *oneDatePtr;
    PPDate *onePPDatePtr;
    WCXFRecord_Phone *onePhonePtr;
    
    
    // M Address----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_AddressPtrDQ.size();i++)
    {
        oneAdrsPtr = oneRecord.m_AddressPtrDQ[i];
        if (oneAdrsPtr != 0)
        {
            for (j = 0;j < (int)oneAdrsPtr->m_HomePtrDQ.size();j++)
            {
                tmpAdrsL3Ptr = oneAdrsPtr->m_HomePtrDQ[j];
                if (tmpAdrsL3Ptr != 0)
                {
                    delete tmpAdrsL3Ptr;
                }
            }
            oneAdrsPtr->m_HomePtrDQ.clear();
            //---------------------------------------------------
            for (j = 0;j < (int)oneAdrsPtr->m_OtherPtrDQ.size();j++)
            {
                tmpAdrsL3Ptr = oneAdrsPtr->m_OtherPtrDQ[j];
                if (tmpAdrsL3Ptr != 0)
                {
                    delete tmpAdrsL3Ptr;
                }
            }
            oneAdrsPtr->m_OtherPtrDQ.clear();
            //---------------------------------------------------
            for (j = 0;j < (int)oneAdrsPtr->m_WorkPtrDQ.size();j++)
            {
                tmpAdrsL3Ptr = oneAdrsPtr->m_WorkPtrDQ[j];
                if (tmpAdrsL3Ptr != 0)
                {
                    delete tmpAdrsL3Ptr;
                }
            }
            oneAdrsPtr->m_WorkPtrDQ.clear();
            delete oneAdrsPtr;
        }
    }
    oneRecord.m_AddressPtrDQ.clear();
    // M Address----------------------------------------------------^-
    // M Comapny----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_CompanyPtrDQ.size();i++)
    {
        oneCompanyPtr = oneRecord.m_CompanyPtrDQ[i];
        if (oneCompanyPtr != 0)
        {
            delete oneCompanyPtr;
        }
    }
    oneRecord.m_CompanyPtrDQ.clear();
    // M Comapny----------------------------------------------------^-
    
    
    // M Date----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_DatePtrDQ.size();i++)
    {
        oneDatePtr = oneRecord.m_DatePtrDQ[i];
        if (oneDatePtr != 0)
        {
            for (j = 0;j < (int)oneDatePtr->m_AnniversaryPtrDQ.size();j++)
            {
                onePPDatePtr = oneDatePtr->m_AnniversaryPtrDQ[j];
                if (onePPDatePtr != 0)
                {
                    delete onePPDatePtr;
                }
            }
            oneDatePtr->m_AnniversaryPtrDQ.clear();
            
            for (j = 0;j < (int)oneDatePtr->m_OtherPtrDQ.size();j++)
            {
                onePPDatePtr = oneDatePtr->m_OtherPtrDQ[j];
                if (onePPDatePtr != 0)
                {
                    delete onePPDatePtr;
                }
            }
            oneDatePtr->m_OtherPtrDQ.clear();
            
            
            delete oneDatePtr;
        }
    }
    oneRecord.m_DatePtrDQ.clear();
    // M Date----------------------------------------------------^-
    
    
    // M Email----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_EmailPtrDQ.size();i++)
    {
        oneEmailPtr = oneRecord.m_EmailPtrDQ[i];
        if (oneEmailPtr != 0)
        {
            delete oneEmailPtr;
        }
    }
    oneRecord.m_EmailPtrDQ.clear();
    // M Email----------------------------------------------------^-
    
    // M Group----------------------------------------------------v-
    oneRecord.m_GroupPtrDQ.clear();
    // M Group----------------------------------------------------^-
    
    // M IM ----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_InstantMessagePtrDQ.size();i++)
    {
        oneIMPtr = oneRecord.m_InstantMessagePtrDQ[i];
        if (oneIMPtr != 0)
        {
            for (j = 0;j < (int)oneIMPtr->m_HomePtrDQ.size();j++)
            {
                oneIMPL3tr = oneIMPtr->m_HomePtrDQ[j];
                if (oneIMPL3tr != 0)
                {
                    delete oneIMPL3tr;
                }
            }
            oneIMPtr->m_HomePtrDQ.clear();
            //---------------------------------------------------
            for (j = 0;j < (int)oneIMPtr->m_OtherPtrDQ.size();j++)
            {
                oneIMPL3tr = oneIMPtr->m_OtherPtrDQ[j];
                if (oneIMPL3tr != 0)
                {
                    delete oneIMPL3tr;
                }
            }
            oneIMPtr->m_OtherPtrDQ.clear();
            //---------------------------------------------------
            for (j = 0;j < (int)oneIMPtr->m_WorkPtrDQ.size();j++)
            {
                oneIMPL3tr = oneIMPtr->m_WorkPtrDQ[j];
                if (oneIMPL3tr != 0)
                {
                    delete oneIMPL3tr;
                }
            }
            oneIMPtr->m_WorkPtrDQ.clear();
            //---------------------------------------------------
            delete oneIMPtr;
        }
    }
    oneRecord.m_InstantMessagePtrDQ.clear();
    // M IM----------------------------------------------------^-
    
    // M Name----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_NamePtrDQ.size();i++)
    {
        oneNamePtr = oneRecord.m_NamePtrDQ[i];
        if (oneNamePtr != 0)
        {
            delete oneNamePtr;
        }
    }
    oneRecord.m_NamePtrDQ.clear();
    // M Name----------------------------------------------------^-
    // M Phone---------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_PhonePtrDQ.size();i++)
    {
        onePhonePtr = oneRecord.m_PhonePtrDQ[i];
        if (onePhonePtr != 0)
        {
            delete onePhonePtr;
        }
    }
    oneRecord.m_PhonePtrDQ.clear();
    // M Phone----------------------------------------------------^-
    
    // M URL---------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_URLPtrDQ.size();i++)
    {
        oneURLPtr = oneRecord.m_URLPtrDQ[i];
        if (oneURLPtr != 0)
        {
            delete oneURLPtr;
        }
    }
    oneRecord.m_URLPtrDQ.clear();
    // M URL----------------------------------------------------^-
    
    //-- 105 sW ------------------------------------------------------------------------------v---
    // M GroupV2---------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_GroupV2PtrDQ.size();i++)
    {
        WCXFRecord_GroupV2 *oneGroupV2Ptr = oneRecord.m_GroupV2PtrDQ[i];
        if (oneGroupV2Ptr != 0)
        {
            delete oneGroupV2Ptr;
        }
    }
    oneRecord.m_GroupV2PtrDQ.clear();
    // M GroupV2----------------------------------------------------^-
    
    // M UserDefine---------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_UserDefinePtrDQ.size();i++)
    {
        WCXFRecord_UD_L1 *oneUDL1P = oneRecord.m_UserDefinePtrDQ[i];
        if (oneUDL1P != 0)
        {
            for (j = 0;j < (int)oneUDL1P->m_UserDefinePDQ.size();j++)
            {
                WCXFRecord_UD_L2 *oneUDL2P= oneUDL1P->m_UserDefinePDQ[j];
                if (oneUDL2P != 0)
                {
                    delete oneUDL2P;
                }
            }
            oneUDL1P->m_UserDefinePDQ.clear();
            delete oneUDL1P;
        }
    }
    oneRecord.m_UserDefinePtrDQ.clear();
    // M UserDefine----------------------------------------------------^-
    
    // M Tags---------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_TagPtrDQ.size();i++)
    {
        WCXFRecord_Tag_L1 *oneTag1P = oneRecord.m_TagPtrDQ[i];
        if (oneTag1P != 0)
        {
            for (j = 0;j < (int)oneTag1P->m_TagPDQ.size();j++)
            {
                WCXFRecord_Tag_L2 *oneTag2P= oneTag1P->m_TagPDQ[j];
                if (oneTag2P != 0)
                {
                    delete oneTag2P;
                }
            }
            oneTag1P->m_TagPDQ.clear();
            delete oneTag1P;
        }
    }
    oneRecord.m_TagPtrDQ.clear();
    // M Tags----------------------------------------------------^-
    //-- 105 sW ------------------------------------------------------------------------------^---
    
    
}

void CPPWcxfFile::DumpAddressL3(WCXFRecord_AdrsL3 *tmpAdrsL3Ptr,CPPFileIo &oneFileIo)
{
    char BufferA[256];
    
    if (tmpAdrsL3Ptr != 0)
    {
        if (tmpAdrsL3Ptr->m_Street.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_Address_Street:");
            oneFileIo.PPOutputDebugString(tmpAdrsL3Ptr->m_Street);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpAdrsL3Ptr->m_City.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_Address_City:");
            oneFileIo.PPOutputDebugString(tmpAdrsL3Ptr->m_City);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpAdrsL3Ptr->m_State.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_Address_State:");
            oneFileIo.PPOutputDebugString(tmpAdrsL3Ptr->m_State);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpAdrsL3Ptr->m_ZIP.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_Address_ZIP:");
            oneFileIo.PPOutputDebugString(tmpAdrsL3Ptr->m_ZIP);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpAdrsL3Ptr->m_Country.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_Address_Country:");
            oneFileIo.PPOutputDebugString(tmpAdrsL3Ptr->m_Country);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpAdrsL3Ptr->m_CountryCode.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_Address_CountryCode:");
            oneFileIo.PPOutputDebugString(tmpAdrsL3Ptr->m_CountryCode);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_Address_Format:");
        pp_itoa(tmpAdrsL3Ptr->m_Format,BufferA,10);
        oneFileIo.PPOutputDebugString(BufferA);
        oneFileIo.PPOutputDebugString("\r\n");
        
        if (tmpAdrsL3Ptr->m_GPS.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_Address_GPS:");
            oneFileIo.PPOutputDebugString(tmpAdrsL3Ptr->m_GPS);
            oneFileIo.PPOutputDebugString("\r\n");
        }
    }
}

void CPPWcxfFile::DumpDate(PPDate *oneDatePtr,const char *preChar,CPPFileIo &oneFileIo)
{
    char BufferA[256];
    
    if (oneDatePtr != 0)
    {
        sprintf(BufferA,"%04d%02d%02d-%02d%02d%02d",oneDatePtr->m_Year,oneDatePtr->m_Month,oneDatePtr->m_Day,oneDatePtr->m_Hour,oneDatePtr->m_Minute,oneDatePtr->m_Second);
        if (preChar != 0)
        {
            oneFileIo.PPOutputDebugString((char*)preChar);
        }
        oneFileIo.PPOutputDebugString(BufferA);
        oneFileIo.PPOutputDebugString("\r\n");
    }
}

void CPPWcxfFile::DumpIML3(WCXFRecord_IML3 *tmpIML3Ptr,CPPFileIo &oneFileIo)
{
    int i;
    if (tmpIML3Ptr != 0)
    {
        if (tmpIML3Ptr->m_AIMPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpIML3Ptr->m_AIMPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_IM_AIM:");
                oneFileIo.PPOutputDebugString(*tmpIML3Ptr->m_AIMPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        if (tmpIML3Ptr->m_GoogleTalkPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpIML3Ptr->m_GoogleTalkPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_IM_GoogleTalk:");
                oneFileIo.PPOutputDebugString(*tmpIML3Ptr->m_GoogleTalkPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        if (tmpIML3Ptr->m_ICQPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpIML3Ptr->m_ICQPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_IM_ICQ:");
                oneFileIo.PPOutputDebugString(*tmpIML3Ptr->m_ICQPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        if (tmpIML3Ptr->m_JabberPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpIML3Ptr->m_JabberPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_IM_Jabber:");
                oneFileIo.PPOutputDebugString(*tmpIML3Ptr->m_JabberPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        if (tmpIML3Ptr->m_MSNPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpIML3Ptr->m_MSNPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_IM_MSN:");
                oneFileIo.PPOutputDebugString(*tmpIML3Ptr->m_MSNPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        if (tmpIML3Ptr->m_QQPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpIML3Ptr->m_QQPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_IM_QQ:");
                oneFileIo.PPOutputDebugString(*tmpIML3Ptr->m_QQPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        if (tmpIML3Ptr->m_YahooMessengerPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpIML3Ptr->m_YahooMessengerPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL3_IM_YahooMessenger:");
                oneFileIo.PPOutputDebugString(*tmpIML3Ptr->m_YahooMessengerPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
    }
}

void CPPWcxfFile::DumpNameL2(WCXFRecord_Name *tmpNamePtr,CPPFileIo &oneFileIo)
{
    //char BufferA[256];
    
    if (tmpNamePtr != 0)
    {
        if (tmpNamePtr->m_Name_Full.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_Full:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_Full);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        if (tmpNamePtr->m_Name_First.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_First:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_First);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        if (tmpNamePtr->m_Name_Middle.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_Middle:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_Middle);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        if (tmpNamePtr->m_Name_Last.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_Last:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_Last);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        if (tmpNamePtr->m_Name_PhoneticFull.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_PhoneticFull:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_PhoneticFull);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpNamePtr->m_Name_PhoneticFirst.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_PhoneticFirst:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_PhoneticFirst);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpNamePtr->m_Name_PhoneticMiddle.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_PhoneticMiddle:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_PhoneticMiddle);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpNamePtr->m_Name_PhoneticLast.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_PhoneticLast:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_PhoneticLast);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpNamePtr->m_Name_Prefix.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_Prefix:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_Prefix);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        if (tmpNamePtr->m_Name_Suffix.GetLength() > 0)
        {
            oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Name_Suffix:");
            oneFileIo.PPOutputDebugString(tmpNamePtr->m_Name_Suffix);
            oneFileIo.PPOutputDebugString("\r\n");
        }
        
        
    }
}


void CPPWcxfFile::DumpPhoneL2(WCXFRecord_Phone *tmpPhonePtr,CPPFileIo &oneFileIo)
{
    int i;
    if (tmpPhonePtr != 0)
    {
        if (tmpPhonePtr->m_Phone_WorkPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_WorkPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_Work:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_WorkPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_HomePtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_HomePtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_Home:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_HomePtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_OtherPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_OtherPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_Other:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_OtherPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_MobilePtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_MobilePtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_Mobile:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_MobilePtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_MainPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_MainPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_Main:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_MainPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_PrimaryPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_PrimaryPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_Primary:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_PrimaryPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_GoogleVoicePtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_GoogleVoicePtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_GoogleVoice:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_GoogleVoicePtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_iPhonePtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_GoogleVoicePtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_iPhone:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_iPhonePtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_PagerPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_PagerPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_Pager:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_PagerPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_WorkFaxPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_WorkFaxPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_WorkFax:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_WorkFaxPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_HomeFaxPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_HomeFaxPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_HomeFax:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_HomeFaxPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpPhonePtr->m_Phone_OtherFaxPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpPhonePtr->m_Phone_OtherFaxPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_Phone_OtherFax:");
                oneFileIo.PPOutputDebugString(*tmpPhonePtr->m_Phone_OtherFaxPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
    }
}


void CPPWcxfFile::DumpURLL2(WCXFRecord_URL *tmpURLPtr,CPPFileIo &oneFileIo)
{
    int i;
    
    if (tmpURLPtr != 0)
    {
        if (tmpURLPtr->m_HomePagePtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_HomePagePtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_HomePage:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_HomePagePtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpURLPtr->m_WorkPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_WorkPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_Work:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_WorkPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpURLPtr->m_HomePtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_HomePtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_Home:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_HomePtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpURLPtr->m_FacebookPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_FacebookPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_Facebook:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_FacebookPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpURLPtr->m_TwitterPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_TwitterPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_Twitter:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_TwitterPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpURLPtr->m_PlurkPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_PlurkPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_Plurk:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_PlurkPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpURLPtr->m_LinkedInPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_LinkedInPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_LinkedIn:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_LinkedInPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpURLPtr->m_ProfilePtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_ProfilePtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_Profile:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_ProfilePtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpURLPtr->m_BlogPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_BlogPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_Blog:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_BlogPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
        if (tmpURLPtr->m_OtherPtrDQ.size() > 0)
        {
            for (i = 0;i < (int)tmpURLPtr->m_OtherPtrDQ.size();i++)
            {
                oneFileIo.PPOutputDebugString("\t\tkWCXF_CDL2_URL_Other:");
                oneFileIo.PPOutputDebugString(*tmpURLPtr->m_OtherPtrDQ[i]);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        
    }
}

void CPPWcxfFile::DumpInt(int iNum,CPPFileIo &oneFileIo)
{
    char Buffer[1024];
    
    pp_itoa(iNum,Buffer,10);
    oneFileIo.PPOutputDebugString("\t\t");
    oneFileIo.PPOutputDebugString(Buffer);
    oneFileIo.PPOutputDebugString("\r\n");
    
}


int CPPWcxfFile::DumpOneRecord(WCXFRecord &oneRecord)
{
    int i,j;
    WCXFRecord_Name *oneNamePtr;
    WCXFRecord_Adrs  *oneAdrsPtr;
    WCXFRecord_AdrsL3 *tmpAdrsL3Ptr;
    WCXFRecord_Company *oneCompanyPtr;
    WCXFRecord_Email *oneEmailPtr;
    WCXFRecord_URL *oneURLPtr;
    WCXFRecord_IM *oneIMPtr;
    WCXFRecord_IML3 *oneIMPL3tr;
    WCXFRecord_Date *oneDatePtr;
    PPDate *onePPDatePtr;
    WCXFRecord_Phone *onePhonePtr;
    CPPFileIo oneFileIo;
    
    
    oneFileIo.m_outputDebugFileName = m_outputDebugFileName;
    
    // Dump Address--------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_AddressPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Address_Begin:\r\n");
        oneAdrsPtr = oneRecord.m_AddressPtrDQ[i];
        if (oneAdrsPtr != 0)
        {
            for (j = 0;j < (int)oneAdrsPtr->m_HomePtrDQ.size();j++)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Address_Home_Begin:\r\n");
                tmpAdrsL3Ptr = oneAdrsPtr->m_HomePtrDQ[j];
                if (tmpAdrsL3Ptr != 0)
                {
                    DumpAddressL3(tmpAdrsL3Ptr,oneFileIo);
                }
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Address_Home_End.\r\n");
            }
            //---------------------------------------------------
            for (j = 0;j < (int)oneAdrsPtr->m_OtherPtrDQ.size();j++)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Address_Other_Begin:\r\n");
                tmpAdrsL3Ptr = oneAdrsPtr->m_OtherPtrDQ[j];
                if (tmpAdrsL3Ptr != 0)
                {
                    DumpAddressL3(tmpAdrsL3Ptr,oneFileIo);
                }
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Address_Other_End.\r\n");
            }
            //---------------------------------------------------
            for (j = 0;j < (int)oneAdrsPtr->m_WorkPtrDQ.size();j++)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Address_Work_Begin:\r\n");
                tmpAdrsL3Ptr = oneAdrsPtr->m_WorkPtrDQ[j];
                if (tmpAdrsL3Ptr != 0)
                {
                    DumpAddressL3(tmpAdrsL3Ptr,oneFileIo);
                }
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Address_Work_End.\r\n");
            }
        }
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Address_End.\r\n");
    }
    // Dump Address----------------------------------------------------^-
    
    
    // Dump Comapny----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_CompanyPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Company_Begin:\r\n");
        oneCompanyPtr = oneRecord.m_CompanyPtrDQ[i];
        if (oneCompanyPtr != 0)
        {
            if (oneCompanyPtr->m_Company_Name.GetLength() > 0)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Company_Name:");
                oneFileIo.PPOutputDebugString(oneCompanyPtr->m_Company_Name);
                oneFileIo.PPOutputDebugString("\r\n");
            }
            
            if (oneCompanyPtr->m_Company_Phonetic.GetLength() > 0)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Company_Phonetic:");
                oneFileIo.PPOutputDebugString(oneCompanyPtr->m_Company_Phonetic);
                oneFileIo.PPOutputDebugString("\r\n");
            }
        }
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Company_End.\r\n");
    }
    // Dump Comapny----------------------------------------------------^-
    
    // Dump Date----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_DatePtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Date_Begin:\r\n");
        oneDatePtr = oneRecord.m_DatePtrDQ[i];
        if (oneDatePtr != 0)
        {
            for (j = 0;j < (int)oneDatePtr->m_AnniversaryPtrDQ.size();j++)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Date_Anniversary_Begin:\r\n");
                onePPDatePtr = oneDatePtr->m_AnniversaryPtrDQ[j];
                if (onePPDatePtr != 0)
                {
                    DumpDate(onePPDatePtr,"\t\t",oneFileIo);
                }
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Date_Anniversary_End.\r\n");
            }
            
            for (j = 0;j < (int)oneDatePtr->m_OtherPtrDQ.size();j++)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Date_Other_Begin:\r\n");
                onePPDatePtr = oneDatePtr->m_OtherPtrDQ[j];
                if (onePPDatePtr != 0)
                {
                    DumpDate(onePPDatePtr,"\t\t",oneFileIo);
                }
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Date_Other_End.\r\n");
            }
        }
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Date_End.\r\n");
    }
    
    // Dump Date----------------------------------------------------^-
    
    
    // Dump Email----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_EmailPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Email_Begin:\r\n");
        oneEmailPtr = oneRecord.m_EmailPtrDQ[i];
        if (oneEmailPtr != 0)
        {
            if (oneEmailPtr->m_HomePtrDQ.size() > 0)
            {
                for (j = 0;j < (int)oneEmailPtr->m_HomePtrDQ.size();j++)
                {
                    oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Email_Home:");
                    oneFileIo.PPOutputDebugString(*oneEmailPtr->m_HomePtrDQ[j]);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                
                for (j = 0;j < (int)oneEmailPtr->m_OtherPtrDQ.size();j++)
                {
                    oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Email_Other:");
                    oneFileIo.PPOutputDebugString(*oneEmailPtr->m_OtherPtrDQ[j]);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                
                for (j = 0;j < (int)oneEmailPtr->m_WorkPtrDQ.size();j++)
                {
                    oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_Email_Work:");
                    oneFileIo.PPOutputDebugString(*oneEmailPtr->m_WorkPtrDQ[j]);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
            }
        }
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Email_End.\r\n");
    }
    // Dump Email----------------------------------------------------^-
    
    
    // Dump Group----------------------------------------------------v-	//(Lո)
    for (i = 0;i < (int)oneRecord.m_GroupPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Group_Begin:\r\n");
        
        oneFileIo.PPOutputDebugString("\t");
        oneFileIo.PPOutputDebugString(*oneRecord.m_GroupPtrDQ[i]);
        oneFileIo.PPOutputDebugString("\r\n");
        
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Group_End.\r\n");
    }
    // Dump Group----------------------------------------------------^-
    
    // Dump IM ----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_InstantMessagePtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_InstantMessage_Begin:\r\n");
        
        oneIMPtr = oneRecord.m_InstantMessagePtrDQ[i];
        if (oneIMPtr != 0)
        {
            for (j = 0;j < (int)oneIMPtr->m_HomePtrDQ.size();j++)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_IM_Home_Begin:\r\n");
                oneIMPL3tr = oneIMPtr->m_HomePtrDQ[j];
                if (oneIMPL3tr != 0)
                {
                    DumpIML3(oneIMPL3tr,oneFileIo);
                }
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_IM_Home_End.\r\n");
            }
            
            //---------------------------------------------------
            for (j = 0;j < (int)oneIMPtr->m_OtherPtrDQ.size();j++)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_IM_Other_Begin:\r\n");
                oneIMPL3tr = oneIMPtr->m_OtherPtrDQ[j];
                if (oneIMPL3tr != 0)
                {
                    DumpIML3(oneIMPL3tr,oneFileIo);
                }
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_IM_Other_End.\r\n");
            }
            
            //---------------------------------------------------
            for (j = 0;j < (int)oneIMPtr->m_WorkPtrDQ.size();j++)
            {
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_IM_Work_Begin:\r\n");
                oneIMPL3tr = oneIMPtr->m_WorkPtrDQ[j];
                if (oneIMPL3tr != 0)
                {
                    DumpIML3(oneIMPL3tr,oneFileIo);
                }
                oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_IM_Work_End.\r\n");
            }
            //---------------------------------------------------
        }
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_InstantMessage_End.\r\n");
    }
    // Dump IM ----------------------------------------------------^-
    
    
    // Dump Name----------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_NamePtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Name_Begin:\r\n");
        oneNamePtr = oneRecord.m_NamePtrDQ[i];
        if (oneNamePtr != 0)
        {
            DumpNameL2(oneNamePtr,oneFileIo);
        }
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Name_End.\r\n");
    }
    // Dump Name----------------------------------------------------^-
    
    
    // Dump Phone---------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_PhonePtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Phone_Begin:\r\n");
        onePhonePtr = oneRecord.m_PhonePtrDQ[i];
        if (onePhonePtr != 0)
        {
            DumpPhoneL2(onePhonePtr,oneFileIo);
        }
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Phone_End.\r\n");
    }
    // Dump Phone----------------------------------------------------^-
    
    // Dump URL---------------------------------------------------v-
    for (i = 0;i < (int)oneRecord.m_URLPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_URL_Begin:\r\n");
        oneURLPtr = oneRecord.m_URLPtrDQ[i];
        if (oneURLPtr != 0)
        {
            DumpURLL2(oneURLPtr,oneFileIo);
        }
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_URL_End.\r\n");
    }
    // Dump URL----------------------------------------------------^-
    
    
    //-Birthday------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Birthday_Begin:\r\n");
    DumpDate(&oneRecord.m_Birthday,"\t\t",oneFileIo);
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Birthday_End.\r\n");
    
    //-BloodType------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_BloodType_Begin:\r\n");
    oneFileIo.PPOutputDebugString("\t\t");
    oneFileIo.PPOutputDebugString(oneRecord.m_BloodType);
    oneFileIo.PPOutputDebugString("\r\n");
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_BloodType_End.\r\n");
    
    //-Children------------------------------------------------------------
    for (i = 0;i < (int)oneRecord.m_ChildrenPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Children_Begin:\r\n");
        oneFileIo.PPOutputDebugString("\t");
        oneFileIo.PPOutputDebugString(*oneRecord.m_ChildrenPtrDQ[i]);
        oneFileIo.PPOutputDebugString("\r\n");
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Children_End.\r\n");
    }
    
    //-CreateTime------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_CreateTime_Begin:\r\n");
    DumpDate(&oneRecord.m_CreateTime,"\t\t",oneFileIo);
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_CreateTime_End.\r\n");
    
    //-Department------------------------------------------------------------
    
    for (i = 0;i < (int)oneRecord.m_DepartmentPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Department_Begin:\r\n");
        oneFileIo.PPOutputDebugString("\t");
        oneFileIo.PPOutputDebugString(*oneRecord.m_DepartmentPtrDQ[i]);
        oneFileIo.PPOutputDebugString("\r\n");
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Department_End.\r\n");
    }
    //-Education------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Education_Begin:\r\n");
    oneFileIo.PPOutputDebugString("\t\t");
    oneFileIo.PPOutputDebugString(oneRecord.m_Education);
    oneFileIo.PPOutputDebugString("\r\n");
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Education_End.\r\n");
    
    //-Horoscope------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Horoscope_Begin:\r\n");
    oneFileIo.PPOutputDebugString("\t\t");
    oneFileIo.PPOutputDebugString(oneRecord.m_Horoscope);
    oneFileIo.PPOutputDebugString("\r\n");
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Horoscope_End.\r\n");
    
    //-Image_Back_Size------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL2_Image_Back_Size_Begin:\r\n");
    DumpInt(oneRecord.m_Image_Back_size,oneFileIo);
    oneFileIo.PPOutputDebugString("kWCXF_CDL2_Image_Back_Size_End.\r\n");
    
    //-Image_Front_Size------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL2_Image_Front_Size_Begin:\r\n");
    DumpInt(oneRecord.m_Image_Front_size,oneFileIo);
    oneFileIo.PPOutputDebugString("kWCXF_CDL2_Image_Front_Size_End.\r\n");
    
    //-Image_IDPhoto_size------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL2_Image_IDPhoto_size_Begin:\r\n");
    DumpInt(oneRecord.m_Image_IDPhoto_size,oneFileIo);
    oneFileIo.PPOutputDebugString("kWCXF_CDL2_Image_IDPhoto_size_End.\r\n");
    
    //-ModifiedTime------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_ModifiedTime_Begin:\r\n");
    DumpDate(&oneRecord.m_ModifiedTime,"\t\t",oneFileIo);
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_ModifiedTime_End.\r\n");
    
    //-NickName------------------------------------------------------------
    for (i = 0;i < (int)oneRecord.m_NickNamePtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_NickName_Begin:\r\n");
        
        oneFileIo.PPOutputDebugString("\t");
        oneFileIo.PPOutputDebugString(*oneRecord.m_NickNamePtrDQ[i]);
        oneFileIo.PPOutputDebugString("\r\n");
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_NickName_End.\r\n");
    }
    
    //-Note------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Note_Begin:\r\n");
    oneFileIo.PPOutputDebugString("\t\t");
    oneFileIo.PPOutputDebugString(oneRecord.m_Note);
    oneFileIo.PPOutputDebugString("\r\n");
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Note_End.\r\n");
    
    //-Other------------------------------------------------------------
    for (i = 0;i < (int)oneRecord.m_OtherPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Other_Begin:\r\n");
        
        oneFileIo.PPOutputDebugString("\t");
        oneFileIo.PPOutputDebugString(*oneRecord.m_OtherPtrDQ[i]);
        oneFileIo.PPOutputDebugString("\r\n");
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Other_End.\r\n");
    }
    
    //-Position------------------------------------------------------------
    for (i = 0;i < (int)oneRecord.m_PositionPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Position_Begin:\r\n");
        
        oneFileIo.PPOutputDebugString("\t");
        oneFileIo.PPOutputDebugString(*oneRecord.m_PositionPtrDQ[i]);
        oneFileIo.PPOutputDebugString("\r\n");
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Position_End.\r\n");
    }
    
    //-RecogLang------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_RecogLang_Begin:\r\n");
    oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_RecogLang_Front_Begin:\r\n");
    DumpInt(oneRecord.m_RecogLang.m_Front,oneFileIo);
    oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_RecogLang_Front_End.\r\n");
    oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_RecogLang_Back_Begin:\r\n");
    DumpInt(oneRecord.m_RecogLang.m_Back,oneFileIo);
    oneFileIo.PPOutputDebugString("\tkWCXF_CDL2_RecogLang_Back_End.\r\n");
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_RecogLang_End\r\n");
    
    //-RecognizedTime--------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_RecognizedTime_Begin:\r\n");
    DumpDate(&oneRecord.m_RecognizedTime,"\t\t",oneFileIo);
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_RecognizedTime_End.\r\n");
    
    //-Sex------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Sex_Begin:\r\n");
    oneFileIo.PPOutputDebugString("\t\t");
    oneFileIo.PPOutputDebugString(oneRecord.m_Sex);
    oneFileIo.PPOutputDebugString("\r\n");
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_Sex_End.\r\n");
    
    //-Skype------------------------------------------------------------
    for (i = 0;i < (int)oneRecord.m_SkypePtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Skype_Begin:\r\n");
        
        oneFileIo.PPOutputDebugString("\t");
        oneFileIo.PPOutputDebugString(*oneRecord.m_SkypePtrDQ[i]);
        oneFileIo.PPOutputDebugString("\r\n");
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Skype_End.\r\n");
    }
    
    //-Spouse------------------------------------------------------------
    for (i = 0;i < (int)oneRecord.m_SpousePtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Spouse_Begin:\r\n");
        
        oneFileIo.PPOutputDebugString("\t");
        oneFileIo.PPOutputDebugString(*oneRecord.m_SpousePtrDQ[i]);
        oneFileIo.PPOutputDebugString("\r\n");
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_Spouse_End.\r\n");
    }
    
    //-UnifiedBusinessNumber------------------------------------------------------------
    for (i = 0;i < (int)oneRecord.m_UnifiedBusinessNumberPtrDQ.size();i++)
    {
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_UnifiedBusinessNumber_Begin:\r\n");
        
        oneFileIo.PPOutputDebugString("\t");
        oneFileIo.PPOutputDebugString(*oneRecord.m_UnifiedBusinessNumberPtrDQ[i]);
        oneFileIo.PPOutputDebugString("\r\n");
        oneFileIo.PPOutputDebugString("kWCXF_CDL1_UnifiedBusinessNumber_End.\r\n");
    }
    
    //-UniqueID-----------------------------------------------------------------
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_UniqueID_Begin:\r\n");
    oneFileIo.PPOutputDebugString("\t\t");
    oneFileIo.PPOutputDebugString(oneRecord.m_UniqueID);
    oneFileIo.PPOutputDebugString("\r\n");
    oneFileIo.PPOutputDebugString("kWCXF_CDL1_UniqueID_End.\r\n");
    
    oneFileIo.PPOutputDebugString("----------------------------------------------------------\r\n");
    
    return 1;
}



void CPPWcxfFile::FreeOneCard(void *oneDict)
{
    WCXFNode *oneNode;
    WCXFNodePtrDQ *oneDQPtr;
    int i,iNum;
    WCXFNode *oneChildP;
    PPCStringW *tmpCStrPtr;
    int *tmpNumPtr;
    WCXFData *tmpDataPtr;
    
    if (oneDict != 0)
    {
        oneNode = (WCXFNode *)oneDict;
        if (oneNode != 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_ARRAY)
            {
                oneDQPtr = (WCXFNodePtrDQ*)oneNode->m_Data;
                if (oneDQPtr != 0)
                {
                    iNum = (int)(*oneDQPtr).size();
                    for (i = 0;i < iNum;i++)
                    {
                        oneChildP = (WCXFNode*)((*oneDQPtr)[i]);
                        FreeOneCard(oneChildP);
                    }
                    delete oneDQPtr;
                }
            }else if (oneNode->m_Type == DEF_WCXF_NODE_DICT)
            {
                oneDQPtr = (WCXFNodePtrDQ*)oneNode->m_Data;
                if (oneDQPtr != 0)
                {
                    iNum = (int)(*oneDQPtr).size();
                    for (i = 0;i < iNum;i++)
                    {
                        oneChildP = (WCXFNode*)((*oneDQPtr)[i]);
                        FreeOneCard(oneChildP);
                    }
                    delete oneDQPtr;
                }
            }else if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    delete tmpCStrPtr;
                }
            }else if (oneNode->m_Type == DEF_WCXF_NODE_INTEGER)
            {
                tmpNumPtr = (int*)oneNode->m_Data;
                if (tmpNumPtr != 0)
                {
                    delete tmpNumPtr;
                }
            }else if (oneNode->m_Type == DEF_WCXF_NODE_DATE)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    delete tmpCStrPtr;
                }
            }else if (oneNode->m_Type == DEF_WCXF_NODE_DATA)
            {
                tmpDataPtr = (WCXFData*)oneNode->m_Data;
                if (tmpDataPtr != 0)
                {
                    if (tmpDataPtr->m_dataPtr != 0)
                    {
                        delete [] tmpDataPtr->m_dataPtr;
                    }
                    delete tmpDataPtr;
                }
            }
            delete oneNode;
            
        }
    }
}



int CPPWcxfFile::ConvertString2PPDate(PPCStringW srcString,PPDate &oneDate)
{
    PPWCHAR tmpWChar[2];
    int idx,sIdx;
    int iRetV = 0;
    PPCStringW tmpYMDstr;
    PPCStringW tmpHMSstr;
    
    PPCStringW tmpYearstr;
    PPCStringW tmpMonthstr;
    PPCStringW tmpDaystr;
    
    PPCStringW tmpHourstr;
    PPCStringW tmpMinutestr;
    PPCStringW tmpSecondstr;
    
    srcString.TrimLeft(" \t\r\n");
    srcString.TrimRight(" \t\r\n");
    srcString.MakeUpper();
    
    tmpWChar[0] = 'T';
    tmpWChar[1] = 0;
    
    idx = srcString.Find(tmpWChar,0);
    if (idx != -1)
    {
        tmpYMDstr = srcString.Left(idx);
        tmpWChar[0] = 'Z';
        tmpWChar[1] = 0;
        sIdx = idx+1;
        idx = srcString.Find(tmpWChar,sIdx);
        if (idx != -1)
        {
            tmpHMSstr = srcString.Mid(sIdx,idx - sIdx);
            
            tmpWChar[0] = '-';
            tmpWChar[1] = 0;
            
            idx = tmpYMDstr.Find(tmpWChar,0);
            if (idx != -1)
            {
                tmpYearstr = tmpYMDstr.Left(idx);
                sIdx = idx+1;
                idx = tmpYMDstr.Find(tmpWChar,sIdx);
                if (idx != -1)
                {
                    tmpMonthstr = tmpYMDstr.Mid(sIdx,idx - sIdx);
                    sIdx = idx+1;
                    tmpDaystr = tmpYMDstr.Right(tmpYMDstr.GetLength() - sIdx);
                    // ----------------------------------------------------------------
                    tmpWChar[0] = ':';
                    tmpWChar[1] = 0;
                    
                    idx = tmpHMSstr.Find(tmpWChar,0);
                    if (idx != -1)
                    {
                        tmpHourstr = tmpHMSstr.Left(idx);
                        sIdx = idx+1;
                        idx = tmpHMSstr.Find(tmpWChar,sIdx);
                        if (idx != -1)
                        {
                            tmpMinutestr = tmpHMSstr.Mid(sIdx,idx - sIdx);
                            sIdx = idx+1;
                            tmpSecondstr = tmpHMSstr.Right(tmpHMSstr.GetLength() - sIdx);
                            
                            
                            oneDate.m_Year = tmpYearstr.ToValue();
                            oneDate.m_Month = tmpMonthstr.ToValue();
                            oneDate.m_Day = tmpDaystr.ToValue();
                            oneDate.m_Hour = tmpHourstr.ToValue();
                            oneDate.m_Minute = tmpMinutestr.ToValue();
                            oneDate.m_Second = tmpSecondstr.ToValue();
                            iRetV = 1;
                        }
                    }
                }
            }
        }
    }
    
    if (iRetV == 0)	//Android HD ~榡ץ 02072013
    {
        iRetV = ConvertString2PPDate_Fix1(srcString,oneDate);
    }
    
    //WorldCard Mobile for Android v3.4.20130816(1.0.0) ~榡ץ 12102013
    if ((oneDate.m_Year <= 0))
    {
        oneDate.m_Year = 1;
    }
    if ((oneDate.m_Month <= 0) || (oneDate.m_Month > 12))
    {
        oneDate.m_Month = 1;
    }
    if ((oneDate.m_Day <= 0) || (oneDate.m_Day > 31))
    {
        oneDate.m_Day = 1;
    }
    return iRetV;
}

int CPPWcxfFile::ConvertString2PPDate_Fix1(PPCStringW srcString,PPDate &oneDate)
{
    PPWCHAR tmpWChar[2];
    int idx,sIdx;
    int iRetV = 0;
    PPCStringW tmpYMDstr;
    PPCStringW tmpHMSstr;
    
    PPCStringW tmpYearstr;
    PPCStringW tmpMonthstr;
    PPCStringW tmpDaystr;
    
    PPCStringW tmpHourstr;
    PPCStringW tmpMinutestr;
    PPCStringW tmpSecondstr;
    
    srcString.TrimLeft(" \t\r\n");
    srcString.TrimRight(" \t\r\n");
    srcString.MakeUpper();
    
    tmpWChar[0] = 0x20;
    tmpWChar[1] = 0;
    
    idx = srcString.Find(tmpWChar,0);
    if (idx != -1)
    {
        tmpYMDstr = srcString.Left(idx);
        
        tmpHMSstr = srcString.Right(idx-1);
        
        tmpWChar[0] = '-';
        tmpWChar[1] = 0;
        
        idx = tmpYMDstr.Find(tmpWChar,0);
        if (idx != -1)
        {
            tmpYearstr = tmpYMDstr.Left(idx);
            sIdx = idx+1;
            idx = tmpYMDstr.Find(tmpWChar,sIdx);
            if (idx != -1)
            {
                tmpMonthstr = tmpYMDstr.Mid(sIdx,idx - sIdx);
                sIdx = idx+1;
                tmpDaystr = tmpYMDstr.Right(tmpYMDstr.GetLength() - sIdx);
                // ----------------------------------------------------------------
                tmpWChar[0] = ':';
                tmpWChar[1] = 0;
                
                idx = tmpHMSstr.Find(tmpWChar,0);
                if (idx != -1)
                {
                    tmpHourstr = tmpHMSstr.Left(idx);
                    sIdx = idx+1;
                    idx = tmpHMSstr.Find(tmpWChar,sIdx);
                    if (idx != -1)
                    {
                        tmpMinutestr = tmpHMSstr.Mid(sIdx,idx - sIdx);
                        sIdx = idx+1;
                        tmpSecondstr = tmpHMSstr.Right(tmpHMSstr.GetLength() - sIdx);
                        
                        
                        oneDate.m_Year = tmpYearstr.ToValue();
                        oneDate.m_Month = tmpMonthstr.ToValue();
                        oneDate.m_Day = tmpDaystr.ToValue();
                        oneDate.m_Hour = tmpHourstr.ToValue();
                        oneDate.m_Minute = tmpMinutestr.ToValue();
                        oneDate.m_Second = tmpSecondstr.ToValue();
                        iRetV = 1;
                    }
                }
            }
            
        }
    }
    return iRetV;
}

int CPPWcxfFile::PutField2Record(WCXFRecord &oneRecord,PPCStringW &lastKey,void *oneDict,int bAction)
{
    WCXFNode *oneNode = 0;
    PPCStringW *tmpCStrPtr;
    WCXFData *tmpDataPtr;
    int *tmpNumPtr;
    WCXFRecord_Name *oneNamePtr;
    WCXFRecord_Company *oneCompanyPtr;
    WCXFRecord_Phone *onePhonePtr;
    WCXFRecord_AdrsTmp *oneAdrsTmpPtr;
    //	WCXFRecord_AdrsL3 *tmpL3Ptr;
    WCXFRecord_Email *oneEmailPtr;
    WCXFRecord_URL *oneURLPtr;
    WCXFRecord_IMTmp *oneIMTmpPtr;
    WCXFRecord_Date *oneDatePtr;
    PPDate *onePPDatePtr;
    PPBYTE *tmpBytePtr;
    WCXFRecord_GroupV2 *oneGroupV2Ptr;
    WCXFRecord_UD_Tmp *oneUserDefineTmpPtr;
    WCXFRecord_Tag_Tmp *oneTagTmpPtr;
    CPPMisc oneMisc;
    PPCStringW tmpOneStr;
    PPCStringW tmpOneStr1;
    //	int i;
    
    oneNode = (WCXFNode *)oneDict;
    if (oneNode != 0)
    {
        if (lastKey.CompareNoCase(kWCXF_CDL1_Group) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_GroupPtrDQ.push_back(tmpCStrPtr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_UniqueID) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    tmpOneStr = *tmpCStrPtr;
                    //01272014 by knight--Ncode ̨PPMisc  FixUUID -----------
                    oneRecord.m_UniqueID = oneMisc.FixUUID(tmpOneStr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Name) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_Name();			//### New Alloc
                    if (oneRecord.m_varDataPtr != 0)
                    {
                        oneRecord.m_nowState = DEF_WCXF_STATE_NAME_INIT;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                if (bAction == 2)
                {
                    oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                    if (oneNamePtr != 0)
                    {
                        oneRecord.m_NamePtrDQ.push_back(oneNamePtr);
                        oneRecord.m_varDataPtr = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                    }
                }
            }
            return 1;
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Company) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_Company();	//### New Alloc
                    if (oneRecord.m_varDataPtr != 0)
                    {
                        oneRecord.m_nowState = DEF_WCXF_STATE_COMPANY_INIT;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_COMPANY_INIT)
            {
                if (bAction == 2)
                {
                    oneCompanyPtr = (WCXFRecord_Company*)oneRecord.m_varDataPtr;
                    if (oneCompanyPtr != 0)
                    {
                        oneRecord.m_CompanyPtrDQ.push_back(oneCompanyPtr);
                        oneRecord.m_varDataPtr = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                    }
                }
            }
            return 1;
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Phone) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_Phone();		//### New Alloc
                    if (oneRecord.m_varDataPtr != 0)
                    {
                        oneRecord.m_nowState = DEF_WCXF_STATE_PHONE_INIT;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                if (bAction == 2)
                {
                    onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                    if (onePhonePtr != 0)
                    {
                        oneRecord.m_PhonePtrDQ.push_back(onePhonePtr);
                        oneRecord.m_varDataPtr = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                    }
                }
            }
            return 1;
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Address) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_AdrsTmp();			//### New Alloc
                    oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                    if (oneAdrsTmpPtr != 0)
                    {
                        oneAdrsTmpPtr->m_AdrsL1 = new WCXFRecord_Adrs();		//### New Alloc
                        oneRecord.m_nowState = DEF_WCXF_STATE_ADDRESS_INIT_L1;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L1)
            {
                if (bAction == 2)
                {
                    oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                    if (oneAdrsTmpPtr != 0)
                    {
                        oneRecord.m_AddressPtrDQ.push_back(oneAdrsTmpPtr->m_AdrsL1);
                        delete oneAdrsTmpPtr;	//hݭnOo.
                        oneRecord.m_varDataPtr = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                    }
                }
            }
            return 1;
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Email) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_Email();		//###New Alloc
                    if (oneRecord.m_varDataPtr != 0)
                    {
                        oneRecord.m_nowState = DEF_WCXF_STATE_EMAIL_INIT;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_EMAIL_INIT)
            {
                if (bAction == 2)
                {
                    oneEmailPtr = (WCXFRecord_Email*)oneRecord.m_varDataPtr;
                    if (oneEmailPtr != 0)
                    {
                        oneRecord.m_EmailPtrDQ.push_back(oneEmailPtr);
                        oneRecord.m_varDataPtr = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                    }
                }
            }
            return 1;
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_URL) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_URL();		//###New Alloc
                    if (oneRecord.m_varDataPtr != 0)
                    {
                        oneRecord.m_nowState = DEF_WCXF_STATE_URL_INIT;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                if (bAction == 2)
                {
                    oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                    if (oneURLPtr != 0)
                    {
                        oneRecord.m_URLPtrDQ.push_back(oneURLPtr);
                        oneRecord.m_varDataPtr = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                    }
                }
            }
            return 1;
        }
        //-- 105 sW ------------------------------------------------------------------------------v---
        else if (lastKey.CompareNoCase(kWCXF_CDL1_GroupV2) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_GroupV2();		//###New Alloc
                    if (oneRecord.m_varDataPtr != 0)
                    {
                        oneRecord.m_nowState = DEF_WCXF_STATE_GROUPV2_INIT;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_GROUPV2_INIT)
            {
                if (bAction == 2)
                {
                    oneGroupV2Ptr = (WCXFRecord_GroupV2*)oneRecord.m_varDataPtr;
                    if (oneGroupV2Ptr != 0)
                    {
                        oneRecord.m_GroupV2PtrDQ.push_back(oneGroupV2Ptr);
                        oneRecord.m_varDataPtr = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                    }
                }
            }
            return 1;
        }
        else if (lastKey.CompareNoCase(kWCXF_CDL1_UserDefine) == 0)
        {
            
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_UD_Tmp();			//### New Alloc
                    oneUserDefineTmpPtr = (WCXFRecord_UD_Tmp*)oneRecord.m_varDataPtr;
                    if (oneUserDefineTmpPtr != 0)
                    {
                        oneUserDefineTmpPtr->m_UD_L1 = new WCXFRecord_UD_L1();		//### New Alloc
                        oneUserDefineTmpPtr->m_UD_L2 = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_USERDEFINE_INIT_L1;
                        oneUserDefineTmpPtr->m_State = 0;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_USERDEFINE_INIT_L1)
            {
                if (bAction == 1)
                {
                    oneUserDefineTmpPtr = (WCXFRecord_UD_Tmp*)oneRecord.m_varDataPtr;
                    if (oneUserDefineTmpPtr != 0)
                    {
                        if (oneUserDefineTmpPtr->m_UD_L2 == 0)
                        {
                            oneUserDefineTmpPtr->m_UD_L2 = new WCXFRecord_UD_L2();		//### New Alloc
                            oneUserDefineTmpPtr->m_State = 1;
                        }
                    }
                    
                }else if (bAction == 2)
                {
                    oneUserDefineTmpPtr = (WCXFRecord_UD_Tmp*)oneRecord.m_varDataPtr;
                    if (oneUserDefineTmpPtr != 0)
                    {
                        if (oneUserDefineTmpPtr->m_State == 1)
                        {
                            oneUserDefineTmpPtr->m_UD_L1->m_UserDefinePDQ.push_back(oneUserDefineTmpPtr->m_UD_L2);
                            oneUserDefineTmpPtr->m_UD_L2 = 0;
                            oneUserDefineTmpPtr->m_State = 0;
                        }else
                        {
                            oneRecord.m_UserDefinePtrDQ.push_back(oneUserDefineTmpPtr->m_UD_L1);
                            delete oneUserDefineTmpPtr;	//hݭnOo.
                            oneRecord.m_varDataPtr = 0;
                            oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                        }
                    }
                }
            }
            return 1;
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Tag) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_Tag_Tmp();			//### New Alloc
                    oneTagTmpPtr = (WCXFRecord_Tag_Tmp*)oneRecord.m_varDataPtr;
                    if (oneTagTmpPtr != 0)
                    {
                        oneTagTmpPtr->m_L1 = new WCXFRecord_Tag_L1();		//### New Alloc
                        oneTagTmpPtr->m_L2 = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_TAG_INIT_L1;
                        oneTagTmpPtr->m_State = 0;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_TAG_INIT_L1)
            {
                if (bAction == 1)
                {
                    oneTagTmpPtr = (WCXFRecord_Tag_Tmp*)oneRecord.m_varDataPtr;
                    if (oneTagTmpPtr != 0)
                    {
                        if (oneTagTmpPtr->m_L2 == 0)
                        {
                            oneTagTmpPtr->m_L2 = new WCXFRecord_Tag_L2();		//### New Alloc
                            oneTagTmpPtr->m_State = 1;
                        }
                    }
                    
                }else if (bAction == 2)
                {
                    oneTagTmpPtr = (WCXFRecord_Tag_Tmp*)oneRecord.m_varDataPtr;
                    if (oneTagTmpPtr != 0)
                    {
                        if (oneTagTmpPtr->m_State == 1)
                        {
                            oneTagTmpPtr->m_L1->m_TagPDQ.push_back(oneTagTmpPtr->m_L2);
                            oneTagTmpPtr->m_L2 = 0;
                            oneTagTmpPtr->m_State = 0;
                            if (oneRecord.m_inArray == 0) // YWsbhn[J
                            {
                                oneRecord.m_TagPtrDQ.push_back(oneTagTmpPtr->m_L1);
                                delete oneTagTmpPtr;	//hݭnOo.
                                oneRecord.m_varDataPtr = 0;
                                oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                            }
                        }else
                        {
                            oneRecord.m_TagPtrDQ.push_back(oneTagTmpPtr->m_L1);
                            delete oneTagTmpPtr;	//hݭnOo.
                            oneRecord.m_varDataPtr = 0;
                            oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                        }
                    }
                }
            }
            return 1;
        }
        //-- 105 sW ------------------------------------------------------------------------------^---
        else if (lastKey.CompareNoCase(kWCXF_CDL1_InstantMessage) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_IMTmp();			//### New Alloc
                    oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                    if (oneIMTmpPtr != 0)
                    {
                        oneIMTmpPtr->m_L1 = new WCXFRecord_IM();		//### New Alloc
                        oneRecord.m_nowState = DEF_WCXF_STATE_IM_INIT_L1;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L1)
            {
                if (bAction == 2)
                {
                    oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                    if (oneIMTmpPtr != 0)
                    {
                        oneRecord.m_InstantMessagePtrDQ.push_back(oneIMTmpPtr->m_L1);
                        delete oneIMTmpPtr;					//hݭnOo.
                        oneRecord.m_varDataPtr = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                    }
                }
            }
            return 1;
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Date) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NONE)
            {
                if (bAction == 1)
                {
                    oneRecord.m_varDataPtr = new WCXFRecord_Date();		//### New Alloc
                    if (oneRecord.m_varDataPtr != 0)
                    {
                        oneRecord.m_nowState = DEF_WCXF_STATE_DATE_INIT;
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_DATE_INIT)
            {
                if (bAction == 2)
                {
                    oneDatePtr = (WCXFRecord_Date*)oneRecord.m_varDataPtr;
                    if (oneDatePtr != 0)
                    {
                        oneRecord.m_DatePtrDQ.push_back(oneDatePtr);
                        oneRecord.m_varDataPtr = 0;
                        oneRecord.m_nowState = DEF_WCXF_STATE_NONE;
                    }
                }
            }
            return 1;
        }else if ((lastKey.CompareNoCase(kWCXF_CDL1_Image) == 0) || (lastKey.CompareNoCase(kWCXF_CDL1_RecogLang) == 0))
        {
            return 0;
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_NickName) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_NickNamePtrDQ.push_back(tmpCStrPtr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Position) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_PositionPtrDQ.push_back(tmpCStrPtr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Department) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_DepartmentPtrDQ.push_back(tmpCStrPtr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Skype) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_SkypePtrDQ.push_back(tmpCStrPtr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Other) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_OtherPtrDQ.push_back(tmpCStrPtr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Note) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_Note = *tmpCStrPtr;
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_UnifiedBusinessNumber) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_UnifiedBusinessNumberPtrDQ.push_back(tmpCStrPtr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Birthday) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_DATE)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    ConvertString2PPDate(*tmpCStrPtr,oneRecord.m_Birthday);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Children) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_ChildrenPtrDQ.push_back(tmpCStrPtr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Spouse) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_SpousePtrDQ.push_back(tmpCStrPtr);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_BloodType) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_BloodType = *tmpCStrPtr;
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Sex) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_Sex = *tmpCStrPtr;
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Horoscope) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_Horoscope = *tmpCStrPtr;
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_Education) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_Education = *tmpCStrPtr;
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_CreateTime) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_DATE)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    ConvertString2PPDate(*tmpCStrPtr,oneRecord.m_CreateTime);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_ModifiedTime) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_DATE)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    ConvertString2PPDate(*tmpCStrPtr,oneRecord.m_ModifiedTime);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_RecognizedTime) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_DATE)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    ConvertString2PPDate(*tmpCStrPtr,oneRecord.m_RecognizedTime);
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Image_Front) == 0)
            //--------------------------------------------------------------------------- L2
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_DATA)
            {
                tmpDataPtr = (WCXFData*)oneNode->m_Data;
                if (tmpDataPtr != 0)
                {
                    if (tmpDataPtr->m_dataLen > 4)
                    {
                        //ѩm_dataPtr|htm10 bytesw,]iH
                        tmpBytePtr = (PPBYTE*)tmpDataPtr->m_dataPtr;
                        if (tmpBytePtr != 0)
                        {
                            if ((tmpBytePtr[0] == 0xFF) && (tmpBytePtr[1] == 0xD8))
                            {
                                if (tmpBytePtr[tmpDataPtr->m_dataLen-1] != 0xD9)
                                {
                                    if (tmpBytePtr[tmpDataPtr->m_dataLen-1] == 0xFF) //S0xD9
                                    {
                                        tmpBytePtr[tmpDataPtr->m_dataLen] = 0xD9;
                                        tmpDataPtr->m_dataLen++;
                                    }else	//ӳS
                                    {
                                        tmpBytePtr[tmpDataPtr->m_dataLen] = 0xFF;
                                        tmpDataPtr->m_dataLen++;
                                        tmpBytePtr[tmpDataPtr->m_dataLen] = 0xD9;
                                        tmpDataPtr->m_dataLen++;
                                    }
                                }
                            }
                            oneRecord.m_Image_Front_Ptr = tmpDataPtr->m_dataPtr;
                            oneRecord.m_Image_Front_size = (int)tmpDataPtr->m_dataLen;
                            oneRecord.m_Image_Flag |= DEF_WCXF_IMAGE_FLAG_FRONT;
                            
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Image_Back) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_DATA)
            {
                tmpDataPtr = (WCXFData*)oneNode->m_Data;
                if (tmpDataPtr != 0)
                {
                    if (tmpDataPtr->m_dataLen > 4)
                    {
                        //ѩm_dataPtr|htm10 bytesw,]iH
                        tmpBytePtr = (PPBYTE*)tmpDataPtr->m_dataPtr;
                        if (tmpBytePtr != 0)
                        {
                            if ((tmpBytePtr[0] == 0xFF) && (tmpBytePtr[1] == 0xD8))
                            {
                                if (tmpBytePtr[tmpDataPtr->m_dataLen-1] != 0xD9)
                                {
                                    if (tmpBytePtr[tmpDataPtr->m_dataLen-1] == 0xFF) //S0xD9
                                    {
                                        tmpBytePtr[tmpDataPtr->m_dataLen] = 0xD9;
                                        tmpDataPtr->m_dataLen++;
                                    }else	//ӳS
                                    {
                                        tmpBytePtr[tmpDataPtr->m_dataLen] = 0xFF;
                                        tmpDataPtr->m_dataLen++;
                                        tmpBytePtr[tmpDataPtr->m_dataLen] = 0xD9;
                                        tmpDataPtr->m_dataLen++;
                                    }
                                }
                            }
                            oneRecord.m_Image_Back_Ptr = tmpDataPtr->m_dataPtr;
                            oneRecord.m_Image_Back_size = (int)tmpDataPtr->m_dataLen;
                            oneRecord.m_Image_Flag |= DEF_WCXF_IMAGE_FLAG_BACK;
                            
                        }
                    }
                    
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Image_IDPhoto) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_DATA)
            {
                tmpDataPtr = (WCXFData*)oneNode->m_Data;
                if (tmpDataPtr != 0)
                {
                    if (tmpDataPtr->m_dataLen > 4)
                    {
                        //ѩm_dataPtr|htm10 bytesw,]iH
                        tmpBytePtr = (PPBYTE*)tmpDataPtr->m_dataPtr;
                        if (tmpBytePtr != 0)
                        {
                            if ((tmpBytePtr[0] == 0xFF) && (tmpBytePtr[1] == 0xD8))
                            {
                                if (tmpBytePtr[tmpDataPtr->m_dataLen-1] != 0xD9)
                                {
                                    if (tmpBytePtr[tmpDataPtr->m_dataLen-1] == 0xFF) //S0xD9
                                    {
                                        tmpBytePtr[tmpDataPtr->m_dataLen] = 0xD9;
                                        tmpDataPtr->m_dataLen++;
                                    }else	//ӳS
                                    {
                                        tmpBytePtr[tmpDataPtr->m_dataLen] = 0xFF;
                                        tmpDataPtr->m_dataLen++;
                                        tmpBytePtr[tmpDataPtr->m_dataLen] = 0xD9;
                                        tmpDataPtr->m_dataLen++;
                                    }
                                }
                            }
                            oneRecord.m_Image_IDPhoto_Ptr = tmpDataPtr->m_dataPtr;
                            oneRecord.m_Image_IDPhoto_size = (int)tmpDataPtr->m_dataLen;
                            oneRecord.m_Image_Flag |= DEF_WCXF_IMAGE_FLAG_PHOTO;
                            
                        }
                    }
                    //oneRecord.m_Image_IDPhoto_Ptr = tmpDataPtr->m_dataPtr;
                    //oneRecord.m_Image_IDPhoto_size = tmpDataPtr->m_dataLen;
                    //oneRecord.m_Image_Flag |= DEF_WCXF_IMAGE_FLAG_PHOTO;
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_RecogLang_Front) == 0)
        {
            tmpNumPtr = (int*)oneNode->m_Data;
            if (tmpNumPtr != 0)
            {
                oneRecord.m_RecogLang.m_Front = *tmpNumPtr;
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_RecogLang_Back) == 0)
        {
            tmpNumPtr = (int*)oneNode->m_Data;
            if (tmpNumPtr != 0)
            {
                oneRecord.m_RecogLang.m_Back = *tmpNumPtr;
            }
        }
        //-Name---------------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_Full) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_Full = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_First) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_First = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_Middle) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_Middle = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_Last) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_Last = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_PhoneticFull) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_PhoneticFull = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_PhoneticFirst) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_PhoneticFirst = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_PhoneticMiddle) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_PhoneticMiddle = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_PhoneticLast) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_PhoneticLast = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_Prefix) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_Prefix = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Name_Suffix) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_NAME_INIT)
            {
                oneNamePtr = (WCXFRecord_Name*)oneRecord.m_varDataPtr;
                if (oneNamePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneNamePtr->m_Name_Suffix = *tmpCStrPtr;
                        }
                    }
                }
            }
        }
        //-Company---------------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_Company_Name) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_COMPANY_INIT)
            {
                oneCompanyPtr = (WCXFRecord_Company*)oneRecord.m_varDataPtr;
                if (oneCompanyPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneCompanyPtr->m_Company_Name = *tmpCStrPtr;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Company_Phonetic) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_COMPANY_INIT)
            {
                oneCompanyPtr = (WCXFRecord_Company*)oneRecord.m_varDataPtr;
                if (oneCompanyPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneCompanyPtr->m_Company_Phonetic = *tmpCStrPtr;
                        }
                    }
                }
            }
        }
        //-Phone---------------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_Work) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_WorkPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_Home) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_HomePtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_Other) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_OtherPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_Mobile) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_MobilePtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_Main) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_MainPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_Primary) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_PrimaryPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_GoogleVoice) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_GoogleVoicePtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_iPhone) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_iPhonePtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_Pager) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_PagerPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_WorkFax) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_WorkFaxPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_HomeFax) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_HomeFaxPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Phone_OtherFax) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_PHONE_INIT)
            {
                onePhonePtr = (WCXFRecord_Phone*)oneRecord.m_varDataPtr;
                if (onePhonePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePhonePtr->m_Phone_OtherFaxPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }
        //-Address------------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_Address_Work) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L1)
            {
                if (bAction == 1)
                {
                    oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                    if (oneAdrsTmpPtr != 0)
                    {
                        oneAdrsTmpPtr->m_AdrsL3 = new WCXFRecord_AdrsL3();		//### New Alloc
                        if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                        {
                            oneRecord.m_nowState = DEF_WCXF_STATE_ADDRESS_INIT_L2;
                        }
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                if (bAction == 2)
                {
                    oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                    if (oneAdrsTmpPtr != 0)
                    {
                        if ((oneAdrsTmpPtr->m_AdrsL3 != 0) && (oneAdrsTmpPtr->m_AdrsL1 != 0))
                        {
                            oneAdrsTmpPtr->m_AdrsL1->m_WorkPtrDQ.push_back(oneAdrsTmpPtr->m_AdrsL3);
                            oneAdrsTmpPtr->m_AdrsL3 = 0;
                            oneRecord.m_nowState = DEF_WCXF_STATE_ADDRESS_INIT_L1;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Address_Home) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L1)
            {
                if (bAction == 1)
                {
                    oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                    if (oneAdrsTmpPtr != 0)
                    {
                        oneAdrsTmpPtr->m_AdrsL3 = new WCXFRecord_AdrsL3();		//### New Alloc
                        if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                        {
                            oneRecord.m_nowState = DEF_WCXF_STATE_ADDRESS_INIT_L2;
                        }
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                if (bAction == 2)
                {
                    oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                    if (oneAdrsTmpPtr != 0)
                    {
                        if ((oneAdrsTmpPtr->m_AdrsL3 != 0) && (oneAdrsTmpPtr->m_AdrsL1 != 0))
                        {
                            oneAdrsTmpPtr->m_AdrsL1->m_HomePtrDQ.push_back(oneAdrsTmpPtr->m_AdrsL3);
                            oneAdrsTmpPtr->m_AdrsL3 = 0;
                            oneRecord.m_nowState = DEF_WCXF_STATE_ADDRESS_INIT_L1;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Address_Other) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L1)
            {
                if (bAction == 1)
                {
                    oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                    if (oneAdrsTmpPtr != 0)
                    {
                        oneAdrsTmpPtr->m_AdrsL3 = new WCXFRecord_AdrsL3();		//### New Alloc
                        if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                        {
                            oneRecord.m_nowState = DEF_WCXF_STATE_ADDRESS_INIT_L2;
                        }
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                if (bAction == 2)
                {
                    oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                    if (oneAdrsTmpPtr != 0)
                    {
                        if ((oneAdrsTmpPtr->m_AdrsL3 != 0) && (oneAdrsTmpPtr->m_AdrsL1 != 0))
                        {
                            oneAdrsTmpPtr->m_AdrsL1->m_OtherPtrDQ.push_back(oneAdrsTmpPtr->m_AdrsL3);
                            oneAdrsTmpPtr->m_AdrsL3 = 0;
                            oneRecord.m_nowState = DEF_WCXF_STATE_ADDRESS_INIT_L1;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_Address_Street) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                if (oneAdrsTmpPtr != 0)
                {
                    if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneAdrsTmpPtr->m_AdrsL3->m_Street = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_Address_City) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                if (oneAdrsTmpPtr != 0)
                {
                    if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneAdrsTmpPtr->m_AdrsL3->m_City = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_Address_State) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                if (oneAdrsTmpPtr != 0)
                {
                    if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneAdrsTmpPtr->m_AdrsL3->m_State = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_Address_ZIP) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                if (oneAdrsTmpPtr != 0)
                {
                    if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneAdrsTmpPtr->m_AdrsL3->m_ZIP = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_Address_Country) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                if (oneAdrsTmpPtr != 0)
                {
                    if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneAdrsTmpPtr->m_AdrsL3->m_Country = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_Address_CountryCode) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                if (oneAdrsTmpPtr != 0)
                {
                    if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneAdrsTmpPtr->m_AdrsL3->m_CountryCode = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_Address_Format) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                if (oneAdrsTmpPtr != 0)
                {
                    if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_INTEGER)
                        {
                            tmpNumPtr = (int*)oneNode->m_Data;
                            if (tmpNumPtr != 0)
                            {
                                oneAdrsTmpPtr->m_AdrsL3->m_Format = *tmpNumPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_Address_GPS) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_ADDRESS_INIT_L2)
            {
                oneAdrsTmpPtr = (WCXFRecord_AdrsTmp*)oneRecord.m_varDataPtr;
                if (oneAdrsTmpPtr != 0)
                {
                    if (oneAdrsTmpPtr->m_AdrsL3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneAdrsTmpPtr->m_AdrsL3->m_GPS = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }
        //-Email------------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_Email_Work) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_EMAIL_INIT)
            {
                oneEmailPtr = (WCXFRecord_Email*)oneRecord.m_varDataPtr;
                if (oneEmailPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneEmailPtr->m_WorkPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Email_Home) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_EMAIL_INIT)
            {
                oneEmailPtr = (WCXFRecord_Email*)oneRecord.m_varDataPtr;
                if (oneEmailPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneEmailPtr->m_HomePtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Email_Other) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_EMAIL_INIT)
            {
                oneEmailPtr = (WCXFRecord_Email*)oneRecord.m_varDataPtr;
                if (oneEmailPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneEmailPtr->m_OtherPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }
        //-URL------------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_HomePage) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_HomePagePtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_Work) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_WorkPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_Home) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_HomePtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_Facebook) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_FacebookPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_Twitter) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_TwitterPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_Plurk) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_PlurkPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_LinkedIn) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_LinkedInPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_Profile) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_ProfilePtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_Blog) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_BlogPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_URL_Other) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_URL_INIT)
            {
                oneURLPtr = (WCXFRecord_URL*)oneRecord.m_varDataPtr;
                if (oneURLPtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneURLPtr->m_OtherPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }
        //-- 105 sW ------------------------------------------------------------------------------v---
        //-GroupV2------------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_GroupV2_Default) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_GROUPV2_INIT)
            {
                oneGroupV2Ptr = (WCXFRecord_GroupV2*)oneRecord.m_varDataPtr;
                if (oneGroupV2Ptr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneGroupV2Ptr->m_DefaultPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_GroupV2_Defined) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_GROUPV2_INIT)
            {
                oneGroupV2Ptr = (WCXFRecord_GroupV2*)oneRecord.m_varDataPtr;
                if (oneGroupV2Ptr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            oneGroupV2Ptr->m_DefinedPtrDQ.push_back(tmpCStrPtr);
                        }
                    }
                }
            }
        }
        //-UserDefine---------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_UserDefine_Label) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_USERDEFINE_INIT_L1)
            {
                oneUserDefineTmpPtr = (WCXFRecord_UD_Tmp*)oneRecord.m_varDataPtr;
                if (oneUserDefineTmpPtr != 0)
                {
                    if (oneUserDefineTmpPtr->m_UD_L2 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneUserDefineTmpPtr->m_UD_L2->m_Label = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_UserDefine_Content) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_USERDEFINE_INIT_L1)
            {
                oneUserDefineTmpPtr = (WCXFRecord_UD_Tmp*)oneRecord.m_varDataPtr;
                if (oneUserDefineTmpPtr != 0)
                {
                    if (oneUserDefineTmpPtr->m_UD_L2 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneUserDefineTmpPtr->m_UD_L2->m_Content = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }
        //-Tag ---------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_Tag_Name) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_TAG_INIT_L1)
            {
                oneTagTmpPtr = (WCXFRecord_Tag_Tmp*)oneRecord.m_varDataPtr;
                if (oneTagTmpPtr != 0)
                {
                    if (oneTagTmpPtr->m_L2 == 0)
                    {
                        if (oneTagTmpPtr->m_L2 == 0)
                        {
                            oneTagTmpPtr->m_L2 = new WCXFRecord_Tag_L2();		//### New Alloc
                            oneTagTmpPtr->m_State = 1;
                        }
                    }
                    if (oneTagTmpPtr->m_L2 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneTagTmpPtr->m_L2->m_Name = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Tag_Data) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_TAG_INIT_L1)
            {
                oneTagTmpPtr = (WCXFRecord_Tag_Tmp*)oneRecord.m_varDataPtr;
                if (oneTagTmpPtr != 0)
                {
                    if (oneTagTmpPtr->m_L2 == 0)
                    {
                        if (oneTagTmpPtr->m_L2 == 0)
                        {
                            oneTagTmpPtr->m_L2 = new WCXFRecord_Tag_L2();		//### New Alloc
                            oneTagTmpPtr->m_State = 1;
                        }
                    }
                    if (oneTagTmpPtr->m_L2 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneTagTmpPtr->m_L2->m_Data = *tmpCStrPtr;
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL1_PPAccountID) == 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneRecord.m_PPAccountIDDQ.push_back(tmpCStrPtr);
                }
            }
        }
        //-- 105 sW ------------------------------------------------------------------------------^---
        //-IM------------------------------------------------------------------- L2
        else if (lastKey.CompareNoCase(kWCXF_CDL2_IM_Work) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L1)
            {
                if (bAction == 1)
                {
                    oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                    if (oneIMTmpPtr != 0)
                    {
                        oneIMTmpPtr->m_L3 = new WCXFRecord_IML3();		//### New Alloc
                        if (oneIMTmpPtr->m_L3 != 0)
                        {
                            oneRecord.m_nowState = DEF_WCXF_STATE_IM_INIT_L2;
                        }
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                if (bAction == 2)
                {
                    oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                    if (oneIMTmpPtr != 0)
                    {
                        if ((oneIMTmpPtr->m_L3 != 0) && (oneIMTmpPtr->m_L1 != 0))
                        {
                            oneIMTmpPtr->m_L1->m_WorkPtrDQ.push_back(oneIMTmpPtr->m_L3);
                            oneIMTmpPtr->m_L3 = 0;
                            oneRecord.m_nowState = DEF_WCXF_STATE_IM_INIT_L1;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_IM_Home) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L1)
            {
                if (bAction == 1)
                {
                    oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                    if (oneIMTmpPtr != 0)
                    {
                        oneIMTmpPtr->m_L3 = new WCXFRecord_IML3();		//### New Alloc
                        if (oneIMTmpPtr->m_L3 != 0)
                        {
                            oneRecord.m_nowState = DEF_WCXF_STATE_IM_INIT_L2;
                        }
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                if (bAction == 2)
                {
                    oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                    if (oneIMTmpPtr != 0)
                    {
                        if ((oneIMTmpPtr->m_L3 != 0) && (oneIMTmpPtr->m_L1 != 0))
                        {
                            oneIMTmpPtr->m_L1->m_HomePtrDQ.push_back(oneIMTmpPtr->m_L3);
                            oneIMTmpPtr->m_L3 = 0;
                            oneRecord.m_nowState = DEF_WCXF_STATE_IM_INIT_L1;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_IM_Other) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L1)
            {
                if (bAction == 1)
                {
                    oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                    if (oneIMTmpPtr != 0)
                    {
                        oneIMTmpPtr->m_L3 = new WCXFRecord_IML3();		//### New Alloc
                        if (oneIMTmpPtr->m_L3 != 0)
                        {
                            oneRecord.m_nowState = DEF_WCXF_STATE_IM_INIT_L2;
                        }
                    }
                }
            }else if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                if (bAction == 2)
                {
                    oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                    if (oneIMTmpPtr != 0)
                    {
                        if ((oneIMTmpPtr->m_L3 != 0) && (oneIMTmpPtr->m_L1 != 0))
                        {
                            oneIMTmpPtr->m_L1->m_OtherPtrDQ.push_back(oneIMTmpPtr->m_L3);
                            oneIMTmpPtr->m_L3 = 0;
                            oneRecord.m_nowState = DEF_WCXF_STATE_IM_INIT_L1;
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_IM_AIM) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                if (oneIMTmpPtr != 0)
                {
                    if (oneIMTmpPtr->m_L3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneIMTmpPtr->m_L3->m_AIMPtrDQ.push_back(tmpCStrPtr);
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_IM_YahooMessenger) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                if (oneIMTmpPtr != 0)
                {
                    if (oneIMTmpPtr->m_L3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneIMTmpPtr->m_L3->m_YahooMessengerPtrDQ.push_back(tmpCStrPtr);
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_IM_MSN) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                if (oneIMTmpPtr != 0)
                {
                    if (oneIMTmpPtr->m_L3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneIMTmpPtr->m_L3->m_MSNPtrDQ.push_back(tmpCStrPtr);
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_IM_ICQ) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                if (oneIMTmpPtr != 0)
                {
                    if (oneIMTmpPtr->m_L3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneIMTmpPtr->m_L3->m_ICQPtrDQ.push_back(tmpCStrPtr);
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_IM_Jabber) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                if (oneIMTmpPtr != 0)
                {
                    if (oneIMTmpPtr->m_L3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneIMTmpPtr->m_L3->m_JabberPtrDQ.push_back(tmpCStrPtr);
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_IM_QQ) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                if (oneIMTmpPtr != 0)
                {
                    if (oneIMTmpPtr->m_L3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneIMTmpPtr->m_L3->m_QQPtrDQ.push_back(tmpCStrPtr);
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL3_IM_GoogleTalk) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_IM_INIT_L2)
            {
                oneIMTmpPtr = (WCXFRecord_IMTmp*)oneRecord.m_varDataPtr;
                if (oneIMTmpPtr != 0)
                {
                    if (oneIMTmpPtr->m_L3 != 0)
                    {
                        if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
                        {
                            tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                            if (tmpCStrPtr != 0)
                            {
                                oneIMTmpPtr->m_L3->m_GoogleTalkPtrDQ.push_back(tmpCStrPtr);
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Date_Anniversary) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_DATE_INIT)
            {
                oneDatePtr = (WCXFRecord_Date*)oneRecord.m_varDataPtr;
                if (oneDatePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_DATE)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePPDatePtr = new PPDate();			//### New Alloc
                            if (onePPDatePtr != 0)
                            {
                                //oneDatePtr->m_AnniversaryPtrDQ
                                ConvertString2PPDate(*tmpCStrPtr,*onePPDatePtr);
                                oneDatePtr->m_AnniversaryPtrDQ.push_back(onePPDatePtr);
                            }
                        }
                    }
                }
            }
        }else if (lastKey.CompareNoCase(kWCXF_CDL2_Date_Other) == 0)
        {
            if (oneRecord.m_nowState == DEF_WCXF_STATE_DATE_INIT)
            {
                oneDatePtr = (WCXFRecord_Date*)oneRecord.m_varDataPtr;
                if (oneDatePtr != 0)
                {
                    if (oneNode->m_Type == DEF_WCXF_NODE_DATE)
                    {
                        tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                        if (tmpCStrPtr != 0)
                        {
                            onePPDatePtr = new PPDate();			//### New Alloc
                            if (onePPDatePtr != 0)
                            {
                                //oneDatePtr->m_AnniversaryPtrDQ
                                ConvertString2PPDate(*tmpCStrPtr,*onePPDatePtr);
                                oneDatePtr->m_OtherPtrDQ.push_back(onePPDatePtr);
                            }
                        }
                    }
                }
            }
        }
        
    }
    return 1;
    
}

int CPPWcxfFile::pp_itoa(int val, char* buf,unsigned int radix)
{
    char* p;
    unsigned int a;        //every digit
    int len;
    char* b;            //start of the digit char
    char temp;
    unsigned int u;
    
    p = buf;
    
    if (val < 0)
    {
        *p++ = '-';
        val = 0 - val;
    }
    u = (unsigned int)val;
    
    b = p;
    
    do
    {
        a = u % radix;
        u /= radix;
        
        *p++ = a + '0';
        
    } while (u > 0);
    
    len = (int)(p - buf);
    
    *p-- = 0;
    
    //swap
    do
    {
        temp = *p;
        *p = *b;
        *b = temp;
        --p;
        ++b;
        
    } while (b < p);
    
    return len;
}


int CPPWcxfFile::WriteRootInfo(void *fileH)
{
    int iOKFlag = 0;
    CPPWcxfFInfo *oneInfoP = (CPPWcxfFInfo*)fileH;
    char *tmpCharP;
    char tmpBufferA[128];
    
    if ((oneInfoP != 0) && (oneInfoP->m_Mode == DEF_WCXF_OPENFILE_MODE_WRITE))
    {
        if (oneInfoP->m_FileH != 0)
        {
            if (m_FileIo.WriteFile(oneInfoP->m_FileH,DEF_WCXF_XMLHEADER1,1,strlen(DEF_WCXF_XMLHEADER1)) != strlen(DEF_WCXF_XMLHEADER1))
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            if (m_FileIo.WriteFile(oneInfoP->m_FileH,DEF_WCXF_XMLHEADER2,1,strlen(DEF_WCXF_XMLHEADER2)) != strlen(DEF_WCXF_XMLHEADER2))
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            if (m_FileIo.WriteFile(oneInfoP->m_FileH,DEF_WCXF_XMLHEADER3,1,strlen(DEF_WCXF_XMLHEADER3)) != strlen(DEF_WCXF_XMLHEADER3))
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            
            if (WriteToken(oneInfoP->m_FileH,0,"<dict>\xa") != 1)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            
            // ---kWCXF_R_Generator---------------------------------------------------------------------------
            if (WriteTokenLine(oneInfoP->m_FileH,1,"key",kWCXF_R_Generator) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            if (WriteTokenLine(oneInfoP->m_FileH,1,"string",m_kWCXF_R_Generator) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            
            // ---kWCXF_R_FormatVersion---------------------------------------------------------------------------
            if (WriteTokenLine(oneInfoP->m_FileH,1,"key",kWCXF_R_FormatVersion) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            sprintf(tmpBufferA,"%03d",m_kWCXF_R_FormatVersion);
            if (WriteTokenLine(oneInfoP->m_FileH,1,"integer",tmpBufferA) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            
            // ---kWCXF_R_FileID---------------------------------------------------------------------------
            if (WriteTokenLine(oneInfoP->m_FileH,1,"key",kWCXF_R_FileID) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            if (WriteTokenLine(oneInfoP->m_FileH,1,"string",m_kWCXF_R_FileID) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            
            // ---kWCXF_R_FileCreateTime---------------------------------------------------------------------------
            if (WriteTokenLine(oneInfoP->m_FileH,1,"key",kWCXF_R_FileCreateTime) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            
            tmpCharP = GetDateStringA(m_kWCXF_R_FileCreateTime);
            if (tmpCharP == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            m_kWCXF_R_FileCreateTimePos = m_FileIo.GetFilePos(oneInfoP->m_FileH) + 7; //1tab + <date>
            if (WriteTokenLine(oneInfoP->m_FileH,1,"date",tmpCharP) == 0)
            {
                
                delete [] tmpCharP;
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            delete [] tmpCharP;
            
            // ---kWCXF_R_CardCount---------------------------------------------------------------------------
            if (WriteTokenLine(oneInfoP->m_FileH,1,"key",kWCXF_R_CardCount) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            sprintf(tmpBufferA,"%d",m_kWCXF_R_CardCount);
            if (WriteTokenLine(oneInfoP->m_FileH,1,"integer",tmpBufferA) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            
            // ---kWCXF_R_CardArray---------------------------------------------------------------------------
            if (WriteTokenLine(oneInfoP->m_FileH,1,"key",kWCXF_R_CardArray) == 0)
            {
                goto CPPWcxfFile_WriteRootInfo_Err000;
            }
            
            WriteToken(oneInfoP->m_FileH,1,"<array>\xa");
            
            m_kWCXF_R_FileCreateTime_Old = m_kWCXF_R_FileCreateTime;
            iOKFlag = 1;
            
        }
        
    }
CPPWcxfFile_WriteRootInfo_Err000:
    return iOKFlag;
}


int CPPWcxfFile::WriteTokenLine(void *fileH,int tabNum,const char *tokenString,const char *keyString)
{
    int i;
    int iOKFlag = 0;
    char tokenBufferS[128];
    char tokenBufferE[128];
    
    if (fileH != 0)
    {
        for (i = 0;i < tabNum;i++)
        {
            if (m_FileIo.WriteFile(fileH,(char*)"\t",1,strlen("\t")) != strlen("\t"))
            {
                goto CPPWcxfFile_WriteTokenLine_Err000;
                break;
            }
        }
        sprintf(tokenBufferS,"<%s>",tokenString);
        sprintf(tokenBufferE,"</%s>\xa",tokenString);
        
        if (m_FileIo.WriteFile(fileH,tokenBufferS,1,(int)strlen(tokenBufferS)) != (int)strlen(tokenBufferS))
        {
            goto CPPWcxfFile_WriteTokenLine_Err000;
        }
        if (m_FileIo.WriteFile(fileH,(char*)keyString,1,(int)strlen(keyString)) != (int)strlen(keyString))
        {
            goto CPPWcxfFile_WriteTokenLine_Err000;
        }
        if (m_FileIo.WriteFile(fileH,(char*)tokenBufferE,1,(int)strlen(tokenBufferE)) != (int)strlen(tokenBufferE))
        {
            goto CPPWcxfFile_WriteTokenLine_Err000;
        }
        iOKFlag = 1;
        
    }
CPPWcxfFile_WriteTokenLine_Err000:
    return iOKFlag;
}

int CPPWcxfFile::WriteTokenLine(void *fileH,int tabNum,const char *tokenString,PPCStringW &keyString)
{
    char *BufferP;
    int iRet = 0;
    PPCStringW tmpStr;
    
    tmpStr = ChangeXMLString_Write(keyString);
    BufferP = Unicode2UTF8(tmpStr);
    if (BufferP != 0)
    {
        iRet = WriteTokenLine(fileH,tabNum,tokenString,BufferP);
        delete [] BufferP;
    }
    return iRet;
}


int CPPWcxfFile::WriteToken(void *fileH,int tabNum,const char *tokenString)
{
    int iRet = 0;
    int i;
    
    if (fileH != 0)
    {
        for (i = 0;i < tabNum;i++)
        {
            if (m_FileIo.WriteFile(fileH, (char*)"\t", 1, strlen("\t")) != strlen("\t"))
            {
                goto CPPWcxfFile_WriteToken_Err000;
                break;
            }
        }
    }
    if (m_FileIo.WriteFile(fileH,(char*)tokenString,1,(int)strlen(tokenString)) == (int)strlen(tokenString))
    {
        iRet = 1;
    }
    
CPPWcxfFile_WriteToken_Err000:
    return iRet;
}



char *CPPWcxfFile::GetDateStringA(PPDate &oneDate)
{
    char *tmpBufferP = CPPMem.new_char(32);
    
    if (tmpBufferP != 0)
    {
        sprintf(tmpBufferP,"%04d-%02d-%02dT%02d:%02d:%02dZ",oneDate.m_Year,oneDate.m_Month,oneDate.m_Day,oneDate.m_Hour,oneDate.m_Minute,oneDate.m_Second);
    }
    return tmpBufferP;
    
}


char *CPPWcxfFile::Unicode2UTF8(PPCStringW &oneStringW)
{
    CPPCode onePPCode;
    char *utf8BufferP = 0;
    int iLen;
    int idx;
    
    
    iLen = oneStringW.GetLength();
    if (iLen > 0)
    {
        utf8BufferP = CPPMem.new_char(iLen*3+12);
        idx = onePPCode.PPUnicode2UTF8(oneStringW.GetBuffer(),iLen,utf8BufferP,iLen*3+12);
        if (idx >= 0)
        {
            utf8BufferP[idx] = 0;
        }
    }else
    {
        utf8BufferP = CPPMem.new_char(12);
        utf8BufferP[0] = 0;
    }
    return utf8BufferP;
}


int CPPWcxfFile::WriteOneRecord(void *fileH, WCXFRecord &oneRecord)
{
    CPPWcxfFInfo *oneInfoP = (CPPWcxfFInfo*)fileH;
    int i,j,k;
    WCXFRecord_Name *oneNamePtr;
    WCXFRecord_Company *oneCompanyPtr;
    WCXFRecord_Phone *onePhonePtr;
    WCXFRecord_Adrs  *oneAdrsPtr;
    WCXFRecord_AdrsL3 *tmpAdrsL3Ptr;
    WCXFRecord_Email *oneEmailPtr;
    WCXFRecord_URL *oneURLPtr;
    WCXFRecord_IM *oneIMPtr;
    WCXFRecord_IML3 *oneIMPL3tr;
    WCXFRecord_Date *oneDatePtr;
    PPDate *onePPDatePtr;
    WCXFRecord_GroupV2 *oneGroupV2Ptr;
    char *tmpCharP;
    WCXFRecord_UD_L1 *oneUserDefinePtr;
    WCXFRecord_UD_L2 * oneUDL2Ptr;
    WCXFRecord_Tag_L1 *oneTagL1Ptr;
    WCXFRecord_Tag_L2 *oneTagL2Ptr;
    /*
     
     CPPFileIo oneFileIo;
     */
    CBase64 oneBase64;
    int iTmpSize;
    char *aBufferP = 0;
    char tmpBufferA[128];
    int tabLevel=3;
    
    //-- 105 sW ------------------------------------------------------------------------------v---
    FilterFields(oneRecord);
    //-- 105 sW ------------------------------------------------------------------------------^---
    
    if ((oneInfoP != 0) && (oneInfoP->m_Mode == DEF_WCXF_OPENFILE_MODE_WRITE))
    {
        WriteToken(oneInfoP->m_FileH,2,"<dict>\xa");
        
        
        // Write Group----------------------------------------------------v-	//(Lո)
        if (oneRecord.m_GroupPtrDQ.size() > 0)
        {
            if (oneRecord.m_GroupPtrDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Group) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_GroupPtrDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Group) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_GroupPtrDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_GroupPtrDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // Write Group----------------------------------------------------^-
        //-UniqueID---------------------------------------------------------v-----
        if (oneRecord.m_UniqueID.GetLength() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_UniqueID) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            if (WriteTokenLine(oneInfoP->m_FileH,3,"string",oneRecord.m_UniqueID) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
        }else
        {
            m_LastError = DEF_WCXF_ERR_UniqueID;
        }
        //-UniqueID---------------------------------------------------------^-----
        //-kWCXF_CDL1_Image-------------------------------------------------v------
        if (oneRecord.m_Image_Flag != 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Image) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            WriteToken(oneInfoP->m_FileH,3,"<dict>\xa");
            
            if ((oneRecord.m_Image_Flag & DEF_WCXF_IMAGE_FLAG_FRONT) != 0)
            {
                if (oneRecord.m_Image_Front_size > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"key",kWCXF_CDL2_Image_Front) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    WriteToken(oneInfoP->m_FileH,4,"<data>\xa");
                    aBufferP = oneBase64.NewBase64Encode(oneRecord.m_Image_Front_Ptr,oneRecord.m_Image_Front_size,true,&iTmpSize);
                    if (aBufferP != 0)
                    {
                        aBufferP[iTmpSize] = 0;
                        if (WriteToken(oneInfoP->m_FileH,0,aBufferP) == 0)
                        {
                            delete [] aBufferP;
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                        delete [] aBufferP;
                        WriteToken(oneInfoP->m_FileH,0,"\xa");
                    }
                    WriteToken(oneInfoP->m_FileH,4,"</data>\xa");
                }
            }
            
            if ((oneRecord.m_Image_Flag & DEF_WCXF_IMAGE_FLAG_BACK) != 0)
            {
                if (oneRecord.m_Image_Back_size > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"key",kWCXF_CDL2_Image_Back) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    WriteToken(oneInfoP->m_FileH,4,"<data>\xa");
                    aBufferP = oneBase64.NewBase64Encode(oneRecord.m_Image_Back_Ptr,oneRecord.m_Image_Back_size,true,&iTmpSize);
                    if (aBufferP != 0)
                    {
                        aBufferP[iTmpSize] = 0;
                        if (WriteToken(oneInfoP->m_FileH,0,aBufferP) == 0)
                        {
                            delete [] aBufferP;
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                        delete [] aBufferP;
                        WriteToken(oneInfoP->m_FileH,0,"\xa");
                    }
                    WriteToken(oneInfoP->m_FileH,4,"</data>\xa");
                }
            }
            
            if ((oneRecord.m_Image_Flag & DEF_WCXF_IMAGE_FLAG_PHOTO) != 0)
            {
                if (oneRecord.m_Image_IDPhoto_size > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"key",kWCXF_CDL2_Image_IDPhoto) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    WriteToken(oneInfoP->m_FileH,4,"<data>\xa");
                    aBufferP = oneBase64.NewBase64Encode(oneRecord.m_Image_IDPhoto_Ptr,oneRecord.m_Image_IDPhoto_size,true,&iTmpSize);
                    if (aBufferP != 0)
                    {
                        aBufferP[iTmpSize] = 0;
                        if (WriteToken(oneInfoP->m_FileH,0,aBufferP) == 0)
                        {
                            delete [] aBufferP;
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                        delete [] aBufferP;
                        WriteToken(oneInfoP->m_FileH,0,"\xa");
                    }
                    WriteToken(oneInfoP->m_FileH,4,"</data>\xa");
                    
                }
            }
            WriteToken(oneInfoP->m_FileH,3,"</dict>\xa");
            
        }
        //-kWCXF_CDL1_Image-------------------------------------------------^------
        //-kWCXF_CDL1_RecogLang----------------------------------------------v------
        if ((oneRecord.m_RecogLang.m_Front >= 0) || (oneRecord.m_RecogLang.m_Back >= 0))
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_RecogLang) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            WriteToken(oneInfoP->m_FileH,3,"<dict>\xa");
            
            if (oneRecord.m_RecogLang.m_Front >= 0)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,4,"key",kWCXF_CDL2_RecogLang_Front) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                sprintf(tmpBufferA,"%d",oneRecord.m_RecogLang.m_Front);
                if (WriteTokenLine(oneInfoP->m_FileH,4,"integer",tmpBufferA) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }
            if (oneRecord.m_RecogLang.m_Back >= 0)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,4,"key",kWCXF_CDL2_RecogLang_Back) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                sprintf(tmpBufferA,"%d",oneRecord.m_RecogLang.m_Back);
                if (WriteTokenLine(oneInfoP->m_FileH,4,"integer",tmpBufferA) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }
            WriteToken(oneInfoP->m_FileH,3,"</dict>\xa");
        }
        //-kWCXF_CDL1_RecogLang----------------------------------------------^------
        // kWCXF_CDL1_Name----------------------------------------------------v-
        if (oneRecord.m_NamePtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Name) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_NamePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_NamePtrDQ.size();i++)
            {
                oneNamePtr = oneRecord.m_NamePtrDQ[i];
                WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                
                if (oneNamePtr->m_Name_Full.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_Full) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_Full) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                if (oneNamePtr->m_Name_First.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_First) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_First) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                if (oneNamePtr->m_Name_Middle.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_Middle) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_Middle) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                if (oneNamePtr->m_Name_Last.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_Last) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_Last) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                if (oneNamePtr->m_Name_PhoneticFull.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_PhoneticFull) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_PhoneticFull) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                
                if (oneNamePtr->m_Name_PhoneticFirst.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_PhoneticFirst) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_PhoneticFirst) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                
                if (oneNamePtr->m_Name_PhoneticMiddle.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_PhoneticMiddle) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_PhoneticMiddle) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                
                if (oneNamePtr->m_Name_PhoneticLast.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_PhoneticLast) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_PhoneticLast) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                
                if (oneNamePtr->m_Name_Prefix.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_Prefix) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_Prefix) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                
                if (oneNamePtr->m_Name_Suffix.GetLength() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Name_Suffix) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneNamePtr->m_Name_Suffix) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");
            }
            if (oneRecord.m_NamePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
            
        }
        // kWCXF_CDL1_Name----------------------------------------------------^-
        // kWCXF_CDL1_NickName----------------------------------------------------v-
        if (oneRecord.m_NickNamePtrDQ.size() > 0)
        {
            if (oneRecord.m_NickNamePtrDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_NickName) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_NickNamePtrDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_NickName) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_NickNamePtrDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_NickNamePtrDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // kWCXF_CDL1_NickName----------------------------------------------------^-
        //-kWCXF_CDL1_Position----------------------------------------------------v--
        
        if (oneRecord.m_PositionPtrDQ.size() > 0)
        {
            if (oneRecord.m_PositionPtrDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Position) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_PositionPtrDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Position) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_PositionPtrDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_PositionPtrDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_Position----------------------------------------------------^--
        
        //-kWCXF_CDL1_Department----------------------------------------------------v--
        
        if (oneRecord.m_DepartmentPtrDQ.size() > 0)
        {
            if (oneRecord.m_DepartmentPtrDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Department) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_DepartmentPtrDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Department) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_DepartmentPtrDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_DepartmentPtrDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_Department----------------------------------------------------^--
        
        //-kWCXF_CDL1_Company----------------------------------------------------v--
        if (oneRecord.m_CompanyPtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Company) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_CompanyPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_CompanyPtrDQ.size();i++)
            {
                oneCompanyPtr = oneRecord.m_CompanyPtrDQ[i];
                WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                
                if (oneCompanyPtr->m_Company_Name.GetLength() >= 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Company_Name) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneCompanyPtr->m_Company_Name) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                
                if (oneCompanyPtr->m_Company_Phonetic.GetLength() >= 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"key",kWCXF_CDL2_Company_Phonetic) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel+1,"string",oneCompanyPtr->m_Company_Phonetic) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");
            }
            if (oneRecord.m_CompanyPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_Company----------------------------------------------------^--
        //-kWCXF_CDL1_Phone----------------------------------------------------v--
        if (oneRecord.m_PhonePtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Phone) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_PhonePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_PhonePtrDQ.size();i++)
            {
                onePhonePtr = oneRecord.m_PhonePtrDQ[i];
                WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                tabLevel++;
                if (onePhonePtr->m_Phone_WorkPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_Work) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_WorkPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_WorkPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_WorkPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_WorkPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_HomePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_Home) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_HomePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_HomePtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_HomePtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_HomePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_OtherPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_Other) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_OtherPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_OtherPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_OtherPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_OtherPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_MobilePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_Mobile) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_MobilePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_MobilePtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_MobilePtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_MobilePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_MainPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_Main) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_MainPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_MainPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_MainPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_MainPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_PrimaryPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_Primary) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_PrimaryPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_PrimaryPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_PrimaryPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_PrimaryPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_GoogleVoicePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_GoogleVoice) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_GoogleVoicePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_GoogleVoicePtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_GoogleVoicePtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_GoogleVoicePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_iPhonePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_iPhone) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_iPhonePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_iPhonePtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_iPhonePtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_iPhonePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_PagerPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_Pager) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_PagerPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_PagerPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_PagerPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_PagerPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_WorkFaxPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_WorkFax) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_WorkFaxPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_WorkFaxPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_WorkFaxPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_WorkFaxPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_HomeFaxPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_HomeFax) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_HomeFaxPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_HomeFaxPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_HomeFaxPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_HomeFaxPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (onePhonePtr->m_Phone_OtherFaxPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Phone_OtherFax) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (onePhonePtr->m_Phone_OtherFaxPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)onePhonePtr->m_Phone_OtherFaxPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*onePhonePtr->m_Phone_OtherFaxPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (onePhonePtr->m_Phone_OtherFaxPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                tabLevel--;
                WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");
            }
            if (oneRecord.m_PhonePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_Phone----------------------------------------------------^--
        //-kWCXF_CDL1_Skype----------------------------------------------------v--
        
        if (oneRecord.m_SkypePtrDQ.size() > 0)
        {
            if (oneRecord.m_SkypePtrDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Skype) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_SkypePtrDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Skype) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_SkypePtrDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_SkypePtrDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_Skype----------------------------------------------------^--
        //-kWCXF_CDL1_Address----------------------------------------------------v--
        if (oneRecord.m_AddressPtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Address) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_AddressPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_AddressPtrDQ.size();i++)
            {
                oneAdrsPtr = oneRecord.m_AddressPtrDQ[i];
                WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                tabLevel++;
                if (oneAdrsPtr->m_WorkPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Address_Work) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneAdrsPtr->m_WorkPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneAdrsPtr->m_WorkPtrDQ.size();j++)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                        tabLevel++;
                        tmpAdrsL3Ptr = oneAdrsPtr->m_WorkPtrDQ[j];
                        if (tmpAdrsL3Ptr != 0)
                        {
                            if (tmpAdrsL3Ptr->m_Street.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_Street) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_Street) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_City.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_City) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_City) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_State.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_State) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_State) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_ZIP.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_ZIP) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_ZIP) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_Country.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_Country) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_Country) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_CountryCode.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_CountryCode) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_CountryCode) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_Format) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            sprintf(tmpBufferA,"%d",tmpAdrsL3Ptr->m_Format);
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"integer",tmpBufferA) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (tmpAdrsL3Ptr->m_GPS.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_GPS) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_GPS) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                        }
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");
                    }
                    if (oneAdrsPtr->m_WorkPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneAdrsPtr->m_HomePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Address_Home) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneAdrsPtr->m_HomePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneAdrsPtr->m_HomePtrDQ.size();j++)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                        tabLevel++;
                        tmpAdrsL3Ptr = oneAdrsPtr->m_HomePtrDQ[j];
                        if (tmpAdrsL3Ptr != 0)
                        {
                            if (tmpAdrsL3Ptr->m_Street.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_Street) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_Street) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_City.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_City) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_City) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_State.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_State) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_State) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_ZIP.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_ZIP) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_ZIP) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_Country.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_Country) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_Country) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_CountryCode.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_CountryCode) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_CountryCode) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_Format) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            sprintf(tmpBufferA,"%d",tmpAdrsL3Ptr->m_Format);
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"integer",tmpBufferA) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (tmpAdrsL3Ptr->m_GPS.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_GPS) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_GPS) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                        }
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");
                    }
                    if (oneAdrsPtr->m_HomePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneAdrsPtr->m_OtherPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Address_Other) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneAdrsPtr->m_OtherPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneAdrsPtr->m_OtherPtrDQ.size();j++)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                        tabLevel++;
                        tmpAdrsL3Ptr = oneAdrsPtr->m_OtherPtrDQ[j];
                        if (tmpAdrsL3Ptr != 0)
                        {
                            if (tmpAdrsL3Ptr->m_Street.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_Street) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_Street) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_City.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_City) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_City) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_State.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_State) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_State) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_ZIP.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_ZIP) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_ZIP) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_Country.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_Country) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_Country) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (tmpAdrsL3Ptr->m_CountryCode.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_CountryCode) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_CountryCode) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_Format) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            sprintf(tmpBufferA,"%d",tmpAdrsL3Ptr->m_Format);
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"integer",tmpBufferA) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (tmpAdrsL3Ptr->m_GPS.GetLength() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_Address_GPS) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",tmpAdrsL3Ptr->m_GPS) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                        }
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");
                    }
                    if (oneAdrsPtr->m_OtherPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                tabLevel--;
                WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
            }
            if (oneRecord.m_AddressPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_Address----------------------------------------------------^--
        
        //-kWCXF_CDL1_Email----------------------------------------------------v--
        if (oneRecord.m_EmailPtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Email) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_EmailPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_EmailPtrDQ.size();i++)
            {
                oneEmailPtr = oneRecord.m_EmailPtrDQ[i];
                WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                tabLevel++;
                
                if (oneEmailPtr->m_WorkPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Email_Work) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneEmailPtr->m_WorkPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneEmailPtr->m_WorkPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneEmailPtr->m_WorkPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneEmailPtr->m_WorkPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneEmailPtr->m_HomePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Email_Home) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneEmailPtr->m_HomePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneEmailPtr->m_HomePtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneEmailPtr->m_HomePtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneEmailPtr->m_HomePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneEmailPtr->m_OtherPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Email_Other) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneEmailPtr->m_OtherPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneEmailPtr->m_OtherPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneEmailPtr->m_OtherPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneEmailPtr->m_OtherPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                tabLevel--;
                WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
            }
            if (oneRecord.m_EmailPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_Email----------------------------------------------------^--
        
        //-kWCXF_CDL1_URL----------------------------------------------------v--
        if (oneRecord.m_URLPtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_URL) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_URLPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_URLPtrDQ.size();i++)
            {
                oneURLPtr = oneRecord.m_URLPtrDQ[i];
                WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                tabLevel++;
                
                if (oneURLPtr->m_HomePagePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_HomePage) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_HomePagePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_HomePagePtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_HomePagePtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_HomePagePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneURLPtr->m_WorkPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_Work) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_WorkPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_WorkPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_WorkPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_WorkPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneURLPtr->m_HomePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_Home) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_HomePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_HomePtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_HomePtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_HomePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneURLPtr->m_FacebookPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_Facebook) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_FacebookPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_FacebookPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_FacebookPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_FacebookPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneURLPtr->m_TwitterPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_Twitter) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_TwitterPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_TwitterPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_TwitterPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_TwitterPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneURLPtr->m_PlurkPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_Plurk) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_PlurkPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_PlurkPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_PlurkPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_PlurkPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneURLPtr->m_LinkedInPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_LinkedIn) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_LinkedInPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_LinkedInPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_LinkedInPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_LinkedInPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneURLPtr->m_ProfilePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_Profile) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_ProfilePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_ProfilePtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_ProfilePtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_ProfilePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneURLPtr->m_BlogPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_Blog) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_BlogPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_BlogPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_BlogPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_BlogPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneURLPtr->m_OtherPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_URL_Other) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneURLPtr->m_OtherPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneURLPtr->m_OtherPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneURLPtr->m_OtherPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneURLPtr->m_OtherPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                tabLevel--;
                WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
            }
            if (oneRecord.m_URLPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_URL----------------------------------------------------^--
        
        //-kWCXF_CDL1_InstantMessage----------------------------------------------------v--
        if (oneRecord.m_InstantMessagePtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_InstantMessage) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_InstantMessagePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_InstantMessagePtrDQ.size();i++)
            {
                oneIMPtr = oneRecord.m_InstantMessagePtrDQ[i];
                WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                tabLevel++;
                
                if (oneIMPtr->m_WorkPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_IM_Work) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    
                    if (oneIMPtr->m_WorkPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    
                    WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");	
                    tabLevel++;
                    for (j = 0;j < (int)oneIMPtr->m_WorkPtrDQ.size();j++)
                    {
                        oneIMPL3tr = oneIMPtr->m_WorkPtrDQ[j];
                        if (oneIMPL3tr != 0)
                        {
                            if (oneIMPL3tr->m_AIMPtrDQ.size() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_AIM) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                
                                if (oneIMPL3tr->m_AIMPtrDQ.size() > 1)
                                {
                                    WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                    tabLevel++;
                                }
                                
                                for (k = 0;k < (int)oneIMPL3tr->m_AIMPtrDQ.size();k++)
                                {
                                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_AIMPtrDQ[k]) == 0)
                                    {
                                        goto CPPWcxfFile_WriteOneRecord_Err000;
                                    }
                                }
                                if (oneIMPL3tr->m_AIMPtrDQ.size() > 1)
                                {
                                    tabLevel--;
                                    WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                                }
                                
                            }
                        }
                        
                        if (oneIMPL3tr->m_YahooMessengerPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_YahooMessenger) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_YahooMessengerPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_YahooMessengerPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_YahooMessengerPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_YahooMessengerPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                            
                        }
                        if (oneIMPL3tr->m_MSNPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_MSN) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_MSNPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_MSNPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_MSNPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_MSNPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_ICQPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_ICQ) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_ICQPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_ICQPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_ICQPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_ICQPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_JabberPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_Jabber) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_JabberPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_JabberPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_JabberPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_JabberPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_QQPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_QQ) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_QQPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_QQPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_QQPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_QQPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_GoogleTalkPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_GoogleTalk) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_GoogleTalkPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_GoogleTalkPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_GoogleTalkPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_GoogleTalkPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                    }
                    
                    tabLevel--;
                    WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
                    
                    if (oneIMPtr->m_WorkPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneIMPtr->m_HomePtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_IM_Home) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    
                    if (oneIMPtr->m_HomePtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    
                    WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");	
                    tabLevel++;
                    for (j = 0;j < (int)oneIMPtr->m_HomePtrDQ.size();j++)
                    {
                        oneIMPL3tr = oneIMPtr->m_HomePtrDQ[j];
                        if (oneIMPL3tr != 0)
                        {
                            if (oneIMPL3tr->m_AIMPtrDQ.size() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_AIM) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                
                                if (oneIMPL3tr->m_AIMPtrDQ.size() > 1)
                                {
                                    WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                    tabLevel++;
                                }
                                
                                for (k = 0;k < (int)oneIMPL3tr->m_AIMPtrDQ.size();k++)
                                {
                                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_AIMPtrDQ[k]) == 0)
                                    {
                                        goto CPPWcxfFile_WriteOneRecord_Err000;
                                    }
                                }
                                if (oneIMPL3tr->m_AIMPtrDQ.size() > 1)
                                {
                                    tabLevel--;
                                    WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                                }
                                
                            }
                        }
                        
                        if (oneIMPL3tr->m_YahooMessengerPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_YahooMessenger) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_YahooMessengerPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_YahooMessengerPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_YahooMessengerPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_YahooMessengerPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                            
                        }
                        if (oneIMPL3tr->m_MSNPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_MSN) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_MSNPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_MSNPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_MSNPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_MSNPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_ICQPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_ICQ) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_ICQPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_ICQPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_ICQPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_ICQPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_JabberPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_Jabber) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_JabberPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_JabberPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_JabberPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_JabberPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_QQPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_QQ) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_QQPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_QQPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_QQPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_QQPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_GoogleTalkPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_GoogleTalk) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_GoogleTalkPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_GoogleTalkPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_GoogleTalkPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_GoogleTalkPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                    }
                    
                    tabLevel--;
                    WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
                    
                    if (oneIMPtr->m_HomePtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneIMPtr->m_OtherPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_IM_Other) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    
                    if (oneIMPtr->m_OtherPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    
                    WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");	
                    tabLevel++;
                    for (j = 0;j < (int)oneIMPtr->m_OtherPtrDQ.size();j++)
                    {
                        oneIMPL3tr = oneIMPtr->m_OtherPtrDQ[j];
                        if (oneIMPL3tr != 0)
                        {
                            if (oneIMPL3tr->m_AIMPtrDQ.size() > 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_AIM) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                
                                if (oneIMPL3tr->m_AIMPtrDQ.size() > 1)
                                {
                                    WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                    tabLevel++;
                                }
                                
                                for (k = 0;k < (int)oneIMPL3tr->m_AIMPtrDQ.size();k++)
                                {
                                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_AIMPtrDQ[k]) == 0)
                                    {
                                        goto CPPWcxfFile_WriteOneRecord_Err000;
                                    }
                                }
                                if (oneIMPL3tr->m_AIMPtrDQ.size() > 1)
                                {
                                    tabLevel--;
                                    WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                                }
                                
                            }
                        }
                        
                        if (oneIMPL3tr->m_YahooMessengerPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_YahooMessenger) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_YahooMessengerPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_YahooMessengerPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_YahooMessengerPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_YahooMessengerPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                            
                        }
                        if (oneIMPL3tr->m_MSNPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_MSN) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_MSNPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_MSNPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_MSNPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_MSNPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_ICQPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_ICQ) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_ICQPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_ICQPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_ICQPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_ICQPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_JabberPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_Jabber) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_JabberPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_JabberPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_JabberPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_JabberPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_QQPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_QQ) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_QQPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_QQPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_QQPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_QQPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                        if (oneIMPL3tr->m_GoogleTalkPtrDQ.size() > 0)
                        {
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL3_IM_GoogleTalk) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (oneIMPL3tr->m_GoogleTalkPtrDQ.size() > 1)
                            {
                                WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");	
                                tabLevel++;
                            }
                            
                            for (k = 0;k < (int)oneIMPL3tr->m_GoogleTalkPtrDQ.size();k++)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneIMPL3tr->m_GoogleTalkPtrDQ[k]) == 0)
                                {
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                            }
                            if (oneIMPL3tr->m_GoogleTalkPtrDQ.size() > 1)
                            {
                                tabLevel--;
                                WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");	
                            }
                        }
                    }
                    
                    tabLevel--;
                    WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
                    
                    if (oneIMPtr->m_OtherPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                
                tabLevel--;
                WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
            }
            if (oneRecord.m_InstantMessagePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_InstantMessage----------------------------------------------------^--
        //-kWCXF_CDL1_Date----------------------------------------------------v--
        if (oneRecord.m_DatePtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Date) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_DatePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_DatePtrDQ.size();i++)
            {
                oneDatePtr = oneRecord.m_DatePtrDQ[i];
                WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                tabLevel++;
                
                if (oneDatePtr->m_AnniversaryPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Date_Anniversary) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneDatePtr->m_AnniversaryPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneDatePtr->m_AnniversaryPtrDQ.size();j++)
                    {
                        onePPDatePtr = oneDatePtr->m_AnniversaryPtrDQ[j];
                        if (onePPDatePtr != 0)
                        {
                            tmpCharP = GetDateStringA(*onePPDatePtr);
                            if (tmpCharP != 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"date",tmpCharP) == 0)
                                {
                                    delete [] tmpCharP;
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                delete [] tmpCharP;
                            }
                        }
                        
                    }
                    if (oneDatePtr->m_AnniversaryPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneDatePtr->m_OtherPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Date_Other) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneDatePtr->m_OtherPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneDatePtr->m_OtherPtrDQ.size();j++)
                    {
                        onePPDatePtr = oneDatePtr->m_OtherPtrDQ[j];
                        if (onePPDatePtr != 0)
                        {
                            tmpCharP = GetDateStringA(*onePPDatePtr);
                            if (tmpCharP != 0)
                            {
                                if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"date",tmpCharP) == 0)
                                {
                                    delete [] tmpCharP;
                                    goto CPPWcxfFile_WriteOneRecord_Err000;
                                }
                                delete [] tmpCharP;
                            }
                        }
                        
                    }
                    if (oneDatePtr->m_OtherPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                tabLevel--;
                WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
            }
            if (oneRecord.m_DatePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        //-kWCXF_CDL1_Date----------------------------------------------------^--
        
        // kWCXF_CDL1_Other----------------------------------------------------v-
        if (oneRecord.m_OtherPtrDQ.size() > 0)
        {
            if (oneRecord.m_OtherPtrDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Other) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_OtherPtrDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Other) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_OtherPtrDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_OtherPtrDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // kWCXF_CDL1_Other----------------------------------------------------^-
        
        // kWCXF_CDL1_Note----------------------------------------------------v-
        if (oneRecord.m_Note.GetLength() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Note) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            if (WriteTokenLine(oneInfoP->m_FileH,3,"string",oneRecord.m_Note) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
        }
        // kWCXF_CDL1_Note----------------------------------------------------^-
        
        // kWCXF_CDL1_UnifiedBusinessNumber----------------------------------------------------v-
        if (oneRecord.m_UnifiedBusinessNumberPtrDQ.size() > 0)
        {
            if (oneRecord.m_UnifiedBusinessNumberPtrDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_UnifiedBusinessNumber) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_UnifiedBusinessNumberPtrDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_UnifiedBusinessNumber) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_UnifiedBusinessNumberPtrDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_UnifiedBusinessNumberPtrDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // kWCXF_CDL1_UnifiedBusinessNumber----------------------------------------------------^-
        
        // kWCXF_CDL1_Birthday----------------------------------------------------v-
        if ((oneRecord.m_Birthday.m_Year != 0) && (oneRecord.m_Birthday.m_Month != 0) && (oneRecord.m_Birthday.m_Day != 0))
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Birthday) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            tmpCharP = GetDateStringA(oneRecord.m_Birthday);
            if (tmpCharP != 0)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"date",tmpCharP) == 0)
                {
                    delete [] tmpCharP;
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                delete [] tmpCharP;
            }
        }
        // kWCXF_CDL1_Birthday----------------------------------------------------^-
        
        // kWCXF_CDL1_Children----------------------------------------------------v-
        if (oneRecord.m_ChildrenPtrDQ.size() > 0)
        {
            if (oneRecord.m_ChildrenPtrDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Children) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_ChildrenPtrDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Children) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_ChildrenPtrDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_ChildrenPtrDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // kWCXF_CDL1_Children----------------------------------------------------^-
        
        // kWCXF_CDL1_Spouse----------------------------------------------------v-
        if (oneRecord.m_SpousePtrDQ.size() > 0)
        {
            if (oneRecord.m_SpousePtrDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Spouse) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_SpousePtrDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Spouse) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_SpousePtrDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_SpousePtrDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // kWCXF_CDL1_Spouse----------------------------------------------------^-
        
        // kWCXF_CDL1_BloodType----------------------------------------------------v-
        if (oneRecord.m_BloodType.GetLength() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_BloodType) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            if (WriteTokenLine(oneInfoP->m_FileH,3,"string",oneRecord.m_BloodType) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
        }
        // kWCXF_CDL1_BloodType----------------------------------------------------^-
        
        // kWCXF_CDL1_Sex----------------------------------------------------v-
        if (oneRecord.m_Sex.GetLength() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Sex) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            if (WriteTokenLine(oneInfoP->m_FileH,3,"string",oneRecord.m_Sex) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
        }
        // kWCXF_CDL1_Sex----------------------------------------------------^-
        
        // kWCXF_CDL1_Horoscope----------------------------------------------------v-
        if (oneRecord.m_Horoscope.GetLength() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Horoscope) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            if (WriteTokenLine(oneInfoP->m_FileH,3,"string",oneRecord.m_Horoscope) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
        }
        // kWCXF_CDL1_Horoscope----------------------------------------------------^-
        
        // kWCXF_CDL1_Education----------------------------------------------------v-
        if (oneRecord.m_Education.GetLength() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Education) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            if (WriteTokenLine(oneInfoP->m_FileH,3,"string",oneRecord.m_Education) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
        }
        // kWCXF_CDL1_Education----------------------------------------------------^-
        
        // kWCXF_CDL1_CreateTime----------------------------------------------------v-
        if ((oneRecord.m_CreateTime.m_Year != 0) && (oneRecord.m_CreateTime.m_Month != 0) && (oneRecord.m_CreateTime.m_Day != 0))
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_CreateTime) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            tmpCharP = GetDateStringA(oneRecord.m_CreateTime);
            if (tmpCharP != 0)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"date",tmpCharP) == 0)
                {
                    delete [] tmpCharP;
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                delete [] tmpCharP;
            }
        }
        // kWCXF_CDL1_CreateTime----------------------------------------------------^-
        
        // kWCXF_CDL1_ModifiedTime----------------------------------------------------v-
        if ((oneRecord.m_ModifiedTime.m_Year != 0) && (oneRecord.m_ModifiedTime.m_Month != 0) && (oneRecord.m_ModifiedTime.m_Day != 0))
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_ModifiedTime) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            tmpCharP = GetDateStringA(oneRecord.m_ModifiedTime);
            if (tmpCharP != 0)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"date",tmpCharP) == 0)
                {
                    delete [] tmpCharP;
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                delete [] tmpCharP;
            }
        }
        // kWCXF_CDL1_ModifiedTime----------------------------------------------------^-
        
        // kWCXF_CDL1_RecognizedTime----------------------------------------------------v-
        if ((oneRecord.m_RecognizedTime.m_Year != 0) && (oneRecord.m_RecognizedTime.m_Month != 0) && (oneRecord.m_RecognizedTime.m_Day != 0))
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_RecognizedTime) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            tmpCharP = GetDateStringA(oneRecord.m_RecognizedTime);
            if (tmpCharP != 0)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"date",tmpCharP) == 0)
                {
                    delete [] tmpCharP;
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                delete [] tmpCharP;
            }
        }
        // kWCXF_CDL1_RecognizedTime----------------------------------------------------^-
        
        
        //-- 105 sW ------------------------------------------------------------------------------v---
        // kWCXF_CDL1_GroupV2----------------------------------------------------v-
        if (oneRecord.m_GroupV2PtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_GroupV2) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_GroupV2PtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_GroupV2PtrDQ.size();i++)
            {
                oneGroupV2Ptr = oneRecord.m_GroupV2PtrDQ[i];
                WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                tabLevel++;
                
                if (oneGroupV2Ptr->m_DefaultPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_GroupV2_Default) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneGroupV2Ptr->m_DefaultPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneGroupV2Ptr->m_DefaultPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneGroupV2Ptr->m_DefaultPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneGroupV2Ptr->m_DefaultPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                if (oneGroupV2Ptr->m_DefinedPtrDQ.size() > 0)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_GroupV2_Defined) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                    if (oneGroupV2Ptr->m_DefinedPtrDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneGroupV2Ptr->m_DefinedPtrDQ.size();j++)
                    {
                        if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",*oneGroupV2Ptr->m_DefinedPtrDQ[j]) == 0)
                        {
                            goto CPPWcxfFile_WriteOneRecord_Err000;
                        }
                    }
                    if (oneGroupV2Ptr->m_DefinedPtrDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                tabLevel--;
                WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
            }
            if (oneRecord.m_GroupV2PtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // kWCXF_CDL1_GroupV2----------------------------------------------------^-
        // kWCXF_CDL1_UserDefine----------------------------------------------------v-
        
        if (oneRecord.m_UserDefinePtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_UserDefine) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_UserDefinePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_UserDefinePtrDQ.size();i++)
            {
                oneUserDefinePtr = oneRecord.m_UserDefinePtrDQ[i];
                //WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                //tabLevel++;
                if (oneUserDefinePtr->m_UserDefinePDQ.size() > 0)
                {
                    if (oneUserDefinePtr->m_UserDefinePDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneUserDefinePtr->m_UserDefinePDQ.size();j++)
                    {
                        oneUDL2Ptr = oneUserDefinePtr->m_UserDefinePDQ[j];
                        if (oneUDL2Ptr != 0)
                        {
                            WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                            tabLevel++;
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_UserDefine_Label) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",oneUDL2Ptr->m_Label) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_UserDefine_Content) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",oneUDL2Ptr->m_Content) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            tabLevel--;
                            WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");
                        }
                        
                    }
                    if (oneUserDefinePtr->m_UserDefinePDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                //tabLevel--;
                //WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
            }
            if (oneRecord.m_UserDefinePtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // kWCXF_CDL1_UserDefine----------------------------------------------------^-
        // kWCXF_CDL1_Tag----------------------------------------------------v-
        if (oneRecord.m_TagPtrDQ.size() > 0)
        {
            if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_Tag) == 0)
            {
                goto CPPWcxfFile_WriteOneRecord_Err000;
            }
            
            if (oneRecord.m_TagPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                tabLevel = 4;
            }else
            {
                tabLevel = 3;
            }
            for (i = 0;i < (int)oneRecord.m_TagPtrDQ.size();i++)
            {
                oneTagL1Ptr = oneRecord.m_TagPtrDQ[i];
                //WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                //tabLevel++;
                if (oneTagL1Ptr->m_TagPDQ.size() > 0)
                {
                    if (oneTagL1Ptr->m_TagPDQ.size() > 1)
                    {
                        WriteToken(oneInfoP->m_FileH,tabLevel,"<array>\xa");
                        tabLevel++;
                    }
                    for (j = 0;j < (int)oneTagL1Ptr->m_TagPDQ.size();j++)
                    {
                        oneTagL2Ptr = oneTagL1Ptr->m_TagPDQ[j];
                        if (oneTagL2Ptr != 0)
                        {
                            WriteToken(oneInfoP->m_FileH,tabLevel,"<dict>\xa");
                            tabLevel++;
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Tag_Name) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",oneTagL2Ptr->m_Name) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"key",kWCXF_CDL2_Tag_Data) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            
                            if (WriteTokenLine(oneInfoP->m_FileH,tabLevel,"string",oneTagL2Ptr->m_Data) == 0)
                            {
                                goto CPPWcxfFile_WriteOneRecord_Err000;
                            }
                            tabLevel--;
                            WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");
                        }
                        
                    }
                    if (oneTagL1Ptr->m_TagPDQ.size() > 1)
                    {
                        tabLevel--;
                        WriteToken(oneInfoP->m_FileH,tabLevel,"</array>\xa");
                    }
                }
                
                //tabLevel--;
                //WriteToken(oneInfoP->m_FileH,tabLevel,"</dict>\xa");	
            }
            if (oneRecord.m_TagPtrDQ.size() > 1)
            {
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // kWCXF_CDL1_Tag----------------------------------------------------^-
        // kWCXF_CDL1_PPAccountID----------------------------------------------------v-
        if (oneRecord.m_PPAccountIDDQ.size() > 0)
        {
            if (oneRecord.m_PPAccountIDDQ.size() == 1)
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_PPAccountID) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                if (WriteTokenLine(oneInfoP->m_FileH,3,"string",*oneRecord.m_PPAccountIDDQ[0]) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
            }else
            {
                if (WriteTokenLine(oneInfoP->m_FileH,3,"key",kWCXF_CDL1_PPAccountID) == 0)
                {
                    goto CPPWcxfFile_WriteOneRecord_Err000;
                }
                WriteToken(oneInfoP->m_FileH,3,"<array>\xa");
                for (i = 0;i < (int)oneRecord.m_PPAccountIDDQ.size();i++)
                {
                    if (WriteTokenLine(oneInfoP->m_FileH,4,"string",*oneRecord.m_PPAccountIDDQ[i]) == 0)
                    {
                        goto CPPWcxfFile_WriteOneRecord_Err000;
                    }
                }
                WriteToken(oneInfoP->m_FileH,3,"</array>\xa");
            }
        }
        // kWCXF_CDL1_PPAccountID----------------------------------------------------^-
        //-- 105 sW ------------------------------------------------------------------------------^---
        
        WriteToken(oneInfoP->m_FileH,2,"</dict>\xa");
        
    }
    return 1;
CPPWcxfFile_WriteOneRecord_Err000:
    return 0;
}

//-- 105 sW ------------------------------------------------------------------------------v---
void CPPWcxfFile::FilterFields(WCXFRecord &oneRecord)
{
    int i = 0;
    int j = 0;
    WCXFRecord_Tag_L1 *onePtr;
    WCXFRecord_Tag_L2 *oneL2Ptr;
    int iFindFlag;
    CPPMisc oneMisc;
    WCXFRecord_Name *oneNamePtr;
    
    for (i = 0;i < oneRecord.m_TagPtrDQ.size();i++)
    {
        onePtr = oneRecord.m_TagPtrDQ[i];
        if (onePtr != 0)
        {
            for (j = 0;j < onePtr->m_TagPDQ.size();j++)
            {
                oneL2Ptr = onePtr->m_TagPDQ[j];
                if (oneL2Ptr != 0)
                {
                    iFindFlag = 0;
                    if (oneL2Ptr->m_Name.Compare("FAVOR") == 0)
                    {
                        iFindFlag = 1;
                    }else if (oneL2Ptr->m_Name.Compare("unVRF") == 0)
                    {
                        iFindFlag = 1;
                    }
                    if (iFindFlag == 0)
                    {
                        
                        onePtr->m_TagPDQ.erase(onePtr->m_TagPDQ.begin()+j);
                        j--;
                        continue;
                    }
                    
                }
            }
            if (onePtr->m_TagPDQ.size() == 0)
            {
                oneRecord.m_TagPtrDQ.erase(oneRecord.m_TagPtrDQ.begin()+i);
                i--;
                continue;
            }
        }
    }
    //01272014 by knight--bo̼W[ FixUUID -----------
    oneRecord.m_UniqueID = oneMisc.FixUUID(oneRecord.m_UniqueID);
    
    //03202014 by knight--bo̼W[ WCXFuWӨLmWTҬŸƮɡAhNWפJܡWr(last name) -----------
    {
        for (i = 0;i < oneRecord.m_NamePtrDQ.size();i++)
        {
            oneNamePtr = oneRecord.m_NamePtrDQ[i];
            if (oneNamePtr != 0)
            {
                if ((oneNamePtr->m_Name_First.GetLength() == 0) && (oneNamePtr->m_Name_Last.GetLength() == 0) && (oneNamePtr->m_Name_Middle.GetLength() == 0))
                {
                    if (oneNamePtr->m_Name_Full.GetLength() > 0)
                    {
                        oneNamePtr->m_Name_Last = oneNamePtr->m_Name_Full;
                        if (oneNamePtr->m_Name_PhoneticFull.GetLength() > 0) //YŪ@óBz
                        {
                            oneNamePtr->m_Name_PhoneticLast = oneNamePtr->m_Name_PhoneticFull;
                        }
                    }
                }
            }
        }
    }
    
}
//-- 105 sW ------------------------------------------------------------------------------^---
