//
//  WCTCRMFlowController.m
//  Pods
//
//  Created by sanhue on 2016/9/19.
//
//

#import "WCTServerContactExportFlowController.h"

// define
#import "WCTServerContactExportFlowController+SettingsKey.h"
#import "WCTServerContactExportFlowController+ResourceDefine.h"
#import "WCTRestClientController+ParameterDefine.h"
#import "WCTRestObject+ParameterDefine.h"
#import "WCTSettingsKey.h"

#import "NSObject+PPBusyView.h"
#import "NSThread+Additions.h"

//controller
#import "WCTSalesforceLoginViewController.h"
#import "WCTRestClientController+Version.h"
#import "WCToastController.h"
#import "PPSettingsController.h"
#import "WCTAccountDataController.h"
#import "PPNetworkReachabilityController.h"
#import "WCTMatomoController.h"
#import "PPNavigationController.h"
#import "PPAlertController.h"
#import "WCTServerContactExportHelper.h"

#import "WCTExchangeLoginViewController.h"
#import "WCTExportSettingsViewController.h"
#import "PPMicrosoftLoginViewController.h"
#import "WCTSalesforceContactSearchViewController.h"
#import "WCTQNapLoginViewController.h"


////////////////////////////////////////////////////////////////////////////////////////////////////
static WCTServerContactExportFlowController *staticExportFlowController = nil;

@interface WCTServerContactExportFlowController () <UIAlertViewDelegate>


@property (nonatomic, retain) NSArray *contactGuidsToExport;
@property (nonatomic, retain) UIViewController *superViewController;
@property (nonatomic, copy) WCTServerExportCompleteHandler exportCompleteHandler;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTServerContactExportFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.contactGuidsToExport = nil;
    self.superViewController = nil;
    self.exportCompleteHandler = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}


//==============================================================================
//
//==============================================================================
+ (NSString *)errorMessageWithError:(NSError *)error
{
    NSString *errorMessage = nil;
    NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
    switch (statusCode) {
        case WCTServer_QcontactzLogin_ErrorCode_LoginFailed:
        {
            errorMessage = WCTServerContactExportFlowControllerString_MLS_ErrorExchangeLoginFailed;
            break;
        }
        case WCTServer_QcontactzLogin_ErrorCode_NotInstallQcontactzService:
        {
            errorMessage = WCTServerContactExportFlowControllerString_MLS_ErrorQcontactzNotFound;
            break;
        }
        case WCTServer_QcontactzLogin_ErrorCode_NotAllowedIP:
        {
            errorMessage = WCTServerContactExportFlowControllerString_NotAllowedIP;
            break;
        }
        case WCTServer_QcontactzLogin_ErrorCode_PermissionDenied:
        {
            errorMessage = WCTServerContactExportFlowControllerString_PermissionDenied;
            break;
        }
        default:
        {
            errorMessage = [WCTServerContactExportFlowControllerString_MLS_ErrorExchangeLoginFailed stringByAppendingFormat:@" (%@)", @(statusCode)];
            break;
        }
    }
    return errorMessage;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - CRM methods


//==============================================================================
// must be called in background thread
//==============================================================================
+ (BOOL)checkCRMLoginStatusWithError:(NSError **)error
{
    __block BOOL result = NO;
    
    // 檢查CRM設定
    WCTRCCRMSettingsResponseResult *crmSettingsResponseResult = [[WCTRestClientController shareRestClientController] CRMSettingsWithError:error];
    
    if(crmSettingsResponseResult)
    {
        result = YES;
    }

    return result;
}

//==============================================================================
//
//==============================================================================
+ (void)showLoginCRMFromViewController:(UIViewController *)viewController clientID:(NSString *)clientID secret:(NSString *)secret completeHandler:(void(^)(NSDictionary *params, NSError *error))completeHandler
{
    __block NSError *error = nil;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        NSString *crmLoginURL = nil;
        
        do {
            WCTRCCRMSystem *CRMSystemInfo = nil;
            
            CRMSystemInfo = [WCTServerContactExportHelper CRMSystemTypeWithError:&error];
            
            // 如果是not found不算錯誤
            NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
            if(statusCode==WCTServer_Common_ErrorCode_DataNotFound)
            {
                error = nil;
            }
            
            if (error)
            {
                [error retain];
                break;
            }
            
            // !! 檢查有沒有設定CRM系統，如果沒有，跳出alert
            if ([CRMSystemInfo.supportCRM length]==0)
            {
                error = [PPErrorMake(WCTServerExportFlowErrorCode_SystemDisabledByManager, [WCTServerContactExportHelper disabledByManagerMessage], error) retain];
                break;
            }
            
            // 檢查是否已登入, 已登入就不再顯示登入
            if ([self checkCRMLoginStatusWithError:nil])
            {
                error = [PPErrorMake(WCTServerExportFlowErrorCode_AlreadyLogin, [WCTServerContactExportHelper alreadyLoginMessageWithTarget:WCTServerExportTarget_Salesforce], error) retain];
                break;
            }

            crmLoginURL = CRMSystemInfo.url;

        } while (0);
        
        [crmLoginURL retain];
        BOOL isV7Server = ([WCTRestClientController shareRestClientController].serverVersionInfo.majorVersion>=7.0);

        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            // 顯示錯誤提示
            if (error)
            {
                [crmLoginURL release];
                if (completeHandler)
                {
                    completeHandler(nil, error);
                    [error release];
                }
                
                return ;
            }
            
            //////////////////////////////////////////////////
            // 顯示登入介面
            WCTSalesforceLoginViewController *loginViewController = [[WCTSalesforceLoginViewController alloc] init];
            loginViewController.clientID = clientID;
            loginViewController.clientSecret = secret;
            
            
            if(isV7Server)
            {
                // !! 看server版本決定要不要Call server get_salesforce_oauth_token
                loginViewController.requestAuthTokenHandler = ^NSMutableDictionary * _Nullable(NSString * _Nullable code, NSError * _Nullable * _Nullable error) {
                    
                    NSError *returnError  = nil;
                    
                    WCTRCCRMUserAgentOAuthTokenResponseResult *responseResult = [[WCTRestClientController shareRestClientController] salesforceOAuthTokenWithCode:code error:&returnError];
                    
                    if (returnError!=nil)
                    {
                        if(error!=nil)
                        {
                            *error = returnError;
                        }
                        return nil;
                    }
                    else
                    {
                        NSMutableDictionary *loginInfo = [NSMutableDictionary dictionary];
                        [loginInfo setValue:responseResult.data.access_token forKey:kSFOAuthAccessToken];
                        [loginInfo setValue:responseResult.data.refresh_token forKey:kSFOAuthRefreshToken];
                        [loginInfo setValue:responseResult.data.identifier forKey:kSFOAuthIdentityUrl];
                        [loginInfo setValue:responseResult.data.instance_url forKey:kSFOAuthInstanceUrl];
                        [loginInfo setValue:responseResult.data.signature forKey:kSFOAuthSignature];
                        [loginInfo setValue:responseResult.data.issued_at forKey:kSFOAuthIssuedAt];
                        [loginInfo setValue:responseResult.data.token_type forKey:kSFOAuthTokenType];                        
                        return loginInfo;
                    }
                };
            }
            
            loginViewController.title = [WCTServerContactExportHelper loginToTarget:WCTServerExportTarget_Salesforce];
            loginViewController.customDomain = crmLoginURL;
            [crmLoginURL release];
            
            [loginViewController showFromViewController:viewController completeHandler:^(NSDictionary *params, NSError *error) {
                
                [loginViewController setBusy:@(YES)];
                __block NSError *returnedError = [error retain];
                
                __block NSMutableDictionary *tempParams = nil;
                
                dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                    
                    if(returnedError==nil)
                    {
                        tempParams = [NSMutableDictionary dictionaryWithDictionary:params];
                        
                        [tempParams setObject:WCTRC_ExportMode_Manual forKey:kSFOAuthExportMode];
                        [PPSettingsController setStringValue:WCTRC_ExportMode_Manual withKey:WCTSettingsKey_CRMExportMode];
                        
                        //////////////////////////////////////////////////
                        // MARK: 將登入及設定值寫入server
                        WCTRCUpdateCRMTokenRequest *crmToken = [[WCTRCUpdateCRMTokenRequest alloc] init];
                        crmToken.crmexportMode = tempParams[kSFOAuthExportMode];
                        crmToken.userCRMAccount = tempParams[kSFOAuthUserAccount];
                        crmToken.salesforceUserAgentAuthToken = [[[WCTRCSalesforceUserAgentAuthToken alloc] init] autorelease];
                        crmToken.salesforceUserAgentAuthToken.access_token = tempParams[kSFOAuthAccessToken];
                        crmToken.salesforceUserAgentAuthToken.identifier = tempParams[kSFOAuthIdentityUrl];
                        crmToken.salesforceUserAgentAuthToken.instance_url = tempParams[kSFOAuthInstanceUrl];
                        crmToken.salesforceUserAgentAuthToken.issued_at = tempParams[kSFOAuthIssuedAt];
                        crmToken.salesforceUserAgentAuthToken.refresh_token = tempParams[kSFOAuthRefreshToken];
                        crmToken.salesforceUserAgentAuthToken.signature = tempParams[kSFOAuthSignature];
                        crmToken.salesforceUserAgentAuthToken.token_type = tempParams[kSFOAuthTokenType];
                        
                        [[WCTRestClientController shareRestClientController] setCRMTokenWithTokenRequest:crmToken error:&returnedError];
                        [crmToken release];
                        
                        [returnedError retain];
                    }
                    //////////////////////////////////////////////////
                    dispatch_async(dispatch_get_main_queue(), ^{
                        
                        [loginViewController setBusy:@(NO)];
                        
                        [loginViewController goBackAnimated:YES];
                        
                        //////////////////////////////////////////////////
                        if (completeHandler)
                        {
//                            if ([WCTRestClientController statusCodeFromAFRKNetworkingError:returnedError]==WCTServer_UpdateCRMToken_ErrorCode_CRMOperationFailed)
//                            {
//                                NSError *tempError = [PPErrorMake(WCTServerExportFlowErrorCode_UpdateTokenFailed, WCTServerContactExportFlowControllerString_ErrorUpdateTargetFailed, returnedError) retain];
//                                
//                                [returnedError release];
//                                returnedError = tempError;
//                            }
                            
                            completeHandler(tempParams, returnedError);
                            [returnedError release];
                        }
                    });
                });
            }];
            [loginViewController release];
        });
    });
    
    
    
}


//==============================================================================
//
//==============================================================================
- (void)crmExportProcessWithButtonTitle:(NSString *)buttonTitle companyAssignMode:(NSString *)companyAssignMode
{
    __block typeof(self) blockSelf = self;
    void(^ExportProcessHandler)(NSString *salesforceAccountId, NSError *error) = ^(NSString *salesforceAccountId, NSError *error)
    {
        if(error)
        {
            if(blockSelf.exportCompleteHandler)
            {
                blockSelf.exportCompleteHandler (error);
            }
            
            [blockSelf setBusy:@(NO)];
            
            
            //////////////////////////////////////////////////
            // release staticExportFlowController
            dispatch_async(dispatch_get_main_queue(), ^{
                
                [staticExportFlowController release];
                staticExportFlowController = nil;
            });
        }
        
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                [blockSelf setBusy:@(YES)];
            });
            
            //////////////////////////////////////////////////
            NSString *target = nil;
            NSError *error = nil;
            WCTMatomoController_ExportTarget exportTarget = WCTMatomoController_ExportTarget_None;
            
            if ([buttonTitle isEqualToString:WCTServerContactExportFlowControllerString_ManualExportCRM_Contact]==YES)
            {
                target = WCTRC_SalesforceTarget_Contact;
                exportTarget = WCTMatomoController_ExportTarget_SalesforceContact;
            }
            else if ([buttonTitle isEqualToString:WCTServerContactExportFlowControllerString_ManualExportCRM_Opportunity]==YES)
            {
                target = WCTRC_SalesforceTarget_Lead;
                exportTarget = WCTMatomoController_ExportTarget_SalesforceLead;
            }
            
            WCTRCListRequest *listRequest = [[WCTRCListRequest alloc] init];
            listRequest.list = blockSelf.contactGuidsToExport;
            
            [[WCTRestClientController shareRestClientController] exportToSalesforceWithContactList:listRequest
                                                                                            target:target
                                                                               salesforceAccountId:salesforceAccountId
                                                                                             error:&error];
            
            [listRequest release];
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if(blockSelf.exportCompleteHandler)
                {
                    NSError *customError = nil;
                    if (error)
                    {
                        customError = PPErrorMake(WCTServerExportFlowErrorCode_ManualExportToTargetFailed, WCTServerContactExportFlowControllerString_ErrorManualExportToTargetFailed, error);
                    }
                    else
                    {
                        // MARK: !! matomo log (匯出CRM)
                        if(exportTarget!=WCTMatomoController_ExportTarget_None)
                        {
                            [WCTMatomoController sendLogWithExportTarget:exportTarget];
                        }
                    }
                    blockSelf.exportCompleteHandler (customError);
                }
                
                [blockSelf setBusy:@(NO)];
                
                
                //////////////////////////////////////////////////
                // release staticExportFlowController
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    [staticExportFlowController release];
                    staticExportFlowController = nil;
                });
            });
        });
    };
    
    //////////////////////////////////////////////////
    if([buttonTitle isEqualToString:WCTServerContactExportFlowControllerString_ManualExportCRM_Contact] &&
       [companyAssignMode isEqualToString:WCTRC_CRMCompanyAssignmentOption_Manual])
    {
        // 要先顯示salesforce聯絡人選取清單
        WCTSalesforceContactSearchViewController *contactSearchViewController = [[WCTSalesforceContactSearchViewController alloc] init];
        
        contactSearchViewController.requestRecentContactsHandler = ^NSArray *(NSError **error) {
          
            // 在 background執行
            
            WCTSalesForceSearchRecordResponseResult *result = [[WCTRestClientController shareRestClientController] salesforceRecentViewAccountsWithError:error];
            
            NSInteger i = 0;
            NSMutableArray *sectionModels = [NSMutableArray array];
            PPSectionModel *sectionModel = [PPSectionModel sectionModelWithSection:0 title:WCTServerContactExportFlowControllerString_RecentlyViewdAccount rowModels:nil];
            [sectionModels addObject:sectionModel];

            //////////////////////////////////////////////////
            NSMutableArray *rowModels = [NSMutableArray array];
            for (WCTSalesForceSearchRecord *searchRecord in result.data.records)
            {
                PPRowModel *rowModel = [PPRowModel rowModelWithRow:i
                                                              text:searchRecord.name
                                                        detailText:searchRecord.identifier
                                                            object:searchRecord];
                [rowModels addObject:rowModel];
                i++;
            }

            if([rowModels count]>0)
            {
                [sectionModel.rowModels addObjectsFromArray:rowModels];
            }
            return sectionModels;
        };
        
        contactSearchViewController.requestSearchResultHandler = ^NSArray *(NSString *keyword) {
            
            // 在 background執行
            
            NSError *error = nil;
            WCTSalesForceSearchRecordResponseResult *result = [[WCTRestClientController shareRestClientController] salesforceAccountsWithKeyword:keyword error:&error];
            
            NSInteger i = 0;
            NSMutableArray *sectionModels = [NSMutableArray array];
            PPSectionModel *sectionModel = [PPSectionModel sectionModelWithSection:0 title:WCTServerContactExportFlowControllerString_SearchResultContact rowModels:nil];
            [sectionModels addObject:sectionModel];

            //////////////////////////////////////////////////
            NSMutableArray *rowModels = [NSMutableArray array];
            for (WCTSalesForceSearchRecord *searchRecord in result.data.records)
            {
                PPRowModel *rowModel = [PPRowModel rowModelWithRow:i
                                                              text:searchRecord.name
                                                        detailText:searchRecord.identifier
                                                            object:searchRecord];
                [rowModels addObject:rowModel];
                i++;
            }
            
            if([rowModels count]>0)
            {
                [sectionModel.rowModels addObjectsFromArray:rowModels];
            }
            return sectionModels;
        };
        //////////////////////////////////////////////////
        contactSearchViewController.completeHandler = ^(NSString *contactID, NSError *error) {
          
            if(error)
            {
                ExportProcessHandler(nil, error);
            }
            else
            {
                // !! 從這邊進來，contactID 是空的表示沒選取
                if([contactID length]>0)
                {
                    ExportProcessHandler(contactID, error);
                }
            }
        };
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:contactSearchViewController];
        [self.superViewController presentViewController:navigationController animated:YES completion:nil];
        
        [navigationController release];
        [contactSearchViewController release];
    }
    else
    {
        // 直接call API
        ExportProcessHandler(nil, nil);
    }

    

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - exchange methods


//==============================================================================
// !!要在background thread 使用
//==============================================================================
+ (WCTRCExchangeServerSystemDetail *)exchangeSystemWithError:(NSError **)error
{
    NSError *returnError = nil;
    // 檢查CRM設定
    WCTRCExchangeServerSystemResponseResult *exchangeSystemResult = [[WCTRestClientController shareRestClientController] exchangeServerInfoWithError:&returnError];
    
    // 如果是not found不算錯誤
    NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:returnError];
    if(statusCode==WCTServer_Common_ErrorCode_DataNotFound)
    {
        returnError = nil;
    }
    
    if(error)
    {
        *error = returnError;
    }
    return exchangeSystemResult.data;
}


//==============================================================================
// !!要在background thread 使用
//==============================================================================
+ (BOOL)isLoginExchangeServer
{
    __block BOOL result = NO;
    NSError *returnError = nil;

    // 檢查CRM設定
    WCTRCExchangeServerSettingsResponseResult *settingsResponseResult = [[WCTRestClientController shareRestClientController] exchangeServerSettingsWithError:&returnError];
    
    if(settingsResponseResult)
    {
        result = YES;
    }

    return result;
}




//==============================================================================
//
//==============================================================================
+ (void)showLoginExchangeFromViewController:(UIViewController *)viewController completeHandler:(ExchangeLoginComplete)completeHandler
{
    [viewController retain];
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{

        // !!  先取得目前的exchange system
        NSError *returnError = nil;

        BOOL isEnabled = NO;
        BOOL isLogin = NO;
        WCTServerExportTarget target = WCTServerExportTarget_None;
        WCTRCExchangeServerSystemDetail *exchangeSystem = [WCTServerContactExportFlowController exchangeSystemWithError:&returnError];

        if(returnError==nil)
        {
            if(exchangeSystem!=nil && [exchangeSystem.supportContactServer isEqualToString:WCTRC_ExportType_None]==NO)
            {
                isEnabled= YES;
            }

            isLogin = [WCTServerContactExportFlowController isLoginExchangeServer];
            target = [WCTServerContactExportHelper targetFromServerType:exchangeSystem.supportContactServer];
        }

        [returnError retain];
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{

            [returnError release];
            // !! 有錯誤直接回傳
            if(returnError)
            {
                NSError *tempError = PPErrorMake(WCTServerExportFlowErrorCode_GetSystemTypeFailed, [WCTServerContactExportHelper disabledByManagerMessage], nil);
                if(completeHandler)
                {
                    completeHandler(nil, tempError);
                }
                return;
            }

            // 沒設定要顯示錯誤訊息
            if(isEnabled==NO)
            {
                NSError *returnError = PPErrorMake(WCTServerExportFlowErrorCode_SystemDisabledByManager, [WCTServerContactExportHelper disabledByManagerMessage], nil);
                if(completeHandler)
                {
                    completeHandler(nil, returnError);
                }
                return;
            }

            if(isLogin==YES)
            {
                NSError *returnError = PPErrorMake(WCTServerExportFlowErrorCode_AlreadyLogin, [WCTServerContactExportHelper alreadyLoginMessageWithTarget:WCTServerExportTarget_Exchange_MS], nil);
                if(completeHandler)
                {
                    completeHandler(nil, returnError);
                }
                return ;
            }
            ////////////////////////////////////////////////
            // 顯示登入介面

            switch (target)
            {
                case WCTServerExportTarget_Exchange_MS:
                {
                    WCTExchangeLoginViewController *loginViewController = [[WCTExchangeLoginViewController alloc] init];

                    loginViewController.loginComplete = ^(NSString *account, NSError *error) {

                        if(completeHandler)
                        {
                            completeHandler(account, error);
                        }
                    };

                    PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:loginViewController];
                    [viewController presentViewController:navigationController animated:YES completion:^{
                        [loginViewController.ppNavigationBarView.titleLabel setText:[WCTServerContactExportHelper loginToTarget:target]];

                    }];

                    [loginViewController release];
                    [navigationController release];
                    break;
                }
                case WCTServerExportTarget_Exchange_Office365:
                {
                    PPMicrosoftLoginViewController *loginViewController = [[[PPMicrosoftLoginViewController alloc] init] autorelease];
                    loginViewController.isLaunchPage = NO;

                    loginViewController.titleString = [WCTServerContactExportHelper loginToTarget:WCTServerExportTarget_Exchange_Office365];

                    [loginViewController showAuthWithClientID:WCTSCEFC_Office365ClientID
                                                     secretID:nil
                                                  redirectURL:WCTSCEFC_Office365RedirectURL
                                          superViewController:viewController
                                                   completion:^(NSDictionary *object, NSError *error)
                     {
                        [error retain];

                        //////////////////////////////////////////////////
                        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{

                            __block NSError *returnError = nil;
                            if(error==nil)
                            {
                                // MARK: !!寫入server
                                WCTRCExchangeServerTokenSettings *exchangeSettings = [[WCTRCExchangeServerTokenSettings alloc] init];
                                exchangeSettings.userContactServerAccount = object[@"email"];
                                exchangeSettings.supportContactServer = WCTRC_ExportType_Office365;
                                exchangeSettings.contactServerExportMode = WCTRC_ExportMode_Manual;
                                exchangeSettings.authToken = [[[WCTRCTokenObject alloc] init] autorelease];
                                exchangeSettings.authToken.refresh_token = object[@"refresh_token"];;
                                exchangeSettings.authToken.access_token = object[@"access_token"];;

                                [[WCTRestClientController shareRestClientController] setExchangeServerTokenWithTokenRequest:exchangeSettings error:&returnError];
                                [exchangeSettings release];
                            }
                            else
                            {
                                returnError = error ;
                                [error release];
                            }

                            [returnError retain];
                            //////////////////////////////////////////////////
                            dispatch_async(dispatch_get_main_queue(), ^{

                                if(returnError==nil)
                                {
                                    if(completeHandler)
                                    {
                                        completeHandler(object[@"email"], nil);
                                    }
                                }
                                else
                                {
                                    NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:returnError];
                                    [returnError release];

                                    if(statusCode==WCTServer_ExchangeServer_ErrorCode_ServerTypeNotMatch)
                                    {
                                        returnError = [PPErrorMake(WCTServerExportFlowErrorCode_UpdateTokenFailed, [WCTServerContactExportHelper setExportModeFailedMessageWithTarget:WCTServerExportTarget_Exchange_Office365], nil) retain];
                                    }
                                    else if(statusCode==WCTServer_ExchangeServer_ErrorCode_DisabledByManager)
                                    {
                                        returnError = [PPErrorMake(WCTServerExportFlowErrorCode_UpdateTokenFailed, [WCTServerContactExportHelper disabledByManagerMessage], nil) retain];
                                    }
                                    else
                                    {
                                        NSError *tempError = [PPErrorMake(WCTServerExportFlowErrorCode_UpdateTokenFailed,  [WCTServerContactExportHelper setExportModeFailedMessageWithTarget:WCTServerExportTarget_Exchange_Office365], nil) retain];
                                        returnError = tempError;
                                    }


                                    if(completeHandler)
                                    {
                                        completeHandler(nil, returnError);
                                    }
                                    [returnError release];
                                }
                            });
                        });


                    }];

                    break;
                }
                case WCTServerExportTarget_Exchange_QContactz:
                {
                    WCTQNapLoginViewController *loginViewController = [[WCTQNapLoginViewController alloc] init];
                    
                    loginViewController.loginComplete = ^(NSString *account, NSError *error) {

                        if(completeHandler)
                        {
                            completeHandler(account, error);
                        }
                    };
                    
                    loginViewController.errorMessageHandler = ^NSString *(NSError *error) {
                                                
                        return [WCTServerContactExportFlowController errorMessageWithError:error];
                    };
                    
                    PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:loginViewController];
                    [viewController presentViewController:navigationController animated:YES completion:nil];
                    
                    [loginViewController release];
                    [navigationController release];
                    break;
                }
                default:
                    break;
            }
        });
    });
}


//==============================================================================
//
//==============================================================================
- (void)exchangeExportProcessWithTarget:(WCTServerExportTarget)target
{
    __block typeof(self) blockSelf = self;

    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [blockSelf setBusy:@(YES)];
        });
        
        //////////////////////////////////////////////////
       NSError *error = nil;

        
        WCTRCListRequest *listRequest = [[WCTRCListRequest alloc] init];
        listRequest.list = blockSelf.contactGuidsToExport;
        
        [[WCTRestClientController shareRestClientController] exportToExchangeServerWithContactList:listRequest
                                                                                             error:&error];

        [listRequest release];
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{

            if(blockSelf.exportCompleteHandler)
            {
                NSError *customError = nil;
                if (error)
                {
                    customError = PPErrorMake(WCTServerExportFlowErrorCode_ManualExportToTargetFailed, WCTServerContactExportFlowControllerString_ErrorManualExportToTargetFailed, error);
                }
                else
                {
                    // MARK: !! matomo log (匯出CRM)
//                    if(exportTarget!=WCTMatomoController_ExportTarget_None)
//                    {
//                        [WCTMatomoController sendLogWithExportTarget:exportTarget];
//                    }
                }
                blockSelf.exportCompleteHandler (customError);
            }
            
            [blockSelf setBusy:@(NO)];
            

            //////////////////////////////////////////////////
            // release staticExportFlowController
            dispatch_async(dispatch_get_main_queue(), ^{
                
                [staticExportFlowController release];
                staticExportFlowController = nil;
            });
        });
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - usage methods


//==============================================================================
//
//==============================================================================
+ (void)showLoginTarget:(WCTServerExportTarget)target
     fromViewController:(UIViewController *)viewController
               clientID:(NSString *)clientID
                 secret:(NSString *)secret
        completeHandler:(void(^)(NSDictionary *params, NSError *error))completeHandler
{
    switch (target)
    {
        case WCTServerExportTarget_Salesforce:
        case WCTServerExportTarget_SugarCRM:
        {
            [self showLoginCRMFromViewController:viewController clientID:clientID secret:secret completeHandler:completeHandler];
            break;
        }
        case WCTServerExportTarget_Exchange_MS:
        case WCTServerExportTarget_Exchange_Office365:
        case WCTServerExportTarget_Exchange_QContactz:
        {
            [self showLoginExchangeFromViewController:viewController completeHandler:^(NSString *account, NSError *error) {
                if (completeHandler)
                {
                    NSMutableDictionary *params = nil;
                    if(error==nil)
                    {
                        params = [NSMutableDictionary dictionary];
                        if(account)
                        {
                            [params setObject:account forKey:@"account"];
                        }
                    }
                    completeHandler(params, error);
                }
            }];
            break;
        }
        case WCTServerExportTarget_None:
        default:
        {
            // none表示沒開
            NSError *tempError = PPErrorMake(WCTServerExportFlowErrorCode_GetSystemTypeFailed, [WCTServerContactExportHelper disabledByManagerMessage], nil);
            if(completeHandler)
            {
                completeHandler(nil, tempError);
            }
            break;
        }
    }
}


//==============================================================================
//
//==============================================================================
+ (void)logoutTarget:(WCTServerExportTarget)target
 withCompleteHaldler:(void(^)(NSError *error))completeHandler
{
    NSError *error = nil;
    switch (target)
    {
        case WCTServerExportTarget_Salesforce:
        case WCTServerExportTarget_SugarCRM:
        {
            NSString *crmType = WCTRC_CRMType_Salesforce;
            if(target==WCTServerExportTarget_Salesforce)
            {
                crmType = WCTRC_CRMType_SugarCRM;
            }
            [[WCTRestClientController shareRestClientController] logoutCRMWithType:crmType error:&error];
            
            if(error==nil)
            {
                // !! 清除設定
                [PPSettingsController removeValueWithKey:WCTSettingsKey_CRMAccount];
                
                [PPSettingsController setStringValue:WCTRC_ExportMode_Manual withKey:WCTSettingsKey_CRMExportMode];
            }
            
            break;
        }
        case WCTServerExportTarget_Exchange_MS:
        case WCTServerExportTarget_Exchange_Office365:
        case WCTServerExportTarget_Exchange_QContactz:
        {
            [[WCTRestClientController shareRestClientController] logoutExchangeServerWithError:&error];
            
            if(error==nil)
            {
                // !! 清除設定
                [PPSettingsController removeValueWithKey:WCTSettingsKey_ExchangeAccount];
                
                [PPSettingsController setStringValue:WCTRC_ExportMode_Manual withKey:WCTSettingsKey_ExchangeExportMode];
            }
            

            break;
        }
        default:
            return ;
    }
    
    if(completeHandler)
    {
        completeHandler(error);
    }
}



//==============================================================================
//
//==============================================================================
+ (void)showExportSettingsForTarget:(WCTServerExportTarget)target
                 fromViewController:(UIViewController *)viewController
                    completeHandler:(ExportSelectItemCompletion)completeHandler

{
    WCTExportSettingsViewController *exportSettingsViewController = [[WCTExportSettingsViewController alloc] init];
    exportSettingsViewController.title = [WCTServerContactExportHelper settingTitleWithTarget:target];
    exportSettingsViewController.target = target;
    
    //////////////////////////////////////////////////
    [exportSettingsViewController showFromViewController:viewController
                                      completeHandler:^(WCTExportSettingsViewController *settingsViewController, NSInteger itemIndex, NSString *itemString, NSError *error)
     {
         // 使用者按返回要當成功
         if(error==nil || error.code == WCTExportSettingsViewControllerErrorCode_UserBack)
         {
             //////////////////////////////////////////////////
             if (completeHandler)
             {
                 completeHandler (settingsViewController, itemIndex, itemString, nil);
             }
             //////////////////////////////////////////////////

             // 使用者按返回，就不用再做go back
             if (error.code != WCTExportSettingsViewControllerErrorCode_UserBack)
             {
                 dispatch_async(dispatch_get_main_queue(), ^{

                     [exportSettingsViewController goBackAnimated:YES];
                 });
             }
         }
         else
         {
             //////////////////////////////////////////////////
             if (completeHandler)
             {
                 error = PPErrorMake(WCTServerExportFlowErrorCode_FailedToSetExortMode, [WCTServerContactExportHelper setExportModeFailedMessageWithTarget:target], error);
                 completeHandler (settingsViewController, 0, nil, error);
             }
         }
     }];

    [exportSettingsViewController release];
}


//==============================================================================
//
//==============================================================================
+ (void)showLoginAndSettingsWithTarget:(WCTServerExportTarget)target
                    fromViewController:(UIViewController *)viewController
                              clientID:(NSString *)clientID
                                secret:(NSString *)secret
                       completeHandler:(void(^)(NSDictionary *params, NSError *error))completeHandler
{
    
    [self showLoginTarget:target
       fromViewController:viewController
                 clientID:clientID
                   secret:secret
          completeHandler:^(NSDictionary *params, NSError *error) {
        
        // !! 如果有執行登入，要執行設定
        if (error==nil)
        {
            //////////////////////////////////////////////////
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                [self showExportSettingsForTarget:target
                               fromViewController:viewController
                                  completeHandler:^(WCTExportSettingsViewController *viewController, NSInteger itemIndex, NSString *itemString, NSError *error) {
                    if(error==nil)
                    {
                        dispatch_async(dispatch_get_main_queue(), ^{
                            
                            if (completeHandler)
                            {
                                completeHandler (nil, error);
                            }
                        });
                    }
                }];
            });
        }
        else
        {
            [error retain];
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if (completeHandler)
                {
                    completeHandler (nil, error);
                }
                [error release];
            });
         }
     }];
}




//==============================================================================
//
//==============================================================================
+ (void)exportToTarget:(WCTServerExportTarget)target
          withContacts:(NSArray *)contactGuids
    fromViewController:(UIViewController *)viewController
       completeHandler:(WCTServerExportCompleteHandler)completeHandler
{
    __block typeof(self) blockSelf = self;
    [viewController setBusy:@(YES)];

    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{

        NSError *error = nil;
        // !! 如果沒有登入，要跳出訊息提示
        BOOL isLogin = NO;
        switch (target)
        {
            case WCTServerExportTarget_Salesforce:
            case WCTServerExportTarget_SugarCRM:
            {
                isLogin = [blockSelf checkCRMLoginStatusWithError:&error];
                break;
            }
            case WCTServerExportTarget_Exchange_MS:
            case WCTServerExportTarget_Exchange_Office365:
            case WCTServerExportTarget_Exchange_QContactz:
            {
                isLogin = [blockSelf isLoginExchangeServer];
                break;
            }
            default:
                break;
        }
        
        if (isLogin==YES)
        {
            // !! 要再更新一次CRM設定
            [WCTAccountDataController updateSettingsFromServerWithCompleteHandler:^(BOOL hasNetwork) {

                // 判斷目前設定的匯出模式，自動就只有alert提示，手動則給使用者選擇要匯出到哪
                BOOL needAlert = NO;
                NSString *exportMode = WCTRC_ExportMode_Manual;
                NSString *companyAssignmentMode = WCTRC_CRMCompanyAssignmentOption_Auto;

                switch (target)
                {
                    case WCTServerExportTarget_Salesforce:
                    case WCTServerExportTarget_SugarCRM:
                    {
                        needAlert = YES;
                        exportMode = [PPSettingsController stringValueWithKey:WCTSettingsKey_CRMExportMode];
                        companyAssignmentMode = [PPSettingsController stringValueWithKey:WCTSettingsKey_CRMCompanyAssignmentOption];
                        break;
                    }
                    case WCTServerExportTarget_Exchange_MS:
                    case WCTServerExportTarget_Exchange_Office365:
                    case WCTServerExportTarget_Exchange_QContactz:
                    {
                        exportMode = [PPSettingsController stringValueWithKey:WCTSettingsKey_ExchangeExportMode];
                        break;
                    }
                    default:
                        break;
                }
                   
                
                // MARK: TSMC export
                BOOL isTSMCVersion = [[self class] isTSMCVersion];
                if(isTSMCVersion)
                {
                    // 手動匯出要絡使用者決定匯出的標的
                    
                    // 台積電版本都是手動
                    companyAssignmentMode = WCTRC_CRMCompanyAssignmentOption_Manual;
                    staticExportFlowController = [[WCTServerContactExportFlowController alloc] init];
                    staticExportFlowController.contactGuidsToExport = contactGuids;
                    staticExportFlowController.superViewController = viewController;
                    staticExportFlowController.exportCompleteHandler = completeHandler;
                    
                    dispatch_async(dispatch_get_main_queue(), ^{
                        
                        [viewController setBusy:@(NO)];
                        
                        UIAlertAction *contactAction = [UIAlertAction actionWithTitle:WCTServerContactExportFlowControllerString_ManualExportCRM_Contact
                                                                                style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                            [staticExportFlowController crmExportProcessWithButtonTitle:WCTServerContactExportFlowControllerString_ManualExportCRM_Contact
                                                                      companyAssignMode:companyAssignmentMode];
                        }];
                        UIAlertAction *leadAction = [UIAlertAction actionWithTitle:WCTServerContactExportFlowControllerString_ManualExportCRM_Opportunity
                                                                             style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                            
                            [staticExportFlowController crmExportProcessWithButtonTitle:WCTServerContactExportFlowControllerString_ManualExportCRM_Opportunity
                                                                      companyAssignMode:companyAssignmentMode];
                        }];
                        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:WCTServerContactExportFlowControllerString_Cancel
                                                                               style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                            
                            dispatch_async(dispatch_get_main_queue(), ^{
                                
                                [staticExportFlowController release];
                                staticExportFlowController = nil;
                            });
                        }];
                        [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                                  title:WCTServerContactExportFlowControllerString_ManualExportCRMTitle
                                                                message:nil
                                                 showFromViewController:viewController
                                                               animated:YES
                                                            alertAction:contactAction, leadAction, cancelAction, nil];
                        
                    });
                    // next: @selector(alertView:clickedButtonAtIndex:);
                }
                else
                {
                    // MARK: general export
                    if ([exportMode isEqualToString:WCTRC_ExportMode_Manual])
                    {
                        // 手動匯出要絡使用者決定匯出的標的
                        
                        staticExportFlowController = [[WCTServerContactExportFlowController alloc] init];
                        staticExportFlowController.contactGuidsToExport = contactGuids;
                        staticExportFlowController.superViewController = viewController;
                        staticExportFlowController.exportCompleteHandler = completeHandler;
                        
                        
                        if(needAlert)
                        {
                            dispatch_async(dispatch_get_main_queue(), ^{
                                
                                [viewController setBusy:@(NO)];
                                
                                UIAlertAction *contactAction = [UIAlertAction actionWithTitle:WCTServerContactExportFlowControllerString_ManualExportCRM_Contact
                                                                                        style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                                    [staticExportFlowController crmExportProcessWithButtonTitle:WCTServerContactExportFlowControllerString_ManualExportCRM_Contact
                                                                              companyAssignMode:companyAssignmentMode];
                                }];
                                UIAlertAction *leadAction = [UIAlertAction actionWithTitle:WCTServerContactExportFlowControllerString_ManualExportCRM_Opportunity
                                                                                     style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                                    
                                    [staticExportFlowController crmExportProcessWithButtonTitle:WCTServerContactExportFlowControllerString_ManualExportCRM_Opportunity
                                                                              companyAssignMode:companyAssignmentMode];
                                }];
                                UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:WCTServerContactExportFlowControllerString_Cancel
                                                                                       style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                                    
                                    dispatch_async(dispatch_get_main_queue(), ^{
                                        
                                        [staticExportFlowController release];
                                        staticExportFlowController = nil;
                                    });
                                }];
                                [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                                          title:WCTServerContactExportFlowControllerString_ManualExportCRMTitle
                                                                        message:nil
                                                         showFromViewController:viewController
                                                                       animated:YES
                                                                    alertAction:contactAction, leadAction, cancelAction, nil];

                            });
                            // next: @selector(alertView:clickedButtonAtIndex:);
                        }
                        else
                        {
                            [staticExportFlowController exchangeExportProcessWithTarget:target];
                        }
                        
                    }
                    else
                    {
                        NSString *message = nil;
                        
                        if ([exportMode isEqualToString:WCTRC_ExportMode_ContactSyncAuto])
                        {
                            message =[NSString stringWithFormat:WCTServerContactExportFlowControllerString_ExportMessageFormat,
                                      [WCTServerContactExportHelper stringFromTarget:target],
                                      WCTServerContactExportFlowControllerString_ContactAutoSync];
                        }
                        else if ([exportMode isEqualToString:WCTRC_ExportMode_Auto])
                        {
                            message =[NSString stringWithFormat:WCTServerContactExportFlowControllerString_ExportMessageFormat,
                                      [WCTServerContactExportHelper stringFromTarget:target],
                                      WCTServerContactExportFlowControllerString_AutoExport];
                        }
                        else
                        {
                            message =[NSString stringWithFormat:WCTServerContactExportFlowControllerString_ExportMessageFormat,
                                      [WCTServerContactExportHelper stringFromTarget:target],
                                      @"Unknown"];
                            
                        }
                        
                        //////////////////////////////////////////////////
                        dispatch_async(dispatch_get_main_queue(), ^{
                            
                            [viewController setBusy:@(NO)];
                            
                            [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                                      title:@""
                                                                    message:message
                                                           alertActionStyle:UIAlertActionStyleDefault
                                                     showFromViewController:viewController
                                                                   animated:YES];
                        });
                    }
                }
            }];

        }
        else
        {

            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{

                [viewController setBusy:@(NO)];
                NSError *networkError = [error findNetworkError];
                if (networkError)
                {
                    if ([PPNetworkReachabilityController checkForInternetConnection]==NO)
                    {
                        [WCToastController showMessageToastFromSuperView:viewController.view
                                                             withMessage:WCTServerContactExportFlowControllerString_FailedToConnectInternet
                                                                position:PPToastPositionCenter];
                    }
                    else
                    {
                        [WCToastController showMessageToastFromSuperView:viewController.view
                                                             withMessage:WCTServerContactExportFlowControllerString_FailedToConnectServer
                                                                position:PPToastPositionCenter];

                    }
                }
                else
                {
                    [WCToastController showMessageToastFromSuperView:viewController.view
                                                         withMessage:[WCTServerContactExportHelper mustLoginBeforeUseMessageWithTarget:target]
                                                            position:PPToastPositionCenter];
                }
            });
        }
    });

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - TSMCMethods


//==============================================================================
//
//==============================================================================
+ (void)setTSMCVersion:(BOOL)tsmcVersion
{
    [PPSettingsController setNumberValue:@(tsmcVersion) withKey:WCTServerContactExportFlowController_SettingsKey_IsTSMCVersion];
}


//==============================================================================
//
//==============================================================================
+ (BOOL)isTSMCVersion
{
    NSNumber *isTSMCVersionNumber = [PPSettingsController numberValueWithKey:WCTServerContactExportFlowController_SettingsKey_IsTSMCVersion];
    
    if ([isTSMCVersionNumber boolValue]!=YES)
    {
        return NO;
    }
    else
    {
        return YES;
    }
}



@end
