//
//  WCTExportSettingsViewController.m
//  Pods
//
//  Created by sanhue on 2016/9/23.
//
//

#import "WCTExportSettingsViewController.h"

//define
#import "WCAppearanceDefine.h"
#import "WCTSettingsKey.h"
#import "WCTServerContactExportFlowController+ResourceDefine.h"

// category
#import "PPButton+Factory.h"

//controller
#import "PPNavigationController.h"
#import "WCTRestClientController.h"
#import "PPSettingsController.h"
#import "WCToastController.h"

typedef NS_ENUM(NSInteger, WCTExportSettingsButtonTag)
{
    WCTExportSettingsButtonTag_Back,
    WCTExportSettingsButtonTag_Done,
};

typedef NS_ENUM(NSInteger, WCTExportSettingsSection)
{
    WCTExportSettingsSection_ExportMode,
    WCTExportSettingsSection_CompanyAssignmentMode,
};

static NSString *const WCTExportSettingsViewController_ImageName_Done = @"Done";

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTExportSettingsViewController () <PPButtonDelegate,PPSelectItemViewControllerDelegate>

@property (nonatomic, copy) ExportSelectItemCompletion completeHandler;
@property (nonatomic, assign) WCTExportMode currentSelectedExportMode;
@property (nonatomic, assign) WCTCompnayAssignmentMode currentCompanyAssignMode;

@property (nonatomic, assign) NSInteger exportItemMask; // 設定匯出選項

@property (nonatomic, assign) BOOL isExchangeMode; // CRM的setting或是exchange setting
@property (nonatomic, assign) BOOL isQcontactz; // Qcontactz要call不同API，default NO

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTExportSettingsViewController

////////////////////////////////////////////////////////////////////////////////////////////////////





#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
+ (void)initialize
{
//    [[PPSelectItemViewController appearance] setTableViewBackgroundColor:[UIColor clearColor]];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.delegate = self;
        
        self.defaultBarViewStyle = PPBarViewStyle_CenteredAbsolute;
        
        self.currentSelectedExportMode = WCTExportMode_ContactSyncAuto;
        self.currentCompanyAssignMode = WCTCompnayAssignmentMode_Auto;

        //////////////////////////////////////////////////
//        [PPSettingsController setDefaultStringValue:WCTRC_CRMCompanyAssignmentOption_Auto withKey:WCTSettingsKey_CRMCompanyAssignmentOption];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.completeHandler = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
     //!! 一定要在viewWillAppear之前Call，有些設定會在super class中用到
    [self configWithTarget:self.target];
    
    //////////////////////////////////////////////////
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    NSString *exportMode = nil;
    NSString *companyAssignMode = nil;
    
    if (self.isExchangeMode)
    {
        exportMode = [PPSettingsController stringValueWithKey:WCTSettingsKey_ExchangeExportMode];
    }
    else
    {
        exportMode = [PPSettingsController stringValueWithKey:WCTSettingsKey_CRMExportMode];
        companyAssignMode = [PPSettingsController stringValueWithKey:WCTSettingsKey_CRMCompanyAssignmentOption];
        
        // !! 手動匯出，預設為自動
        if([exportMode isEqualToString:WCTRC_CRMExportMode_Manual] &&
           [companyAssignMode isEqualToString:WCTRC_CRMCompanyAssignmentOption_None])
        {
            companyAssignMode = WCTRC_CRMCompanyAssignmentOption_Auto;
            [PPSettingsController setStringValue:WCTRC_CRMCompanyAssignmentOption_Auto withKey:WCTSettingsKey_CRMCompanyAssignmentOption];
        }
    }
    
    NSInteger selectedMode = [WCTExportSettingsViewController exportModeFromServerDefinedExportMode:exportMode];
    NSInteger selectedCompanyAssignMode = [WCTExportSettingsViewController companyAssignModeFromServerDefinedCompanyAssignMode:companyAssignMode];
    
    self.currentSelectedExportMode = selectedMode;
    self.currentCompanyAssignMode = selectedCompanyAssignMode;
    
    [self.ppSectionController.sectionModelsForDefault addObjectsFromArray:[self settingsSectionModels]];

    [self prepareMainUI];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare data


//==============================================================================
//
//==============================================================================
- (void)configWithTarget:(WCTServerExportTarget)target
{
    switch (target)
    {
        case WCTServerExportTarget_Salesforce:
        case WCTServerExportTarget_SugarCRM:
        {
            self.isExchangeMode = NO;
            self.isQcontactz = NO;
            break;
        }
        case WCTServerExportTarget_Exchange_MS:
        case WCTServerExportTarget_Exchange_Office365:
        case WCTServerExportTarget_Exchange_QContactz:
        {
            self.isExchangeMode = YES;
            self.isQcontactz = YES;
            break;
        }
        default:
            break;
    }
    
    //////////////////////////////////////////////////
    if (target==WCTServerExportTarget_SugarCRM||
        target==WCTServerExportTarget_Salesforce||
        target==WCTServerExportTarget_Exchange_Office365||
        target==WCTServerExportTarget_Exchange_MS)
    {
        self.exportItemMask |= WCTExportMode_ContactSyncAuto;
    }
    
    self.exportItemMask |= WCTExportMode_Manual;
    
    if (target==WCTServerExportTarget_Exchange_QContactz)
    {
        self.exportItemMask |= WCTExportMode_Auto;
    }
    if ((self.exportItemMask&WCTExportMode_ContactSyncAuto)==WCTExportMode_ContactSyncAuto)
    {

    }
    else
    {
        // 選項不包含 ContactSyncAuto，預設改為手動
        self.currentSelectedExportMode = WCTExportMode_Manual;
    }

}



//==============================================================================
//
//==============================================================================
- (NSMutableArray *)settingsSectionModels
{
//    NSLog(@"%s (%td, %td)", __PRETTY_FUNCTION__, self.currentSelectedExportMode, self.currentCompanyAssignMode);
    
    NSMutableArray *sectionModels = [[NSMutableArray alloc] init];
        
    PPSectionModel *sectionModel = [[PPSectionModel alloc] init];
    if (sectionModel)
    {
        sectionModel.section = WCTExportSettingsSection_ExportMode;
        PPRowModel *rowModel = nil;
        
        if(self.isExchangeMode)
        {
            sectionModel.title = WCTServerContactExportFlowControllerString_ExportMode;
        }
        else
        {
            sectionModel.title = WCTServerContactExportFlowControllerString_CRMExportMode;
        }
        
        //////////////////////////////////////////////////
        if ((self.exportItemMask&WCTExportMode_ContactSyncAuto)==WCTExportMode_ContactSyncAuto)
        {
            rowModel = [PPRowModel rowModelWithRow:WCTExportMode_ContactSyncAuto
                                              text:WCTServerContactExportFlowControllerString_ContactAutoSync
                                        detailText:nil
                                            object:(self.currentSelectedExportMode==WCTExportMode_ContactSyncAuto)?@(YES):nil];
            if (rowModel)
            {
                [sectionModel.rowModels addObject:rowModel];
            }
            
        }

        //////////////////////////////////////////////////
        if ((self.exportItemMask&WCTExportMode_Manual)==WCTExportMode_Manual)
        {
            rowModel = [PPRowModel rowModelWithRow:WCTExportMode_Manual
                                              text:WCTServerContactExportFlowControllerString_Manual
                                        detailText:nil
                                            object:(self.currentSelectedExportMode==WCTExportMode_Manual)?@(YES):nil];
            if (rowModel)
            {
                [sectionModel.rowModels addObject:rowModel];
            }
        }
        //////////////////////////////////////////////////
        if ((self.exportItemMask&WCTExportMode_Auto)==WCTExportMode_Auto)
        {
            rowModel = [PPRowModel rowModelWithRow:WCTExportMode_Auto
                                              text:WCTServerContactExportFlowControllerString_AutoExport
                                        detailText:nil
                                            object:(self.currentSelectedExportMode==WCTExportMode_Auto)?@(YES):nil];
            if (rowModel)
            {
                [sectionModel.rowModels addObject:rowModel];
            }
        }
        //////////////////////////////////////////////////
        [sectionModels addObject:sectionModel];
        [sectionModel release];
    }
    //////////////////////////////////////////////////
    if (self.isExchangeMode==NO)
    {
        // !!如果companyAssignMode==nil，就是舊版server，不用顯示公司帳戶設定模式
        NSString *companyAssignMode = [PPSettingsController stringValueWithKey:WCTSettingsKey_CRMCompanyAssignmentOption];
        
        if(companyAssignMode!=nil)
        {
            sectionModel = [[PPSectionModel alloc] init];
            if (sectionModel)
            {
                sectionModel.section = WCTExportSettingsSection_CompanyAssignmentMode;
                sectionModel.title = WCTServerContactExportFlowControllerString_CompanyAssignMode;
                PPRowModel *rowModel = nil;
                NSInteger rowID = 0;
                
                //////////////////////////////////////////////////
                rowModel = [PPRowModel rowModelWithRow:rowID
                                                  text:WCTServerContactExportFlowControllerString_CompanyAssignMode_Manual
                                            detailText:nil
                                                object:(self.currentCompanyAssignMode==rowID)?@(YES):nil];
                if (rowModel)
                {
                    [sectionModel.rowModels addObject:rowModel];
                }
                
                rowID++;
                
                //////////////////////////////////////////////////
                rowModel = [PPRowModel rowModelWithRow:rowID
                                                  text:WCTServerContactExportFlowControllerString_CompanyAssignMode_Auto
                                            detailText:nil
                                                object:(self.currentCompanyAssignMode==rowID)?@(YES):nil];
                if (rowModel)
                {
                    [sectionModel.rowModels addObject:rowModel];
                }
                
                rowID++;
                //////////////////////////////////////////////////
                [sectionModels addObject:sectionModel];
                [sectionModel release];
            }
        }
    }
    
    return [sectionModels autorelease];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPSelectItemViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)ppSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController selectRowModel:(PPRowModel *)rowModel sectionModel:(PPSectionModel *)sectionModel
{
    __block typeof(self) blockSelf = self;
    
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        NSError *error = nil;
        BOOL canSetting = NO;
        if(self.isExchangeMode)
        {
            // MARK: set Exchange settings
            do {
                WCTRCExchangeServerSystemResponseResult *responseResult =  [[WCTRestClientController shareRestClientController] exchangeServerInfoWithError:&error];
                
                // 如果是not found不算錯誤
                NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
                if(statusCode==WCTServer_Common_ErrorCode_DataNotFound)
                {
                    error = nil;
                }
                
                // !! 檢查有沒有設定CRM系統，如果沒有，跳出alert
                if ([responseResult.data.supportContactServer length]==0)
                {
                    error = PPErrorMake(WCTExportSettingsViewControllerErrorCode_DisabledByManager, WCTServerContactExportFlowControllerString_ErrorDisabledByManager, error);
                    break;
                }
                
                // 檢查是否已登入, 已登入就不再顯示登入
                WCTRCExchangeServerSettingsResponseResult *exchangeSettingsResponseResult = [[WCTRestClientController shareRestClientController] exchangeServerSettingsWithError:&error];
                
                if(exchangeSettingsResponseResult==nil)
                {
                    error = PPErrorMake(WCTExportSettingsViewControllerErrorCode_MustLoginBeforeUse, WCTServerContactExportFlowControllerString_ErrorMustLoginBeforeUse, error);
                    break;
                }
                
                canSetting = YES;
                
            } while (0);
            
            
            if (error==nil && canSetting)
            {
                NSString *serverDefinedCRMExportMode = [WCTExportSettingsViewController serverDefinedStringFromWCTExportMode:rowModel.row];
                if (self.isQcontactz)
                {
                    [[WCTRestClientController shareRestClientController] setQContactzExportMode:serverDefinedCRMExportMode error:&error];
                }
                else
                {
                    [[WCTRestClientController shareRestClientController] setExchangeServerExportModeWithMode:serverDefinedCRMExportMode
                                                                                                       error:&error];
                }
                                
                if (error==nil)
                {
                    [PPSettingsController setStringValue:serverDefinedCRMExportMode withKey:WCTSettingsKey_ExchangeExportMode];
                }
            }
            //////////////////////////////////////////////////
            [error retain];
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if (blockSelf.completeHandler)
                {
                    blockSelf.completeHandler (self, rowModel.row, rowModel.text, error);
                }
                [error release];
            });
        }
        else
        {

            if(sectionModel.section==WCTExportSettingsSection_ExportMode)
            {
                self.currentSelectedExportMode = rowModel.row;
                self.currentCompanyAssignMode = WCTCompnayAssignmentMode_Auto;
            }
            else
            {
                self.currentCompanyAssignMode = rowModel.row;
            }
            
            NSArray *sectionModels = [[self settingsSectionModels] retain];
            dispatch_async(dispatch_get_main_queue(), ^{
                
                [self.ppSectionController replaceSectionModels:sectionModels forSearching:NO];
                [self reloadTable];
                [sectionModels release];
            });
        }
    });
}


//==============================================================================
//
//==============================================================================
- (PPBarViewItemModel *)closeItemModelForSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController
{
    PPBarViewItemModel * itemModel = nil;
    PPButton *ppButton = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                                        tag:WCTExportSettingsButtonTag_Back
                                                                   delegate:self
                                                      normalBackgroundColor:nil
                                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];

    if (ppButton)
    {
        itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:ppButton];
        itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
    }
    
    return itemModel;
}


//==============================================================================
//
//==============================================================================
- (PPBarViewBlockModel *)rightBlockModelForSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController
{
    if (self.isExchangeMode)
    {
        return nil;
    }
    else
    {
        PPBarViewItemModel * itemModel = nil;
        PPButton *ppButton = [PPButton ppButtonWithIconImageName:WCTExportSettingsViewController_ImageName_Done
                                                                            tag:WCTExportSettingsButtonTag_Done
                                                                       delegate:self
                                                          normalBackgroundColor:nil
                                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        
        if (ppButton)
        {
            itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:ppButton];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        }
        
        if (itemModel!=nil)
        {
            PPBarViewBlockModel *blockModel = [[PPBarViewBlockModel alloc] init];
            [blockModel.itemModels addObject:itemModel];
            return [blockModel autorelease];
        }
        return nil;
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Override


//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
//    NSLog(@"%s", __PRETTY_FUNCTION__);
    if(self.isExchangeMode)
    {
        return [super numberOfSectionsInTableView:tableView];
    }
    else
    {
        if (self.currentSelectedExportMode==WCTExportMode_ContactSyncAuto)
        {
            return 1;
        }
        else
        {
            return [super numberOfSectionsInTableView:tableView];
        }
    }
}

//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [super tableView:tableView numberOfRowsInSection:section];
}


//==============================================================================
//
//==============================================================================
- (nullable UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    PPSectionHeaderView *sectionHeaderView = [self.ppSectionController viewForHeaderInSection:section forSearching:NO];
    [sectionHeaderView.textLabel setTextColor:WCAppearanceDefine_SectionHeaderTitleColor];
    [sectionHeaderView.textLabel setFont:[UIFont systemFontOfSize:WCAppearanceDefine_SectionHeaderFontSize]];
    return sectionHeaderView;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate


//==============================================================================
//
//==============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return WCAppearanceDefine_SectionHeaderHeight;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    //////////////////////////////////////////////////
    
    do
    {
//        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
//        
//        switch (rowModel.row) {
//            case WCTExportMode_Auto:
//                
//                break;
//                
//            default:
//                break;
//        }
        NSMutableArray *sectionModels = [self.ppSectionController sectionModelsForSearching:self.searchDisplayController.isActive];
        if(sectionModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(PPSectionModel *sectionModel in sectionModels)
        {
            for(PPRowModel *rowModel in sectionModel.rowModels)
            {
                NSIndexPath *currentIndexPath = [NSIndexPath indexPathForRow:[sectionModel.rowModels indexOfObject:rowModel]
                                                                   inSection:[sectionModels indexOfObject:sectionModel]];
                //////////////////////////////////////////////////
                
                if(currentIndexPath.section==indexPath.section && currentIndexPath.row==indexPath.row)
                {
                    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppSelectItemViewController:selectRowModel:sectionModel:)]==YES)
                    {
                        [self.delegate ppSelectItemViewController:self selectRowModel:rowModel sectionModel:sectionModel];
                    }
                    
                    break;
                    //////////////////////////////////////////////////
                    
//                    [tableView cellForRowAtIndexPath:currentIndexPath].accessoryType = UITableViewCellAccessoryCheckmark;
                }
//                else
//                {
//                    if(rowModel.object!=nil)
//                    {
//                        rowModel.object = nil;
//                    }
//
//                    //////////////////////////////////////////////////
//
//                    [tableView cellForRowAtIndexPath:currentIndexPath].accessoryType = UITableViewCellAccessoryNone;
//                }
            }
        }
        
    }while(0);
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if(ppButton.tag==0)
    {
        //////////////////////////////////////////////////
        if (self.completeHandler)
        {
            NSError *error = nil;
            error = PPErrorMake(WCTExportSettingsViewControllerErrorCode_UserBack, @"user click back", nil);
            
            self.completeHandler (self, 0, nil, error);
        }
        
        dispatch_async(dispatch_get_main_queue(), ^{

            //////////////////////////////////////////////////
            [self goBackAnimated:YES];
        });
    }
    else
    {
        __block typeof(self) blockSelf = self;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            BOOL canSetting = NO;
            NSError *error = nil;
            // MARK: set CRM setting
            do {
                WCTRCCRMSystemResponseResult *responseResult =  [[WCTRestClientController shareRestClientController] CRMSystemWithError:&error];
                
                // 如果是not found不算錯誤
                NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
                if(statusCode==WCTServer_Common_ErrorCode_DataNotFound)
                {
                    error = nil;
                }
                
                // !! 檢查有沒有設定CRM系統，如果沒有，跳出alert
                if ([responseResult.data.supportCRM length]==0)
                {
                    error = PPErrorMake(WCTExportSettingsViewControllerErrorCode_DisabledByManager, WCTServerContactExportFlowControllerString_ErrorDisabledByManager, error);
                    break;
                }
                
                // 檢查是否已登入, 已登入就不再顯示登入
                WCTRCCRMSettingsResponseResult *crmSettingsResponseResult = [[WCTRestClientController shareRestClientController] CRMSettingsWithError:&error];
                
                if(crmSettingsResponseResult==nil)
                {
                    error = PPErrorMake(WCTExportSettingsViewControllerErrorCode_MustLoginBeforeUse, WCTServerContactExportFlowControllerString_ErrorMustLoginBeforeUse, error);
                    break;
                }
                
                canSetting = YES;
                
            } while (0);
            
            
            if (error==nil && canSetting)
            {
                NSString *serverDefinedCRMExportMode = [WCTExportSettingsViewController serverDefinedStringFromWCTExportMode:self.currentSelectedExportMode];
                NSString *companyAssignMode = [WCTExportSettingsViewController serverDefinedStringFromWCTWCTCompnayAssignmentMode:self.currentCompanyAssignMode];
                
                [[WCTRestClientController shareRestClientController] setCRMExportModeWithCRMType:WCTRC_CRMType_Salesforce
                                                                                   CTMExportMode:serverDefinedCRMExportMode
                                                                      CRMCompanyAssignmentOption:companyAssignMode
                                                                                           error:&error];
                
                if (error==nil)
                {
                    [PPSettingsController setStringValue:serverDefinedCRMExportMode withKey:WCTSettingsKey_CRMExportMode];
                    [PPSettingsController setStringValue:companyAssignMode withKey:WCTSettingsKey_CRMCompanyAssignmentOption];
                }
            }
            
            //////////////////////////////////////////////////

            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                //////////////////////////////////////////////////
                [self goBackAnimated:YES];
            });
        });

    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
- (void)showFromViewController:(UIViewController *)viewController completeHandler:(ExportSelectItemCompletion)completeHandler
{
    self.completeHandler = completeHandler;

    if(viewController.navigationController)
    {
        [viewController.navigationController pushViewController:self animated:YES];
    }
    else
    {
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:self];
        [viewController presentViewController:navigationController animated:YES completion:nil];
        [navigationController release];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (NSString *)serverDefinedStringFromWCTExportMode:(WCTExportMode)exportMode
{
    switch (exportMode)
    {
        case WCTExportMode_Auto:
        {
            return WCTRC_ExportMode_Auto;
        }
        case WCTExportMode_ContactSyncAuto:
        {
            return WCTRC_ExportMode_ContactSyncAuto;
        }
        case WCTExportMode_Manual:
        {
            return WCTRC_ExportMode_Manual;
        }
        default:
            return nil;
    }
}



//==============================================================================
//
//==============================================================================
+ (WCTExportMode)exportModeFromServerDefinedExportMode:(NSString *)exportMode
{
    if ([exportMode isEqualToString:WCTRC_ExportMode_Manual])
    {
        return WCTExportMode_Manual;
    }
    else if([exportMode isEqualToString:WCTRC_ExportMode_ContactSyncAuto])
    {
        return WCTExportMode_ContactSyncAuto;
    }
    else if([exportMode isEqualToString:WCTRC_ExportMode_Auto])
    {
        return WCTExportMode_Auto;
    }

    
    return WCTExportMode_Manual;
}


//==============================================================================
//
//==============================================================================
+ (NSString *)serverDefinedStringFromWCTWCTCompnayAssignmentMode:(WCTCompnayAssignmentMode)assignMode
{
    switch (assignMode)
    {
        case WCTCompnayAssignmentMode_Manual:
        {
            return WCTRC_CRMCompanyAssignmentOption_Manual;
        }
        case WCTCompnayAssignmentMode_Auto:
        {
            return WCTRC_CRMCompanyAssignmentOption_Auto;
        }
        default:
            return WCTRC_CRMCompanyAssignmentOption_None;
    }
}


//==============================================================================
//
//==============================================================================
+ (WCTCompnayAssignmentMode)companyAssignModeFromServerDefinedCompanyAssignMode:(NSString *)companyAssignMode
{
    if ([companyAssignMode isEqualToString:WCTRC_CRMCompanyAssignmentOption_Manual])
    {
        return WCTCompnayAssignmentMode_Manual;
    }
    else if([companyAssignMode isEqualToString:WCTRC_CRMCompanyAssignmentOption_Auto])
    {
        return WCTCompnayAssignmentMode_Auto;
    }
    
    
    return WCTCompnayAssignmentMode_None;
}

@end
