//
//  WCTExchangeLoginViewController.m
//  WorldCardTeam
//
//  Created by sanhue on 2019/11/29.
//  Copyright © 2019 penpower. All rights reserved.
//

#import "WCTExchangeLoginViewController.h"

//define
#import "WCAppearanceDefine.h"
#import "WCTServerContactExportFlowController+ResourceDefine.h"

//view
#import "PPTableView.h"
#import "WCTExchangeTextFieldButtonTableViewCell.h"
#import "NSString+Additions.h"
#import "UIView+Appearance.h"
#import "NSError+Custom.h"


// controller
#import "PPSectionController.h"
#import "WCToastController.h"
#import "WCTRestClientController.h"
#import "WCTServerContactExportHelper.h"

//////////////////////////////////////////////////
#define WCTSCEFC @"WCTServerContactExportFlowController"

// exchange login
#define WCTELV_MLS_Password [@"MLS_Password" localizedFromTable:WCTSCEFC]
#define WCTELV_MLS_User [@"MLS_User" localizedFromTable:WCTSCEFC]
#define WCTELV_MLS_Login [@"MLS_Login" localizedFromTable:WCTSCEFC]


#define WCTELVC_TextFieldBorderColor [UIColor colorWithHexString:@"#9cbff3"]

#define WCTELVC_LoginButton_NormalBackgroundColor [UIColor colorWithHexString:@"#3fa1e8"]
#define WCTELVC_LoginButton_HighlightedBackgroundColor [UIColor colorWithHexString:@"#2094e8"]
#define WCTELVC_LoginButton_NormalTextColor [UIColor colorWithHexString:@"#ffffff"]
#define WCTELVC_LoginButton_HighlightedTextColor [UIColor colorWithHexString:@"#dcefff"]

////////////////////////////////////////////////////////////////////////////////////////////////////

static CGFloat const WCTELVC_LoginButtonFontSize = 16;

static NSString * const WCTELVC_ImageNameButtonShowPassword  = @"WCTELVC_ButtonShowPassword";
static NSString * const WCTELVC_ImageNameButtonHidePassword  = @"WCTELVC_ButtonHidePassword";

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCTELVC_CellID)
{
    WCTELVC_CellID_Account = 100,
    WCTELVC_CellID_Password,
};

typedef NS_ENUM(NSInteger, WCTELVC_ButtonTag)
{
    WCTELVC_ButtonTag_Back = 0,
    WCTELVC_ButtonTag_HiddenPassword,
    WCTELVC_ButtonTag_ShowPassword,
    WCTELVC_ButtonTag_Login,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTExchangeLoginViewController ()
<
CustomRectTextFieldDataSource,
PPButtonDelegate,
PPTextFieldButtonViewDelegate,
UITableViewDataSource,
UITableViewDelegate
>

@property(nonatomic, retain) NSArray *layoutConstraints;
@property(nonatomic, retain) NSArray *footerViewlayoutConstraints;

@property(nonatomic, retain) PPSectionController *ppSectionController;

@property(nonatomic, retain, readwrite) PPNavigationBarView *ppNavigationBarView;
@property(nonatomic, retain, readwrite) PPButton *ppButtonBack;

@property(nonatomic, retain) PPTableView *ppTableView;

@property(nonatomic, retain) UIView *tableFooterView;
@property(nonatomic, retain) PPButton *ppButtonLogin;

@property(nonatomic, assign) BOOL secureTextEntry;
@end

@implementation WCTExchangeLoginViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.secureTextEntry = YES;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.loginComplete = nil;
    self.ppSectionController = nil;
    
    
    [self removeMainUI];
    [self removeLayoutConstraints];
    
    //////////////////////////////////////////////////
    [super dealloc];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidLoad
{
    [super viewDidLoad];
    //////////////////////////////////////////////////
    // Do any additional setup after loading the view.
    [self prepareData];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    [self prepareMainUI];

    [self.view setNeedsUpdateConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)updateViewConstraints
{
    [super updateViewConstraints];
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    if(self.ppButtonBack==nil)
    {
        self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                            tag:WCTELVC_ButtonTag_Back
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    
    if (self.ppNavigationBarView==nil)
    {
        self.ppNavigationBarView = [[[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
    }
    
    [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
    
    //////////////////////////////////////////////////
    if (self.ppButtonBack)
    {
        PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
        itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        
        [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
    }
    
    //////////////////////////////////////////////////
    if (self.navigationController!=nil)
    {
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
    }
    
    //////////////////////////////////////////////////
    if(self.ppTableView==nil)
    {
        self.ppTableView = [[[PPTableView alloc] initWithFrame:CGRectZero] autorelease];
    }
    
    if(self.ppTableView)
    {
        [self.ppTableView setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.ppTableView setDelegate:self];
        [self.ppTableView setDataSource:self];
        [self.ppTableView setSeparatorStyle:UITableViewCellSeparatorStyleNone];
        [self.ppTableView setAllowsSelection:NO];
        
        [self.ppTableView registerClass:[WCTExchangeTextFieldButtonTableViewCell class]
                 forCellReuseIdentifier:NSStringFromClass([WCTExchangeTextFieldButtonTableViewCell class])];
        
        self.ppTableView.tableHeaderView = [[[UIView alloc] initWithFrame:CGRectZero] autorelease];
        self.tableFooterView = [[[UIView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, UIButtonAdditions_DefaultMinHeight*2)] autorelease];
        
        if(self.tableFooterView!=nil)
        {
//            [self.tableFooterView setTranslatesAutoresizingMaskIntoConstraints:NO];
            
            self.ppButtonLogin = [[[PPButton alloc] initWithFrame:UIButtonAdditions_LargeRect] autorelease];
            
            if(self.ppButtonLogin!=nil)
            {
                [self.ppButtonLogin setTranslatesAutoresizingMaskIntoConstraints:NO];
                self.ppButtonLogin.delegate = self;
                self.ppButtonLogin.tag      = WCTELVC_ButtonTag_Login;
                
                [self.ppButtonLogin addControlEvents:UIControlEventTouchUpInside];
                [self.ppButtonLogin setTitle:WCTELV_MLS_Login maxWidth:UIButtonAdditions_DefaultMaxWidth];
                
                //////////////////////////////////////////////////
                
                [self.ppButtonLogin setBackgroundImage:[UIImage imageWithColor:WCTELVC_LoginButton_NormalBackgroundColor]
                                              forState:UIControlStateNormal];
                
                [self.ppButtonLogin setBackgroundImage:[UIImage imageWithColor:WCTELVC_LoginButton_HighlightedBackgroundColor]
                                              forState:UIControlStateHighlighted];
                
                [self.ppButtonLogin setTitleColor:WCTELVC_LoginButton_NormalTextColor forState:UIControlStateNormal];
                [self.ppButtonLogin setTitleColor:WCTELVC_LoginButton_HighlightedTextColor forState:UIControlStateHighlighted];
                
                self.ppButtonLogin.titleLabel.font = [UIFont systemFontOfSize:WCTELVC_LoginButtonFontSize];
                
                //////////////////////////////////////////////////
                
                [self.tableFooterView addSubview:self.ppButtonLogin];
            }
            
            //////////////////////////////////////////////////
            
            self.ppTableView.tableFooterView  = self.tableFooterView;
        }
        
        [self.view addSubview:self.ppTableView];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self.ppButtonLogin removeFromSuperview];
    self.ppButtonLogin = nil;
    
    self.tableFooterView = nil;
    
    [self.ppTableView removeFromSuperview];
    self.ppTableView = nil;
    
    self.navigationItem.leftBarButtonItem = nil;
    self.ppNavigationBarView = nil;
    self.ppButtonBack = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.ppTableView==nil)
    {
        return;
    }
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"topLayoutGuide":self.topLayoutGuide,
                            @"ppTableView":self.ppTableView};
    NSDictionary *metrics = nil;//@{@"<#viewName#>":<#viewInstance#>};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[ppTableView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[topLayoutGuide][ppTableView]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
    }
    
    //////////////////////////////////////////////////
    [self resetFooterViewLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
    
    //////////////////////////////////////////////////
    [self removeFooterViewLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)resetFooterViewLayoutConstraints
{
    if(self.ppButtonLogin==nil)
    {
        return;
    }
    
    [self removeFooterViewLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"ppButtonLogin":self.ppButtonLogin};
    NSDictionary *metrics = nil;//@{@"<#viewName#>":<#viewInstance#>};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|-[ppButtonLogin]-|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|-[ppButtonLogin]-|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.footerViewlayoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.tableFooterView addConstraints:self.footerViewlayoutConstraints];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeFooterViewLayoutConstraints
{
    if (self.footerViewlayoutConstraints)
    {
        [self.tableFooterView removeConstraints:self.footerViewlayoutConstraints];
        self.footerViewlayoutConstraints = nil;
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PrepareData


//==============================================================================
//
//==============================================================================
- (void)prepareData
{
    if(self.ppSectionController==nil)
    {
        self.ppSectionController = [[[PPSectionController alloc] init] autorelease];
    }

    NSMutableArray *rowModels = [NSMutableArray array];
    PPRowModel *rowModel = nil;
    
    rowModel = [PPRowModel rowModelWithRow:WCTELVC_CellID_Account
                                      text:WCTELV_MLS_User
                                detailText:@""
                                    object:nil];
    [rowModels addObject:rowModel];

    rowModel = [PPRowModel rowModelWithRow:WCTELVC_CellID_Password
                                      text:WCTELV_MLS_Password
                                detailText:@""
                                    object:nil];
    [rowModels addObject:rowModel];

    //////////////////////////////////////////////////

    NSMutableArray *sectionModels = [NSMutableArray array];
    
    PPSectionModel *sectionModel = [PPSectionModel sectionModelWithSection:0
                                                                     title:@""
                                                                 rowModels:rowModels];
    
    [sectionModels addObject:sectionModel];
    
    //////////////////////////////////////////////////
    [self.ppSectionController replaceSectionModels:sectionModels forSearching:NO];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private


//==============================================================================
//
//==============================================================================
- (void)sendExchangeSettings
{
    PPRowModel *accountRodModel = [self.ppSectionController rowModelAtIndex:0 forSearching:NO];
    PPRowModel *passwordRodModel = [self.ppSectionController rowModelAtIndex:1 forSearching:NO];
    
    NSString *account = accountRodModel.object;
    NSString *password = passwordRodModel.object;
    
    if([account length]==0 ||[password length]==0)
    {
        // !!
        [WCToastController showMessageToastFromSuperView:self.view withMessage:WCTServerContactExportFlowControllerString_MLS_ErrorExchangeLoginFailed position:PPToastPositionCenter];
        return;
    }
    
    //////////////////////////////////////////////////
    [account retain];
    [password retain];
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        __block NSError *returnError = nil;
        WCTRCExchangeServerSettings *exchangeSettings = [[WCTRCExchangeServerSettings alloc] init];
        exchangeSettings.account = account;
        exchangeSettings.password = password;
        exchangeSettings.supportContactServer = WCTRC_ExportType_Exchange;
        exchangeSettings.contactServerExportMode = WCTRC_ExportMode_Manual;
        [account release];
        [password release];
        
        [[WCTRestClientController shareRestClientController] setExchangeServerSettingsWithSettings:exchangeSettings error:&returnError];
        [exchangeSettings release];
        
        [returnError retain];
        

        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            // !! 錯誤處理，一般錯誤顯示toast不用退出，415要退出
            BOOL shouldRetuen = NO;
            if (returnError)
            {
                NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:returnError];
                [returnError release];


                if(statusCode==WCTServer_ExchangeServer_ErrorCode_ServerTypeNotMatch)
                {
                    returnError = [PPErrorMake(WCTServerLoginErrorCode_UpdateTokenFailed, [WCTServerContactExportHelper setExportModeFailedMessageWithTarget:WCTServerExportTarget_Exchange_MS], nil) retain];
                    shouldRetuen = YES;
                }
                else if(statusCode==WCTServer_ExchangeServer_ErrorCode_DisabledByManager)
                {
                    returnError = [PPErrorMake(WCTServerLoginErrorCode_DisabledByManager, [WCTServerContactExportHelper disabledByManagerMessage], nil) retain];
                    shouldRetuen = YES;
                }
                else if(statusCode==WCTServer_ExchangeServer_ErrorCode_LoginFailed)
                {
                    NSString *message = WCTServerContactExportFlowControllerString_MLS_ErrorExchangeLoginFailed;
                    returnError = [PPErrorMake(WCTServerLoginErrorCode_MSExchangeServerLoginFailed, message, nil) retain];
                    [WCToastController showMessageToastFromSuperView:self.view
                                                         withMessage:[returnError alertMessage]
                                                            position:PPToastPositionCenter];
                }
                else
                {
                    NSString *message = [[WCTServerContactExportHelper setExportModeFailedMessageWithTarget:WCTServerExportTarget_Exchange_MS] stringByAppendingFormat:@"(%@)", @(statusCode)];
                    returnError = [PPErrorMake(WCTServerLoginErrorCode_UpdateTokenFailed, message, nil) retain];
                    [WCToastController showMessageToastFromSuperView:self.view
                                                         withMessage:[returnError alertMessage]
                                                            position:PPToastPositionCenter];
                }
            }
            else
            {
                shouldRetuen = YES;
            }
            
            if(shouldRetuen)
            {
                [blockSelf goBackAnimated:YES];
                
                if(blockSelf.loginComplete)
                {
                    blockSelf.loginComplete(account,returnError);
                }
            }
            [returnError release];
        });
    });

    

}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTELVC_ButtonTag_HiddenPassword:
        {
            // MARK: 隱藏密碼
            self.secureTextEntry = !self.secureTextEntry;
            
            [self.ppTableView reloadRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:1 inSection:0]]
                                    withRowAnimation:UITableViewRowAnimationNone];
            
            break;
        }
        case WCTELVC_ButtonTag_ShowPassword:
        {
            // MARK: 顯示密碼
            self.secureTextEntry = !self.secureTextEntry;
            
            [self.ppTableView reloadRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:1 inSection:0]]
                                    withRowAnimation:UITableViewRowAnimationNone];
            
            break;
        }
        case WCTELVC_ButtonTag_Login:
        {
            // MARK:!! 傳送給server
            [self sendExchangeSettings];
            break;;
        }
        default:
        {
            [self goBackAnimated:YES];
            break;
        }
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITextFieldDelegate


//================================================================================
//
//================================================================================
- (void)ppTextFieldButtonViewDidChanged:(PPTextFieldButtonView *)textFieldButtonView
{
    do
    {
        NSIndexPath *indexPath = nil;
        
        for(UITableViewCell *tableViewCell in [self.ppTableView visibleCells])
        {
            if(tableViewCell.contentView==textFieldButtonView.superview)
            {
                indexPath = [self.ppTableView indexPathForCell:tableViewCell];
                break;
            }
        }
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rowModel.object = textFieldButtonView.textField.text;
    }while(0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDataSource


//==============================================================================
//
//==============================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.ppSectionController numberOfRowsInSection:section forSearching:NO];
}


//==============================================================================
//
//==============================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];

    WCTExchangeTextFieldButtonTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([WCTExchangeTextFieldButtonTableViewCell class])
                                                                                    forIndexPath:indexPath];
    
    cell.tag = rowModel.row;
    
    switch (rowModel.row)
    {
        case WCTELVC_CellID_Account:
        {
            cell.textFieldButtonView.ppButtonDetail.hidden = YES;
            [cell.textFieldButtonView setNeedsLayout];
            break;
        }
        case WCTELVC_CellID_Password:
        {
            cell.textFieldButtonView.ppButtonDetail.delegate = self;
            cell.textFieldButtonView.textField.secureTextEntry = self.secureTextEntry;
            
            if(self.secureTextEntry==YES)
            {
                cell.textFieldButtonView.ppButtonDetail.tag = WCTELVC_ButtonTag_HiddenPassword;
                [cell.textFieldButtonView.ppButtonDetail setImageWithName:WCTELVC_ImageNameButtonShowPassword];
            }
            else
            {
                cell.textFieldButtonView.ppButtonDetail.tag = WCTELVC_ButtonTag_ShowPassword;
                [cell.textFieldButtonView.ppButtonDetail setImageWithName:WCTELVC_ImageNameButtonHidePassword];
            }
            break;
        }
        default:
            break;
    }
    //////////////////////////////////////////////////
     
    [cell.textFieldButtonView setBorderColor:WCTELVC_TextFieldBorderColor];
     [cell.textFieldButtonView setBorderWidth:1.0];
     
     cell.textFieldButtonView.delegate = self;
    
     //////////////////////////////////////////////////
    
    cell.textFieldButtonView.textField.placeholder = rowModel.text;
    
    if([rowModel.object isKindOfClass:[NSString class]])
    {
        cell.textFieldButtonView.textField.text = rowModel.object;
    }
    cell.textFieldButtoViewContentInset = UIEdgeInsetsMake(5, 10, 5, 10);
    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate




@end
