//
//  WCTRestClientController+LocalMode.m
//  
//
//  Created by Howard on 2016/4/12.
//
//

#import "WCTRestClientController+LocalMode.h"

// Model
#import "WCTRCContactSimpleInfo.h"

@implementation WCTRestClientController (LocalMode)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)localModel
{
#ifdef DEBUG
    // TODO: 之後可能要加入單機模式
    return self.enableLocalMode;
#else
    return NO;
#endif
    
}

//================================================================================
//
//================================================================================
- (WCTRCContactListPageResponseResult *)localShareContactListUnderAccountWithError:(NSError **)error
{
    WCTRCContactListPageResponseResult *result = nil;
    
    do
    {
        result = [[WCTRCContactListPageResponseResult alloc] init];
        
        if(result==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSMutableArray *data = [NSMutableArray array];
        
        if(data==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        for(NSUInteger index=0; index<=10; index++)
        {
            WCTRCContactSimpleInfo *contactSimpleInfo = [[WCTRCContactSimpleInfo alloc] init];

            if(contactSimpleInfo!=nil)
            {
                contactSimpleInfo.company = [NSString stringWithFormat:@"company %td",index];
                contactSimpleInfo.contactGuid = [NSString stringWithFormat:@"contactGuid %td",index];
                contactSimpleInfo.fullname = [NSString stringWithFormat:@"fullname %td",index];
                contactSimpleInfo.jobTitle = [NSString stringWithFormat:@"jobTitle %td",index];
                
                [data addObject:contactSimpleInfo];
            }
            
            [contactSimpleInfo release];
        }

        //////////////////////////////////////////////////

        result.data = data;

        //////////////////////////////////////////////////

        [NSThread sleepForTimeInterval:2];
    }
    while (0);
 
    return [result autorelease];
}


//================================================================================
//
//================================================================================
- (WCTRCSharedContactStatusResponseResult *)localShareContactStatusWithContactGuids:(NSArray *)contactGuids
                                                                            error:(NSError **)error
{
    WCTRCSharedContactStatusResponseResult *result = nil;
    
    do
    {
        result = [[WCTRCSharedContactStatusResponseResult alloc] init];
        
        if(result==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSMutableArray *data = [NSMutableArray array];
        
        if(data==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(NSString *guid in contactGuids)
        {
            WCTRCGuidWithDataInfo *guidWithDataInfo = [[WCTRCGuidWithDataInfo alloc] init];
            
            if(guidWithDataInfo!=nil)
            {
                guidWithDataInfo.guid = guid;
                guidWithDataInfo.data = [contactGuids indexOfObject:guid]%2;
                
                [data addObject:guidWithDataInfo];
            }
            
            [guidWithDataInfo release];
        }
        
        //////////////////////////////////////////////////
        
        result.data = data;
        
    }
    while (0);
    
    return [result autorelease];
}


//================================================================================
//
//=================================================================================
- (WCTRCPublicContactsDownloadByContactGuidReponseResult *)localPublicContactsDownloadByContactGuids:(NSArray *)contactGuids
                                                                                             error:(NSError **)error
{
    WCTRCPublicContactsDownloadByContactGuidReponseResult *result = [[WCTRCPublicContactsDownloadByContactGuidReponseResult alloc] init];
    
    do
    {
        if([contactGuids count]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if(result!=nil)
        {
            result.data = [contactGuids firstObject];
            result.message = @"dataloadData is ok";
        }
    }
    while (0);

    return [result autorelease];
}


//================================================================================
//
//================================================================================
- (WCTRCSearchPublicContactsByKeywordResponseResult *)localSearchContactsByKeywordWithKeyword:(NSString *)keyword
                                                                                error:(NSError **)error
{
    WCTRCSearchPublicContactsByKeywordResponseResult *result = nil;
    
    do
    {
        result = [[WCTRCSearchPublicContactsByKeywordResponseResult alloc] init];
        
        if(result==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSMutableArray *data = [NSMutableArray array];
        
        if(data==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([[keyword componentsSeparatedByCharactersInSet:[NSCharacterSet decimalDigitCharacterSet]] count]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(NSUInteger index=0; index<=5; index++)
        {
            WCTRCContactSimpleInfo *contactSimpleInfo = [[WCTRCContactSimpleInfo alloc] init];
            
            if(contactSimpleInfo!=nil)
            {
                contactSimpleInfo.company = [NSString stringWithFormat:@"company %td",index];
                contactSimpleInfo.contactGuid = [NSString stringWithFormat:@"contactGuid %td",index];
                contactSimpleInfo.fullname = [NSString stringWithFormat:@"fullname %td",index];
                contactSimpleInfo.jobTitle = [NSString stringWithFormat:@"jobTitle %td",index];
                
                [data addObject:contactSimpleInfo];
            }
            
            [contactSimpleInfo release];
        }
        
        //////////////////////////////////////////////////
        
        result.data = data;
        
    }
    while (0);
    
    return [result autorelease];
}


//================================================================================
//
//================================================================================
- (WCTRCPrivateContactDeleteResponseResult *)localDeletePrivateContactWithContactGuids:(NSArray *)contactGuids
                                                                               error:(NSError **)error
{
    WCTRCPrivateContactDeleteResponseResult *result = [[WCTRCPrivateContactDeleteResponseResult alloc] init];
    
    do
    {
        if([contactGuids count]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [NSThread sleepForTimeInterval:3];
        
        //////////////////////////////////////////////////
        
        if(result!=nil)
        {
            result.data = [contactGuids firstObject];
            result.message = @"deleteData is ok";
        }
    }
    while (0);
    
    return [result autorelease];
}
@end
