//
//  WCTRCTimeIntervalFilter.m
//  
//
//  Created by Howard on 2017/4/14.
//
//

#import "WCTRCTimeIntervalFilter.h"

// Category
#import "NSDate+Format.h"

@implementation WCTRCTimeIntervalFilter

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _timeStart = [[[NSDate dateWithTimeIntervalSince1970:0] stringWithFormat:WCTRC_IntervalFilterDataFormat] retain];
        _timeEnd   = [[[NSDate date] stringWithFormat:WCTRC_IntervalFilterDataFormat] retain];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_timeEnd release];
    _timeEnd = nil;
    
    [_timeStart release];
    _timeStart = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{timeEnd:%@, _timeStart:%@}",
            [super description],
            self.timeEnd,
            self.timeStart];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCTimeIntervalFilter *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.timeEnd = [[self.timeEnd copyWithZone:zone] autorelease];
            object.timeStart = [[self.timeStart copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"timeStart":@"timeStart",
                                                              @"timeEnd":@"timeEnd"}];
        
    }
    
    return responseMapping;
}

@end
