//
//  WCTRCServicePort.m
//  Pods
//
//  Created by sanhue on 2017/6/22.
//
//

#import "WCTRCServicePort.h"

@implementation WCTRCServicePort



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_portName release];
    _portName = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{portName:%@, port:%td}",
            [super description],
            self.portName,
            self.port];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCServicePort *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.portName = [[self.portName copyWithZone:zone] autorelease];
            object.port = self.port;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"openPortName":@"portName",
                                                              @"openPortNum":@"port"}];
        
    }
    
    return responseMapping;
}

@end
