//
//  WCTRCApplyAccountInfo.m
//  WCTRestClientController
//
//  Created by sanhue cheng on 2021/2/1.
//

#import "WCTRCApplyAccountInfo.h"

@implementation WCTRCApplyAccountInfo


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_name release];
    _name = nil;
    
    [_email release];
    _email = nil;
    
    [_password release];
    _password = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{email:%@, name:%@, password:%@}",
            [super description],
            self.email,
            self.name,
            self.password];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCApplyAccountInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.name = [[self.name copyWithZone:zone] autorelease];
            object.email = [[self.email copyWithZone:zone] autorelease];
            object.password = [[self.password copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"name":@"name",
                                                              @"email":@"email",
                                                              @"password":@"password"
        }];
        
    }
    
    return responseMapping;
}

@end
