//
//  WCTRCSyncUpdateInfo.m
//  Pods
//
//  Created by sanhue on 2016/4/9.
//
//

#import "WCTRCSyncUpdateInfo.h"
#import "WCTRCCategoryCompareAction.h"
#import "WCTRCContactCompareAction.h"

@implementation WCTRCSyncUpdateInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_categoryLastRecTimeResult release];
    _categoryLastRecTimeResult = nil;
    
    [_categoryCompareActionList release];
    _categoryCompareActionList = nil;
    
    [_contactLastRecTimeResult release];
    _contactLastRecTimeResult = nil;
    
    [_contactCompareActionList release];
    _contactCompareActionList = nil;
    
    [_firstSyncTimeResult release];
    _firstSyncTimeResult = nil;
    
    [_contactContinueSeekTimeResult release];
    _contactContinueSeekTimeResult = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"categoryLastRecTimeResult:%@, categoryCompareActionList:%@, contactLastRecTimeResult:%@, contactCompareActionList:%@, firstSyncTimeResult:%@, isNeedContactContinueSeek:%@, contactContinueSeekTimeResult:%@ ",
            self.categoryLastRecTimeResult,
            self.categoryCompareActionList,
            self.contactLastRecTimeResult,
            self.contactCompareActionList,
            self.firstSyncTimeResult,
            self.isNeedContactContinueSeek?@"YES":@"NO",
            self.contactContinueSeekTimeResult];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCSyncUpdateInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.categoryLastRecTimeResult = [[self.categoryLastRecTimeResult copyWithZone:zone] autorelease];
            object.categoryCompareActionList = [[self.categoryCompareActionList copyWithZone:zone] autorelease];
            object.contactLastRecTimeResult = [[self.contactLastRecTimeResult copyWithZone:zone] autorelease];
            object.contactCompareActionList = [[self.contactCompareActionList copyWithZone:zone] autorelease];
            object.firstSyncTimeResult = [[self.firstSyncTimeResult copyWithZone:zone] autorelease];
            object.isNeedContactContinueSeek = self.isNeedContactContinueSeek;
            object.contactContinueSeekTimeResult = [[self.contactContinueSeekTimeResult copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"categoryLastRecTimeResult":@"categoryLastRecTimeResult",
                                                              @"contactLastRecTimeResult":@"contactLastRecTimeResult",
                                                              @"firstSyncTimeResult":@"firstSyncTimeResult",
                                                              @"isNeedContactContinueSeek":@"isNeedContactContinueSeek",
                                                              @"contactContinueSeekTimeResult":@"contactContinueSeekTimeResult"}];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"categoryCompareActionList"
                                                                                        toKeyPath:@"categoryCompareActionList"
                                                                                      withMapping:[WCTRCCategoryCompareAction responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"contactCompareActionList"
                                                                                        toKeyPath:@"contactCompareActionList"
                                                                                      withMapping:[WCTRCContactCompareAction responseMapping]]];
        

    }
    
    return responseMapping;
}


@end
