//
//  WCTRCContactCheckRequest.m
//  Pods
//
//  Created by sanhue on 2016/9/7.
//
//

#import "WCTRCSyncContactCheckRequest.h"

@implementation WCTRCSyncContactCheckRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountID release];
    _accountID = nil;
    
    [_actionType release];
    _actionType = nil;
    
    [_contactID release];
    _contactID = nil;
    
    [_modifyTime release];
    _modifyTime = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"accountID:%@, actionType:%@, contactID:%@, modifyTime:%@",
            self.accountID,
            self.actionType,
            self.contactID,
            self.modifyTime];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCSyncContactCheckRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountID = [[self.accountID copyWithZone:zone] autorelease];
            object.actionType = [[self.actionType copyWithZone:zone] autorelease];
            object.contactID = [[self.contactID copyWithZone:zone] autorelease];
            object.modifyTime = [[self.modifyTime copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountID":@"accountID",
                                                              @"actionType":@"actionType",
                                                              @"contactID":@"contactID",
                                                              @"modifyTime":@"modifyTime"}];
    }
    
    return responseMapping;
}

@end
