//
//  WCTRCContactCompareAction.m
//  Pods
//
//  Created by sanhue on 2016/4/9.
//
//

#import "WCTRCContactCompareAction.h"

@implementation WCTRCContactCompareAction

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_contactGuid release];
    _contactGuid = nil;
    
    [_updateAction release];
    _updateAction = nil;
    
    [_lastModifyTime release];
    _lastModifyTime = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{contactGuid:%@, updateAction:%@, lastModifyTime:%@}",
            [super description],
            self.contactGuid,
            self.updateAction,
            self.lastModifyTime];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactCompareAction *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.contactGuid = [[self.contactGuid copyWithZone:zone] autorelease];
            object.updateAction = [[self.updateAction copyWithZone:zone] autorelease];
            object.lastModifyTime = [[self.lastModifyTime copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"contactGuid":@"contactGuid",
                                                              @"updateAction":@"updateAction",
                                                              @"lastModifyTime":@"lastModifyTime"}];
    }
    
    return responseMapping;
}

@end
