//
//  WCTRCCategorySyncInfo.m
//  Pods
//
//  Created by sanhue on 2016/4/11.
//
//

#import "WCTRCCategorySyncInfo.h"

@implementation WCTRCCategorySyncInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_action release];
    _action = nil;
    
    [_categoryGuid release];
    _categoryGuid = nil;
    
    [_lastModifyTime release];
    _lastModifyTime = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{action:%@, categoryGuid:%@, lastModifyTime:%@}",
            [super description],
            self.action,
            self.categoryGuid,
            self.lastModifyTime];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCategorySyncInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.action = [[self.action copyWithZone:zone] autorelease];
            object.categoryGuid = [[self.categoryGuid copyWithZone:zone] autorelease];
            object.lastModifyTime = [[self.lastModifyTime copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"action":@"action",
                                                              @"categoryGuid":@"categoryGuid",
                                                              @"lastModifyTime":@"lastModifyTime"}];
    }
    
    return responseMapping;
}
@end
