//
//  WCTRCAuthorizedInfo.m
//
//
//  Created by Howard on 2016/3/11.
//
//

#import "WCTRCAuthorizedInfo.h"

@implementation WCTRCAuthorizedInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_allSerialNumbers release];
    _allSerialNumbers = nil;
    
    [_companyName release];
    _companyName = nil;
    
    [_email release];
    _email = nil;
    
    [_time release];
    _time = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{allSerialNumbers:%@, companyName:%@, email:%@, maxAccountSize:%td, time:%@}",
            [super description],
            self.allSerialNumbers,
            self.companyName,
            self.email,
            self.maxAccountSize,
            self.time];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAuthorizedInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.allSerialNumbers = [[self.allSerialNumbers copyWithZone:zone] autorelease];
            object.companyName = [[self.companyName copyWithZone:zone] autorelease];
            object.email = [[self.email copyWithZone:zone] autorelease];
            object.maxAccountSize = self.maxAccountSize;
            object.time = [[self.time copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"allSerialNumbers":@"allSerialNumbers",
                                                              @"companyName":@"companyName",
                                                              @"email":@"email",
                                                              @"maxAccountSize":@"maxAccountSize",
                                                              @"time":@"time"}];
        
    }
    
    return responseMapping;
}
@end
