//
//  WCTRCAdcancedSearchTimeCondition.m
//  ADAL
//
//  Created by sanhue on 2018/4/27.
//

#import "WCTRCAdvancedSearchTimeCondition.h"

@implementation WCTRCAdvancedSearchTimeCondition

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_beginTime release];
    _beginTime = nil;
    
    [_endTime release];
    _endTime = nil;
    
    [_field release];
    _field = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{beginTime:%@, endTime:%@, field:%@}",
            [super description],
            self.beginTime,
            self.endTime,
            self.field];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAdvancedSearchTimeCondition *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.beginTime = [[self.beginTime copyWithZone:zone] autorelease];
            object.endTime = [[self.endTime copyWithZone:zone] autorelease];
            object.field = [[self.field copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"beginTime":@"beginTime",
                                                              @"endTime":@"endTime",
                                                              @"field":@"field"
                                                              }];
    }
    
    return responseMapping;
}
@end
