//
//  WCTRCAdvancedSearchCustomFieldTimeInterval.m
//  ADAL
//
//  Created by sanhue on 2018/4/27.
//

#import "WCTRCAdvancedSearchCustomFieldTimeInterval.h"

@implementation WCTRCAdvancedSearchCustomFieldTimeInterval

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_beginTime release];
    _beginTime = nil;
    
    [_endTime release];
    _endTime = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{beginTime:%@, endTime:%@}",
            [super description],
            self.beginTime,
            self.endTime];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAdvancedSearchCustomFieldTimeInterval *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.beginTime = [[self.beginTime copyWithZone:zone] autorelease];
            object.endTime = [[self.endTime copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"beginTime":@"beginTime",
                                                              @"endTime":@"endTime"}];
    }
    
    return responseMapping;
}
@end
