//
//  WCTRCAdvancedSearchCustomFieldCondition.m
//  ADAL
//
//  Created by sanhue on 2018/4/27.
//

#import "WCTRCAdvancedSearchCustomFieldCondition.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTRCAdvancedSearchCustomFieldCondition ()

#pragma mark property
@property (nonatomic, retain, readwrite) NSMutableArray *customFieldSearchInfos;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTRCAdvancedSearchCustomFieldCondition

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    
    if (self) {
        _customFieldSearchInfos = [[NSMutableArray alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_customFieldSearchInfos release];
    _customFieldSearchInfos = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{customFieldSearchInfos:%@}",
            [super description],
            self.customFieldSearchInfos];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAdvancedSearchCustomFieldCondition *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.customFieldSearchInfos = [[self.customFieldSearchInfos copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"customFieldSearchInfos"
                                                                                        toKeyPath:@"customFieldSearchInfos"
                                                                                      withMapping:[WCTRCAdvancedSearchCustomFieldSearchInfo responseMapping]]];
    }
    
    return responseMapping;
}
@end
