//
//  WCTRCAdvancedSearchContactSearchInfo.m
//  ADAL
//
//  Created by sanhue on 2018/4/27.
//

#import "WCTRCAdvancedSearchContactSearchInfo.h"

@implementation WCTRCAdvancedSearchContactSearchInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_field release];
    _field = nil;

    [_keyword release];
    _keyword = nil;

    [_logicWithPreviousAllResults release];
    _logicWithPreviousAllResults = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{field:%@, keyword:%@, logicWithPreviousAllResults:%@}",
            [super description],
            self.field,
            self.keyword,
            self.logicWithPreviousAllResults];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAdvancedSearchContactSearchInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.field = [[self.field copyWithZone:zone] autorelease];
            object.keyword = [[self.keyword copyWithZone:zone] autorelease];
            object.logicWithPreviousAllResults = [[self.logicWithPreviousAllResults copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"field":@"field",
                                                              @"keyword":@"keyword",
                                                              @"logicWithPreviousAllResults":@"logicWithPreviousAllResults",
                                                              }];
    }
    
    return responseMapping;
}
@end
