//
//  WCTRCAdvancedAccountCondition.m
//  ADAL
//
//  Created by sanhue on 2018/4/27.
//

#import "WCTRCAdvancedSearchAccountCondition.h"

@implementation WCTRCAdvancedSearchAccountCondition

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_field release];
    _field = nil;
    
    [_accountGuids release];
    _accountGuids = nil;
 
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{field:%@, accountGuids:%@}",
            [super description],
            self.field,
            self.accountGuids];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAdvancedSearchAccountCondition *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.field = [[self.field copyWithZone:zone] autorelease];
            object.accountGuids = [[self.accountGuids copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"field":@"field",
                                                              @"accountGuids":@"accountGuids"}];
    }
    
    return responseMapping;
}
@end
