//
//  WCTRCGuidWithDataInfo.m
//  
//
//  Created by Howard on 2016/3/25.
//
//

#import "WCTRCGuidWithDataInfo.h"

@implementation WCTRCGuidWithDataInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_guid release];
    _guid = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{data:%@, guid:%@}",
            [super description],
            self.data?@"YES":@"NO",
            self.guid];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCGuidWithDataInfo *object = [WCTRCGuidWithDataInfo copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.data = self.data;
            object.guid = [[self.guid copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"data":@"data",
                                                              @"guid":@"guid"}];
    }
    
    return responseMapping;
}
@end
