//
//  WCTRCAccountBeSharedByOneContactInfo.m
//  mapping for AccountBeSharedByOneContact
//
//  Created by Howard on 2016/5/10.
//
//

#import "WCTRCAccountBeSharedByOneContactInfo.h"

@implementation WCTRCAccountBeSharedByOneContactInfo


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuid release];
    _accountGuid = nil;
    
    [_accountName release];
    _accountName = nil;
    
    [_status release];
    _status = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountGuid:%@, accountName:%@, status:%@, beBoss:%@, beShared:%@, beSubordinate:%@, beOwner:%@, SharedContactCount:%ld}",
            [super description],
            self.accountGuid,
            self.accountName,
            self.status,
            self.beBoss?@"YES":@"NO",
            self.beShared?@"YES":@"NO",
            self.beSubordinate?@"YES":@"NO",
            self.beOwner?@"YES":@"NO",
            (long)self.sharedContactCount];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAccountBeSharedByOneContactInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountName = [[self.accountName copyWithZone:zone] autorelease];
            object.accountGuid = [[self.accountGuid copyWithZone:zone] autorelease];
            object.status = [[self.status copyWithZone:zone] autorelease];
            object.beBoss = self.beBoss;
            object.beShared = self.beShared;
            object.beSubordinate = self.beSubordinate;
            object.beOwner = self.beOwner;
            object.sharedContactCount = self.sharedContactCount;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountName":@"accountName",
                                                              @"accountGuid":@"accountGuid",
                                                              @"status":@"status",
                                                              @"beBoss":@"beBoss",
                                                              @"beShared":@"beShared",
                                                              @"beSubordinate":@"beSubordinate",
                                                              @"beOwner":@"beOwner",
                                                              @"sharedContactCount":@"sharedContactCount"}];
    }
    
    return responseMapping;
}

@end
