//
//  WCTNoticeInfo.m
//  Pods
//
//  Created by sanhue on 2016/9/2.
//
//

#import "WCTRCNoticeInfo.h"
#import "NSString+Additions.h"
#import "WCTRCBackupFailedType.h"

#define WCTRestClientControllerString_SenderSystem [@"MLS_SenderSystem" localizedFromTable:@"WCTRestClientController"]


#define WCTRestClientControllerString_ExchangeType_MS [@"MLS_ExchangeType_MS" localizedFromTable:@"WCTRestClientController"]
#define WCTRestClientControllerString_ExchangeType_Office365 [@"MLS_ExchangeType_Office365" localizedFromTable:@"WCTRestClientController"]
#define WCTRestClientControllerString_ExchangeType_Salesforce [@"MLS_ExchangeType_Salesforce" localizedFromTable:@"WCTRestClientController"]
#define WCTRestClientControllerString_ExchangeType_SugarCRM [@"MLS_ExchangeType_SugarCRM" localizedFromTable:@"WCTRestClientController"]
#define WCTRestClientControllerString_ExchangeType_Qcontactz [@"MLS_ExchangeType_Qcontactz" localizedFromTable:@"WCTRestClientController"]





////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCTRCNoticeInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_guid release];
    _guid = nil;
    
    [_notifyCategory release];
    _notifyCategory = nil;
    
    [_notifyContent release];
    _notifyContent = nil;
    
    [_notifyTime release];
    _notifyTime = nil;
    
    [_notifyType release];
    _notifyType = nil;
    
    [_senderGuid release];
    _senderGuid = nil;
    
    [_senderName release];
    _senderName = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{GUID:%@, notifyCategory:%@, notifyContent:%@, notifyTime:%@, notifyType:%@, senderGuid:%@, senderName:%@, viewed:%@,",
            [super description],
            self.guid,
            self.notifyCategory,
            self.notifyContent,
            self.notifyTime,
            self.notifyType,
            self.senderGuid,
            self.senderName,
            self.viewed?@"YES":@"NO"];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCNoticeInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.viewed = self.viewed;
            
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.notifyCategory = [[self.notifyCategory copyWithZone:zone] autorelease];
            object.notifyContent = [[self.notifyContent copyWithZone:zone] autorelease];
            object.notifyTime = [[self.notifyTime copyWithZone:zone] autorelease];
            object.notifyType = [[self.notifyType copyWithZone:zone] autorelease];
            object.viewed = self.viewed;
            object.senderGuid = [[self.senderGuid copyWithZone:zone] autorelease];
            object.senderName = [[self.senderName copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"guid" : @"guid",
                                                              @"notifyCategory" : @"notifyCategory",
                                                              @"notifyContent" : @"notifyContent",
                                                              @"notifyTime" : @"notifyTime",
                                                              @"notifyType" : @"notifyType",
                                                              @"senderGuid" : @"senderGuid",
                                                              @"senderName" : @"senderName",
                                                              @"viewed" : @"viewed"}];
    }
    
    return responseMapping;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - localized string methods


//==============================================================================
//
//==============================================================================
- (NSDictionary *)contentDictionary
{
    NSError *error = nil;
    NSData *jsonData = [self.notifyContent dataUsingEncoding:NSUTF8StringEncoding];
    return [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingAllowFragments error:&error];
}


//==============================================================================
//
//==============================================================================
- (NSString *)localizedExchangeType:(NSString *)exchangeType
{
    if ([exchangeType isEqualToString:WCTRC_ExportType_Salesforce])
    {
        return WCTRestClientControllerString_ExchangeType_Salesforce;
    }
    else if ([exchangeType isEqualToString:WCTRC_ExportType_SugarCRM])
    {
        return WCTRestClientControllerString_ExchangeType_SugarCRM;
    }
    else if ([exchangeType isEqualToString:WCTRC_ExportType_Exchange])
    {
        return WCTRestClientControllerString_ExchangeType_MS;
    }
    else if ([exchangeType isEqualToString:WCTRC_ExportType_Office365])
    {
        return WCTRestClientControllerString_ExchangeType_Office365;
    }
    else if ([exchangeType isEqualToString:WCTRC_ExportType_Qcontactz])
    {
        return WCTRestClientControllerString_ExchangeType_Qcontactz;
    }
    else
    {
        return @"";
    }
}


//==============================================================================
//
//==============================================================================
- (NSString *)localizedSenderName
{
    if ([self.senderGuid length]==0)
    {
        return WCTRestClientControllerString_SenderSystem;
    }
    else
    {
        return self.senderName;
    }
}


//==============================================================================
/// 回傳多語系的通知title
//==============================================================================
- (NSString *)localizedNoticeTitle
{     
    if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountBossChanged])
    {
        return [@"MLS_NoticeTitle_AccountBossChanged" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountAbilityChanged])
    {
        return [@"MLS_NoticeTitle_AccountAbilityChanged" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountExportAbilityChanged])
    {
        return [@"MLS_NoticeTitle_AccountAbilityChanged" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountPrintAbilityChanged])
    {
        return [@"MLS_NoticeTitle_AccountAbilityChanged" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountSecretaryAbilityChanged])
    {
        return [@"MLS_NoticeTitle_AccountAbilityChanged" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountSetInheritor])
    {
        return [@"MLS_NoticeTitle_AccountSetInheritor" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountSetToResigned])
    {
        return [@"MLS_NoticeTitle_AccountSetToResigned" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountSubordinateChanged])
    {
        return [@"MLS_NoticeTitle_AccountSubordinateChanged" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountUserRoleChange])
    {
        return [@"MLS_NoticeTitle_AccountUserRoleChange" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactBeShared])
    {
        return [@"MLS_NoticeTitle_ContactBeShared" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactCreateFromSomeone])
    {
        return [@"MLS_NoticeTitle_ContactSharedFromSomeone" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactExportCanceled])
    {
        return [@"MLS_NoticeTitle_ContactExportFailed" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactExported])
    {
        return [@"MLS_NoticeTitle_ContactExported" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithCRM])
    {
        return [@"MLS_NoticeTitle_ContactSyncWithExport" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncDone])
    {
        return [@"MLS_NoticeTitle_ContactSyncDone" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_FileSystemReadOnly])
    {
        return [@"MLS_NoticeTitle_FileSystemReadOnly" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_GlobalShareRuleChange])
    {
        return [@"MLS_NoticeTitle_GlobalShareRuleChange" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_LowStorageSpace])
    {
        return [@"MLS_NoticeTitle_LowStorageSpace" localizedFromTable:@"WCTRestClientController"];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_NewAccountCreated])
    {
        return [@"MLS_NoticeTitle_NewAccountCreated" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_CRMSettingsChanged])
    {
        return [@"MLS_NoticeTitle_CRMSettingsOpen" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_CRMSettingsRemoved])
    {
        return [@"MLS_NoticeTitle_CRMSettingsClose" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_GetCRMTokenFailed])
    {
        return [@"MLS_NoticeTitle_CRMRefreshTokenFail" localizedFromTable:@"WCTRestClientController"];
    }    
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SystemMaintenance])
    {
        return [@"MLS_NoticeTitle_SystemMaintenance" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_LoginWithUnbindingDevice])
    {
        return [@"MLS_NoticeTitle_LoginWithUnbindingDevice" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_BackupFailed])
    {
        return [@"MLS_NoticeTitle_BackupFailed" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SearchEngineDiskInfo])
    {
        return [@"MLS_NoticeTitle_SearchEngineDiskInfo" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SubscriptionDuplicateService])
    {
        return [@"MLS_NoticeTitle_SubscriptionDuplicateService" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SubscriptionLostCheck])
    {
        return [@"MLS_NoticeTitle_SubscriptionLostCheck" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_AccountTemplateInvalidate])
    {
        return [@"MLS_NoticeTitle_AccountTemplateInvalidate" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_AccountLockedByUnactive])
    {
        return [@"MLS_NoticeTitle_AccountLockedByUnactive" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_AccountLockedByLoginFailed])
    {
        return [@"MLS_NoticeTitle_AccountLockedByLoginFailure" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_ExchangeServerSettingsChanged])
    {
        return [@"MLS_NoticeTitle_ExchangeServerOpen" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_ExchangeServerSettingsRemoved])
    {
        return [@"MLS_NoticeTitle_ExchangeServerClose" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_ExportedToExchangeServer] ||
            [self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithExchangeServer]||
            [self.notifyType isEqualToString:WCTRC_NoticeType_GoogleContactOverflow])
    {
        return [@"MLS_NoticeTitle_ExportedToExchangeServer" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_GoogleTokenFailed])
    {
        return [@"MLS_NoticeTitle_ExchangeLoginFailed" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_LDAPSyncFailed])
    {
        return [@"MLS_NoticeTitle_SyncADAccountFailed" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_LDAPSyncAuthFailed])
    {
        return [@"MLS_NoticeTitle_SyncADAccountAuthFailed" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SystemDomainChanged]==YES)
    {
        return [@"MLS_NoticeTitle_SystemChangeMyCard" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SystemDomainRemoved]==YES)
    {
        return [@"MLS_NoticeTitle_SystemCloseMyCard" localizedFromTable:@"WCTRestClientController"];
    }
//    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_SharedAcitvityInfo])
//    {
//        return [@"MLS_NoticeTitle_GlobalShareRuleChange" localizedFromTable:@"WCTRestClientController"];
//    }
//    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_SharedTaskInfo])
//    {
//        return [@"MLS_NoticeTitle_GlobalShareRuleChange" localizedFromTable:@"WCTRestClientController"];
//    }
//    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_TaskAssigned])
//    {
//        return [@"MLS_NoticeTitle_GlobalShareRuleChange" localizedFromTable:@"WCTRestClientController"];
//    }
//    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_TaskFinished])
//    {
//        return [@"MLS_NoticeTitle_GlobalShareRuleChange" localizedFromTable:@"WCTRestClientController"];
//    }


    return self.notifyType;
}



//==============================================================================
/// 回傳多語系的通知內文
//==============================================================================
- (NSString *)localizedNoticeContent
{
    NSDictionary *contentDictionary = [self contentDictionary];
    
#ifdef DEBUG
    NSLog(@"##### JSON Content:%@", contentDictionary);
#endif
    
    if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountBossChanged])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_AccountBossChanged" localizedFromTable:@"WCTRestClientController"];
        
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *contentName = [contentDictionary objectForKey:@"newBossName"];
        
        return [NSString stringWithFormat:contentFormat, adminAccount, contentName];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountAbilityChanged])
    {
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];

        NSMutableString *content = [NSMutableString stringWithFormat:[@"MLS_NoticeContent_AccountAbilityChanged" localizedFromTable:@"WCTRestClientController"], adminAccount];
        
        id exportAbility = [contentDictionary objectForKey:@"exportAbility"];
        
        if([exportAbility isKindOfClass:[NSString class]])
        {
            if ([content length]>0)
            {
                [content appendString:@"\n"];
            }
            
            NSMutableString *abilityString = [NSMutableString stringWithFormat:@"%@: ",
                                              [@"MLS_AccountAbility_Export" localizedFromTable:@"WCTRestClientController"]];
            
            if ([(NSString *)exportAbility boolValue])
            {
                [abilityString appendString:[@"MLS_AccountAbilityChanged_Enable" localizedFromTable:@"WCTRestClientController"]];
                
            }
            else
            {
                [abilityString appendString:[@"MLS_AccountAbilityChanged_Disable" localizedFromTable:@"WCTRestClientController"]];
            }
            
            [content appendString:abilityString];
        }
        else
        {
            // 沒有變動
        }
        
        //////////////////////////////////////////////////
        id secretaryAbility = [contentDictionary objectForKey:@"secretary"];
        
        if([secretaryAbility isKindOfClass:[NSString class]])
        {
            if ([content length]>0)
            {
                [content appendString:@"\n"];
            }
            
            NSMutableString *abilityString = [NSMutableString stringWithFormat:@"%@: ",
                                              [@"MLS_AccountAbility_Secretary" localizedFromTable:@"WCTRestClientController"]];
            
            if ([(NSString *)secretaryAbility boolValue])
            {
                [abilityString appendString:[@"MLS_AccountAbilityChanged_Enable" localizedFromTable:@"WCTRestClientController"]];
                
            }
            else
            {
                [abilityString appendString:[@"MLS_AccountAbilityChanged_Disable" localizedFromTable:@"WCTRestClientController"]];
            }
            
            [content appendString:abilityString];
        }
        else
        {
            // 沒有變動
        }
        
        //////////////////////////////////////////////////
        id printAbility = [contentDictionary objectForKey:@"printAbility"];
        
        if([printAbility isKindOfClass:[NSString class]])
        {
            if ([content length]>0)
            {
                [content appendString:@"\n"];
            }
            
            NSMutableString *abilityString = [NSMutableString stringWithFormat:@"%@: ",
                                              [@"MLS_AccountAbility_Print" localizedFromTable:@"WCTRestClientController"]];
            
            if ([(NSString *)printAbility boolValue])
            {
                [abilityString appendString:[@"MLS_AccountAbilityChanged_Enable" localizedFromTable:@"WCTRestClientController"]];
                
            }
            else
            {
                [abilityString appendString:[@"MLS_AccountAbilityChanged_Disable" localizedFromTable:@"WCTRestClientController"]];
            }
            
            [content appendString:abilityString];
        }
        else
        {
            // 沒有變動
        }


        return [NSString stringWithString:content];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountExportAbilityChanged])
    {
        NSNumber *exportAbility = [contentDictionary objectForKey:@"exportAbility"];
        
        if ([exportAbility boolValue])
        {
            return [@"MLS_NoticeContent_AccountExportAbilityEnabled" localizedFromTable:@"WCTRestClientController"];
        }
        else
        {
            return [@"MLS_NoticeContent_AccountExportAbilityDisabled" localizedFromTable:@"WCTRestClientController"];
        }
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountPrintAbilityChanged])
    {
        NSNumber *exportAbility = [contentDictionary objectForKey:@"printAbility"];
        
        if ([exportAbility boolValue])
        {
            return [@"MLS_NoticeContent_AccountPrintAbilityEnabled" localizedFromTable:@"WCTRestClientController"];
        }
        else
        {
            return [@"MLS_NoticeContent_AccountPrintAbilityDisabled" localizedFromTable:@"WCTRestClientController"];
        }
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountSecretaryAbilityChanged])
    {
        NSNumber *exportAbility = [contentDictionary objectForKey:@"secretaryAbility"];
        
        if ([exportAbility boolValue])
        {
            return [@"MLS_NoticeContent_AccountSecretaryAbilityEnabled" localizedFromTable:@"WCTRestClientController"];
        }
        else
        {
            return [@"MLS_NoticeContent_AccountSecretaryAbilityDisabled" localizedFromTable:@"WCTRestClientController"];
        }
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountSetInheritor])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_AccountSetInheritor" localizedFromTable:@"WCTRestClientController"];
        
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *originalAccount = [contentDictionary objectForKey:@"originalAccountName"];
        NSString *inheritorAccount = [contentDictionary objectForKey:@"inheritorName"];
        
        return [NSString stringWithFormat:contentFormat, adminAccount, inheritorAccount, originalAccount];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountSetToResigned])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_AccountSetToResigned" localizedFromTable:@"WCTRestClientController"];
        
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *resignedAccount = [contentDictionary objectForKey:@"resignedAccountName"];

        return [NSString stringWithFormat:contentFormat, adminAccount, resignedAccount];

    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountSubordinateChanged])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_AccountSubordinateChanged" localizedFromTable:@"WCTRestClientController"];
        
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *contentName = [contentDictionary objectForKey:@"newSubordinateName"];

        return [NSString stringWithFormat:contentFormat, adminAccount, contentName];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_AccountUserRoleChange])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_AccountUserRoleChange" localizedFromTable:@"WCTRestClientController"];
        
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *newUserRole = [contentDictionary objectForKey:@"newUserRole"];
        
        NSString *contentSettingString = nil;
        if ([newUserRole isEqualToString:WCTRC_Role_Admin])
        {
            contentSettingString = [@"MLS_AccountUserRoleChanged_Admin" localizedFromTable:@"WCTRestClientController"];
        }
        else if ([newUserRole isEqualToString:WCTRC_Role_NormalUser])
        {
            contentSettingString = [@"MLS_AccountUserRoleChanged_Normal" localizedFromTable:@"WCTRestClientController"];
        }
        else
        {
            contentSettingString = [@"MLS_AccountUserRoleChanged_ReadOnly" localizedFromTable:@"WCTRestClientController"];
        }
        
        return [NSString stringWithFormat:contentFormat, adminAccount, contentSettingString];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactCreateFromSomeone])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_ContactSharedFromSomeone" localizedFromTable:@"WCTRestClientController"];
        NSArray *list = [contentDictionary objectForKey:@"list"];

        return [NSString stringWithFormat:contentFormat,self.senderName,@([list count])];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactBeShared])
    {
        // 這個是用在Section header
        NSString *contentFormat = [@"MLS_NoticeContent_ContactBeShared" localizedFromTable:@"WCTRestClientController"];
        
        return [NSString stringWithFormat:contentFormat, self.senderName];

    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactExportCanceled])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_ContactExportFailed" localizedFromTable:@"WCTRestClientController"];
        NSArray *list = [contentDictionary objectForKey:@"list"];
        return [NSString stringWithFormat:contentFormat, @([list count])];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactExported])
    {
        return [NSString stringWithFormat:@"%@\n%@",[self CRMExportSuccessString],[self CRMExportFailedString]];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithCRM])
    {
        return [NSString stringWithFormat:@"%@",[self CRMExportFailedString]];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_FileSystemReadOnly])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_FileSystemReadOnly" localizedFromTable:@"WCTRestClientController"];
        
        NSString *totalSpace = [contentDictionary objectForKey:@"totalSpace"];
        NSString *usableSapce = [contentDictionary objectForKey:@"usableSpace"];
        
        return [NSString stringWithFormat:contentFormat, totalSpace, usableSapce];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_GlobalShareRuleChange])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_GlobalShareRuleChange" localizedFromTable:@"WCTRestClientController"];
        
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *contentSetting = [contentDictionary objectForKey:@"newGlobalShareRule"];
        
        NSString *contentSettingString = nil;
        if ([contentSetting isEqualToString:@"ALL"])
        {
            contentSettingString = [@"MLS_GlobalShareRuleChanged_All" localizedFromTable:@"WCTRestClientController"];
        }
        else
        {
            contentSettingString = [@"MLS_GlobalShareRuleChanged_BySetting" localizedFromTable:@"WCTRestClientController"];
        }
        
        return [NSString stringWithFormat:contentFormat, adminAccount, contentSettingString];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_LowStorageSpace])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_LowStorageSpace" localizedFromTable:@"WCTRestClientController"];
        
        NSString *totalSpace = [contentDictionary objectForKey:@"totalSpace"];
        NSString *usableSapce = [contentDictionary objectForKey:@"usableSpace"];
        NSString *usableSpaceLessThanValue = [contentDictionary objectForKey:@"usableSpaceLessThanValue"];
        
        return [NSString stringWithFormat:contentFormat, totalSpace, usableSapce, usableSpaceLessThanValue];
    }
    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_NewAccountCreated])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_NewAccountCreated" localizedFromTable:@"WCTRestClientController"];
        
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *newAccount = [contentDictionary objectForKey:@"newAccountName"];

        return [NSString stringWithFormat:contentFormat, adminAccount, newAccount];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_CRMSettingsChanged])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_CRMSettingsOpen" localizedFromTable:@"WCTRestClientController"];
        
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *exchangeType = [contentDictionary objectForKey:@"newSystemCRM"];
        NSString *localizedExchangeType = [self localizedExchangeType:exchangeType];

        return [NSString stringWithFormat:contentFormat, adminAccount, localizedExchangeType];
        
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_CRMSettingsRemoved])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_CRMSettingsClose" localizedFromTable:@"WCTRestClientController"];
        
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *exchangeType = [contentDictionary objectForKey:@"systemCRMSetting"];
        NSString *localizedExchangeType = [self localizedExchangeType:exchangeType];
        
        return [NSString stringWithFormat:contentFormat, adminAccount, localizedExchangeType];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_GetCRMTokenFailed])
    {
        return [@"MLS_FailureReason_CRMRefreshTokenFail" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SystemMaintenance])
    {
        BOOL readOnlyStatus = [[contentDictionary objectForKey:@"readOnlyStatus"] boolValue];
//        NSString *adminAccount = [contentDictionary objectForKey:@"dateTime"];
        
        if(readOnlyStatus==YES)
        {
            // 維護開始
            return [@"MLS_NoticeContent_SystemMaintenaceStart" localizedFromTable:@"WCTRestClientController"];
        }
        else
        {
            // 維護完成
            return [@"MLS_NoticeContent_SystemMaintenaceFinished" localizedFromTable:@"WCTRestClientController"];
       }
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_LoginWithUnbindingDevice])
    {
        NSString *deviceID = [contentDictionary objectForKey:@"deviceId"];
        NSString *deviceName = [contentDictionary objectForKey:@"deviceName"];
        NSString *loginAccountName = [contentDictionary objectForKey:@"loginAccountName"];
        NSString *contentFormat = [@"MLS_NoticeContent_LoginWithUnbindingDevice" localizedFromTable:@"WCTRestClientController"];
        
        return [NSString stringWithFormat:contentFormat, loginAccountName, deviceName, deviceID];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_BackupFailed])
    {
        NSString *backupFailedType = [contentDictionary objectForKey:@"backupFailedType"];

        if ([backupFailedType isEqualToString:WCTRCBackupFailedType_UnsupportFileSystem])
        {
            return [@"MLS_NoticeContent_BackupFailed_UnsupportFileSystem" localizedFromTable:@"WCTRestClientController"];
        }
        else if ([backupFailedType isEqualToString:WCTRCBackupFailedType_InvalidPath])
        {
            return [@"MLS_NoticeContent_BackupFailed_InvalidPath" localizedFromTable:@"WCTRestClientController"];
        }
        else if ([backupFailedType isEqualToString:WCTRCBackupFailedType_SystemNotSupported])
        {
            return [@"MLS_NoticeContent_BackupFailed_SystemNotSupported" localizedFromTable:@"WCTRestClientController"];
        }
        else if ([backupFailedType isEqualToString:WCTRCBackupFailedType_BackupJobAlreadyRunning])
        {
            return [@"MLS_NoticeContent_BackupFailed_BackupJobAlreadyRunning" localizedFromTable:@"WCTRestClientController"];
        }
        else if ([backupFailedType isEqualToString:WCTRCBackupFailedType_BackupJobScheduleAlreadySetup])
        {
            return [@"MLS_NoticeContent_BackupFailed_BackupJobScheduleAlreadySetup" localizedFromTable:@"WCTRestClientController"];
        }
        else if ([backupFailedType isEqualToString:WCTRCBackupFailedType_BackupStorageNotEnough])
        {
            return [@"MLS_NoticeContent_BackupFailed_BackupStorageNotEnough" localizedFromTable:@"WCTRestClientController"];
        }
        else if ([backupFailedType isEqualToString:WCTRCBackupFailedType_BackupWhileImageDataMigration])
        {
            return [@"MLS_NoticeContent_BackupFailed_WhileImageDataMigration" localizedFromTable:@"WCTRestClientController"];
        }
        else if ([backupFailedType isEqualToString:WCTRCBackupFailedType_UnknownType])
        {
            NSString *noticeContent = [@"MLS_NoticeContent_BackupFailed_UnknownType" localizedFromTable:@"WCTRestClientController"];
            NSString *unknownException = [contentDictionary objectForKey:@"unknowTypeException"];

            // 如果有exception要顯示出來
            if([unknownException length]>0)
            {
                noticeContent = [noticeContent stringByAppendingFormat:@"\n\n(%@)", unknownException];
            }
            return noticeContent;
        }
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SearchEngineDiskInfo])
    {
        NSString *spaceInsufficient = [contentDictionary objectForKey:@"diskSpaceInsufficient"];

        if ([spaceInsufficient boolValue]==YES)
        {
            return [@"MLS_NoticeContent_SearchEngineDiskInfo_NotEnough" localizedFromTable:@"WCTRestClientController"];
        }
        else
        {
            return [@"MLS_NoticeContent_SearchEngineDiskInfo_Enough" localizedFromTable:@"WCTRestClientController"];
        }
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SubscriptionDuplicateService])
    {
        return [@"MLS_NoticeContent_SubscriptionDuplicateService" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SubscriptionLostCheck])
    {
        NSNumber *lostConnectDay = [contentDictionary objectForKey:@"lostConnectDays"];

        NSString *contentFormat = [@"MLS_NoticeContent_SubscriptionLostCheck" localizedFromTable:@"WCTRestClientController"];
        
        return [NSString stringWithFormat:contentFormat, lostConnectDay];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_AccountTemplateInvalidate])
    {
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *templateInvalidateAccount = [contentDictionary objectForKey:@"templateInvalidateAccountName"];
        
        if ([adminAccount length]==0)
        {
            NSString *contentFormat = [@"MLS_NoticeContent_AccountTemplateInvalidateBySystem" localizedFromTable:@"WCTRestClientController"];
            
            return [NSString stringWithFormat:contentFormat, templateInvalidateAccount];
        }
        else
        {
            NSString *contentFormat = [@"MLS_NoticeContent_AccountTemplateInvalidate" localizedFromTable:@"WCTRestClientController"];
            
            return [NSString stringWithFormat:contentFormat, adminAccount, templateInvalidateAccount];
        }
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_AccountLockedByUnactive])
    {
        NSString *lockedAccountName = [contentDictionary objectForKey:@"lockedAccountName"];
        NSNumber *unloginDays = [contentDictionary objectForKey:@"unloginDays"];

        NSString *contentFormat = [@"MLS_NoticeContent_AccountLockedByUnactive" localizedFromTable:@"WCTRestClientController"];
        
        return [NSString stringWithFormat:contentFormat, lockedAccountName, unloginDays];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_AccountLockedByLoginFailed])
    {
        NSString *userEmail = [contentDictionary objectForKey:@"userEmail"];
        NSNumber *failureCount = [contentDictionary objectForKey:@"failurecount"];
        
        NSString *contentFormat = [@"MLS_NoticeContent_AccountLockedByLoginFailure" localizedFromTable:@"WCTRestClientController"];
        
        return [NSString stringWithFormat:contentFormat, userEmail, failureCount];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_ExchangeServerSettingsChanged])
    {
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *exchangeType = [contentDictionary objectForKey:@"newContactServer"];
        NSString *localizedExchangeType = [self localizedExchangeType:exchangeType];

        NSString *contentFormat = [@"MLS_NoticeContent_ExchangeServerOpen" localizedFromTable:@"WCTRestClientController"];
        
        return [NSString stringWithFormat:contentFormat, adminAccount, localizedExchangeType];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_ExchangeServerSettingsRemoved])
    {
        NSString *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
        NSString *exchangeType = [contentDictionary objectForKey:@"contactServerSetting"];
        NSString *localizedExchangeType = [self localizedExchangeType:exchangeType];

        NSString *contentFormat = [@"MLS_NoticeContent_ExchangeServerClose" localizedFromTable:@"WCTRestClientController"];
        
        return [NSString stringWithFormat:contentFormat, adminAccount, localizedExchangeType];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_ExportedToExchangeServer])
    {
        return [NSString stringWithFormat:@"%@\n%@",[self exportSuccessString],[self exportFailedString]];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_GoogleContactOverflow])
    {
        return [@"MLS_NoticeContent_GoogleContactOverflow" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_GoogleTokenFailed])
    {
        return [@"MLS_NoticeContent_GoogleExchangeAccountChanged" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithExchangeServer])
    {
        return [NSString stringWithFormat:@"%@",[self exportFailedString]];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_LDAPSyncFailed])
    {
        NSArray *failedAccount = [contentDictionary objectForKey:@"outofcountAdAccounts"];
        
        NSString *failedAccountString = [failedAccount componentsJoinedByString:@"\n"];
        
        return [NSString stringWithFormat:[@"MLS_NoticeContent_SyncADAccountFailed" localizedFromTable:@"WCTRestClientController"], failedAccountString];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_LDAPSyncAuthFailed])
    {
        return [@"MLS_NoticeContent_SyncADAccountAuthFailed" localizedFromTable:@"WCTRestClientController"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SystemDomainChanged]==YES)
    {
        NSArray *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
     
        return [NSString stringWithFormat: [@"MLS_NoticeContent_SystemChangeMyCard" localizedFromTable:@"WCTRestClientController"],adminAccount];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_SystemDomainRemoved]==YES)
    {
        NSArray *adminAccount = [contentDictionary objectForKey:@"adminAccount"];
     
        return [NSString stringWithFormat: [@"MLS_NoticeContent_SystemCloseMyCard" localizedFromTable:@"WCTRestClientController"],adminAccount];
    }
//    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_SharedAcitvityInfo])
//    {
//
//    }
//    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_SharedTaskInfo])
//    {
//        
//    }
//    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_TaskAssigned])
//    {
//        
//    }
//    else if ([self.notifyType isEqualToString:WCTRC_NoticeType_TaskFinished])
//    {
//        
//    }


    return self.notifyContent;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - export json handler


//==============================================================================
//
//==============================================================================
- (NSString *)exportSuccessString
{
    NSDictionary *contentDictionary = [self contentDictionary];
    
    if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactExported] ||
        [self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithCRM] ||
        [self.notifyType isEqualToString:WCTRC_NoticeType_ExportedToExchangeServer] ||
        [self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithExchangeServer])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_ContactExportedSuccess" localizedFromTable:@"WCTRestClientController"];
        NSNumber *numberOfSuccess = [contentDictionary objectForKey:@"numSucceeded"];
        
        return [NSString stringWithFormat:contentFormat, numberOfSuccess?:@"0"];
    }
    
    return self.notifyContent;
}


//==============================================================================
//
//==============================================================================
- (NSString *)exportFailedString
{
    if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactExported]||
        [self.notifyType isEqualToString:WCTRC_NoticeType_ExportedToExchangeServer])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_ContactExportedFailed" localizedFromTable:@"WCTRestClientController"];
      
        return [NSString stringWithFormat:contentFormat, [self CRMExportFailedNumber]?:@"0"];
    }
    else if([self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithCRM]||
            [self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithExchangeServer])
    {
        NSString *contentFormat = [@"MLS_NoticeContent_ContactSyncFailed" localizedFromTable:@"WCTRestClientController"];
        
        return [NSString stringWithFormat:contentFormat, [self CRMExportFailedNumber]?:@"0"];
    }
    
    return self.notifyContent;
}



//==============================================================================
//
//==============================================================================
- (NSNumber *)exportFailedNumber
{
    NSDictionary *contentDictionary = [self contentDictionary];
    
    if ([self.notifyType isEqualToString:WCTRC_NoticeType_ContactExported] ||
        [self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithCRM] ||
        [self.notifyType isEqualToString:WCTRC_NoticeType_ExportedToExchangeServer] ||
        [self.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithExchangeServer])
    {
        NSArray *failedList =  [contentDictionary objectForKey:@"failedList"];
      
        return @([failedList count]);
    }
    
    return @(0);
}


//==============================================================================
//
//==============================================================================
//- (WCTRCCRMExportResult *)crmExportResult
//{
//    NSError *error = nil;
//    WCTRCCRMExportResult *result = [[WCTRCCRMExportResult alloc] initWithJsonString:self.notifyContent error:&error];
//
//    return  [result autorelease];
//}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - CRM json handler


//==============================================================================
//
//==============================================================================
- (NSString *)CRMExportSuccessString
{
    return [self exportSuccessString];
}


//==============================================================================
//
//==============================================================================
- (NSString *)CRMExportFailedString
{
    return [self exportFailedString];
}



//==============================================================================
//
//==============================================================================
- (NSNumber *)CRMExportFailedNumber
{
    return [self exportFailedNumber];
}


//==============================================================================
//
//==============================================================================
- (WCTRCCRMExportResult *)crmExportResult
{
    NSError *error = nil;
    WCTRCCRMExportResult *result = [[WCTRCCRMExportResult alloc] initWithJsonString:self.notifyContent error:&error];
    
    return  [result autorelease];
}


@end
