//
//  WCTRCCRMExportResult.m
//  
//
//  Created by sanhue on 2016/12/21.
//
//

#import "WCTRCCRMExportResult.h"

@implementation WCTRCCRMExportResult





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_failedList release];
    _failedList = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{numberOfSucceeded:%@, failedList:%@",
            [super description],
            @(self.numberOfSucceeded),
            self.failedList];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCRMExportResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.numberOfSucceeded = self.numberOfSucceeded;
            
            object.failedList = [[self.failedList copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}




//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"numSucceeded" : @"numberOfSucceeded"}];
        
        //////////////////////////////////////////////////
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"failedList"
                                                                                        toKeyPath:@"failedList"
                                                                                      withMapping:[WCTRCCRMFailureReasonInfo responseMapping]]];
        
    }
    
    return responseMapping;
}

@end
