//
//  WCTRCTransferQuotaRequest.m
//  WCTRestClientController
//
//  Created by sanhue cheng on 2021/3/2.
//

#import "WCTRCTransferQuotaRequest.h"

@implementation WCTRCTransferQuotaRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_amount release];
    _amount = nil;
    
    [_targetGuid release];
    _targetGuid = nil;
 
    //////////////////////////////////////////////////
    
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{amount:%@, targetGuid:%@",
            [super description],
            self.amount,
            self.targetGuid];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCTransferQuotaRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.amount = [[self.amount copyWithZone:zone] autorelease];
            object.targetGuid = [[self.targetGuid copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"amount":@"amount",
                                                              @"targetGuid":@"targetGuid"}];
        
    }
    
    return responseMapping;
}
@end
