//
//  WCTRCQContactzEmailInfo.m
//  WCTRestClientController
//
//  Created by Howard on 2020/9/28.
//

#import "WCTRCQContactzEmailInfo.h"

@implementation WCTRCQContactzEmailInfo


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{emergencyLimit:%td, emergencyCount:%td, sendResult:%d",
            [super description],
            self.emergencyLimit,
            self.emergencyCount,
            self.sendResult];

}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCQContactzEmailInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.emergencyLimit = self.emergencyLimit;
            object.emergencyCount = self.emergencyCount;
            object.sendResult = self.sendResult;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{
            @"emergencyLimit":@"emergencyLimit",
            @"emergencyCount":@"emergencyCount",
            @"sendResult":@"sendResult"
        }];
    }
    
    return responseMapping;
}

@end
