//
//  WCTRCPCSSetting.m
//  WCTRestClientController
//
//  Created by sanhue cheng on 2021/3/2.
//

#import "WCTRCPCSSetting.h"

@implementation WCTRCPCSSetting

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_lastPurchaseTime release];
    _lastPurchaseTime = nil;
    
    [_pcsSupportedLangs release];
    _pcsSupportedLangs = nil;
    
    [_quotaRemained release];
    _quotaRemained = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{lastPurchaseTime:%@, pcsSupportedLangs:%@,quotaRemained:%@",
            [super description],
            self.lastPurchaseTime,
            self.pcsSupportedLangs,
            self.quotaRemained];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCPCSSetting *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.lastPurchaseTime = [[self.lastPurchaseTime copyWithZone:zone] autorelease];
            object.pcsSupportedLangs = [[self.pcsSupportedLangs copyWithZone:zone] autorelease];
            object.quotaRemained = [[self.quotaRemained copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"lastPurchaseTime":@"lastPurchaseTime",
                                                              @"pcsSupportedLangs":@"pcsSupportedLangs",
                                                              @"quotaRemained":@"quotaRemained"}];
        
    }
    
    return responseMapping;
}
@end
