//
//  WCTRCExchangeServerTokenSettings.m
//  WCTRestClientController
//
//  Created by sanhue on 2019/12/5.
//

#import "WCTRCExchangeServerTokenSettings.h"

@implementation WCTRCExchangeServerTokenSettings

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_userContactServerAccount release];
    _userContactServerAccount = nil;

    [_contactServerExportMode release];
    _contactServerExportMode = nil;

    [_supportContactServer release];
    _supportContactServer = nil;

    [_authToken release];
    _authToken = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{contactServerExportMode:%@, supportContactServer:%@, userContactServerAccount:%@, authToken:%@}",
            [super description],
            self.contactServerExportMode,
            self.supportContactServer,
            self.userContactServerAccount,
            self.authToken
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCExchangeServerTokenSettings *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.contactServerExportMode = [[self.contactServerExportMode copyWithZone:zone] autorelease];
            object.supportContactServer = [[self.supportContactServer copyWithZone:zone] autorelease];
            object.userContactServerAccount = [[self.userContactServerAccount copyWithZone:zone] autorelease];
            object.authToken = [[self.authToken copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"contactServerExportMode":@"contactServerExportMode",
                                                              @"supportContactServer":@"supportContactServer",
                                                              @"userContactServerAccount":@"userContactServerAccount"}];
                
        //////////////////////////////////////////////////

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"authToken"
                                                                                        toKeyPath:@"authToken"
                                                                                      withMapping:[WCTRCTokenObject responseMapping]]];
    }
    
    return responseMapping;
}
@end
