//
//  WCTRCAccountSharedTargetRequest.m
//  Pods
//
//  Created by sanhue on 2016/5/13.
//
//

#import "WCTRCAccountSharedTargetRequest.h"

@implementation WCTRCAccountSharedTargetRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuid release];
    _accountGuid = nil;
    
    [_shareItem release];
    _shareItem = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@\n{accountGuid:%@, shareItem:%@}",
            [super description],
            self.accountGuid,
            self.shareItem];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAccountSharedTargetRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountGuid = [[self.accountGuid copyWithZone:zone] autorelease];
            object.shareItem = [[self.shareItem copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountGuid":@"accountGuid",
                                                              @"shareItem":@"shareItem"}];
    }
    
    return responseMapping;
}

@end
