//
//  WCTRCLoginCode.m
//
//
//  Created by Howard on 2016/9/1.
//
//

#import "WCTRCLoginCode.h"

@implementation WCTRCLoginCode


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_code release];
    _code = nil;
    
    [_hwid1 release];
    _hwid1 = nil;
    
    [_hwid2 release];
    _hwid2 = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{code:%@, hwid1:%@, hwid2:%@}",
            [super description],
            self.code,
            self.hwid1,
            self.hwid2];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCLoginCode *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.code = [[self.code copyWithZone:zone] autorelease];
            object.hwid1 = [[self.hwid1 copyWithZone:zone] autorelease];
            object.hwid2 = [[self.hwid2 copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"code":@"code",
                                                              @"hwid1":@"hwid1",
                                                              @"hwid2":@"hwid2"}];
    }
    
    return responseMapping;
}


@end
