//
//  WCTRCPrivateContactOperateCategoryResponseResult.m
//  
//
//  Created by Howard on 2016/3/23.
//
//

#import "WCTRCPrivateContactOperateCategoryResponseResult.h"
#import "WCTRCContactGuidWithData.h"

@implementation WCTRCPrivateContactOperateCategoryResponseResult

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_errorData release];
    _errorData = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{errorData:%@}",
            [super description],
            self.errorData];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCPrivateContactOperateCategoryResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.errorData = [[self.errorData copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"errorData":@"errorData",
                                                              @"message":@"message"}];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"data"
                                                                                        toKeyPath:@"data"
                                                                                      withMapping:[WCTRCContactGuidWithData responseMapping]]];
    }
    
    return responseMapping;
}
@end
