//
//  WCTRCContactsRemoveFromCategoryRequest.m
//
//
//  Created by Howard on 2016/3/24.
//
//

#import "WCTRCContactsRemoveFromCategoryRequest.h"

@implementation WCTRCContactsRemoveFromCategoryRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_categoryGuid release];
    _categoryGuid = nil;
    
    [_contactGuids release];
    _contactGuids = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{categoryGuid:%@, contactGuids:%@}",
            [super description],
            self.categoryGuid,
            self.contactGuids];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactsRemoveFromCategoryRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.categoryGuid = [[self.categoryGuid copyWithZone:zone] autorelease];
            object.contactGuids = [[self.contactGuids copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"categoryGuid":@"categoryGuid",
                                                              @"contactGuids":@"contactGuids"}];
    }
    
    return responseMapping;
}
@end
