//
//  WCTRCContactSimpleInfo.m
//  mapping ContactSimpleInfoDto
//
//  Created by Howard on 2016/3/23.
//
//

#import "WCTRCContactSimpleInfo.h"

@implementation WCTRCContactSimpleInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_company release];
    _company = nil;
    
    [_contactGuid release];
    _contactGuid = nil;
    
    [_createdTime release];
    _createdTime = nil;
    
    [_department release];
    _department = nil;
    
    [_fullname release];
    _fullname = nil;
    
    [_jobTitle release];
    _jobTitle = nil;
    
    [_ownerAccountName release];
    _ownerAccountName = nil;
    
    [_ownerAccountGuid release];
    _ownerAccountGuid = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{company:%@, contactGuid:%@, contactImageNum:%td, createdTime:%@, department:%@, fullname:%@, isCorrected:%d, isDownloadedToPrivate:%d, isExportedToSalesforce:%d, isExportedToSugarcrm:%d, jobTitle:%@, ownerAccountGuid:%@, ownerAccountName:%@}",
            [super description],
            self.company,
            self.contactGuid,
            self.contactImageNum,
            self.createdTime,
            self.department,
            self.fullname,
            self.isCorrected,
            self.isDownloadedToPrivate,
            self.isExportedToSalesforce,
            self.isExportedToSugarcrm,
            self.jobTitle,
            self.ownerAccountGuid,
            self.ownerAccountName];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactSimpleInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.company = [[self.company copyWithZone:zone] autorelease];
            object.contactGuid = [[self.contactGuid copyWithZone:zone] autorelease];
            object.contactImageNum = self.contactImageNum;
            object.createdTime = [[self.createdTime copyWithZone:zone] autorelease];
            object.department = [[self.department copyWithZone:zone] autorelease];
            object.fullname = [[self.fullname copyWithZone:zone] autorelease];
            object.isCorrected = self.isCorrected;
            object.isDownloadedToPrivate = self.isDownloadedToPrivate;
            object.isExportedToSalesforce = self.isExportedToSalesforce;
            object.isExportedToSugarcrm = self.isExportedToSugarcrm;
            object.jobTitle = [[self.jobTitle copyWithZone:zone] autorelease];
            object.ownerAccountGuid = [[self.ownerAccountGuid copyWithZone:zone] autorelease];
            object.ownerAccountName = [[self.ownerAccountName copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];

    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"company":@"company",
                                                              @"contactGuid":@"contactGuid",
                                                              @"contactImageNum":@"contactImageNum",
                                                              @"createdTime":@"createdTime",
                                                              @"department":@"department",
                                                              @"fullname":@"fullname",
                                                              @"iscorrected":@"isCorrected",
                                                              @"isdownloadedtoprivate":@"isDownloadedToPrivate",
                                                              @"isexportedtosalesforce":@"isExportedToSalesforce",
                                                              @"isexportedtosugarcrm":@"isExportedToSugarcrm",
                                                              @"jobTitle":@"jobTitle",
                                                              @"ownerAccountGuid":@"ownerAccountGuid",
                                                              @"ownerAccountName":@"ownerAccountName"}];
    }
    
    return responseMapping;
}

@end
