//
//  WCTRCContactNameInfo.m
//  
//
//  Created by Howard on 2016/3/16.
//
//

#import "WCTRCContactNameInfo.h"

@implementation WCTRCContactNameInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.firstName = @"";
        self.firstNamePronunce = @"";
        self.guid = @"";
        self.lastName = @"";
        self.lastNamePronunce = @"";
        self.middleName = @"";
        self.prefix = @"";
        self.suffix = @"";
        self.recognizeSource = @"";
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_firstName release];
    _firstName = nil;
    
    [_firstNamePronunce release];
    _firstNamePronunce = nil;
    
    [_guid release];
    _guid = nil;
    
    [_lastName release];
    _lastName = nil;
    
    [_lastNamePronunce release];
    _lastNamePronunce = nil;
    
    [_middleName release];
    _middleName = nil;
    
    [_prefix release];
    _prefix = nil;
    
    [_suffix release];
    _suffix = nil;
    
    [_recognizeSource release];
    _recognizeSource = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{guid:%@, firstName:%@, firstNamePronunce:%@, lastName:%@, lastNamePronunce:%@, middleName:%@, prefix:%@, suffix:%@, recognizeSource:%@}",
            [super description],
            self.guid,
            self.firstName,
            self.firstNamePronunce,
            self.lastName,
            self.lastNamePronunce,
            self.middleName,
            self.prefix,
            self.suffix,
            self.recognizeSource];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactNameInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.firstName = [[self.firstName copyWithZone:zone] autorelease];
            object.firstNamePronunce = [[self.firstNamePronunce copyWithZone:zone] autorelease];
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.lastName = [[self.lastName copyWithZone:zone] autorelease];
            object.lastNamePronunce = [[self.lastNamePronunce copyWithZone:zone] autorelease];
            object.middleName = [[self.middleName copyWithZone:zone] autorelease];
            object.prefix = [[self.prefix copyWithZone:zone] autorelease];
            object.suffix = [[self.suffix copyWithZone:zone] autorelease];
            object.recognizeSource = [[self.recognizeSource copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"firstName":@"firstName",
                                                              @"firstNamePronunce":@"firstNamePronunce",
                                                              @"guid":@"guid",
                                                              @"lastName":@"lastName",
                                                              @"lastNamePronunce":@"lastNamePronunce",
                                                              @"middleName":@"middleName",
                                                              @"prefix":@"prefix",
                                                              @"suffix":@"suffix",
                                                              @"recognizeSource":@"recognizeSource"}];
    }
    
    return responseMapping;
}
@end
