//
//  WCTRCContactJobInfo.m
//
//
//  Created by Howard on 2016/3/16.
//
//

#import "WCTRCContactJobInfo.h"

@implementation WCTRCContactJobInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.companyName = @"";
        self.companyPronunce = @"";
        self.department = @"";
        self.guid = @"";
        self.jobTitle = @"";
        self.recognizeSource = @"";
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_companyName release];
    _companyName = nil;
    
    [_companyPronunce release];
    _companyPronunce = nil;
    
    [_department release];
    _department = nil;
    
    [_guid release];
    _guid = nil;
   
    [_jobTitle release];
    _jobTitle = nil;
    
    [_recognizeSource release];
    _recognizeSource = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{guid:%@, companyName:%@, companyPronunce:%@, department:%@, jobTitle:%@, recognizeSource:%@}",
            [super description],
            self.guid,
            self.companyName,
            self.companyPronunce,
            self.department,
            self.jobTitle,
            self.recognizeSource];

}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactJobInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.companyName = [[self.companyName copyWithZone:zone] autorelease];
            object.companyPronunce = [[self.companyPronunce copyWithZone:zone] autorelease];
            object.department = [[self.department copyWithZone:zone] autorelease];
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.jobTitle = [[self.jobTitle copyWithZone:zone] autorelease];
            object.recognizeSource = [[self.recognizeSource copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"companyName":@"companyName",
                                                              @"companyPronunce":@"companyPronunce",
                                                              @"department":@"department",
                                                              @"guid":@"guid",
                                                              @"jobTitle":@"jobTitle",
                                                              @"recognizeSource":@"recognizeSource"}];
    }
    
    return responseMapping;
}
@end
