//
//  WCTRCContactImageInfo.m
//  
//
//  Created by Howard on 2016/3/17.
//
//

#import "WCTRCContactImageInfo.h"

@implementation WCTRCContactImageInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.guid = @"";
        self.sha1 = @"";
        self.type = @"";
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_guid release];
    _guid = nil;
    
    [_sha1 release];
    _sha1 = nil;
    
    [_type release];
    _type = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{guid:%@, sha1:%@, type:%@}",
            [super description],
            self.guid,
            self.sha1,
            self.type];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactImageInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.sha1 = [[self.sha1 copyWithZone:zone] autorelease];
            object.type = [[self.type copyWithZone:zone] autorelease];
        }
    }
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"guid":@"guid",
                                                              @"sha1":@"sha1",
                                                              @"type":@"type"}];
    }
    
    return responseMapping;
}
@end
