//
//  WCTRCContactGetByCategoryAndOwnerVoRequest.m
//
//
//  Created by Howard on 2018/2/26.
//

#import "WCTRCContactGetByCategoryAndOwnerVoRequest.h"

@implementation WCTRCContactGetByCategoryAndOwnerVoRequest


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_categoryGuid release];
    _categoryGuid = nil;
    
    [_categoryOwnerAccountGuid release];
    _categoryOwnerAccountGuid = nil;
    
    [_pageInfo release];
    _pageInfo = nil;
    
    [_intervalFilter release];
    _intervalFilter = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{categoryGuid:%@, categoryOwnerAccountGuid:%@, pageInfo:%@, intervalFilter:%@}",
            [super description],
            self.categoryGuid,
            self.categoryOwnerAccountGuid,
            self.pageInfo,
            self.intervalFilter];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactGetByCategoryAndOwnerVoRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.categoryGuid = [[self.categoryGuid copyWithZone:zone] autorelease];
            object.categoryOwnerAccountGuid = [[self.categoryOwnerAccountGuid copyWithZone:zone] autorelease];
            object.pageInfo = [[self.pageInfo copyWithZone:zone] autorelease];
            object.intervalFilter = [[self.intervalFilter copyWithZone:zone] autorelease];
        }
    }
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"categoryGuid":@"categoryGuid",@"categoryOwnerAccountGuid":@"categoryOwnerAccountGuid"}];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"pageInfo"
                                                                                        toKeyPath:@"pageInfo"
                                                                                      withMapping:[WCTRCPageInfo responseMapping]]];
        
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"intervalFilter"
                                                                                        toKeyPath:@"intervalFilter"
                                                                                      withMapping:[WCTRCTimeIntervalFilter responseMapping]]];
    }
    
    return responseMapping;
}

@end
