//
//  WCTRCContactGetByAccountRequest.m
//  
//
//  Created by Howard on 2016/3/24.
//
//

#import "WCTRCContactGetByAccountRequest.h"

@implementation WCTRCContactGetByAccountRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuid release];
    _accountGuid = nil;
    
    [_pageInfo release];
    _pageInfo = nil;
    
    [_intervalFilter release];
    _intervalFilter = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountGuid:%@, pageInfo:%@, intervalFilter:%@}",
            [super description],
            self.accountGuid,
            self.pageInfo,
            self.intervalFilter];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactGetByAccountRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountGuid = [[self.accountGuid copyWithZone:zone] autorelease];
            object.pageInfo = [[self.pageInfo copyWithZone:zone] autorelease];
            object.intervalFilter = [[self.intervalFilter copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountGuid":@"accountGuid"}];
        
        //////////////////////////////////////////////////

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"pageInfo"
                                                                                        toKeyPath:@"pageInfo"
                                                                                      withMapping:[WCTRCPageInfo responseMapping]]];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"intervalFilter"
                                                                                        toKeyPath:@"intervalFilter"
                                                                                      withMapping:[WCTRCTimeIntervalFilter responseMapping]]];
    }
    
    return responseMapping;
}
@end
