//
//  WCTRestClient+Sync.h
//  Pods
//
//  Created by sanhue on 2016/3/29.
//
//

#import "WCTRestClient.h"

#import "WCTRCCategoryInfo.h"
#import "WCTRCContactCreationWithImageRequest.h"
#import "WCTRCContactUpdateInfoRequest.h"
#import "WCTRCSyncInfo.h"
#import "WCTRCContactUpdateCheckRequest.h"
#import "WCTRCSyncContactCheckRequest.h"

#import "WCTRCBooleanResponseResult.h"
#import "WCTRCContactProfileResponseResult.h"
#import "WCTRCDetailCategoryInfoResponseResult.h"
#import "WCTRCDetailContactInfoResponseResult.h"
#import "WCTRCMessageResponseResult.h"
#import "WCTRCStartSyncResponseResult.h"
#import "WCTRCSyncCategoryCreateResponseResult.h"
#import "WCTRCSyncCategoryDeleteResponseResult.h"
#import "WCTRCSyncCategoryUpdateResponseResult.h"
#import "WCTRCSyncContactDeleteResponseResult.h"
#import "WCTRCSyncContactUpdateCheckResponseResult.h"
#import "WCTRCSyncUpdateActionResponseResult.h"
#import "WCTRCSyncNeedForceCompareResponseResult.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTRestClient (Sync)


/**
 *  建立類別
 *
 *  @param loginToken   登入 Token
 *  @param categoryRequest 準備要建立的類別資訊
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncCreateCategoryWithLoginToken:(NSString *)loginToken
                                                  categoryRequest:(WCTRCCategoryInfo *)categoryRequest
                                                       success:(void (^)(WCTRCSyncCategoryCreateResponseResult *syncCategoryCreateResponseResult))success
                                                       failure:(void (^)(NSError *error))failure;


/**
 *  刪除類別
 *
 *  @param loginToken   登入 Token
 *  @param categoryGuid 要刪除的類別GUID
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncDeleteCategoryWithLoginToken:(NSString *)loginToken
                                                  categoryGuid:(NSString *)categoryGuid
                                                       success:(void (^)(WCTRCSyncCategoryDeleteResponseResult *syncCategoryCreateResponseResult))success
                                                       failure:(void (^)(NSError *error))failure;


/**
 *  取得類別
 *
 *  @param loginToken   登入 Token
 *  @param categoryGuid 準備要更新的類別 ID
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncGetCategoryWithLoginToken:(NSString *)loginToken
                                               categoryGuid:(NSString *)categoryGuid
                                                    success:(void (^)(WCTRCDetailCategoryInfoResponseResult *sycCategoryInfoResponseResult))success
                                                    failure:(void (^)(NSError *error))failure;


/**
 *  更新類別
 *
 *  @param loginToken   登入 Token
 *  @param categoryRequest 準備要更新的類別資訊
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncUpdateCategoryWithLoginToken:(NSString *)loginToken
                                               categoryRequest:(WCTRCCategoryInfo *)categoryRequest
                                                       success:(void (^)(WCTRCSyncCategoryUpdateResponseResult *syncCategoryUpdateResponseResult))success
                                                       failure:(void (^)(NSError *error))failure;


/**
 *  建立聯絡人
 *
 *  @param loginToken   登入 Token
 *  @param request 準備要建立的聯絡人資訊
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncCreateContactWithLoginToken:(NSString *)loginToken
                                                      request:(WCTRCContactCreationWithImageRequest *)request
                                                      success:(void (^)(WCTRCContactProfileResponseResult *syncContactResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;
/**
 *  檢查聯絡人是否存在
 *
 *  @param loginToken   登入 Token
 *  @param contactGuid 準備要檢查的聯絡人guid
 *  @param accountGuid 目前執行動作的帳號guid
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncIsExistContactWithLoginToken:(NSString *)loginToken
                                                   contactGuid:(NSString *)contactGuid
                                                   accountGuid:(NSString *)accountGuid
                                                       success:(void (^)(WCTRCBooleanResponseResult *syncIsExistContactResponseReuslt))success
                                                       failure:(void (^)(NSError *error))failure;


/**
 *  刪除聯絡人
 *
 *  @param loginToken   登入 Token
 *  @param contactGuid 準備要刪除的聯絡人guid
 *  @param accountGuid 目前執行動作的帳號guid
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncDeleteContactWithLoginToken:(NSString *)loginToken
                                                  contactGuid:(NSString *)contactGuid
                                                  accountGuid:(NSString *)accountGuid
                                                      success:(void (^)(WCTRCSyncContactDeleteResponseResult *syncContactDeleteResponseReuslt))success
                                                      failure:(void (^)(NSError *error))failure;


/**
 *  取得聯絡人
 *
 *  @param loginToken   登入 Token
 *  @param contactGuid 準備要更新的聯絡人ID
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncGetContactWithLoginToken:(NSString *)loginToken
                                               contactGuid:(NSString *)contactGuid
                                                   success:(void (^)(WCTRCDetailContactInfoResponseResult *sycContactInfoResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  更新聯絡人
 *
 *  @param loginToken   登入 Token
 *  @param request 準備要更新的聯絡人資訊
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncUpdateContactWithLoginToken:(NSString *)loginToken
                                                      request:(WCTRCContactUpdateInfoRequest *)request
                                                      success:(void (^)(WCTRCContactProfileResponseResult *syncUpdateContactResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;



/**
 *  取得需要更新的聯絡人項目
 *
 *  @param loginToken   登入 Token
 *  @param request 準備要更新的聯絡人資訊
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncContactUpdateCheckWithLoginToken:(NSString *)loginToken
                                                           request:(WCTRCContactUpdateCheckRequest *)request
                                                           success:(void (^)(WCTRCSyncContactUpdateCheckResponseResult *syncContactUpdateCheckResult))success
                                                           failure:(void (^)(NSError *error))failure;



/**
 *  取得同步動作
 *
 *  @param loginToken   登入 Token
 *  @param request 準備要更新的聯絡人資訊
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncContactCheckStatusWithLoginToken:(NSString *)loginToken
                                                           request:(WCTRCSyncContactCheckRequest *)request
                                                           success:(void (^)(WCTRCSyncUpdateActionResponseResult *syncContactUpdateCheckResponseResult))success
                                                           failure:(void (^)(NSError *error))failure;


/**
 *  詢問是否需要做重新比對
 *
 *  @param loginToken   登入 Token
 *  @param contactLastRecTime server最後同步名片的修改時間，與startSync中SyncInfo的contactLastRecTime一樣
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)needForceCompareWithLoginToken:(NSString *)loginToken
                                          contactLastRecTime:(NSDate *)contactLastRecTime
                                                     success:(void (^)(WCTRCSyncNeedForceCompareResponseResult *needForceCompareResponseResult))success
                                                     failure:(void (^)(NSError *error))failure;

/**
 *  開始同步流程，會回傳所要處理的同步動作
 *
 *  @param loginToken   登入 Token
 *  @param syncInfo local端的同步資訊
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncStartWithLoginToken:(NSString *)loginToken
                                             syncInfo:(WCTRCSyncInfo *)syncInfo
                                              success:(void (^)(WCTRCStartSyncResponseResult *startSyncResponseResult))success
                                              failure:(void (^)(NSError *error))failure;


/**
 *  通知server同步流程結束
 *
 *  @param loginToken   登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)syncDoneWithLoginToken:(NSString *)loginToken
                                              success:(void (^)(WCTRCMessageResponseResult *syncDoneMessageResponseResult))success
                                              failure:(void (^)(NSError *error))failure;
@end
