//
//  WCTLoginViewController.m
//
//
//  Created by Howard on 16/3/28.
//  Copyright (c) 2016年 penpower. All rights reserved.
//

#import "WCTLoginViewController.h"

// Define
#import "WCTLoginController+ParameterDefine.h"
#import "WCTLoginController+ResourceDefine.h"
#import "WCTRestClientController+SettingsKey.h"
#import "WCTRestClientController+ParameterDefine.h"
#import "WCTRestClient+ParameterDefine.h"

// Controller
#import "PPAlertController.h"
#import "PPNetworkReachabilityController.h"
#import "PPNavigationController.h"
#import "PPSupportController.h"
#import "PPSettingsController.h"
#import "PPSelectController.h"
#import "ForgetPasswordWebViewController.h"
#import "WCTPasswordViewController.h"
#import "WCTRestClientController.h"
#import "WCToastController.h"
#import "WCTLoginController.h"

// View
#import "PPBusyView.h"
#import "PPSwitchTableViewCell.h"
#import "WCTLoginTextFieldButtonTableViewCell.h"
#import "WCTLoginProtocolPortTextFieldButtonTableViewCell.h"

// Category
#import "NSData+AES256.h"
#import "NSString+Additions.h"
#import "UIColor+PropertyDictionary.h"
#import "PPButton+Factory.h"
#import "WCTSettingsKey.h"
#import "NSObject+PPBusyView.h"
#import "WCTRestClientController+Password.h"
#import "WCTRestClientController+Version.h"
#import "NSDate+Format.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef void(^ChangePwdCompleteHandler)(void);

#define WCT_PublicCloudDomain @"worldcardteam.com"
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTLoginViewController()

@interface WCTLoginViewController ()
<
CustomRectTextFieldDataSource,
ForgetPasswordWebViewControllerDelegate,
PPSelectControllerDelegate,
PPSwitchTableViewCellDelegate,
PPTextFieldButtonViewDelegate,
WCTPasswordViewControllerDelegate,
WCTLoginProtocolPortTextFieldButtonTableViewCellDelegate
>

@property(nonatomic,readwrite)        PPSectionController     *ppSectionController;
@property(nonatomic,retain)           NSOperationQueue        *operationQueue;
@property(nonatomic,retain, readwrite)           NSString                *accountUser;
@property(nonatomic,retain)           PPBusyView              *ppBusyView;
@property(nonatomic,retain, readwrite)           PPButton                *ppButtonLogin;
@property(nonatomic,retain, readwrite)           PPButton                *ppButtonHelp;
@property(nonatomic,retain, readwrite)           PPButton                *ppButtonForgetPassword;
@property(nonatomic,retain, readwrite)           PPButton                *ppButtonDeviceID;
@property(nonatomic,retain)           PPSelectController      *menuListSelectController;
@property(nonatomic,retain)           UILabel                 *versionLabel;
@property(nonatomic,retain)           UIImageView             *contentBackgroundImageView;
@property(nonatomic,retain, readwrite)           UIImageView             *logoImageView;
@property(nonatomic,retain, readwrite)           UIView                  *tableFooterView;
@property(nonatomic,retain)           NSIndexPath             *selectedIndexPath;
@property(nonatomic,retain)           WCTRCLoginInfo          *loginInfo;
@property(nonatomic,retain)           WCTLoginController      *loginController;
@property(nonatomic,assign)           BOOL                    secureTextEntry;
@property(nonatomic,retain)           NSDictionary            *errorDictionaries;
@property(nonatomic,assign)           WCTLC_ChangePasswordReason changePasswordReason;
@property(nonatomic,copy)             ChangePwdCompleteHandler     changePwdCompleteHandler;
@property(nonatomic,retain)           WCTLoginProtocolPortTextFieldButtonTableViewCell *protocolPortCell;

@property(nonatomic,copy)             TripleClickBlock tripleClickBlock;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCTLoginViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    id object = nil;
    
    if((self=[super init]))
    {
        [PPSettingsController setDefaultIntegerValue:0 withKey:WCTLoginViewControllerSettingKey_AutoLogin];
        
        //////////////////////////////////////////////////
        
        self.view.backgroundColor = [UIColor whiteColor];
        self.ppTableView.tag = WCTLoginViewControllerTableViewTag_LoginForm;
        
        //////////////////////////////////////////////////
        
        @autoreleasepool
        {
            do
            {
                _operationQueue = [[NSOperationQueue alloc] init];
                if(_operationQueue==nil)
                {
                    break;
                }
                
                [_operationQueue setMaxConcurrentOperationCount:1];
                
                //////////////////////////////////////////////////
                
                _ppSectionController = [[PPSectionController alloc] init];
                if(_ppSectionController==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                _loginController = [[WCTLoginController alloc] init];
                
                [_loginController completedServerListRecord];
                
                //////////////////////////////////////////////////
                
                object = self;
                
            }while(0);
            
            //////////////////////////////////////////////////
            
            
            if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
            {
                self.view.backgroundColor = WCTLVC_IPadBackgroundColor;
            }
            
            //////////////////////////////////////////////////
            
            if(object==nil)
            {
                [self release];
            }
        }
    }
    
    return object;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.tripleClickBlock = nil;
    
    if(_displayServerURLAddress!=nil)
    {
        [_displayServerURLAddress release];
        _displayServerURLAddress = nil;
    }
    
    if(_accountUser!=nil)
    {
        [_accountUser release];
        _accountUser = nil;
    }
    
    //////////////////////////////////////////////////
    
    if(_ppSectionController!=nil)
    {
        [_ppSectionController release];
        _ppSectionController = nil;
    }
    
    //////////////////////////////////////////////////
    
    if(_selectedIndexPath==nil)
    {
        [_selectedIndexPath release];
        _selectedIndexPath = nil;
    }
    
    self.versionString = nil;
    
    //////////////////////////////////////////////////
    
    [_ppBusyView release];
    _ppBusyView = nil;
    
    [_ppButtonLogin release];
    _ppButtonLogin = nil;
    
    [_ppButtonHelp release];
    _ppButtonHelp = nil;
    
    [_ppButtonForgetPassword release];
    _ppButtonForgetPassword = nil;
    
    [_ppButtonDeviceID release];
    _ppButtonDeviceID = nil;
    
    [_versionLabel release];
    _versionLabel = nil;
    
    [_contentBackgroundImageView release];
    _contentBackgroundImageView = nil;
    
    
    [_logoImageView release];
    _logoImageView = nil;
    
    [_tableFooterView release];
    _tableFooterView = nil;
    
    [_selectedIndexPath release];
    _selectedIndexPath = nil;
    
    [_loginInfo release];
    _loginInfo = nil;
    
    [_menuListSelectController release];
    _menuListSelectController = nil;
    
    [_loginController release];
    _loginController = nil;
    
    [_protocolPortCell release];
    _protocolPortCell = nil;
    
    [_changePwdCompleteHandler release];
    _changePwdCompleteHandler = nil;
    //////////////////////////////////////////////////
    
    self.errorDictionaries = nil;
    
    //////////////////////////////////////////////////
    
    if(_operationQueue!=nil)
    {
        @synchronized(_operationQueue)
        {
            if([_operationQueue operationCount]>0)
            {
                [_operationQueue cancelAllOperations];
            }
        }
        
        [_operationQueue release];
        _operationQueue = nil;
    }
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    self.secureTextEntry = YES;
    
    //////////////////////////////////////////////////
    
    //初始值為上次輸入過的位址
    
    // 第一次登入，也沒有紀錄上次成功連線網址，要給預設 url scheme
    if([self.displayServerURLAddress length]<=0)
    {
        self.displayServerURLAddress = [[self.loginController recordServerList] firstObject];
        
        //////////////////////////////////////////////////
        
        if([self.displayServerURLAddress length]<=0)
        {
            self.displayServerURLAddress = @"https://";
        }
    }
    
    //初始值為上次成功登入過的帳號
    if([self.accountUser length]<=0)
    {
        self.accountUser = [PPSettingsController stringValueWithKey:WCTRestClientController_SettingsKey_AccountName];
    }
    
    
    //////////////////////////////////////////////////
    
    self.singleTapResignFirstResponderEnable = YES;
    
    //////////////////////////////////////////////////
    
    if([PPSettingsController integerValueWithKey:WCTLoginViewControllerSettingKey_AutoLogin]>0)
    {
        self.autoLoginAccount = YES;
    }
    else
    {
        self.autoLoginAccount = NO;
    }
    
    //////////////////////////////////////////////////
    
    @autoreleasepool
    {
        NSArray *rowModels = [self rowModelsForAccount];
        
        if(rowModels!=nil)
        {
            [self.ppSectionController.sectionModelsForDefault removeAllObjects];
            
            [self.ppSectionController.sectionModelsForDefault addObject:[PPSectionModel sectionModelWithSection:WCTLoginViewController_Section_Login
                                                                                                          title:@""
                                                                                                      rowModels:rowModels]];
        }
        
        //////////////////////////////////////////////////
        
        if(self.backgroundImageView!=nil)
        {
            UIImage *headImage = [UIImage imageWithName:ImageNameWCTLoginViewControllerHeaderBackground];
            
            //////////////////////////////////////////////////
            
            self.logoImageView = [[[UIImageView alloc] initWithImage:headImage] autorelease];
            
            if(self.logoImageView!=nil)
            {
                self.logoImageView.backgroundColor  = [UIColor clearColor];
                self.logoImageView.contentMode      = UIViewContentModeScaleAspectFit;
                
                [self.view addSubview:self.logoImageView];
                
                
                
                //////////////////////////////////////////////////
                
                _versionLabel = [[UILabel alloc] init];
                
                if(_versionLabel!=nil)
                {
                    [_versionLabel setTextColor:[UIColor whiteColor]];
                }
                
                if(self.versionLabel!=nil)
                {
                    [self.logoImageView addSubview:self.versionLabel];
                }
            }
        }
        
        //////////////////////////////////////////////////
        
        if(self.ppTableView!=nil)
        {
            self.ppTableView.alwaysBounceHorizontal    = NO;
            self.ppTableView.alwaysBounceVertical   = NO;
            self.ppTableView.backgroundColor        = [UIColor clearColor];
            self.ppTableView.dataSource             = self;
            self.ppTableView.delegate               = self;
            self.ppTableView.separatorStyle         = UITableViewCellSeparatorStyleNone;
            [self.view addSubview:self.ppTableView];
            
            //////////////////////////////////////////////////
            
            self.tableFooterView = [[[UIView alloc] init] autorelease];
            
            if(self.tableFooterView!=nil)
            {
                self.ppButtonLogin = [[[PPButton alloc] initWithFrame:UIButtonAdditions_LargeRect] autorelease];
                
                if(self.ppButtonLogin!=nil)
                {
                    self.ppButtonLogin.delegate = self;
                    self.ppButtonLogin.tag      = WCTLoginViewControllerButtonTag_Login;
                    
                    [self.ppButtonLogin addControlEvents:UIControlEventTouchUpInside];
                    [self.ppButtonLogin setTitle:WCTLV_MLS_Login maxWidth:UIButtonAdditions_DefaultMaxWidth];
                    
                    //////////////////////////////////////////////////
                    
                    [self.ppButtonLogin setBackgroundImage:[UIImage imageWithColor:WCTLVC_LoginButton_NormalBackgroundColor]
                                                  forState:UIControlStateNormal];
                    
                    [self.ppButtonLogin setBackgroundImage:[UIImage imageWithColor:WCTLVC_LoginButton_HighlightedBackgroundColor]
                                                  forState:UIControlStateHighlighted];
                    
                    [self.ppButtonLogin setTitleColor:WCTLVC_LoginButton_NormalTextColor forState:UIControlStateNormal];
                    [self.ppButtonLogin setTitleColor:WCTLVC_LoginButton_HighlightedTextColor forState:UIControlStateHighlighted];
                    
                    self.ppButtonLogin.titleLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerLoginButtonFontSize];
                    
                    //////////////////////////////////////////////////
                    
                    [self.tableFooterView addSubview:self.ppButtonLogin];
                }
                
                //////////////////////////////////////////////////
                
                self.ppTableView.tableFooterView  = self.tableFooterView;
            }
            
        }
        
        //////////////////////////////////////////////////
        
        PPButton *ppButtonForgetPassword = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(ppButtonForgetPassword!=nil)
        {
            ppButtonForgetPassword.delegate = self;
            ppButtonForgetPassword.tag      = WCTLoginViewControllerButtonTag_ForgetPassword;
            [ppButtonForgetPassword setTitle:WCTLV_MLS_ForgetPassword maxWidth:0.0];
            [ppButtonForgetPassword addControlEvents:UIControlEventTouchUpInside];
            
            //////////////////////////////////////////////////
            
            [ppButtonForgetPassword setTitleColor:WCTLVC_TextFieldTextColor forState:UIControlStateNormal];
            [ppButtonForgetPassword setTitleColor:WCTLVC_TextFieldHighlightedTextColor forState:UIControlStateHighlighted];
            
            ppButtonForgetPassword.titleLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerForgetPasswordButtonFontSize];
            ppButtonForgetPassword.contentHorizontalAlignment = UIControlContentHorizontalAlignmentRight;
            ppButtonForgetPassword.contentEdgeInsets = WCTLoginViewControllerForgetPasswordButtonEdgeInset;
            
            //////////////////////////////////////////////////
            
            [self.tableFooterView addSubview:ppButtonForgetPassword];
            self.ppButtonForgetPassword = ppButtonForgetPassword;
            
        }
        
        [ppButtonForgetPassword release];
        
        //////////////////////////////////////////////////
        
        PPButton *ppButtonDeviceID = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(ppButtonDeviceID!=nil)
        {
            ppButtonDeviceID.delegate = self;
            ppButtonDeviceID.tag      = WCTLoginViewControllerButtonTag_DeviceID;
            [ppButtonDeviceID setTitle:WCTLV_MLS_DeviceID maxWidth:0.0];
            [ppButtonDeviceID addControlEvents:UIControlEventTouchUpInside];
            
            //////////////////////////////////////////////////
            
            [ppButtonDeviceID setTitleColor:WCTLVC_TextFieldTextColor forState:UIControlStateNormal];
            [ppButtonDeviceID setTitleColor:WCTLVC_TextFieldHighlightedTextColor forState:UIControlStateHighlighted];
            
            ppButtonDeviceID.titleLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerDeviceIDButtonFontSize];
            ppButtonDeviceID.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
            ppButtonDeviceID.contentEdgeInsets = WCTLoginViewControllerDeviceIDButtonEdgeInset;
            
            //////////////////////////////////////////////////
            
            [self.view addSubview:ppButtonDeviceID];
            self.ppButtonDeviceID = ppButtonDeviceID;
            
        }
        
        [ppButtonDeviceID release];
        
        //////////////////////////////////////////////////
        
        PPButton *ppButtonHelp = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(ppButtonHelp!=nil)
        {
            ppButtonHelp.delegate = self;
            ppButtonHelp.tag      = WCTLoginViewControllerButtonTag_ReportProblem;
            [ppButtonHelp setTitle:WCTLV_MLS_Report maxWidth:0.0];
            [ppButtonHelp addControlEvents:UIControlEventTouchUpInside];
            
            //////////////////////////////////////////////////
            
            [ppButtonHelp setTitleColor:WCTLVC_TextFieldTextColor forState:UIControlStateNormal];
            [ppButtonHelp setTitleColor:WCTLVC_TextFieldHighlightedTextColor forState:UIControlStateHighlighted];
            
            ppButtonHelp.titleLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerHelpButtonFontSize];
            ppButtonHelp.contentHorizontalAlignment = UIControlContentHorizontalAlignmentRight;
            ppButtonHelp.contentEdgeInsets = WCTLoginViewControllerHelpButtonEdgeInset;
            
            //////////////////////////////////////////////////
            
            [self.view addSubview:ppButtonHelp];
            self.ppButtonHelp = ppButtonHelp;
            
        }
        
        [ppButtonHelp release];
        
        //////////////////////////////////////////////////
        self.versionLabel.text = self.versionString;
        
        [self checkCanLogin];
        //////////////////////////////////////////////////
        // !! ios 12這個要放在最後做，不然會先做layoutSubView, 造成layout錯誤
        if(self.navigationController!=nil)
        {
            self.navigationController.navigationBarHidden = YES;
        }
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
    
    // MARK: 自動登入
    if(self.autoLoginAccount==YES &&
       [[WCTRestClientController decryptAccountPassword] length]>0)
    {
        //當顯示的URL Address 為空時, 拿上次成功連線的字串當作 URL
        if([[self.loginController recordServerList] count]<=0)
        {
            [self.loginController recordServerListAddServerURL:[PPSettingsController stringValueWithKey:WCTRestClientController_SettingsKey_Success_URLAddress]];
        }
        
        //////////////////////////////////////////////////
        
        [self performSelectorOnMainThread:@selector(loginStarted) withObject:nil waitUntilDone:NO];
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    //畫面切換時，紀錄此時的 account, urlAddress
    
    self.accountUser = [[self userRowModel] object];
    self.displayServerURLAddress = [WCTLoginController urlPathFromUrlComponents:[self serverRowModel].object];
    
    //////////////////////////////////////////////////
    
    [self.ppButtonLogin setDelegate:nil];
    [self.ppButtonLogin removeControlEvents:UIControlEventTouchUpInside];
    [self.ppButtonLogin removeFromSuperview];
    self.ppButtonLogin = nil;
    
    [self.ppButtonHelp setDelegate:nil];
    [self.ppButtonHelp removeControlEvents:UIControlEventTouchUpInside];
    [self.ppButtonHelp removeFromSuperview];
    self.ppButtonHelp = nil;
    
    [self.ppButtonForgetPassword setDelegate:nil];
    [self.ppButtonForgetPassword removeControlEvents:UIControlEventTouchUpInside];
    [self.ppButtonForgetPassword removeFromSuperview];
    self.ppButtonForgetPassword = nil;
    
    [self.ppButtonDeviceID setDelegate:nil];
    [self.ppButtonDeviceID removeControlEvents:UIControlEventTouchUpInside];
    [self.ppButtonDeviceID removeFromSuperview];
    self.ppButtonDeviceID = nil;
    
    self.tableFooterView = nil;
    
    [self.contentBackgroundImageView removeFromSuperview];
    self.contentBackgroundImageView = nil;
    
    [self.logoImageView removeFromSuperview];
    self.logoImageView = nil;
    
    [self.versionLabel removeFromSuperview];
    self.versionLabel = nil;
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}


//================================================================================
//
//================================================================================
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    //////////////////////////////////////////////////
    
    if(self.ppBusyView!=nil)
    {
        [self.ppBusyView.superview bringSubviewToFront:self.ppBusyView];
    }
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [self layoutSubviews];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overriding Methods

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    CGRect viewBounds = CGRectMake(0,
                                   0,
                                   MIN(self.view.bounds.size.width, self.view.bounds.size.height),
                                   MAX(self.view.bounds.size.width, self.view.bounds.size.height));
    CGRect logoImageViewFrame = CGRectZero;
    
    if(self.logoImageView!=nil)
    {
        logoImageViewFrame.size.height  = viewBounds.size.width*(self.logoImageView.image.size.height/self.logoImageView.image.size.width);
        
        logoImageViewFrame.size.width   = viewBounds.size.width;
        
        self.logoImageView.frame = logoImageViewFrame;
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppTableView!=nil)
    {
        CGRect ppTableViewFrame = self.ppTableView.frame;
        
        ppTableViewFrame.size.width = viewBounds.size.width-WCTLoginViewControllerTableViewEdgeInsets.left-WCTLoginViewControllerTableViewEdgeInsets.right;
        
        ppTableViewFrame.origin.x   = WCTLoginViewControllerTableViewEdgeInsets.left;
        ppTableViewFrame.origin.y   = CGRectGetMaxY(logoImageViewFrame)+WCTLoginViewControllerTableViewEdgeInsets.top;
        
        if (@available(iOS 11.0, *)) {
            ppTableViewFrame.size.height = viewBounds.size.height-CGRectGetMaxY(logoImageViewFrame)-WCTLoginViewControllerTableViewEdgeInsets.bottom-WCTLoginViewControllerLoginButtonHeight-self.view.safeAreaInsets.top-self.view.safeAreaInsets.bottom;
        } else {
            ppTableViewFrame.size.height = viewBounds.size.height-CGRectGetMaxY(logoImageViewFrame)-WCTLoginViewControllerTableViewEdgeInsets.bottom-WCTLoginViewControllerLoginButtonHeight;
        }
        
        self.ppTableView.frame = ppTableViewFrame;
    }
    
    //////////////////////////////////////////////////
    
    if(self.contentBackgroundImageView!=nil)
    {
        CGRect contentBackgroundImageViewFrame = CGRectZero;
        
        contentBackgroundImageViewFrame.origin.y     = CGRectGetMaxY(self.logoImageView.frame);
        contentBackgroundImageViewFrame.size.width   = self.contentBackgroundImageView.superview.bounds.size.width;
        contentBackgroundImageViewFrame.size.height  = self.ppTableView.bounds.size.height;
        
        self.contentBackgroundImageView.frame = contentBackgroundImageViewFrame;
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppBusyView!=nil)
    {
        self.ppBusyView.frame = self.ppBusyView.superview.bounds;
    }
    
    //////////////////////////////////////////////////
    
    if(self.tableFooterView!=nil)
    {
        self.tableFooterView.bounds = CGRectMake(0,
                                                 0,
                                                 self.ppTableView.bounds.size.width,
                                                 WCTLoginViewControllerLoginButtonHeight+WCTLoginViewControllerForgetPasswordButtonHeight);
        
        self.ppTableView.tableFooterView = self.tableFooterView;
        
        //////////////////////////////////////////////////
        
        if(self.ppButtonLogin!=nil)
        {
            self.ppButtonLogin.frame = CGRectMake(PPTableViewCellDefaultHorizontalGap,
                                                  0,
                                                  self.ppTableView.bounds.size.width-PPTableViewCellDefaultHorizontalGap*2,
                                                  WCTLoginViewControllerLoginButtonHeight);
        }
        
        //////////////////////////////////////////////////
        
        self.ppButtonForgetPassword.frame = CGRectMake(self.tableFooterView.bounds.size.width/2-PPTableViewCellDefaultHorizontalGap*2,
                                                       CGRectGetMaxY(self.ppButtonLogin.frame)+PPTableViewCellDefaultVerticalGap,
                                                       viewBounds.size.width/2,
                                                       WCTLoginViewControllerForgetPasswordButtonHeight);
    }
    
    //////////////////////////////////////////////////
    
    CGFloat bottomButtonOriginY = 0;
    
    if (@available(iOS 11.0, *)) {
        bottomButtonOriginY = viewBounds.size.height-WCTLoginViewControllerHelpButtonHeight- self.view.safeAreaInsets.bottom;
    } else {
        bottomButtonOriginY = viewBounds.size.height-WCTLoginViewControllerHelpButtonHeight;
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppButtonHelp!=nil)
    {
        self.ppButtonHelp.frame = CGRectMake(viewBounds.size.width/2,
                                             bottomButtonOriginY,
                                             viewBounds.size.width/2,
                                             WCTLoginViewControllerHelpButtonHeight);
    }
    
    if(self.ppButtonDeviceID!=nil)
    {
        self.ppButtonDeviceID.frame = CGRectMake(0,
                                                 bottomButtonOriginY,
                                                 viewBounds.size.width/2,
                                                 WCTLoginViewControllerDeviceIDButtonHeight);
    }
    
    //////////////////////////////////////////////////
    
    self.versionLabel.frame = CGRectMake(self.logoImageView.bounds.size.width*0.55,
                                         self.logoImageView.bounds.size.height*0.762,
                                         self.logoImageView.bounds.size.width/3,
                                         self.logoImageView.bounds.size.height/5);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods


//==============================================================================
//
//==============================================================================
- (NSURLComponents *)urlComponentsForLogin
{
    
    NSURLComponents *serverComponents = [self serverRowModel].object;
    NSURLComponents *protocolAndPortComponents = [self protocolAndPortRowModel].object;
    
    serverComponents.port = protocolAndPortComponents.port;
    serverComponents.scheme = protocolAndPortComponents.scheme;
    
    NSURLComponents *connectedComponents = [WCTLoginController urlComponentsFromUrlPath:[WCTLoginController urlPathFromUrlComponents:serverComponents]];
    
    if(connectedComponents.port==nil)
    {
        [WCTLoginController adjustURLComponents:connectedComponents withHttps:[connectedComponents.scheme isEqualToString:@"https"]];
    }
    
    return connectedComponents;
}

//================================================================================
//
//================================================================================
- (void)checkCanLogin
{
    BOOL canLogin = NO;
    
    do
    {
        PPRowModel *serverRowModel = [self serverRowModel];
        NSURLComponents *components = [serverRowModel object];
        NSURLComponents *protocolAndPortComponents = [[self protocolAndPortRowModel] object];
        
        if(serverRowModel==nil || [[components host] length]<=0 || [protocolAndPortComponents port]==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *userRowModel = [self userRowModel];
        
        if(userRowModel==nil || userRowModel.object==nil || [((NSString *)userRowModel.object) length]==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *passwordRowModel = [self passwordRowModel];
        
        if(passwordRowModel==nil || passwordRowModel.object==nil || [((NSString *)passwordRowModel.object) length]==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        canLogin = YES;
        
    }while(0);
    
    self.ppButtonLogin.enabled = canLogin;
}


//================================================================================
// MARK: 開始登入
//================================================================================
- (void)loginStarted
{
    self.ppBusyView = [[[PPBusyView alloc] initWithSuperView:self.view] autorelease];
    
    //////////////////////////////////////////////////
    
    __block typeof(self) blockself = self;
    
    NSURLComponents *connectedComponents = [self urlComponentsForLogin];
    
    //////////////////////////////////////////////////
    
    //這邊登入重新產生一個 NSURLComponent 是因為界面上有可能 port 不輸入，此時不能紀錄，只能在連線的時候將參數重組
    [self.loginController loginServerByUrlComponents:connectedComponents
                                         accountName:[self userRowModel].object
                                            password:[self passwordRowModel].object
                                          completion:^(WCTRCLoginInfo *loginInfo, WCTLC_ChangePasswordReason changePasswordReason, NSDictionary<NSString *,NSError *> *errorDictionary) {
        
        if([loginInfo.serverStatus.subscriptionStatus isEqualToString:WCTRC_SubscriptionState_TrialLeft2Week]==YES||
           [loginInfo.serverStatus.subscriptionStatus isEqualToString:WCTRC_SubscriptionState_SubscriptionLeft2Week]==YES)
        {
            [PPSettingsController setDateValue:loginInfo.serverStatus.expiredDate withKey:WCTLoginViewControllerSettingKey_SubscriptionExpiredDate];
        }
        else
        {
            [PPSettingsController removeValueWithKey:WCTLoginViewControllerSettingKey_SubscriptionExpiredDate];
        }
        
        blockself.loginInfo = loginInfo;
        blockself.errorDictionaries = errorDictionary;
        //                                              changePasswordReason = WCTLC_ChangePasswordReason_PasswordExpired;
        blockself.changePasswordReason = changePasswordReason;
        [blockself loginFinished];
    }];
}


//================================================================================
// MARK: 登入結束
//================================================================================
- (void)loginFinished
{
    if(self.ppBusyView!=nil)
    {
        [self.ppBusyView removeFromSuperview];
        self.ppBusyView = nil;
    }
    
    //////////////////////////////////////////////////
    // 顯示訊息順序
    // 1. 伺服器授權檢查狀態訊息 (issueStatus error)
    // 2. 訂閱狀態訊息 (subscription error)
    // 3. 切換使用者(login error)或伺服器還原
    // 4. 變更密碼
    
    //////////////////////////////////////////////////
    __block typeof(self) blockSelf = self;
    
    //////////////////////////////////////////////////
    // 顯示變更密碼與之後的流程
    void(^ChangePWDProcess)(BOOL offlineMode, BOOL serverRestored) = ^(BOOL offlineMode, BOOL serverRestored)
    {
        [blockSelf showChangePasswordIfNeedWithCompleteHandler:^{
            
            [blockSelf reportLoginSuccessWithOfflineMode:offlineMode serverRestored:serverRestored];
        }];
    };
    
    //////////////////////////////////////////////////
    [blockSelf showPirateVersionAlertIfNeedWithCompleteHandler:^{
        
        [blockSelf showSubscriptionErrorAlertIfNeedWithCompleteHandler:^{
            
            [blockSelf showLimitedAccountErrorAlertIfNeedWithCompleteHandler:^{
                
                [blockSelf showLoginFailedAlertIfNeedWithCompleteHandler:^(BOOL offlineMode, BOOL switchUser) {
                    
                    if (switchUser)
                    {
                        ChangePWDProcess(offlineMode, NO);
                    } // end of if(switchUser)
                    else
                    {
                        // 沒有切換使用者，才要檢查還原
                        [blockSelf showServerRestoredAlertIfNeededWithCompleteHandler:^(BOOL serverRestored) {
                            ChangePWDProcess(offlineMode, serverRestored);
                        }];
                    } // end of else switchUser
                }];
            }];
        }];
    }];
}


//================================================================================
// 部分登入流程不需要檢查是否要還原, 所以要檢查的call這個
// 不用檢查的call |reportLoginSuccessWithOfflineMode:|
//================================================================================
- (void)checkRestoreAndReportLoginSuccess
{
    // !! MARK: server 還原在這邊判斷
    //////////////////////////////////////////////////
    
    //檢查伺服器是否進行還原
    BOOL serverRestored = [WCTRestClientController isServerRestoredWithDatabaseCreateTime:self.loginInfo.databaseCreateTime];
    
    if (serverRestored)
    {
        PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:@""
                                                                                       message:WCTLV_MLS_ServerRestoreWarning
                                                                                preferredStyle:UIAlertControllerStyleAlert];
        
        [ppAlertViewController addAction:[UIAlertAction actionWithTitle:WCTLV_MLS_OK
                                                                  style:UIAlertActionStyleDefault
                                                                handler:^(UIAlertAction * _Nonnull action) {
            
            [self reportLoginSuccessWithOfflineMode:NO serverRestored:YES];
        }]];
        [self presentViewController:ppAlertViewController animated:YES completion:nil];
    }
    else
    {
        [self reportLoginSuccessWithOfflineMode:NO];
    }
}


//================================================================================
//
//================================================================================
- (void)reportLoginSuccessWithOfflineMode:(BOOL)offlineMode
{
    [self reportLoginSuccessWithOfflineMode:offlineMode
                             serverRestored:NO];
}




//================================================================================
//
//================================================================================
- (void)reportLoginSuccessWithOfflineMode:(BOOL)offlineMode serverRestored:(BOOL)serverRestored
{
    BOOL firstLogin = NO;
    
    // 登入
    if(offlineMode==NO)
    {
        // MARK: 紀錄登入參數
        [PPSettingsController setDateValue:[NSDate date]
                                   withKey:WCTLoginViewControllerSettingKey_LastLoginDate];
        
        [PPSettingsController setIntegerValue:[self.loginInfo.tokenInfo.invalidTime timeIntervalSince1970]
                                      withKey:WCTLoginViewControllerSettingKey_ExpiredTimeMiloSecond];
        
        [PPSettingsController setStringValue:[[[self userRowModel] object] stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]]
                                     withKey:WCTRestClientController_SettingsKey_AccountName];
        
        //////////////////////////////////////////////////
        
        [PPSettingsController setIntegerValue:self.autoLoginAccount
                                      withKey:WCTLoginViewControllerSettingKey_AutoLogin];
        
        //////////////////////////////////////////////////
        
        //紀錄輸入的字串
        
        NSURLComponents *currentComponents = [self serverRowModel].object;
        NSURLComponents *protocolAndPortComponents = [self protocolAndPortRowModel].object;
        
        currentComponents.scheme = protocolAndPortComponents.scheme;
        currentComponents.port = protocolAndPortComponents.port;
        
        NSString *connectedURLString = [WCTLoginController urlPathFromUrlComponents:currentComponents];
        
        //////////////////////////////////////////////////
        
        
        [PPSettingsController setStringValue:connectedURLString
                                     withKey:WCTRestClientController_SettingsKey_Success_URLAddress];
        
        [self.loginController recordServerListAddServerURL:connectedURLString];
        
        //////////////////////////////////////////////////
        
        if([PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID]==nil)
        {
            firstLogin = YES;
        }
        else if([[PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID] compare:self.loginInfo.accountInfo.guid options:NSCaseInsensitiveSearch]!=NSOrderedSame)
        {
            firstLogin = YES;
        }
        //切換伺服器
        else if ([[PPSettingsController stringValueWithKey:WCTSettingsKey_ServerGUID] compare:self.loginInfo.serverId options:NSCaseInsensitiveSearch]!=NSOrderedSame)
        {
            firstLogin = YES;
        }
        
        [PPSettingsController setStringValue:self.loginInfo.accountInfo.guid withKey:WCTSettingsKey_AccountGUID];
        [PPSettingsController setStringValue:self.loginInfo.serverId withKey:WCTSettingsKey_ServerGUID];
        
    }
    
    //////////////////////////////////////////////////
    
    // 判斷帳號是否暫停使用
    BOOL limitedAccount = NO;
    // !!如果沒有 accountSubscriptionStatus表示是舊server, 不會有暫停使用的狀態
    if ([self.loginInfo.accountInfo.accountSubscriptionStatus length]>0)
    {
        limitedAccount = [self.loginInfo.accountInfo.accountSubscriptionStatus isEqualToString:WCTRC_AccountSubscriptionStatus_TemplateInvalidate];
    }
    
    //////////////////////////////////////////////////
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(loginViewControllerLoginSuccess:firstLogin:serverRestore:limitedAccount:offLine:)]==YES)
    {
        [self.delegate loginViewControllerLoginSuccess:self
                                            firstLogin:firstLogin
                                         serverRestore:serverRestored
                                        limitedAccount:limitedAccount
                                               offLine:offlineMode];
    }
    
    // !! 等還原處理後再紀錄登入時間
    if (offlineMode==NO)
    {
        // 紀錄這次登入的server版本
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            [WCTRestClientController setLastLoginServerVersion:[[[WCTRestClientController shareRestClientController] serverVersionInfo] versionString]];
        });
        
        // 紀錄這次登入server的時間
        [WCTRestClientController recordDatabaseCreateTime:self.loginInfo.databaseCreateTime];
    }
    [WCTLoginController saveLoginSuccessTimeWithOfflineMode:offlineMode];
}


//==============================================================================
//
//==============================================================================
- (void)showSubscriptionPageFromViewController:(UIViewController *)viewController
{
    __block typeof(self) blockSelf = self;
    
    [self setBusy:@(YES)];
    
    [self.loginController subscriptionURLWithCompletion:^(NSURL *subscriptionURL, NSError *error) {
        
        if(subscriptionURL!=nil)
        {
            //            PPWebViewController *webViewController = [[PPWebViewController alloc] init];
            //            webViewController.request = [NSURLRequest requestWithURL:subscriptionURL];
            //            webViewController.webTitle = WCTLV_MLS_Subscription;
            //
            //            PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:webViewController];
            //            [viewController presentViewController:navigationController animated:YES completion:nil];
            //            [navigationController release];
            //            [webViewController release];
            [[UIApplication sharedApplication] openURL:subscriptionURL];
        }
        [blockSelf setBusy:@(NO)];
    }];
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - gesture


//==============================================================================
//
//==============================================================================
- (void)enableTripleTapToView:(UIView*)view blockHandler:(TripleClickBlock)blockHandler;
{
    self.tripleClickBlock = blockHandler;
    [self addTripleTapGestureRecognierToView:view];
}


//==============================================================================
//
//==============================================================================
- (void)disableTripleTapToView:(UIView*)view
{
    [self removeTripleTapTapGestureRecognierFromView:view];
}


//==============================================================================
//
//==============================================================================
- (void)addTripleTapGestureRecognierToView:(UIView*)view
{
    UITapGestureRecognizer *tapGestureRecognier = [[UITapGestureRecognizer alloc] init];
    if (tapGestureRecognier)
    {
        [tapGestureRecognier setNumberOfTapsRequired:3];
        [tapGestureRecognier addTarget:self action:@selector(onTripleTapRecognier:)];
        [view setUserInteractionEnabled:YES];
        [view addGestureRecognizer:tapGestureRecognier];
        [tapGestureRecognier release];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeTripleTapTapGestureRecognierFromView:(UIView*)view
{
    NSArray *gestureRecognizers = view.gestureRecognizers;
    for (UIGestureRecognizer *gestureRecognizer in gestureRecognizers)
    {
        [view removeGestureRecognizer:gestureRecognizer];
    }
}


//==============================================================================
//
//==============================================================================
- (void)onTripleTapRecognier:(UITapGestureRecognizer *)tapGestureRecognier
{
    if(self.tripleClickBlock)
    {
        self.tripleClickBlock(tapGestureRecognier.view);
    }
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - process after login


//==============================================================================
//
//==============================================================================
- (void)showChangePasswordIfNeedWithCompleteHandler:(void(^)(void))completeHandler
{
    // MARK: 變更密碼頁面在這邊處理
    if(self.changePasswordReason!=WCTLC_ChangePasswordReason_No)
    {
        __block typeof(self) blockSelf = self;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            BOOL isV6Server = ([WCTRestClientController shareRestClientController].serverVersionInfo.majorVersion>=6.0);
            
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                
                WCTPasswordViewController *passwordViewController = [[[WCTPasswordViewController alloc] init] autorelease];
                
                //////////////////////////////////////////////////
                
                passwordViewController.delegate = self;
                
                WCTPasswordViewControllerStyle style = WCTPasswordViewControllerStyle_ResetPassword;
                
                if (self.changePasswordReason==WCTLC_ChangePasswordReason_PasswordExpired)
                {
                    style = WCTPasswordViewControllerStyle_ResetPasswordBecauseOfExpired;
                }
                
                passwordViewController.passwordViewControllerStyle = style;
                passwordViewController.isV6Server = isV6Server;
                self.changePwdCompleteHandler = completeHandler;
                //////////////////////////////////////////////////
                
                PPNavigationController *navigationController = [[[PPNavigationController alloc] initWithRootViewController:passwordViewController] autorelease];
                //////////////////////////////////////////////////
                
                [self presentViewController:navigationController
                                   animated:YES
                                 completion:nil];
            });
        });
        
    }
    else
    {
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(completeHandler)
            {
                completeHandler();
            }
        });
    }
}


//==============================================================================
// 沒秀訊息或需要繼續時才會call completeHandler
//==============================================================================
- (void)showLoginFailedAlertIfNeedWithCompleteHandler:(void(^)(BOOL offlineMode, BOOL switchUser))completeHandler
{
    // MARK: 登入失敗的Toast，切換使用者，離線登入的Alert在這邊處理
    NSError *error = [self.errorDictionaries objectForKey:WCTLoginControllerErrorInfoKey_Login];
    if(error==nil)
    {
        dispatch_async(dispatch_get_main_queue(), ^{
            if (completeHandler)
            {
                completeHandler(NO, NO);
            }
        });
        return;
    }
    
    //////////////////////////////////////////////////
    
    if([error.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES &&
       error.code==WCTLoginController_ErrorCode_WarningOfflineMode)
    {
        NSString *errorMessage = [error alertMessage];
        [self showConfirmAlertWithMessage:errorMessage completeHandler:^{
            
            dispatch_async(dispatch_get_main_queue(), ^{
                if (completeHandler)
                {
                    completeHandler(YES, NO);
                }
            });
        }];
    }
    else if([error.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES &&
            error.code==WCTLoginController_ErrorCode_WarningOfflineModeWithUpdateClient)
    {
        NSString *errorMessage = [error alertMessage];
        [self showOfflineAndUpdateClientAlertWithMessage:errorMessage updateOnly:NO completeHandler:^(BOOL offline, BOOL update) {
            
            if(offline)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    if (completeHandler)
                    {
                        completeHandler(YES, NO);
                    }
                });
            }
            else if(update)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    [[UIApplication sharedApplication] openURL:[NSURL URLWithString:@"https://apps.apple.com/app/id1232565100"]];
                });
            }
        }];
    }
    else if([error.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES &&
            error.code==WCTLoginController_ErrorCode_ServerIsNewerThanClient)
    {
        NSString *errorMessage = [error alertMessage];
        [self showOfflineAndUpdateClientAlertWithMessage:errorMessage updateOnly:YES completeHandler:^(BOOL offline, BOOL update) {
            
            if(offline)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    if (completeHandler)
                    {
                        completeHandler(YES, NO);
                    }
                });
            }
            else if(update)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    [[UIApplication sharedApplication] openURL:[NSURL URLWithString:@"https://apps.apple.com/app/id1232565100"]];
                });
            }
        }];
    }
    
    else if([error.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES &&
            (error.code==WCTLoginController_ErrorCode_WarningSwitchServer ||
             error.code==WCTLoginController_ErrorCode_WarningSwitchUser))
    {
        NSString *errorMessage = [error alertMessage];
        [self showConfirmAlertWithMessage:errorMessage completeHandler:^{
            
            dispatch_async(dispatch_get_main_queue(), ^{
                if (completeHandler)
                {
                    completeHandler(NO, YES);
                }
            });
        }];
    }
    else if(error.code==WCTServer_Login_ErrorCode_AuthenticationFailed)
    {
        // MARK: 密碼輸入錯誤
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:WCTLC_MLS_AccountNameOrPasswordWrongAndTryAgain
                                                position:PPToastPositionCenter];
    }
    else if([error.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES &&
            error.code==WCTLoginController_ErrorCode_ServerIsUnActived)
    {
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:WCTLC_MLS_ServerIsNotActived
                                                position:PPToastPositionCenter];
    }
    else if([error.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES &&
            (error.code==WCTLoginController_ErrorCode_SubscriptionLock||
             error.code==WCTLoginController_ErrorCode_LockByLoginFailure||
             error.code==WCTLoginController_ErrorCode_LockByAccountActiveExpired))
    {
        NSString *errorMessage = [error alertMessage];
        [self showNormalAlertWithMessage:errorMessage completeHandler:nil];
    }
    else
    {
        [self showToastForError:error];
    }
    
}


//==============================================================================
// 沒秀訊息或需要繼續時才會call completeHandler
//==============================================================================
- (void)showPirateVersionAlertIfNeedWithCompleteHandler:(void(^)(void))completeHandler
{
    // !! MARK: 盜版的警告在這邊顯示
    NSError *error = [self.errorDictionaries objectForKey:WCTLoginControllerErrorInfoKey_DuplicatedServer];
    
    if(error==nil)
    {
        // 空的直接返回
        dispatch_async(dispatch_get_main_queue(), ^{
            if (completeHandler)
            {
                completeHandler();
            }
        });
    }
    else
    {
        
        if([error.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES &&
           error.code==WCTLoginController_ErrorCode_DuplicatedServerWarning)
        {
            [self showNormalAlertWithMessage:[error alertMessage] completeHandler:completeHandler];
        }
    }
}


//==============================================================================
// 沒秀訊息或需要繼續時才會call completeHandler
//==============================================================================
- (void)showLimitedAccountErrorAlertIfNeedWithCompleteHandler:(void(^)(void))completeHandler
{
    // !! MARK: 暫停用戶的警告在這邊顯示，訂閱還沒過期才要秀
    NSError *error = nil;
    BOOL isSubscriptionError = NO;
    BOOL isLimitedAccount = NO;
    
    //////////////////////////////////////////////////
    // 先檢查是否有訂閱錯誤
    NSError *subscriptionError = [self.errorDictionaries objectForKey:WCTLoginControllerErrorInfoKey_Subscription];
    
    if([subscriptionError.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES &&
       (subscriptionError.code==WCTLoginController_ErrorCode_TrialOutOfDate ||
        subscriptionError.code==WCTLoginController_ErrorCode_SubscriptionOutOfDate))
    {
        isSubscriptionError = YES;
    }
    
    //////////////////////////////////////////////////
    // loginError中如果有WCTLoginController_ErrorCode_SubscriptionLock也是訂閱錯誤
    NSError *loginError = [self.errorDictionaries objectForKey:WCTLoginControllerErrorInfoKey_Login];
    
    if([loginError.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES &&
       loginError.code==WCTLoginController_ErrorCode_SubscriptionLock)
    {
        isSubscriptionError = YES;
    }
    //////////////////////////////////////////////////
    
    if (isSubscriptionError==NO)
    {
        // !! 訂閱沒過期才要檢查是否為暫停用戶
        isLimitedAccount = [WCTLoginController isLimitedAccountWithLoginInfo:self.loginInfo returnError:&error];
    }
    
    if (isSubscriptionError==YES ||
        isLimitedAccount==NO ||
        error==nil)
    {
        dispatch_async(dispatch_get_main_queue(), ^{
            if (completeHandler)
            {
                completeHandler();
            }
        });
    }
    else
    {
        [self showNormalAlertWithMessage:[error alertMessage] completeHandler:completeHandler];
    }
}

//==============================================================================
// 沒秀訊息或需要繼續時才會call completeHandler
//==============================================================================
- (void)showSubscriptionErrorAlertIfNeedWithCompleteHandler:(void(^)(void))completeHandler
{
    // !! MARK: 訂閱的警告在這邊顯示
    NSError *error = [self.errorDictionaries objectForKey:WCTLoginControllerErrorInfoKey_Subscription];
    
    if(error==nil)
    {
        // 空的直接返回
        dispatch_async(dispatch_get_main_queue(), ^{
            if (completeHandler)
            {
                completeHandler();
            }
        });
    }
    else
    {
        
        if([error.domain isEqualToString:NSStringFromClass(self.loginController.class)]==YES)
        {
            if(error.code==WCTLoginController_ErrorCode_TrialLeft2WeekOfDate ||
               error.code==WCTLoginController_ErrorCode_SubscriptionLeft2WeekOfDate||
               error.code==WCTLoginController_ErrorCode_TrialOutOfDate ||
               error.code==WCTLoginController_ErrorCode_SubscriptionOutOfDate)
            {
                [self showSubscriptoinExpiredAlertWithMessage:[error alertMessage] completeHandler:^(BOOL subscribe) {
                    
                    // MARK: !!跳出訂閱視窗
                    [self showSubscriptionPageFromViewController:self];
                }];
            }
            else if(error.code==WCTLoginController_ErrorCode_LimitedAccount)
            {
                [self showNormalAlertWithMessage:[error alertMessage] completeHandler:completeHandler];
            }
        }
        
    }
}


//==============================================================================
//
//==============================================================================
- (void)showServerRestoredAlertIfNeededWithCompleteHandler:(void(^)(BOOL serverRestored))completeHandler
{
    // !! MARK: server 還原在這邊判斷
    //////////////////////////////////////////////////
    
    //檢查伺服器是否進行還原
    BOOL serverRestored = [WCTRestClientController isServerRestoredWithDatabaseCreateTime:self.loginInfo.databaseCreateTime];
    
    if (serverRestored)
    {
        [self showNormalAlertWithMessage:WCTLV_MLS_ServerRestoreWarning completeHandler:^{
            if (completeHandler)
            {
                completeHandler(serverRestored);
            }
        }];
    }
    else
    {
        dispatch_async(dispatch_get_main_queue(), ^{
            if (completeHandler)
            {
                completeHandler(serverRestored);
            }
        });
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private show alert


//==============================================================================
// MARK: 顯示只有關閉的alert
//==============================================================================
- (void)showNormalAlertWithMessage:(NSString *)message completeHandler:(void(^)(void))completeHandler
{
    NSAssert([message length]>0, @"message 不能為空");
    
    UIAlertAction *closeAction = [UIAlertAction actionWithTitle:WCTLV_MLS_OK style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
        dispatch_async(dispatch_get_main_queue(), ^{
            if (completeHandler)
            {
                completeHandler();
            }
        });
    }];
    
    PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:@""
                                                                                   message:@""
                                                                            preferredStyle:UIAlertControllerStyleAlert];
    
    //////////////////////////////////////////////////
    // 訊息靠左顯示
    NSMutableParagraphStyle *paraStyle = [[NSMutableParagraphStyle alloc] init];
    paraStyle.alignment = NSTextAlignmentLeft;
    
    NSMutableAttributedString *atrStr = [[NSMutableAttributedString alloc] initWithString:message
                                                                               attributes:@{NSParagraphStyleAttributeName:paraStyle,
                                                                                            NSFontAttributeName:[UIFont systemFontOfSize:14.0]}];
    
    [ppAlertViewController setValue:atrStr forKey:@"attributedMessage"];
    [paraStyle release];
    [atrStr release];
    
    //////////////////////////////////////////////////
    [ppAlertViewController addAction:closeAction];
    [self presentViewController:ppAlertViewController animated:YES completion:nil];
    
}

//==============================================================================
// MARK: 顯示有確定與取消的alert
//==============================================================================
- (void)showConfirmAlertWithMessage:(NSString *)message completeHandler:(void(^)(void))completeHandler
{
    NSAssert([message length]>0, @"message 不能為空");
    
    UIAlertAction *closeAction = [UIAlertAction actionWithTitle:WCTLV_MLS_OK style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        if (completeHandler)
        {
            completeHandler();
        }
    }];
    
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:WCTLV_MLS_Cancel style:UIAlertActionStyleCancel handler:nil];
    
    PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:@""
                                                                                   message:message
                                                                            preferredStyle:UIAlertControllerStyleAlert];
    
    //////////////////////////////////////////////////
    // 訊息靠左顯示
    //    NSMutableParagraphStyle *paraStyle = [[NSMutableParagraphStyle alloc] init];
    //    paraStyle.alignment = NSTextAlignmentLeft;
    //
    //    NSMutableAttributedString *atrStr = [[NSMutableAttributedString alloc] initWithString:message
    //                                                                               attributes:@{NSParagraphStyleAttributeName:paraStyle,
    //                                                                                            NSFontAttributeName:[UIFont systemFontOfSize:14.0]}];
    //
    //    [ppAlertViewController setValue:atrStr forKey:@"attributedMessage"];
    //////////////////////////////////////////////////
    [ppAlertViewController addAction:cancelAction];
    [ppAlertViewController addAction:closeAction];
    
    [self presentViewController:ppAlertViewController animated:YES completion:nil];
}


//==============================================================================
// MARK: 顯示有離線模式與更新的alert
//==============================================================================
- (void)showOfflineAndUpdateClientAlertWithMessage:(NSString *)message updateOnly:(BOOL)updateOnly completeHandler:(void(^)(BOOL offline, BOOL update))completeHandler
{
    NSAssert([message length]>0, @"message 不能為空");
    
    UIAlertAction *loginAction = nil;
    if(updateOnly==NO)
    {
        loginAction = [UIAlertAction actionWithTitle:WCTLV_MLS_OfflineLogin style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            if (completeHandler)
            {
                completeHandler(YES, NO);
            }
        }];
    }
    
    UIAlertAction *updateAction = [UIAlertAction actionWithTitle:WCTLV_MLS_UpdateClient style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        if (completeHandler)
        {
            completeHandler(NO, YES);
        }
    }];
    
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:WCTLV_MLS_Cancel style:UIAlertActionStyleCancel handler:nil];
    
    PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:@""
                                                                                   message:message
                                                                            preferredStyle:UIAlertControllerStyleAlert];
    
    //////////////////////////////////////////////////
    // 訊息靠左顯示
    //    NSMutableParagraphStyle *paraStyle = [[NSMutableParagraphStyle alloc] init];
    //    paraStyle.alignment = NSTextAlignmentLeft;
    //
    //    NSMutableAttributedString *atrStr = [[NSMutableAttributedString alloc] initWithString:message
    //                                                                               attributes:@{NSParagraphStyleAttributeName:paraStyle,
    //                                                                                            NSFontAttributeName:[UIFont systemFontOfSize:14.0]}];
    //
    //    [ppAlertViewController setValue:atrStr forKey:@"attributedMessage"];
    //////////////////////////////////////////////////
    if(loginAction)
    {
        [ppAlertViewController addAction:loginAction];
    }
    [ppAlertViewController addAction:updateAction];
    [ppAlertViewController addAction:cancelAction];
    
    [self presentViewController:ppAlertViewController animated:YES completion:nil];
}


//==============================================================================
// MARK: 顯示有我要訂閱/關閉的Alert
//==============================================================================
- (void)showSubscriptoinExpiredAlertWithMessage:(NSString *)message completeHandler:(void(^)(BOOL subscribe))completeHandler
{
    NSAssert([message length]>0, @"message 不能為空");
    
    PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:@""
                                                                                   message:message
                                                                            preferredStyle:UIAlertControllerStyleAlert];
    
    //////////////////////////////////////////////////
    // 訊息靠左顯示
    //    NSMutableParagraphStyle *paraStyle = [[NSMutableParagraphStyle alloc] init];
    //    paraStyle.alignment = NSTextAlignmentLeft;
    //
    //    NSMutableAttributedString *atrStr = [[NSMutableAttributedString alloc] initWithString:message
    //                                                                               attributes:@{NSParagraphStyleAttributeName:paraStyle,
    //                                                                                            NSFontAttributeName:[UIFont systemFontOfSize:14.0]}];
    //
    //    [ppAlertViewController setValue:atrStr forKey:@"attributedMessage"];
    //////////////////////////////////////////////////
    if([self.loginInfo.accountInfo.role isEqualToString:WCTRC_Role_Admin]==YES)
    {
        UIAlertAction *updateAction = [UIAlertAction actionWithTitle:WCTLV_MLS_Subscription style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            if (completeHandler)
            {
                completeHandler(YES);
            }
        }];
        
        [ppAlertViewController addAction:updateAction];
    }
    
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:WCTLV_MLS_OK style:UIAlertActionStyleCancel handler:nil];
    
    [ppAlertViewController addAction:cancelAction];
    
    [self presentViewController:ppAlertViewController animated:YES completion:nil];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Display Menu Method

//================================================================================
//
//================================================================================
- (void)displayRecordServerList
{
    do
    {
        NSArray *serverList = [self.loginController recordServerList];
        
        if([serverList count]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //顯示選單
        
        self.menuListSelectController = [[[PPSelectController alloc] init] autorelease];
        if(self.menuListSelectController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.menuListSelectController.delegate = self;
        self.menuListSelectController.tag = WCTLoginViewControllerSelectionControllerTag_ServerList;
        
        //////////////////////////////////////////////////
        
        // display
        NSURLComponents *displayURLComponents = [self serverRowModel].object;
        
        NSMutableArray *displayServerList = [NSMutableArray array];
        
        for(NSUInteger index=0; index<serverList.count; index++)
        {
            NSString *serverAddress = [serverList objectAtIndex:index];
            
            NSURLComponents *components = [WCTLoginController urlComponentsFromUrlPath:serverAddress];
            
            if(components==nil)
            {
                [displayServerList addObject:serverAddress];
            }
            else
            {
                NSMutableString *displayString = [NSMutableString stringWithString:@""];
                
                if([[components host] length]>0)
                {
                    displayString = [NSMutableString stringWithString:[components host]];
                }
                
                if([[components path] length]>0 &&
                   [[components path] rangeOfString:WCTLoginControllerServerName].location==NSNotFound)
                {
                    [displayString appendString:[NSString stringWithFormat:@"%@",[components path]]];
                }
                
                if(displayString!=nil)
                {
                    [displayServerList addObject:displayString];
                }
            }
            
            //////////////////////////////////////////////////
            
            if([[components host] isEqualToString:[displayURLComponents host]]==YES)
            {
                if([[components path] length]<=0 ||
                   [[components path] isEqualToString:[components path]]==YES)
                {
                    self.menuListSelectController.selectedIndex = index;
                }
            }
        }
        
        self.menuListSelectController.sourceItemStringArray = displayServerList;
        
        //////////////////////////////////////////////////
        
        self.menuListSelectController.cellFontSize = [UIFont systemFontOfSize:WCTLoginViewControllerServertListFontSize];
        
        //////////////////////////////////////////////////
        
        self.menuListSelectController.userInfo = serverList;
        
        [self.menuListSelectController showFromViewController:self animated:YES];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private RowModels Methods


//==============================================================================
//
//==============================================================================
- (NSIndexPath *)indexPathWithRow:(NSInteger)row
{
    // !! 因為只有一個section，所以用firstobject取
    PPSectionModel *sectionModel = [[self.ppSectionController sectionModelsForSearching:NO] firstObject];
    
    PPRowModel *targetRowModel = nil;
    for (PPRowModel *rowModel in sectionModel.rowModels)
    {
        if (rowModel.row==row)
        {
            targetRowModel = rowModel;
            break;
        }
    }
    
    if(targetRowModel)
    {
        return [self.ppSectionController indexPathForRowModel:targetRowModel forSearching:NO];
    }
    else
    {
        return nil;
    }
}



//================================================================================
//
//================================================================================
- (NSArray *)rowModelsForAccount
{
    NSURLComponents *components = [WCTLoginController urlComponentsFromUrlPath:self.displayServerURLAddress];
    NSURLComponents *protocolAndPortComponents = [WCTLoginController urlComponentsFromUrlPath:self.displayServerURLAddress];
    
    if([protocolAndPortComponents port]==nil)
    {
        [WCTLoginController adjustURLComponents:protocolAndPortComponents
                                      withHttps:[protocolAndPortComponents.scheme isEqualToString:@"https"]];
    }
    
    //////////////////////////////////////////////////
    
    NSArray *rowModels = @[ [PPRowModel rowModelWithRow:WCTLoginViewController_Section_Login_Row_Server
                                                   text:WCTLV_MLS_Server
                                             detailText:nil
                                                 object:components],
                            [PPRowModel rowModelWithRow:WCTLoginViewController_Section_Login_Row_ProtocolAndPort
                                                   text:@"https"
                                             detailText:nil
                                                 object:protocolAndPortComponents],
                            [PPRowModel rowModelWithRow:WCTLoginViewController_Section_Login_Row_User
                                                   text:WCTLV_MLS_User
                                             detailText:nil
                                                 object:self.accountUser],
                            [PPRowModel rowModelWithRow:WCTLoginViewController_Section_Login_Row_Password
                                                   text:WCTLV_MLS_Password
                                             detailText:nil
                                                 object:([PPSettingsController integerValueWithKey:WCTLoginViewControllerSettingKey_AutoLogin]==1?[WCTRestClientController decryptAccountPassword]:nil)],
                            [PPRowModel rowModelWithRow:WCTLoginViewController_Section_Login_Row_AutoLogin
                                                   text:WCTLV_MLS_AutoLogin
                                             detailText:nil
                                                 object:([PPSettingsController integerValueWithKey:WCTLoginViewControllerSettingKey_AutoLogin]==1?@(YES):@(NO))]];
    
    return rowModels;
}


//================================================================================
//
//================================================================================
- (PPRowModel *)protocolAndPortRowModel
{
    NSIndexPath *indexPath = [self indexPathWithRow:WCTLoginViewController_Section_Login_Row_ProtocolAndPort];
    if(indexPath==nil)
    {
        return nil;
    }
    
    PPRowModel *protocolAndPortRowModel = [self.ppSectionController rowModelAtIndexPath:indexPath
                                                                           forSearching:NO];
    
    return protocolAndPortRowModel;
}


//================================================================================
//
//================================================================================
- (PPRowModel *)serverRowModel
{
    NSIndexPath *indexPath = [self indexPathWithRow:WCTLoginViewController_Section_Login_Row_Server];
    if(indexPath==nil)
    {
        return nil;
    }
    
    PPRowModel *serverRowModel = [self.ppSectionController rowModelAtIndexPath:indexPath
                                                                  forSearching:NO];
    
    return serverRowModel;
}


//================================================================================
//
//================================================================================
- (PPRowModel *)userRowModel
{
    NSIndexPath *indexPath = [self indexPathWithRow:WCTLoginViewController_Section_Login_Row_User];
    if(indexPath==nil)
    {
        return nil;
    }
    PPRowModel *userRowModel = [self.ppSectionController rowModelAtIndexPath:indexPath
                                                                forSearching:NO];
    
    return userRowModel;
}


//================================================================================
//
//================================================================================
- (PPRowModel *)passwordRowModel
{
    NSIndexPath *indexPath = [self indexPathWithRow:WCTLoginViewController_Section_Login_Row_Password];
    if(indexPath==nil)
    {
        return nil;
    }
    PPRowModel *passwordRowModel = [self.ppSectionController rowModelAtIndexPath:indexPath
                                                                    forSearching:NO];
    
    return passwordRowModel;
}


//================================================================================
//
//================================================================================
- (PPRowModel *)rememberLoginInfoRowModel
{
    NSIndexPath *indexPath = [self indexPathWithRow:WCTLoginViewController_Section_Login_Row_AutoLogin];
    if(indexPath==nil)
    {
        return nil;
    }
    PPRowModel *rememberLoginInfoRowModel = [self.ppSectionController rowModelAtIndexPath:indexPath
                                                                             forSearching:NO];
    
    return rememberLoginInfoRowModel;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private TableViewCell Methods

//================================================================================
//
//================================================================================
- (PPTextFieldTableViewCell *)tableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    PPTextFieldTableViewCell *textFieldTableViewCell = (PPTextFieldTableViewCell *)[tableView dequeueReusableCellWithIdentifier:NSStringFromClass([PPTextFieldTableViewCell class])];
    
    if(textFieldTableViewCell==nil)
    {
        textFieldTableViewCell = [[[PPTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                                  reuseIdentifier:NSStringFromClass([PPTextFieldTableViewCell class])] autorelease];
        textFieldTableViewCell.delegate = self;
        textFieldTableViewCell.textField.dataSource = self;
    }
    
    textFieldTableViewCell.backgroundColor                  = [UIColor clearColor];
    
    [textFieldTableViewCell.textField setBorderColor:WCTLVC_TextFieldBorderColor];
    [textFieldTableViewCell.textField setBorderWidth:1.0];
    
    if([rowModel.object isKindOfClass:[NSString class]]==YES)
    {
        textFieldTableViewCell.textField.text                   = rowModel.object;
    }
    
    textFieldTableViewCell.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
    textFieldTableViewCell.textField.textColor = WCTLVC_TextFieldTextColor;
    
    if([rowModel.text length]>0)
    {
        NSAttributedString *attributedPlaceholder =
        [[NSAttributedString alloc] initWithString:rowModel.text attributes:@{NSForegroundColorAttributeName:WCTLVC_PlaceholderTextColor}];
        textFieldTableViewCell.textField.attributedPlaceholder = attributedPlaceholder;
        [attributedPlaceholder release];
    }
    
    //////////////////////////////////////////////////
    
    textFieldTableViewCell.contentInsets = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);
    
    //////////////////////////////////////////////////
    
    return textFieldTableViewCell;
    
}


//================================================================================
//
//================================================================================
- (WCTLoginTextFieldButtonTableViewCell *)buttonTableViewCellForTableView:(UITableView *)tableView
                                                                 rowModel:(PPRowModel *)rowModel
                                               reusableCellWithIdentifier:(NSString *)reusableCellWithIdentifier

{
    WCTLoginTextFieldButtonTableViewCell *buttonTableViewCell = (WCTLoginTextFieldButtonTableViewCell *)[tableView dequeueReusableCellWithIdentifier:reusableCellWithIdentifier];
    
    //////////////////////////////////////////////////
    
    if(buttonTableViewCell==nil)
    {
        buttonTableViewCell = [[[WCTLoginTextFieldButtonTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                                           reuseIdentifier:reusableCellWithIdentifier] autorelease];
    }
    
    //////////////////////////////////////////////////
    
    if(buttonTableViewCell!=nil)
    {
        buttonTableViewCell.backgroundColor                  = [UIColor clearColor];
        
        //////////////////////////////////////////////////
        
        [buttonTableViewCell.textFieldButtonView setBorderColor:WCTLVC_TextFieldBorderColor];
        [buttonTableViewCell.textFieldButtonView setBorderWidth:1.0];
        
        buttonTableViewCell.textFieldButtonView.textField.dataSource = self;
        buttonTableViewCell.textFieldButtonView.delegate = self;
        
        //////////////////////////////////////////////////
        
        if([rowModel.object isKindOfClass:[NSString class]]==YES)
        {
            buttonTableViewCell.textFieldButtonView.textField.text                   = rowModel.object;
            
        }
        else if([rowModel.object isKindOfClass:[NSURLComponents class]]==YES)
        {
            NSURLComponents *components = rowModel.object;
            
            if([[components host] length]>0)
            {
                if([[components path] length]>0)
                {
                    buttonTableViewCell.textFieldButtonView.textField.text = [[components host] stringByAppendingString:[components path]];
                }
                else
                {
                    buttonTableViewCell.textFieldButtonView.textField.text = [components host];
                }
            }
        }
        
        
        
        buttonTableViewCell.textFieldButtonView.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
        buttonTableViewCell.textFieldButtonView.textField.textColor = WCTLVC_TextFieldTextColor;
        
        if([rowModel.text length]>0)
        {
            NSAttributedString *attributedPlaceholder =
            [[NSAttributedString alloc] initWithString:rowModel.text attributes:@{NSForegroundColorAttributeName:WCTLVC_PlaceholderTextColor}];
            buttonTableViewCell.textFieldButtonView.textField.attributedPlaceholder = attributedPlaceholder;
            [attributedPlaceholder release];
        }
        
        //////////////////////////////////////////////////
        
        [buttonTableViewCell.textFieldButtonView.ppButtonDetail addControlEvents:UIControlEventTouchUpInside];
        [buttonTableViewCell.textFieldButtonView.ppButtonDetail setDelegate:self];
        
        //////////////////////////////////////////////////
        
        buttonTableViewCell.textFieldButtoViewContentInset = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);
        
    }
    
    return buttonTableViewCell;
}


//================================================================================
// MARK: 產生Protocol && Port欄位 Cell
//================================================================================
- (WCTLoginProtocolPortTextFieldButtonTableViewCell *)protocolAndServerTableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    WCTLoginProtocolPortTextFieldButtonTableViewCell *loginServerTableViewCell = [self.ppTableView dequeueReusableCellWithIdentifier:NSStringFromClass([WCTLoginProtocolPortTextFieldButtonTableViewCell class])];
    
    
    if(loginServerTableViewCell==nil)
    {
        loginServerTableViewCell = [[[WCTLoginProtocolPortTextFieldButtonTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                                                            reuseIdentifier:NSStringFromClass([WCTLoginProtocolPortTextFieldButtonTableViewCell class])] autorelease];
    }
    
    self.protocolPortCell = loginServerTableViewCell;
    //////////////////////////////////////////////////
    
    if(loginServerTableViewCell!=nil)
    {
        loginServerTableViewCell.delegate = self;
        loginServerTableViewCell.backgroundColor                  = [UIColor clearColor];
        
        //////////////////////////////////////////////////
        
        NSURLComponents *components = [self protocolAndPortRowModel].object;
        
        if([[components scheme] length]<=0)
        {
            components.scheme = @"https";
        }
        
        //////////////////////////////////////////////////
        
        loginServerTableViewCell.portTextField.dataSource = self;
        
        if([[components port] integerValue]>0)
        {
            loginServerTableViewCell.portTextField.text = [NSString stringWithInteger:[[components port] integerValue]];
        }
        else
        {
            if([components.scheme isEqualToString:@"https"]==YES)
            {
                loginServerTableViewCell.portTextField.text = [NSString stringWithInteger:WCTLC_HttpsPort];
            }
            else
            {
                loginServerTableViewCell.portTextField.text = [NSString stringWithInteger:WCTLC_HttpPort];
            }
        }
        
        loginServerTableViewCell.protocolHttpsSwitch.on = [[components scheme] isEqualToString:@"https"];
        
        //////////////////////////////////////////////////
        
        loginServerTableViewCell.textFieldButtoViewContentInset = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);
        
    }
    
    return loginServerTableViewCell;
}


//================================================================================
//
//================================================================================
- (WCTLoginTextFieldButtonTableViewCell *)serverTableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    WCTLoginTextFieldButtonTableViewCell *textFieldTableViewCell = [self buttonTableViewCellForTableView:tableView rowModel:rowModel reusableCellWithIdentifier:NSStringFromClass([WCTLoginTextFieldButtonTableViewCell class])];
    
    textFieldTableViewCell.textFieldButtonView.textField.keyboardType = UIKeyboardTypeEmailAddress;
    
    return textFieldTableViewCell;
}


//================================================================================
//
//================================================================================
- (PPTextFieldTableViewCell *)userTableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    PPTextFieldTableViewCell *textFieldTableViewCell = [self tableViewCellForTableView:tableView rowModel:rowModel];
    
    textFieldTableViewCell.textField.keyboardType = UIKeyboardTypeEmailAddress;
    
    return textFieldTableViewCell;
}


//================================================================================
//
//================================================================================
- (WCTLoginTextFieldButtonTableViewCell *)passwordTableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    WCTLoginTextFieldButtonTableViewCell *passwordTableViewCell = (WCTLoginTextFieldButtonTableViewCell *)[self buttonTableViewCellForTableView:tableView rowModel:rowModel reusableCellWithIdentifier:[NSStringFromClass([WCTLoginTextFieldButtonTableViewCell class]) stringByAppendingString:@"Password"]];
    
    //////////////////////////////////////////////////
    
    if(passwordTableViewCell!=nil)
    {
        passwordTableViewCell.textFieldButtonView.textField.secureTextEntry = self.secureTextEntry;
        
        if(self.secureTextEntry==YES)
        {
            passwordTableViewCell.textFieldButtonView.ppButtonDetail.tag = WCTLoginViewControllerButtonTag_HidePassword;
            [passwordTableViewCell.textFieldButtonView.ppButtonDetail setImageWithName:ImageNameWCTLoginViewControllerButtonShowPassword];
        }
        else
        {
            passwordTableViewCell.textFieldButtonView.ppButtonDetail.tag = WCTLoginViewControllerButtonTag_ShowPassword;
            [passwordTableViewCell.textFieldButtonView.ppButtonDetail setImageWithName:ImageNameWCTLoginViewControllerButtonHidePassword];
        }
    }
    
    return passwordTableViewCell;
}


//================================================================================
//
//================================================================================
- (PPTableViewCell *)switchTableViewCellForTableView:(UITableView *)tableView rowModel:(PPRowModel *)rowModel
{
    PPSwitchTableViewCell *switchTableViewCell = (PPSwitchTableViewCell *)[tableView dequeueReusableCellWithIdentifier:NSStringFromClass([PPSwitchTableViewCell class])];
    
    if(switchTableViewCell==nil)
    {
        switchTableViewCell = [[[PPSwitchTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1
                                                            reuseIdentifier:NSStringFromClass([PPSwitchTableViewCell class])] autorelease];
        switchTableViewCell.delegate = self;
    }
    
    switchTableViewCell.backgroundColor     = [UIColor clearColor];
    switchTableViewCell.switchControl.on    = ((NSNumber *)rowModel.object).boolValue;
    switchTableViewCell.textLabel.text      = rowModel.text;
    switchTableViewCell.textLabel.textColor = WCTLVC_TextFieldTextColor;
    switchTableViewCell.textLabel.textAlignment = NSTextAlignmentRight;
    switchTableViewCell.textLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerAutoLoginButtonFontSize];
    
    //////////////////////////////////////////////////
    
    switchTableViewCell.contentInsets = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);
    
    //////////////////////////////////////////////////
    
    return switchTableViewCell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private ViewController Transition Methods

//================================================================================
//
//================================================================================
- (void)pushViewController:(UIViewController *)viewController animated:(BOOL)animated
{
    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        if([[[[UIApplication sharedApplication] keyWindow] rootViewController] isKindOfClass:[UISplitViewController class]]==YES)
        {
            UISplitViewController *splitViewController = (UISplitViewController *)[[[UIApplication sharedApplication] keyWindow] rootViewController];
            
            UINavigationController *navigationController = [[UINavigationController alloc] initWithRootViewController:viewController];
            
            if(splitViewController!=nil && navigationController!=nil)
            {
                splitViewController.viewControllers = @[[splitViewController.viewControllers firstObject],navigationController];
            }
            
            [navigationController release];
        }
    }
    else
    {
        [self.navigationController pushViewController:viewController animated:YES];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Show Error Message

//================================================================================
//
//================================================================================
- (void)showToastForError:(NSError *)error
{
    do
    {
        if(error==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        BOOL showError = YES;
        
        if([self.delegate respondsToSelector:@selector(loginViewControllerShouldShowError:)]==YES)
        {
            showError = [self.delegate loginViewControllerShouldShowError:error];
        }
        
        if(showError==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *message = nil;
        
        if([self.delegate respondsToSelector:@selector(loginViewControllerRequestMessageForError:)]==YES)
        {
            message = [self.delegate loginViewControllerRequestMessageForError:error];
        }
        
        if([message length]<=0)
        {
            message = (error.localizedRecoverySuggestion!=nil?error.localizedRecoverySuggestion:error.localizedFailureReason);
        }
        
        //////////////////////////////////////////////////
        
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:message
                                                position:PPToastPositionCenter];
        
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Public


//==============================================================================
//
//==============================================================================
- (NSString *)loginURLString
{
    NSURLComponents *urlComponents = [self urlComponentsForLogin];
    if([[urlComponents host] length]==0)
    {
        return nil;
    }
    return [WCTLoginController urlPathFromUrlComponents:urlComponents];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Methods

//================================================================================
//
//================================================================================
- (void)keyboardWillShowNotification:(NSNotification *)notification
{
    [super keyboardWillShowNotification:notification];
    
    //////////////////////////////////////////////////
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationCurve:[[[notification userInfo] objectForKey:UIKeyboardAnimationCurveUserInfoKey] intValue]];
    [UIView setAnimationDuration:[[[notification userInfo] objectForKey:UIKeyboardAnimationDurationUserInfoKey] doubleValue]];
    
    CGRect keyboardRectBegin    = CGRectZero;
    CGRect keyboardRectEnd      = CGRectZero;
    
    [[[notification userInfo] objectForKey:UIKeyboardFrameBeginUserInfoKey] getValue:&keyboardRectBegin];
    [[[notification userInfo] objectForKey:UIKeyboardFrameEndUserInfoKey] getValue:&keyboardRectEnd];
    
    //////////////////////////////////////////////////
    
    CGRect editTableViewFrame = [self layoutFrame];
    
    //Howard IOS7鍵盤在不同方向,寬高都是同方向
    switch(self.interfaceOrientation)
    {
        case UIInterfaceOrientationLandscapeLeft:
        case UIInterfaceOrientationLandscapeRight:
        {
            editTableViewFrame.size.height = editTableViewFrame.size.height-keyboardRectEnd.size.width-self.logoImageView.frame.size.height-WCTLoginViewControllerTableViewEdgeInsets.top;
            
            break;
        }
        case UIInterfaceOrientationPortrait:
        case UIInterfaceOrientationPortraitUpsideDown:
        default:
        {
            editTableViewFrame.size.height = editTableViewFrame.size.height-keyboardRectEnd.size.height-self.logoImageView.frame.size.height-WCTLoginViewControllerTableViewEdgeInsets.top;
            
            break;
        }
    }
    
    //////////////////////////////////////////////////
    
    editTableViewFrame.size.width = self.view.bounds.size.width-WCTLoginViewControllerTableViewEdgeInsets.left-WCTLoginViewControllerTableViewEdgeInsets.right;
    
    editTableViewFrame.origin.x   = WCTLoginViewControllerTableViewEdgeInsets.left;
    editTableViewFrame.origin.y   = self.logoImageView.frame.origin.y+self.logoImageView.frame.size.height+WCTLoginViewControllerTableViewEdgeInsets.top;
    
    //////////////////////////////////////////////////
    
    self.ppTableView.frame = editTableViewFrame;
    
    [UIView commitAnimations];
    
    //////////////////////////////////////////////////
    
    if(self.ppTableView.contentSize.height>self.ppTableView.bounds.size.height)
    {
        NSArray *cells = [self.ppTableView visibleCells];
        
        for (UITableViewCell *cell in cells)
        {
            UIView *firstResponderView = [cell firstResponderView];
            if(firstResponderView!=nil)
            {
                [self.ppTableView scrollToRowAtIndexPath:[self.ppTableView indexPathForCell:cell]
                                        atScrollPosition:UITableViewScrollPositionMiddle
                                                animated:YES];
                
                break;
            }
        }
    }
}

//================================================================================
//
//================================================================================
- (void)keyboardWillHideNotification:(NSNotification *)notification
{
    CGRect layoytFrame = [self layoutFrame];
    
    layoytFrame.size.width = self.view.bounds.size.width-WCTLoginViewControllerTableViewEdgeInsets.left-WCTLoginViewControllerTableViewEdgeInsets.right;
    
    layoytFrame.origin.x   = WCTLoginViewControllerTableViewEdgeInsets.left;
    layoytFrame.origin.y   = self.logoImageView.frame.origin.y+self.logoImageView.frame.size.height+WCTLoginViewControllerTableViewEdgeInsets.top;
    
    layoytFrame.size.height = self.view.bounds.size.height-self.logoImageView.frame.size.height-WCTLoginViewControllerTableViewEdgeInsets.top-WCTLoginViewControllerTableViewEdgeInsets.bottom-WCTLoginViewControllerLoginButtonHeight;
    
    self.ppTableView.frame = layoytFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    UIView *firstResponderView = [self.ppTableView firstResponderView];
    
    if(firstResponderView!=nil)
    {
        [firstResponderView resignFirstResponder];
    }
    
    //////////////////////////////////////////////////
    
    switch(ppButton.tag)
    {
            // MARK: 按登入按鈕
        case WCTLoginViewControllerButtonTag_Login:
        {
            do
            {
                if(self.loginController==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                [self loginStarted];
            }
            while (0);
            
            
            break;
        }
        case WCTLoginViewControllerButtonTag_ReportProblem:
        {
            // MARK: 使用手冊
            if([self.delegate respondsToSelector:@selector(loginViewControllerDidReportProblem:)]==YES)
            {
                [self.delegate loginViewControllerDidReportProblem:self];
            }
            
            break;
        }
        case WCTLoginViewControllerButtonTag_DropServerList:
        {
            // MARK: 顯示紀錄的伺服器列表
            
            [self displayRecordServerList];
            
            break;
        }
        case WCTLoginViewControllerButtonTag_HidePassword:
        {
            // MARK: 隱藏密碼
            self.secureTextEntry = !self.secureTextEntry;
            NSIndexPath *indexPath = [self indexPathWithRow:WCTLoginViewController_Section_Login_Row_Password];
            if(indexPath==nil)
            {
                break;
            }
            [self.ppTableView reloadRowsAtIndexPaths:@[indexPath]
                                    withRowAnimation:UITableViewRowAnimationNone];
            
            break;
        }
        case WCTLoginViewControllerButtonTag_ShowPassword:
        {
            // MARK: 顯示密碼
            self.secureTextEntry = !self.secureTextEntry;
            NSIndexPath *indexPath = [self indexPathWithRow:WCTLoginViewController_Section_Login_Row_Password];
            if(indexPath==nil)
            {
                break;
            }
            [self.ppTableView reloadRowsAtIndexPaths:@[indexPath]
                                    withRowAnimation:UITableViewRowAnimationNone];
            
            break;
        }
        case WCTLoginViewControllerButtonTag_ForgetPassword:
        {
            // MARK: 忘記密碼
            
            NSError *error = nil;
            
            do
            {
                ForgetPasswordWebViewController *forgetPasswordWebViewController = [[[ForgetPasswordWebViewController alloc] init] autorelease];
                
                if(forgetPasswordWebViewController==nil)
                {
                    break;
                }
                
                forgetPasswordWebViewController.forgetPasswordDelegate = self;
                
                //////////////////////////////////////////////////
                
                NSURLComponents *serverComponents = [self serverRowModel].object;
                NSURLComponents *protocolAndPortComponents = [self protocolAndPortRowModel].object;
                
                serverComponents.port = protocolAndPortComponents.port;
                serverComponents.scheme = protocolAndPortComponents.scheme;
                
                NSURL *url = [self.loginController forgetPasswordURLWithUrlString:[WCTLoginController urlPathFromUrlComponents:serverComponents]
                                                                            error:nil];
                
                if(url==nil)
                {
                    break;
                }
                
                forgetPasswordWebViewController.hidesBottomBarWhenPushed    = YES;
                forgetPasswordWebViewController.request                     = [NSURLRequest requestWithURL:url                                                                               cachePolicy:NSURLRequestUseProtocolCachePolicy
                                                                                           timeoutInterval:PPWebViewDefaultRequestURLTimeout];
                forgetPasswordWebViewController.forceOpenHttps              = YES;
                
                forgetPasswordWebViewController.webTitle                    = WCTLV_MLS_ForgetPassword;
                forgetPasswordWebViewController.acceptURL                   = [url absoluteString];
                
                //////////////////////////////////////////////////
                
                if(self.splitViewController!=nil)
                {
                    [self pushViewController:forgetPasswordWebViewController animated:YES];
                }
                else
                {
                    PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:forgetPasswordWebViewController];
                    
                    if(navigationController==nil)
                    {
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    [self presentViewController:navigationController
                                       animated:YES
                                     completion:nil];
                    
                    [navigationController release];
                }
            }
            while (0);
            
            //////////////////////////////////////////////////
            
            if(error!=nil)
            {
                [WCToastController showMessageToastFromSuperView:self.view
                                                     withMessage:error.localizedFailureReason
                                                        position:PPToastPositionCenter];
            }
            
            break;
        }
        case WCTLoginViewControllerButtonTag_DeviceID:
        {
            // MARK: 傳送裝置ID
            
            do
            {
                __block NSString *message = [NSString stringWithFormat:@"%@: %@\n",WCTLV_MLS_DeviceName,[[UIDevice currentDevice] name]];
                
                message = [message stringByAppendingString:[NSString stringWithFormat:@"%@: %@",WCTLV_MLS_DeviceID, [PPSupportController systemUUID]]];
                
                //////////////////////////////////////////////////
                
                __block typeof(self) blockself = self;
                
                UIAlertAction *sendMailAction = [UIAlertAction actionWithTitle:WCTLV_MLS_Send style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                    
                    if([PPMailComposeViewController canSendMail]==YES)
                    {
                        PPMailComposeViewController *ppMailComposeViewController = [[PPMailComposeViewController alloc] init];
                        
                        if(ppMailComposeViewController!=nil)
                        {
                            //設定標題
                            NSString *subject = [NSString stringWithFormat:@"WorldCard Team (%@)", WCTLV_MLS_DeviceNameAndID];
                            [ppMailComposeViewController setSubject:subject];
                            
                            ////////////////////////////////////////////////////////////////////////////////////////////////////
                            
                            NSString *messageBody = message;
                            
                            [ppMailComposeViewController setMessageBody:messageBody isHTML:NO];
                            
                            [blockself presentViewController:ppMailComposeViewController animated:YES completion:nil];
                            
                            [ppMailComposeViewController release];
                        }
                    }
                    else
                    {
                        [WCToastController showMessageToastFromSuperView:blockself.view
                                                             withMessage:NSLocalizedString(@"MLS_FailedToOpenEmail", nil)
                                                                position:PPToastPositionCenter];
                    }
                }];
                
                if(sendMailAction==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                UIAlertAction *copyAction = [UIAlertAction actionWithTitle:WCTLV_MLS_Copy style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                    
                    [UIPasteboard generalPasteboard].string = message;
                    
                }];
                
                if(copyAction==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:WCTLV_MLS_Cancel style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                    
                    
                }];
                
                if(cancelAction==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                
                PPAlertController *alertController = [PPAlertController alertControllerWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                                                                          title:WCTLV_MLS_DeviceNameAndID
                                                                                                        message:message
                                                                                                    alertAction:sendMailAction,copyAction,cancelAction,nil];
                
                if(alertController==nil)
                {
                    break;
                }
                
                [self presentViewController:alertController animated:YES completion:nil];
            }
            while (0);
            
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSwitchTableViewCellDelegate

//================================================================================
//
//================================================================================
- (void)ppSwitchTableViewCellValueChanged:(PPSwitchTableViewCell *)switchTableViewCell
{
    do
    {
        NSIndexPath *indexPath = [self.ppTableView indexPathForCell:switchTableViewCell];
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rowModel.object = [NSNumber numberWithBool:switchTableViewCell.switchControl.on];
        
        //////////////////////////////////////////////////
        
        if([rowModel.text isEqualToString:WCTLV_MLS_AutoLogin]==YES)
        {
            self.autoLoginAccount = switchTableViewCell.switchControl.on;
        }
        
    }while(0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldTableViewCellDelegate

//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldTableViewCellShouldBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    BOOL result = NO;
    
    do
    {
        NSIndexPath *indexPath = [self.ppTableView indexPathForCell:textFieldTableViewCell];
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.selectedIndexPath = indexPath;
        result = YES;
        
    }while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    do
    {
        NSIndexPath *indexPath = [self.ppTableView indexPathForCell:textFieldTableViewCell];
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rowModel.object = textFieldTableViewCell.textField.text;
        
        //////////////////////////////////////////////////
        
        [self checkCanLogin];
        
        
    }while(0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldButtonView Delegate Method

//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldButtonViewShouldBeginEditing:(PPTextFieldButtonView *)textFieldButtonView
{
    BOOL result = NO;
    NSUInteger section = 0;
    NSUInteger row = 0;
    
    for(PPSectionModel *sectionModel in [self.ppSectionController sectionModelsForDefault])
    {
        section = [[self.ppSectionController sectionModelsForDefault] indexOfObject:sectionModel];
        
        for(PPRowModel *rowModel in sectionModel.rowModels)
        {
            NSIndexPath *indexPath = [self indexPathWithRow:rowModel.row];
            if(indexPath==nil)
            {
                break;
            }
            
            UITableViewCell *tableViewCell = [self.ppTableView cellForRowAtIndexPath:indexPath];
            
            if([tableViewCell isKindOfClass:[WCTLoginTextFieldButtonTableViewCell class]]==YES)
            {
                WCTLoginTextFieldButtonTableViewCell *textFieldButtonCell = (WCTLoginTextFieldButtonTableViewCell *)tableViewCell;
                
                if(textFieldButtonCell.textFieldButtonView!=textFieldButtonView)
                {
                    continue;
                }
                
                //////////////////////////////////////////////////
                
                self.selectedIndexPath = indexPath;
                
                result = YES;
                
                break;
            }
            else if([tableViewCell isKindOfClass:[WCTLoginProtocolPortTextFieldButtonTableViewCell class]]==YES)
            {
                self.selectedIndexPath = indexPath;
                
                result = YES;
                
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(result==YES)
        {
            break;
        }
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldButtonView:(PPTextFieldButtonView *)textFieldButtonView shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    BOOL result = YES;
    
    do
    {
        NSIndexPath *indexPath = nil;
        
        for(UITableViewCell *tableViewCell in [self.ppTableView visibleCells])
        {
            if(tableViewCell.contentView==textFieldButtonView.superview)
            {
                indexPath = [self.ppTableView indexPathForCell:tableViewCell];
                break;
            }
        }
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // serverTextTextField
        if([[rowModel object] isKindOfClass:[NSURLComponents class]]==YES)
        {
            result = (([string rangeOfString:@":"].location==NSNotFound)&&
                      ([string rangeOfString:@" "].location==NSNotFound))?YES:NO;
        }
        
    }while(0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldButtonViewDidChanged:(PPTextFieldButtonView *)textFieldButtonView
{
    do
    {
        NSIndexPath *indexPath = nil;
        
        for(UITableViewCell *tableViewCell in [self.ppTableView visibleCells])
        {
            if(tableViewCell.contentView==textFieldButtonView.superview)
            {
                indexPath = [self.ppTableView indexPathForCell:tableViewCell];
                break;
            }
        }
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([[rowModel object] isKindOfClass:[NSURLComponents class]]==YES)
        {
            NSURLComponents *components = rowModel.object;
            
            NSURLComponents *newServerComponets = [WCTLoginController urlComponentsFromUrlPath:textFieldButtonView.textField.text];
            
            if([[newServerComponets host] length]>0)
            {
                components.host = newServerComponets.host;
                components.path = newServerComponets.path;
            }
            else if([[newServerComponets path] length]>0)
            {
                components.host = newServerComponets.path;
            }
            
            if ([[newServerComponets host] length]==0 && [[newServerComponets path] length]==0) {
                components.host=nil;
                components.path=nil;
            }
            
            components.scheme = newServerComponets.scheme;
            components.port = newServerComponets.port;
            
            [self serverRowModel].object = components;
        }
        else
        {
            rowModel.object = textFieldButtonView.textField.text;
        }
        
        //////////////////////////////////////////////////
        
        [self checkCanLogin];
        
        //////////////////////////////////////////////////
        
        //  如果是公有雲，修改server欄位時，要順便修正port
        if ([rowModel row]==WCTLoginViewController_Section_Login_Row_Server)
        {
            if (self.protocolPortCell)
            {
                NSURLComponents *serverComponents = [[self serverRowModel] object];
                NSURLComponents *portComponents = [[self protocolAndPortRowModel] object];
                portComponents.host = serverComponents.host;
                [WCTLoginController adjustURLComponents:portComponents withHttps:self.protocolPortCell.protocolHttpsSwitch.on];
                self.protocolPortCell.portTextField.text = [NSString stringWithInteger:[[portComponents port] integerValue]];;
            }
        }
        
    }while(0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSelectControllerDelegate

//================================================================================
//
//================================================================================
- (void)ppSelectController:(PPSelectController *)selectController itemSelectedIndex:(NSInteger)itemIndex withString:(NSString *)itemString
{
    // MARK: 選擇紀錄伺服器位置
    if(selectController.tag==WCTLoginViewControllerSelectionControllerTag_ServerList)
    {
        do
        {
            NSArray *serverUrlList = [self.loginController recordServerList];
            
            if(itemIndex>=serverUrlList.count)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSString *candidatedTitle = [serverUrlList objectAtIndex:itemIndex];
            
            //////////////////////////////////////////////////
            
            [self serverRowModel].object = [WCTLoginController urlComponentsFromUrlPath:candidatedTitle];
            [self protocolAndPortRowModel].object = [WCTLoginController urlComponentsFromUrlPath:candidatedTitle];
            
            [self checkCanLogin];
            
            //////////////////////////////////////////////////
            
            [self.ppTableView performSelectorOnMainThread:@selector(reloadData) withObject:nil waitUntilDone:NO];
        }
        while (0);
    }
}


//================================================================================
//
//================================================================================
- (void)ppSelectControllerDidDismiss:(PPSelectController *)selectController
{
    self.menuListSelectController = nil;
}



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CustomRectTextFieldDataSource

//================================================================================
//
//================================================================================
- (CGRect)placeholderRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField
{
    if(customRectTextField.tag==WCTLoginViewControllerTextFieldTag_Port)
    {
        return bounds;
    }
    else
    {
        return CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-10, bounds.size.height), 5, 0);
    }
}


//================================================================================
//
//================================================================================
- (CGRect)textRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
{
    if(customRectTextField.tag==WCTLoginViewControllerTextFieldTag_Protocol ||
       customRectTextField.tag==WCTLoginViewControllerTextFieldTag_Port)
    {
        return bounds;
    }
    else if(customRectTextField.tag==WCTLoginViewControllerTextFieldTag_URL)
    {
        return CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-5, bounds.size.height), 5, 0);
    }
    else
    {
        return CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-10, bounds.size.height), 5, 0);
    }
}


//================================================================================
//
//================================================================================
- (CGRect)editingRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
{
    return  CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-20, bounds.size.height), 5, 0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ForgetPasswordWebViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (BOOL)forgetPasswordWebViewControllerShouldShowError:(NSError *)error
{
    BOOL showError = YES;
    
    if([self.delegate respondsToSelector:@selector(loginViewControllerShouldShowError:)]==YES)
    {
        showError = [self.delegate loginViewControllerShouldShowError:error];
    }
    
    return showError;
}


//================================================================================
//
//================================================================================
- (NSString *)forgetPasswordWebViewControlerRequestMessageForError:(NSError *)error
{
    NSString *errorMessage = nil;
    NSError *customError = nil;
    
    // find host要客制錯誤
    if([error.domain isEqualToString:NSURLErrorDomain]==YES &&
       error.code==NSURLErrorCannotFindHost)
    {
        customError = PPErrorMake(WCTLoginViewControllerErrorCode_CannotFindHost, WCTLV_MLS_FailedToConnectServer, error);
    }
    else
    {
        customError = error;
    }
    
    if([self.delegate respondsToSelector:@selector(loginViewControllerRequestMessageForError:)]==YES)
    {
        errorMessage = [self.delegate loginViewControllerRequestMessageForError:customError];
    }
    
    return errorMessage;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *tableViewCell = nil;
    
    PPRowModel *rowModel = nil;
    
    do
    {
        rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(indexPath.section==WCTLoginViewController_Section_Login)
        {
            switch(rowModel.row)
            {
                case WCTLoginViewController_Section_Login_Row_ProtocolAndPort:
                {
                    tableViewCell = [self protocolAndServerTableViewCellForTableView:tableView rowModel:rowModel];
                    
                    tableViewCell.selectionStyle = UITableViewCellSelectionStyleNone;
                    
                    break;
                }
                case WCTLoginViewController_Section_Login_Row_Server:
                {
                    tableViewCell = [self serverTableViewCellForTableView:tableView rowModel:rowModel];
                    
                    tableViewCell.selectionStyle = UITableViewCellSelectionStyleNone;
                    
                    break;
                }
                case WCTLoginViewController_Section_Login_Row_Password:
                {
                    tableViewCell = [self passwordTableViewCellForTableView:tableView rowModel:rowModel];
                    
                    tableViewCell.selectionStyle = UITableViewCellSelectionStyleNone;
                    
                    break;
                }
                case WCTLoginViewController_Section_Login_Row_AutoLogin:
                {
                    tableViewCell = [self switchTableViewCellForTableView:tableView rowModel:rowModel];
                    
                    tableViewCell.selectionStyle = UITableViewCellSelectionStyleNone;
                    
                    break;
                }
                case WCTLoginViewController_Section_Login_Row_User:
                {
                    tableViewCell = [self userTableViewCellForTableView:tableView rowModel:rowModel];
                    
                    tableViewCell.selectionStyle = UITableViewCellSelectionStyleNone;
                    
                    break;
                }
                default:
                {
                    tableViewCell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([UITableViewCell class])];
                    
                    if(tableViewCell==nil)
                    {
                        tableViewCell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([UITableViewCell class])] autorelease];
                    }
                    
                    tableViewCell.textLabel.text = rowModel.text;
                    tableViewCell.textLabel.textColor = WCTLVC_TextFieldTextColor;
                    tableViewCell.textLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerForgetPasswordButtonFontSize];
                    tableViewCell.textLabel.textAlignment = NSTextAlignmentRight;
                    
                    break;
                }
            }
        }
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(tableViewCell==nil)
    {
        tableViewCell = [self tableViewCellForTableView:tableView rowModel:rowModel];
    }
    
    return tableViewCell;
}


//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    NSInteger numberOfSection = 1;
    
    if(tableView.tag==WCTLoginViewControllerTableViewTag_LoginForm)
    {
        numberOfSection = [self.ppSectionController numberOfSectionsForSearching:NO];
    }
    
    return numberOfSection;
}

//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRowsInSection = 0;
    
    if(tableView.tag==WCTLoginViewControllerTableViewTag_LoginForm)
    {
        numberOfRowsInSection = [self.ppSectionController numberOfRowsInSection:section forSearching:NO];
    }
    else
    {
        numberOfRowsInSection = [[self.loginController recordServerList] count];
    }
    
    return numberOfRowsInSection;
}

//================================================================================
//
//================================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    if(tableView.tag==WCTLoginViewControllerTableViewTag_LoginForm)
    {
        return [self.ppSectionController titleForHeaderInSection:section forSearching:NO];
    }
    else
    {
        return @"";
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate

//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0;
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if(tableView.tag==WCTLoginViewControllerTableViewTag_LoginForm)
    {
        return WCTLoginViewControllerLoginButtonHeight;
    }
    else
    {
        return WCTLoginViewControllerServerListViewCellHeight;
    }
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTPasswordViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSString *)passwordViewController:(WCTPasswordViewController *)passwordViewController
        requestErrorMessageWithError:(NSError *)error
{
    
    BOOL shouldShowError = YES;
    NSString *message = nil;
    if ([self.delegate respondsToSelector:@selector(loginViewControllerShouldShowError:)])
    {
        shouldShowError = [self.delegate loginViewControllerShouldShowError:error];
    }
    
    if ([self.delegate respondsToSelector:@selector(loginViewControllerRequestMessageForError:)])
    {
        message = [self.delegate loginViewControllerRequestMessageForError:error];
    }
    
    if (shouldShowError==YES)
    {
        if ([self.delegate respondsToSelector:@selector(loginViewControllerRequestMessageForError:)])
        {
            return [self.delegate loginViewControllerRequestMessageForError:error];
        }
    }
    else
    {
        PPAlertController *alertController = [PPAlertController alertControllerWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                                                                  title:@""
                                                                                                message:message
                                                                                            alertAction:[UIAlertAction actionWithTitle:@"OK"
                                                                                                                                 style:UIAlertActionStyleDefault
                                                                                                                               handler:^(UIAlertAction * _Nonnull action) {
            
            [passwordViewController dismissAnimated:YES completion:nil];
        }], nil];
        [passwordViewController presentViewController:alertController animated:YES completion:nil];
        return nil;
    }
    
    return nil;
}


//================================================================================
//
//================================================================================
- (void)passwordViewController:(WCTPasswordViewController *)passwordViewController didChangeWithNewPassword:(NSString *)newPassword
{
    //更新密碼
    
    __block typeof(self) blockSelf = self;
    
    [passwordViewController dismissAnimated:YES completion:^{
        
        dispatch_async(dispatch_get_main_queue(), ^{
            if (blockSelf.changePwdCompleteHandler)
            {
                blockSelf.changePwdCompleteHandler();
            }
        });
    }];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTLoginProtocolPortTextFieldButtonTableViewCellDelegate Method

//================================================================================
//
//================================================================================
- (void)loginURLTextFieldButtonTableViewCellTextDidChanged:(WCTLoginProtocolPortTextFieldButtonTableViewCell *)loginURLTextFieldButtonTableViewCell
{
    NSNumber *portNumber = nil;
    
    if([loginURLTextFieldButtonTableViewCell.portTextField.text length]>0)
    {
        portNumber = [NSNumber numberWithInteger:[loginURLTextFieldButtonTableViewCell.portTextField.text integerValue]];
    }
    
    NSURLComponents *components = [self protocolAndPortRowModel].object;
    components.port = portNumber;
    
    //////////////////////////////////////////////////
    
    [self checkCanLogin];
}


//================================================================================
// MARK: Protocol 異動
//================================================================================
- (void)loginURLTextFieldButtonTableViewCellSwitchValueDidChanged:(WCTLoginProtocolPortTextFieldButtonTableViewCell *)loginURLTextFieldButtonTableViewCell
{
    NSURLComponents *serverComponents = [[self serverRowModel] object];
    NSURLComponents *portComponents = [[self protocolAndPortRowModel] object];
    portComponents.host = serverComponents.host;
    [WCTLoginController adjustURLComponents:portComponents withHttps:loginURLTextFieldButtonTableViewCell.protocolHttpsSwitch.on];
    
    
    //////////////////////////////////////////////////
    
    [self checkCanLogin];
    
    //////////////////////////////////////////////////
    
    [self.ppTableView performSelectorOnMainThread:@selector(reloadData) withObject:nil waitUntilDone:NO];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (BOOL)loginViewControllerIsVisible
{
    return [[self topMostViewController] isKindOfClass:[self class]];
}

@end
