//
//  WCTAdvanceSearchModel.m
//  ADAL
//
//  Created by sanhue on 2018/4/10.
//

#import "WCTAdvancedSearchModel.h"

@interface WCTAdvancedSearchModel()

@property (nonatomic, retain, readwrite, nullable) NSMutableArray *accountConditions;
@property (nonatomic, retain, readwrite, nullable) NSMutableArray *customFieldConditions;

@end



////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTAdvancedSearchModel





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.accountConditions = [NSMutableArray array];
        self.customFieldConditions = [NSMutableArray array];

    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.accountConditions = nil;
    self.customFieldConditions = nil;

    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (NSString *)description
{
    NSMutableString *msg = [[NSMutableString alloc] initWithString:[super description]];

    
    if(self.accountConditions.count>0)
    {
        [msg appendFormat:@"\r\n ❗️❗️❗️accountConditions:%@", self.accountConditions];
    }
    
    if(self.customFieldConditions.count>0)
    {
        [msg appendFormat:@"\r\n ❗️❗️❗️customFieldConditions:%@", self.customFieldConditions];
    }
    
    [msg appendString:@"\r\n"];
    
    //////////////////////////////////////////////////
    
    return [msg autorelease];
}


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - NSCopying


//==============================================================================
//
//==============================================================================
- (id)copyWithZone:(nullable NSZone *)zone
{
    id searchModel =  [super copyWithZone:zone];
    ((WCTAdvancedSearchModel *)searchModel).accountConditions = [[self.accountConditions mutableCopyWithZone:zone] autorelease];
    ((WCTAdvancedSearchModel *)searchModel).customFieldConditions = [[self.customFieldConditions mutableCopyWithZone:zone] autorelease];

    return searchModel;
}



@end


