//
//  WCTAdvancedSearchModel+WCTRCAdvancedSearchInfo.m
//  ADAL
//
//  Created by sanhue on 2018/5/4.
//

#import "WCTAdvancedSearchModel+WCTRCAdvancedSearchInfo.h"
#import "WCTSearchOptionModel+WCTRCSearchConditions.h"
#import "NSDate+Format.h"
#import "WCTRestClient+ParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTAdvancedSearchModel (WCTRCAdvancedSearchInfo)





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - convert methods


//==============================================================================
//
//==============================================================================
- (WCTRCAdvancedSearchInfo *)advancedSearchInfo
{
    WCTRCAdvancedSearchInfo *searchInfo = [[[WCTRCAdvancedSearchInfo alloc] init] autorelease];
    
    if([self.accountConditions count]>0)
    {
        // 目前只支援一組account
        WCTSearchOptionModel *searchOptionModel = [self.accountConditions firstObject];
        NSString *fieldString = [WCTSearchOptionModel searchFieldFromSearchType:(WCTSearchType)searchOptionModel.searchType];
        [searchInfo addConditionWithFieldString:fieldString accountGuids:searchOptionModel.accountGuids];
    }
    
    if ([self.categoryConditions count]>0)
    {
        // 目前只支援一組類別
        WCTSearchOptionModel *searchOptionModel = [self.categoryConditions firstObject];
        [searchInfo addConditionWithCategoryGuids:searchOptionModel.groupGuids];
    }

    if ([self.dateConditions count]>0)
    {
        // 目前只支援一組時間
        WCTSearchOptionModel *searchOptionModel = [self.dateConditions firstObject];
        NSString *fieldString = [WCTSearchOptionModel searchFieldFromSearchType:(WCTSearchType)searchOptionModel.searchType];
        NSString *beginTime = [[searchOptionModel.fromDate stringWithFormat:WCTRestClient_ServerDateFormat_Day] stringByAppendingString:@" 00:00:00.000"];
        NSString *endTime = [[searchOptionModel.toDate stringWithFormat:WCTRestClient_ServerDateFormat_Day] stringByAppendingString:@" 23:59:59.999"];

        [searchInfo addConditionWithFieldString:fieldString beginTime:beginTime endTime:endTime];
    }

    if ([self.contactInfoConditions count]>0)
    {
        for (WCTSearchOptionModel *optionModel in self.contactInfoConditions)
        {
            WCTRCAdvancedSearchContactSearchInfo *contactSearchInfo = [optionModel advanceSearchContactSearchInfo];
            [searchInfo addConditionWithContactSearchInfo:contactSearchInfo];
        }
    }

    if ([self.customFieldConditions count]>0)
    {
        for (WCTSearchOptionModel *optionModel in self.customFieldConditions)
        {
            WCTRCAdvancedSearchCustomFieldSearchInfo *customFieldSearchInfo = [optionModel advanceSearchCustomFieldSearchInfo];
            [searchInfo addConditionWithCustomFieldSearchInfo:customFieldSearchInfo];
        }
    }

    return searchInfo;
}



@end
