//
//  WCGroupModel+WCTRCCategoryInfo.m
//  
//
//  Created by Howard on 2016/5/18.
//
//

#import "WCGroupModel+WCTRCCategoryInfo.h"

// Define
#import "WCGroupDefine.h"
#import "WCTRestObject+ParameterDefine.h"

@implementation WCGroupModel (WCTRCCategoryInfo)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (WCTRCCategoryInfo *)WCTRCCategoryInfo
{
    WCTRCCategoryInfo *categoryInfo = [[WCTRCCategoryInfo alloc] init];
    
    if(categoryInfo!=nil)
    {
        //缺少 Type 轉換
        categoryInfo.guid = self.guid;
        categoryInfo.name = self.name;
        categoryInfo.updateTime = self.modifiedTime;
    }
    
    return [categoryInfo autorelease];
}


//================================================================================
//
//================================================================================
+ (WCGroupModel *)modelWithWCTRCCategoryInfo:(WCTRCCategoryInfo *)categoryInfo
{
    WCGroupModel *groupModel = nil;
    
    do
    {
        if(categoryInfo==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        groupModel = [[WCGroupModel alloc] init];
        
        if(groupModel==nil)
        {
            break;
        }

        groupModel.name = categoryInfo.name;
        groupModel.editable = YES;
        
        //////////////////////////////////////////////////
    
        if([categoryInfo.categoryType compare:WCTRC_CategoryType_All]==NSOrderedSame)
        {
            groupModel.ID = WC_GID_All;
            
            groupModel.editable = NO;
            
            if([[groupModel name] length]<=0)
            {
                groupModel.name = NSLocalizedString(@"MLS_All", nil);
            }
        }
        else if([categoryInfo.categoryType compare:WCTRC_CategoryType_Other]==NSOrderedSame)
        {
            groupModel.ID = WC_GID_Unfiled;
            groupModel.editable = NO;
            
            if([[groupModel name] length]<=0)
            {
                groupModel.name = NSLocalizedString(@"MLS_Unfiled", nil);
            }
        }
        
        //////////////////////////////////////////////////

        groupModel.guid = categoryInfo.guid;
        groupModel.modifiedTime = categoryInfo.updateTime;
    }
    while (0);
   
    
    return [groupModel autorelease];
}
@end
