//
//  WCCardModel+WCTRCContactInfo.m
//  Pods
//
//  Created by Eddie Hu on 2016/5/5.
//
//

#import "WCCardModel+WCTRCContactInfo.h"


@implementation WCCardModel (WCTRCContactInfo)





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - fieldSource convert


//================================================================================
//
//================================================================================
+ (WC_FieldSource)fieldSourceWithRcognizeSource:(NSString *)recognizeSource
{
    if([recognizeSource isEqualToString:WCTRC_ContactRecogSourceField_FrontCard] == YES)
    {
        return WC_FS_FrontRecog;
    }
    else if([recognizeSource isEqualToString:WCTRC_ContactRecogSourceField_BackCard] == YES)
    {
        return WC_FS_BackRecog;
    }
    else
    {
        return WC_FS_UserCreate;
    }
}


//==============================================================================
//
//==============================================================================
+ (NSString *)recognizeSourceWithFieldSource:(WC_FieldSource)fieldSource
{
    switch (fieldSource)
    {
        case WC_FS_FrontRecog: return WCTRC_ContactRecogSourceField_FrontCard;
        case WC_FS_BackRecog: return WCTRC_ContactRecogSourceField_BackCard;
        default: return WCTRC_ContactRecogSourceField_Manual;
    }
    
    return nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - contact info convert


//================================================================================
//
//================================================================================
- (WCTRCContactInfo *)WCTRCContactInfo
{
    WCTRCContactInfo *contactInfo = [[WCTRCContactInfo alloc] init];
    NSMutableArray *fieldArray;
    NSMutableArray *infoArray;
    
    
    //////////////////////////////////////////////////

    if(contactInfo == nil)
    {
        return nil;
    }
    
    
    //////////////////////////////////////////////////
    // 轉換ID資料
    
    contactInfo.guid = self.ID;

    
    //////////////////////////////////////////////////
    // 轉換編輯資料
    
    contactInfo.creatorGuid = self.creator;
    contactInfo.editorGuid = self.editor;
    contactInfo.ownerGuid = self.owner;
    contactInfo.createTime = self.createdTime;
    contactInfo.modifyTimeForDisplay = self.modifiedTime;
    
    
    //////////////////////////////////////////////////
    // 轉換tag資料
    
    contactInfo.beCorrected = !(self.tagMask & WC_TagMask_Unverified);
    contactInfo.beFavorite = (self.tagMask & WC_TagMask_Favorite);
    
    
    //////////////////////////////////////////////////
    // 轉換辨識資料
    
    contactInfo.recogLanguageFront = self.frontRecogLang;
    contactInfo.recogLanguageBack = self.backRecogLang;

    
    //////////////////////////////////////////////////
    // 轉換name資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_Name];
    infoArray = [NSMutableArray array];
    
    for(WCFieldModel *fieldModel in fieldArray)
    {
        WCTRCContactNameInfo *nameInfo = [[WCTRCContactNameInfo alloc] init];
        
        if(nameInfo != nil)
        {
            nameInfo.recognizeSource = [[self class] recognizeSourceWithFieldSource:fieldModel.source];

            nameInfo.firstName = [fieldModel valueWithSubType2:WC_FST2_Name_First];
            nameInfo.firstNamePronunce = [fieldModel valueWithSubType2:WC_FST2_Name_FirstPhonetic];
            nameInfo.lastName = [fieldModel valueWithSubType2:WC_FST2_Name_Last];
            nameInfo.lastNamePronunce = [fieldModel valueWithSubType2:WC_FST2_Name_LastPhonetic];
            nameInfo.middleName = [fieldModel valueWithSubType2:WC_FST2_Name_Middle];
            nameInfo.prefix = [fieldModel valueWithSubType2:WC_FST2_Name_Prefix];
            nameInfo.suffix = [fieldModel valueWithSubType2:WC_FST2_Name_Suffix];
            
            [infoArray addObject:nameInfo];
            [nameInfo release];
        }
    }
    
    contactInfo.names = infoArray;
    
    
    //////////////////////////////////////////////////
    // 轉換comopany資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_Company];
    infoArray = [NSMutableArray array];
    
    for(WCFieldModel *fieldModel in fieldArray)
    {
        WCTRCContactJobInfo *jobInfo = [[WCTRCContactJobInfo alloc] init];
        
        if(jobInfo != nil)
        {
            jobInfo.recognizeSource = [[self class] recognizeSourceWithFieldSource:fieldModel.source];

            jobInfo.companyName = [fieldModel valueWithSubType2:WC_FST2_Company_Name];
            jobInfo.companyPronunce = [fieldModel valueWithSubType2:WC_FST2_Company_Phonetic];
            jobInfo.department = [fieldModel valueWithSubType2:WC_FST2_Company_Department];
            jobInfo.jobTitle = [fieldModel valueWithSubType2:WC_FST2_Company_JobTitle];
            
            [infoArray addObject:jobInfo];
            [jobInfo release];
        }
    }
    
    contactInfo.jobinfos = infoArray;
    
    
    //////////////////////////////////////////////////
    // 轉換address資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_Address];
    infoArray = [NSMutableArray array];
    
    for(WCFieldModel *fieldModel in fieldArray)
    {
        WCTRCContactAddressInfo *addressInfo = [[WCTRCContactAddressInfo alloc] init];
        
        if(addressInfo != nil)
        {
            addressInfo.recognizeSource = [[self class] recognizeSourceWithFieldSource:fieldModel.source];

            NSString *formatString = [fieldModel valueWithSubType2:WC_FST2_Address_Format];
            
            addressInfo.addressFormat = [formatString length] > 0 ? [formatString integerValue] : WC_AF_None;
            addressInfo.street = [fieldModel valueWithSubType2:WC_FST2_Address_Street];
            addressInfo.city = [fieldModel valueWithSubType2:WC_FST2_Address_City];
            addressInfo.state = [fieldModel valueWithSubType2:WC_FST2_Address_State];
            addressInfo.zip = [fieldModel valueWithSubType2:WC_FST2_Address_ZIP];
            addressInfo.countryCode = [fieldModel valueWithSubType2:WC_FST2_Address_CountryCode];

            // !! 沒有國名時要再轉一次
            NSString *country = [fieldModel valueWithSubType2:WC_FST2_Address_Country];
            
            if([country length]==0)
            {
                NSInteger bcrLang = [self recognitionlanguageWithFieldSource:fieldModel.source];
                country = [fieldModel stringDisplayCountryWithBCRLanguage:bcrLang];
            }
            
            if ([country length]>0)
            {
                addressInfo.countryName = country;
            }

            
            switch (fieldModel.subType1)
            {
                case WC_FST1_Address_Work: addressInfo.type = WCTRC_ContactInfoType_Address_Work; break;
                case WC_FST1_Address_Home: addressInfo.type = WCTRC_ContactInfoType_Address_Home; break;
                default: addressInfo.type = WCTRC_ContactInfoType_Address_Other; break;
            }
            
            [infoArray addObject:addressInfo];
            [addressInfo release];
        }
    }
    
    contactInfo.addresses = infoArray;
    
    
    //////////////////////////////////////////////////
    // 轉換phone資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_Phone];
    infoArray = [NSMutableArray array];
    
    for(WCFieldModel *fieldModel in fieldArray)
    {
        WCTRCContactPhoneInfo *phoneInfo = [[WCTRCContactPhoneInfo alloc] init];
        
        if(phoneInfo != nil)
        {
            phoneInfo.recognizeSource = [[self class] recognizeSourceWithFieldSource:fieldModel.source];

            switch (fieldModel.subType1)
            {
                case WC_FST1_Phone_Work: phoneInfo.type = WCTRC_ContactInfoType_Phone_WorkTel; break;
                case WC_FST1_Phone_Home: phoneInfo.type = WCTRC_ContactInfoType_Phone_HomeTel; break;
                case WC_FST1_Phone_Mobile: phoneInfo.type = WCTRC_ContactInfoType_Phone_Mobile; break;
                case WC_FST1_Phone_Main: phoneInfo.type = WCTRC_ContactInfoType_Phone_Main; break;
                case WC_FST1_Phone_WorkFax: phoneInfo.type = WCTRC_ContactInfoType_Phone_WorkFax; break;
                case WC_FST1_Phone_HomeFax: phoneInfo.type = WCTRC_ContactInfoType_Phone_HomeFax; break;
                case WC_FST1_Phone_Pager: phoneInfo.type = WCTRC_ContactInfoType_Phone_Pager; break;
                case WC_FST1_Phone_GoogleVoice: phoneInfo.type = WCTRC_ContactInfoType_Phone_GoogleVoice; break;
                case WC_FST1_Phone_iPhone: phoneInfo.type = WCTRC_ContactInfoType_Phone_iPhone; break;
                case WC_FST1_Phone_Other: phoneInfo.type = WCTRC_ContactInfoType_Phone_OtherTel; break;
                default: phoneInfo.type = WCTRC_ContactInfoType_Phone_OtherTel; break;
            }

            phoneInfo.value = fieldModel.value;
            
            [infoArray addObject:phoneInfo];
            [phoneInfo release];
        }
    }
    
    contactInfo.phones = infoArray;
    
    
    //////////////////////////////////////////////////
    // 轉換email資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_Email];
    infoArray = [NSMutableArray array];
    
    for(WCFieldModel *fieldModel in fieldArray)
    {
        WCTRCContactMailInfo *mailInfo = [[WCTRCContactMailInfo alloc] init];
        
        if(mailInfo != nil)
        {
            mailInfo.recognizeSource = [[self class] recognizeSourceWithFieldSource:fieldModel.source];

            switch (fieldModel.subType1)
            {
                case WC_FST1_Email_Work: mailInfo.type = WCTRC_ContactInfoType_Mail_Work; break;
                case WC_FST1_Email_Home: mailInfo.type = WCTRC_ContactInfoType_Mail_Home; break;
                default: mailInfo.type = WCTRC_ContactInfoType_Mail_Other; break;
            }

            mailInfo.value = fieldModel.value;
            
            [infoArray addObject:mailInfo];
            [mailInfo release];
        }
    }
    
    contactInfo.emails = infoArray;
    
    
    //////////////////////////////////////////////////
    // 轉換url資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_URL];
    infoArray = [NSMutableArray array];
    
    for(WCFieldModel *fieldModel in fieldArray)
    {
        WCTRCContactUrlInfo *urlInfo = [[WCTRCContactUrlInfo alloc] init];
        
        if(urlInfo != nil)
        {
            urlInfo.recognizeSource = [[self class] recognizeSourceWithFieldSource:fieldModel.source];

            switch (fieldModel.subType1)
            {
                case WC_FST1_URL_HomePage: urlInfo.type = WCTRC_ContactInfoType_Url_Main; break;
                case WC_FST1_URL_Work: urlInfo.type = WCTRC_ContactInfoType_Url_Business; break;
                case WC_FST1_URL_Home: urlInfo.type = WCTRC_ContactInfoType_Url_Home; break;
                case WC_FST1_URL_Profile: urlInfo.type = WCTRC_ContactInfoType_Url_Personal; break;
                case WC_FST1_URL_Blog: urlInfo.type = WCTRC_ContactInfoType_Url_Blog; break;
                default: urlInfo.type = WCTRC_ContactInfoType_Url_Other; break;
            }
            
            urlInfo.value = fieldModel.value;
            
            [infoArray addObject:urlInfo];
            [urlInfo release];
        }
    }
    
    contactInfo.urls = infoArray;
    
    
    //////////////////////////////////////////////////
    // 轉換im資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_InstantMessage];
    infoArray = [NSMutableArray array];
    
    for(WCFieldModel *fieldModel in fieldArray)
    {
        WCTRCContactIMInfo *imInfo = [[WCTRCContactIMInfo alloc] init];
        
        if(imInfo != nil)
        {
            imInfo.recognizeSource = [[self class] recognizeSourceWithFieldSource:fieldModel.source];
            
            switch (fieldModel.subType1)
            {
                case WC_FST1_IM_MSN: imInfo.type = WCTRC_ContactInfoType_IM_Msn; break;
                case WC_FST1_IM_Skype: imInfo.type = WCTRC_ContactInfoType_IM_Skype; break;
                case WC_FST1_IM_QQ: imInfo.type = WCTRC_ContactInfoType_IM_QQ; break;
                case WC_FST1_IM_Yahoo: imInfo.type = WCTRC_ContactInfoType_IM_Yahoo; break;
                case WC_FST1_IM_ICQ: imInfo.type = WCTRC_ContactInfoType_IM_Icq; break;
                case WC_FST1_IM_GoogleTalk: imInfo.type = WCTRC_ContactInfoType_IM_GoogleTalk; break;
                case WC_FST1_IM_Jabber: imInfo.type = WCTRC_ContactInfoType_IM_Jabber; break;
                case WC_FST1_IM_AIM: imInfo.type = WCTRC_ContactInfoType_IM_Aim; break;
                case WC_FST1_IM_GaduGadu: imInfo.type = WCTRC_ContactInfoType_IM_Gadu; break;
                default: imInfo.type = WCTRC_ContactInfoType_IM_Other; break;
            }
            
            imInfo.value = fieldModel.value;
            
            [infoArray addObject:imInfo];
            [imInfo release];
        }
    }
    
    contactInfo.ims = infoArray;
    
    
    //////////////////////////////////////////////////
    // 轉換social資料

    fieldArray = [self fieldArrayWithType:WC_FT_SocialNetwork];
    infoArray = [NSMutableArray array];
    
    for(WCFieldModel *fieldModel in fieldArray)
    {
        WCTRCContactSocialInfo *socialNetworkInfo = [[WCTRCContactSocialInfo alloc] init];
        
        if(socialNetworkInfo != nil)
        {
            socialNetworkInfo.recognizeSource = [[self class] recognizeSourceWithFieldSource:fieldModel.source];
            
            switch (fieldModel.subType1)
            {
                case WC_FST1_SN_Twitter: socialNetworkInfo.type = WCTRC_ContactInfoType_Social_Twitter; break;
                case WC_FST1_SN_Facebook: socialNetworkInfo.type = WCTRC_ContactInfoType_Social_Facebook; break;
                case WC_FST1_SN_Flicker: socialNetworkInfo.type = WCTRC_ContactInfoType_Social_Flicker; break;
                case WC_FST1_SN_LinkedIn: socialNetworkInfo.type = WCTRC_ContactInfoType_Social_Linkedin; break;
                case WC_FST1_SN_MySpace: socialNetworkInfo.type = WCTRC_ContactInfoType_Social_MySpace; break;
                case WC_FST1_SN_SinaWebo: socialNetworkInfo.type = WCTRC_ContactInfoType_Social_Weibo; break;
                default: socialNetworkInfo.type = WCTRC_ContactInfoType_Social_Other; break;
            }
            
            socialNetworkInfo.value = fieldModel.value;
            
            [infoArray addObject:socialNetworkInfo];
            [socialNetworkInfo release];
        }
    }
    
    contactInfo.socials = infoArray;
    
    
    //////////////////////////////////////////////////
    // 轉換date/birthday資料

    fieldArray = [self fieldArrayWithType:WC_FT_Date];
    infoArray = [NSMutableArray array];
    
    for(WCFieldModel *fieldModel in fieldArray)
    {
        switch (fieldModel.subType1)
        {
            case WC_FST1_Date_Birthday:
            {
                // !! special case for birthday
                contactInfo.birthday = fieldModel.value;
                break;
            }
                
            case WC_FST1_Date_Anniversary:
            {
                WCTRCContactDateInfo *dateInfo = [[WCTRCContactDateInfo alloc] init];
                
                if(dateInfo != nil)
                {
                    dateInfo.type = WCTRC_ContactInfoType_Date_Celebration;
                    dateInfo.value = fieldModel.value;
                
                    [infoArray addObject:dateInfo];
                    [dateInfo release];
                }
                
                break;
            }
                
            default:
            {
                WCTRCContactDateInfo *dateInfo = [[WCTRCContactDateInfo alloc] init];
                
                if(dateInfo != nil)
                {
                    dateInfo.type = WCTRC_ContactInfoType_Date_Other;
                    dateInfo.value = fieldModel.value;
                
                    [infoArray addObject:dateInfo];
                    [dateInfo release];
                }
                
                break;
            }
        }
    }
    
    contactInfo.dates = infoArray;
    
    
    //////////////////////////////////////////////////
    // TODO: 轉換自訂欄位資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_UserDefine];
    infoArray = [NSMutableArray array];

    for (WCFieldModel *fieldModel in fieldArray)
    {
        WCTRCContactCustomFieldData *contactCustomFieldInfo = [[WCTRCContactCustomFieldData alloc] init];
        contactCustomFieldInfo.guid = fieldModel.guid;
        contactCustomFieldInfo.customFieldSettingGuid = fieldModel.customFieldInfoGuid;
        contactCustomFieldInfo.textValue = fieldModel.value;

        if(fieldModel.customFieldContentType==WCCustomFieldContentType_Float)
        {
            contactCustomFieldInfo.fieldType = WCTRC_CustomField_Attributes_Float;
        }
        else if(fieldModel.customFieldContentType==WCCustomFieldContentType_Integer)
        {
            contactCustomFieldInfo.fieldType = WCTRC_CustomField_Attributes_Number;
        }
        else if(fieldModel.customFieldContentType==WCCustomFieldContentType_URL)
        {
            contactCustomFieldInfo.fieldType = WCTRC_CustomField_Attributes_URL;
        }
        else if(fieldModel.customFieldContentType==WCCustomFieldContentType_Email)
        {
            contactCustomFieldInfo.fieldType = WCTRC_CustomField_Attributes_Email;
        }
        else if(fieldModel.customFieldContentType==WCCustomFieldContentType_Picklist)
        {
            contactCustomFieldInfo.fieldType = WCTRC_CustomField_Attributes_Picklist;
        }
        else if(fieldModel.customFieldContentType==WCCustomFieldContentType_Date)
        {
            contactCustomFieldInfo.fieldType = WCTRC_CustomField_Attributes_Date;
            
            //!! 日期要補滿
            NSArray *dateComponents = [fieldModel.value componentsSeparatedByString:@"/"];
            
            // 沒有滿三個，要補上年
            if([dateComponents count]<3)
            {
                fieldModel.value = [NSString stringWithFormat:@"1900/%@", fieldModel.value];
            }
            contactCustomFieldInfo.textValue = [[fieldModel.value stringByReplacingOccurrencesOfString:@"/" withString:@"-"] stringByAppendingString:@" 00:00:00.000"];
 
        }
        else if(fieldModel.customFieldContentType==WCCustomFieldContentType_DateTime)
        {
            contactCustomFieldInfo.fieldType = WCTRC_CustomField_Attributes_DateTime;
            // !! 日期時間也要補滿
            contactCustomFieldInfo.textValue = [[fieldModel.value stringByReplacingOccurrencesOfString:@"/" withString:@"-"] stringByAppendingString:@":00.000"];
        }
        else
        {
            contactCustomFieldInfo.fieldType = WCTRC_CustomField_Attributes_Text;
        }
        [infoArray addObject:contactCustomFieldInfo];
        [contactCustomFieldInfo release];
    }
    
    contactInfo.customFields = infoArray;
    
    //////////////////////////////////////////////////
    // 轉換note資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_Note];
    
    if([fieldArray count] > 0)
    {
        WCFieldModel *filedModel = [fieldArray firstObject];
        
        contactInfo.note = filedModel.value;
    }
    else
    {
        contactInfo.note = @"";
    }
    
    
    //////////////////////////////////////////////////
    // 轉換nickname資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_Nickname];
    
    if([fieldArray count] > 0)
    {
        WCFieldModel *filedModel = [fieldArray firstObject];
        
        contactInfo.nickname = filedModel.value;
    }
    else
    {
        contactInfo.nickname = @"";
    }
    
    
    //////////////////////////////////////////////////
    // 轉換UnifiedBusinessNo資料
    
    fieldArray = [self fieldArrayWithType:WC_FT_UnifiedBusinessNo];
    
    if([fieldArray count] > 0)
    {
        WCFieldModel *filedModel = [fieldArray firstObject];
        
        contactInfo.uniformNumber = filedModel.value;
    }
    else
    {
        contactInfo.uniformNumber = @"";
    }

    //////////////////////////////////////////////////
    
    return [contactInfo autorelease];
}


//================================================================================
//
//================================================================================
+ (WCCardModel *)modelWithWCTRCContactInfo:(WCTRCContactInfo *)contactInfo
{
    WCCardModel *cardModel = [[[WCCardModel alloc] init] autorelease];
    
    
    //////////////////////////////////////////////////
    
    if(cardModel == nil)
    {
        return nil;
    }
    
    
    //////////////////////////////////////////////////
    // 取得包含影像
    
    for(WCTRCContactImageInfo *imageInfo in contactInfo.images)
    {
        if([imageInfo.type caseInsensitiveCompare:WCTRC_ImageType_Front] == NSOrderedSame)
        {
            if([imageInfo.sha1 caseInsensitiveCompare:WCTRC_SHA1_Empty] != NSOrderedSame)
            {
                cardModel.containImageType |= WC_IT_FrontSide;
            }
        }
        else if([imageInfo.type caseInsensitiveCompare:WCTRC_ImageType_Rear] == NSOrderedSame)
        {
            if([imageInfo.sha1 caseInsensitiveCompare:WCTRC_SHA1_Empty] != NSOrderedSame)
            {
                cardModel.containImageType |= WC_IT_BackSide;
            }
        }
        else if([imageInfo.type caseInsensitiveCompare:WCTRC_ImageType_Logo] == NSOrderedSame)
        {
            if([imageInfo.sha1 caseInsensitiveCompare:WCTRC_SHA1_Empty] != NSOrderedSame)
            {
                cardModel.containImageType |= WC_IT_IDPhoto;
            }
        }
    }

    //////////////////////////////////////////////////
    // 轉換SharedAccount

    if(contactInfo.beSharedAccounts != nil)
    {
        NSMutableArray *sharedAccountGuids = [NSMutableArray array];
        
        for(WCTRCAccountLessInfo *info in contactInfo.beSharedAccounts)
        {
            [sharedAccountGuids addObject:info.guid];
        }
             
        cardModel.sharedAccountGUIDArray = sharedAccountGuids;
    }
             
    
    //////////////////////////////////////////////////
    // 轉換ID資料
    
    cardModel.ID = contactInfo.guid;
    
    
    //////////////////////////////////////////////////
    // 轉換編輯資料

    cardModel.creator = contactInfo.creatorGuid;
    cardModel.editor = contactInfo.editorGuid;
    cardModel.owner = contactInfo.ownerGuid;
    cardModel.createdTime = contactInfo.createTime;
    cardModel.modifiedTime = contactInfo.modifyTimeForDisplay;

    
    //////////////////////////////////////////////////
    // 轉換tag資料
    
    if(contactInfo.beCorrected == NO)
    {
        cardModel.tagMask |= WC_TagMask_Unverified;
    }

    if(contactInfo.beFavorite == YES)
    {
        cardModel.tagMask |= WC_TagMask_Favorite;
    }

    
    //////////////////////////////////////////////////
    // 轉換辨識資料
    
    cardModel.frontRecogLang = contactInfo.recogLanguageFront;
    cardModel.backRecogLang = contactInfo.recogLanguageBack;

    
    //////////////////////////////////////////////////
    // 轉換name資料
    
    for(WCTRCContactNameInfo *nameInfo in contactInfo.names)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_Name;
            fieldModel.source = [self fieldSourceWithRcognizeSource:nameInfo.recognizeSource];
            
            [fieldModel setSubType2FieldWithValue:nameInfo.firstName recogRect:CGRectZero subType2:WC_FST2_Name_First];
            [fieldModel setSubType2FieldWithValue:nameInfo.firstNamePronunce recogRect:CGRectZero subType2:WC_FST2_Name_FirstPhonetic];
            [fieldModel setSubType2FieldWithValue:nameInfo.lastName recogRect:CGRectZero subType2:WC_FST2_Name_Last];
            [fieldModel setSubType2FieldWithValue:nameInfo.lastNamePronunce recogRect:CGRectZero subType2:WC_FST2_Name_LastPhonetic];
            [fieldModel setSubType2FieldWithValue:nameInfo.middleName recogRect:CGRectZero subType2:WC_FST2_Name_Middle];
            [fieldModel setSubType2FieldWithValue:nameInfo.prefix recogRect:CGRectZero subType2:WC_FST2_Name_Prefix];
            [fieldModel setSubType2FieldWithValue:nameInfo.suffix recogRect:CGRectZero subType2:WC_FST2_Name_Suffix];
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    
    //////////////////////////////////////////////////
    // 轉換company資料
    
    for(WCTRCContactJobInfo *jobInfo in contactInfo.jobinfos)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_Company;
            fieldModel.source = [self fieldSourceWithRcognizeSource:jobInfo.recognizeSource];
            
            [fieldModel setSubType2FieldWithValue:jobInfo.companyName recogRect:CGRectZero subType2:WC_FST2_Company_Name];
            [fieldModel setSubType2FieldWithValue:jobInfo.companyPronunce recogRect:CGRectZero subType2:WC_FST2_Company_Phonetic];
            [fieldModel setSubType2FieldWithValue:jobInfo.department recogRect:CGRectZero subType2:WC_FST2_Company_Department];
            [fieldModel setSubType2FieldWithValue:jobInfo.jobTitle recogRect:CGRectZero subType2:WC_FST2_Company_JobTitle];
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    
    //////////////////////////////////////////////////
    // 轉換address資料
    
    for(WCTRCContactAddressInfo *addressInfo in contactInfo.addresses)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_Address;
            fieldModel.source = [self fieldSourceWithRcognizeSource:addressInfo.recognizeSource];
            
            if([addressInfo.type isEqualToString:WCTRC_ContactInfoType_Address_Home] == YES)
            {
                fieldModel.subType1 = WC_FST1_Address_Home;
            }
            else if([addressInfo.type isEqualToString:WCTRC_ContactInfoType_Address_Work] == YES)
            {
                fieldModel.subType1 = WC_FST1_Address_Work;
            }
            else
            {
                fieldModel.subType1 = WC_FST1_Address_Other;
            }
            
            [fieldModel setSubType2FieldWithValue:addressInfo.street recogRect:CGRectZero subType2:WC_FST2_Address_Street];
            [fieldModel setSubType2FieldWithValue:addressInfo.city recogRect:CGRectZero subType2:WC_FST2_Address_City];
            [fieldModel setSubType2FieldWithValue:addressInfo.state recogRect:CGRectZero subType2:WC_FST2_Address_State];
            [fieldModel setSubType2FieldWithValue:addressInfo.zip recogRect:CGRectZero subType2:WC_FST2_Address_ZIP];
            [fieldModel setSubType2FieldWithValue:addressInfo.countryName recogRect:CGRectZero subType2:WC_FST2_Address_Country];
            [fieldModel setSubType2FieldWithValue:addressInfo.countryCode recogRect:CGRectZero subType2:WC_FST2_Address_CountryCode];
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    
    //////////////////////////////////////////////////
    // 轉換phone資料
    
    for(WCTRCContactPhoneInfo *phoneInfo in contactInfo.phones)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_Phone;
            fieldModel.source = [self fieldSourceWithRcognizeSource:phoneInfo.recognizeSource];
            fieldModel.value = phoneInfo.value;

            //防止值為nil, 被其它流程寫入 [dictionary setObject:fieldModel.valie forkey:..]
            if(fieldModel.value==nil)
            {
                fieldModel.value = @"";
            }
            
            if([phoneInfo.type isEqualToString:WCTRC_ContactInfoType_Phone_WorkTel] == YES)
            {
                fieldModel.subType1 = WC_FST1_Phone_Work;
            }
            else if([phoneInfo.type isEqualToString:WCTRC_ContactInfoType_Phone_HomeTel] == YES)
            {
                fieldModel.subType1 = WC_FST1_Phone_Home;
            }
            else if([phoneInfo.type isEqualToString:WCTRC_ContactInfoType_Phone_Mobile] == YES)
            {
                fieldModel.subType1 = WC_FST1_Phone_Mobile;
            }
            else if([phoneInfo.type isEqualToString:WCTRC_ContactInfoType_Phone_Main] == YES)
            {
                fieldModel.subType1 = WC_FST1_Phone_Main;
            }
            else if([phoneInfo.type isEqualToString:WCTRC_ContactInfoType_Phone_WorkFax] == YES)
            {
                fieldModel.subType1 = WC_FST1_Phone_WorkFax;
            }
            else if([phoneInfo.type isEqualToString:WCTRC_ContactInfoType_Phone_HomeFax] == YES)
            {
                fieldModel.subType1 = WC_FST1_Phone_HomeFax;
            }
            else if([phoneInfo.type isEqualToString:WCTRC_ContactInfoType_Phone_Pager] == YES)
            {
                fieldModel.subType1 = WC_FST1_Phone_Pager;
            }
            else if([phoneInfo.type isEqualToString:WCTRC_ContactInfoType_Phone_GoogleVoice] == YES)
            {
                fieldModel.subType1 = WC_FST1_Phone_GoogleVoice;
            }
            else if([phoneInfo.type isEqualToString:WCTRC_ContactInfoType_Phone_iPhone] == YES)
            {
                fieldModel.subType1 = WC_FST1_Phone_iPhone;
            }
            else
            {
                fieldModel.subType1 = WC_FST1_Phone_Other;
            }
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    
    //////////////////////////////////////////////////
    // 轉換email資料
    
    for(WCTRCContactMailInfo *mailInfo in contactInfo.emails)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_Email;
            fieldModel.source = [self fieldSourceWithRcognizeSource:mailInfo.recognizeSource];
            fieldModel.value = mailInfo.value;
            
            //防止值為nil, 被其它流程寫入 [dictionary setObject:fieldModel.valie forkey:..]
            if(fieldModel.value==nil)
            {
                fieldModel.value = @"";
            }
            
            if([mailInfo.type isEqualToString:WCTRC_ContactInfoType_Mail_Home] == YES)
            {
                fieldModel.subType1 = WC_FST1_Email_Home;
            }
            else if([mailInfo.type isEqualToString:WCTRC_ContactInfoType_Mail_Work] == YES)
            {
                fieldModel.subType1 = WC_FST1_Email_Work;
            }
            else
            {
                fieldModel.subType1 = WC_FST1_Email_Other;
            }
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    
    //////////////////////////////////////////////////
    // 轉換url資料
    
    for(WCTRCContactUrlInfo *urlInfo in contactInfo.urls)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_URL;
            fieldModel.source = [self fieldSourceWithRcognizeSource:urlInfo.recognizeSource];
            fieldModel.value = urlInfo.value;
            
            //防止值為nil, 被其它流程寫入 [dictionary setObject:fieldModel.valie forkey:..]
            if(fieldModel.value==nil)
            {
                fieldModel.value = @"";
            }
            
            if([urlInfo.type isEqualToString:WCTRC_ContactInfoType_Url_Main] == YES)
            {
                fieldModel.subType1 = WC_FST1_URL_HomePage;
            }
            else if([urlInfo.type isEqualToString:WCTRC_ContactInfoType_Url_Home] == YES)
            {
                fieldModel.subType1 = WC_FST1_URL_Home;
            }
            else if([urlInfo.type isEqualToString:WCTRC_ContactInfoType_Url_Business] == YES)
            {
                fieldModel.subType1 = WC_FST1_URL_Work;
            }
            else if([urlInfo.type isEqualToString:WCTRC_ContactInfoType_Url_Personal] == YES)
            {
                fieldModel.subType1 = WC_FST1_URL_Profile;
            }
            else if([urlInfo.type isEqualToString:WCTRC_ContactInfoType_Url_Blog] == YES)
            {
                fieldModel.subType1 = WC_FST1_URL_Blog;
            }
            else
            {
                fieldModel.subType1 = WC_FST1_URL_Other;
            }
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    
    //////////////////////////////////////////////////
    // 轉換im資料
    
    for(WCTRCContactIMInfo *imInfo in contactInfo.ims)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_InstantMessage;
            fieldModel.source = [self fieldSourceWithRcognizeSource:imInfo.recognizeSource];
            fieldModel.value = imInfo.value;
            
            //防止值為nil, 被其它流程寫入 [dictionary setObject:fieldModel.valie forkey:..]
            if(fieldModel.value==nil)
            {
                fieldModel.value = @"";
            }
            
            if([imInfo.type isEqualToString:WCTRC_ContactInfoType_IM_Msn] == YES)
            {
                fieldModel.subType1 = WC_FST1_IM_MSN;
            }
            else if([imInfo.type isEqualToString:WCTRC_ContactInfoType_IM_Skype] == YES)
            {
                fieldModel.subType1 = WC_FST1_IM_Skype;
            }
            else if([imInfo.type isEqualToString:WCTRC_ContactInfoType_IM_QQ] == YES)
            {
                fieldModel.subType1 = WC_FST1_IM_QQ;
            }
            else if([imInfo.type isEqualToString:WCTRC_ContactInfoType_IM_Yahoo] == YES)
            {
                fieldModel.subType1 = WC_FST1_IM_Yahoo;
            }
            else if([imInfo.type isEqualToString:WCTRC_ContactInfoType_IM_Icq] == YES)
            {
                fieldModel.subType1 = WC_FST1_IM_ICQ;
            }
            else if([imInfo.type isEqualToString:WCTRC_ContactInfoType_IM_GoogleTalk] == YES)
            {
                fieldModel.subType1 = WC_FST1_IM_GoogleTalk;
            }
            else if([imInfo.type isEqualToString:WCTRC_ContactInfoType_IM_Jabber] == YES)
            {
                fieldModel.subType1 = WC_FST1_IM_Jabber;
            }
            else if([imInfo.type isEqualToString:WCTRC_ContactInfoType_IM_Aim] == YES)
            {
                fieldModel.subType1 = WC_FST1_IM_AIM;
            }
            else if([imInfo.type isEqualToString:WCTRC_ContactInfoType_IM_Gadu] == YES)
            {
                fieldModel.subType1 = WC_FST1_IM_GaduGadu;
            }
            else
            {
                fieldModel.subType1 = WC_FST1_IM_Other;
            }
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    
    //////////////////////////////////////////////////
    // 轉換social資料
    
    for(WCTRCContactSocialInfo *socialNetworkInfo in contactInfo.socials)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_SocialNetwork;
            fieldModel.source = [self fieldSourceWithRcognizeSource:socialNetworkInfo.recognizeSource];
            fieldModel.value = socialNetworkInfo.value;
            
            //防止值為nil, 被其它流程寫入 [dictionary setObject:fieldModel.valie forkey:..]
            if(fieldModel.value==nil)
            {
                fieldModel.value = @"";
            }
            
            if([socialNetworkInfo.type isEqualToString:WCTRC_ContactInfoType_Social_Facebook] == YES)
            {
                fieldModel.subType1 = WC_FST1_SN_Facebook;
            }
            else if([socialNetworkInfo.type isEqualToString:WCTRC_ContactInfoType_Social_Flicker] == YES)
            {
                fieldModel.subType1 = WC_FST1_SN_Flicker;
            }
            else if([socialNetworkInfo.type isEqualToString:WCTRC_ContactInfoType_Social_Linkedin] == YES)
            {
                fieldModel.subType1 = WC_FST1_SN_LinkedIn;
            }
            else if([socialNetworkInfo.type isEqualToString:WCTRC_ContactInfoType_Social_MySpace] == YES)
            {
                fieldModel.subType1 = WC_FST1_SN_MySpace;
            }
            else if([socialNetworkInfo.type isEqualToString:WCTRC_ContactInfoType_Social_Twitter] == YES)
            {
                fieldModel.subType1 = WC_FST1_SN_Twitter;
            }
            else if([socialNetworkInfo.type isEqualToString:WCTRC_ContactInfoType_Social_Weibo] == YES)
            {
                fieldModel.subType1 = WC_FST1_SN_SinaWebo;
            }
            else
            {
                fieldModel.subType1 = WC_FST1_SN_Other;
            }
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    //////////////////////////////////////////////////
    // 轉換date資料
    
    for(WCTRCContactDateInfo *dateInfo in contactInfo.dates)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_Date;
            fieldModel.source = WC_FS_UserCreate;
            fieldModel.value = dateInfo.value;
            
            if([dateInfo.type isEqualToString:WCTRC_ContactInfoType_Date_Celebration] == YES)
            {
                fieldModel.subType1 = WC_FST1_Date_Anniversary;
            }
            else
            {
                fieldModel.subType1 = WC_FST1_Date_Other;
            }
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    // !! special case for birthday
    if(contactInfo.birthday != nil)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_Date;
            fieldModel.subType1 = WC_FST1_Date_Birthday;
            fieldModel.source = WC_FS_UserCreate;
            fieldModel.value = contactInfo.birthday;
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    //////////////////////////////////////////////////
    // 轉換自訂欄位資料

    for(WCTRCContactCustomFieldData *customFieldInfo in contactInfo.customFields)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_UserDefine;
            fieldModel.source = WC_FS_UserCreate;
            
            fieldModel.guid = customFieldInfo.guid;
            fieldModel.customFieldInfoGuid = customFieldInfo.customFieldSettingGuid;
            fieldModel.value = customFieldInfo.textValue;
            
            if([customFieldInfo.fieldType isEqualToString:WCTRC_CustomField_Attributes_Number])
            {
                fieldModel.customFieldContentType = WCCustomFieldContentType_Integer;
            }
            else if([customFieldInfo.fieldType isEqualToString:WCTRC_CustomField_Attributes_Email])
            {
                fieldModel.customFieldContentType = WCCustomFieldContentType_Email;
            }
            else if([customFieldInfo.fieldType isEqualToString:WCTRC_CustomField_Attributes_URL])
            {
                fieldModel.customFieldContentType = WCCustomFieldContentType_URL;
            }
            else if([customFieldInfo.fieldType isEqualToString:WCTRC_CustomField_Attributes_Picklist])
            {
                fieldModel.customFieldContentType = WCCustomFieldContentType_Picklist;
            }
            else if([customFieldInfo.fieldType isEqualToString:WCTRC_CustomField_Attributes_Float])
            {
                fieldModel.customFieldContentType = WCCustomFieldContentType_Float;
            }
            else if([customFieldInfo.fieldType isEqualToString:WCTRC_CustomField_Attributes_Date])
            {
                fieldModel.customFieldContentType = WCCustomFieldContentType_Date;
                
                // !! 日期，要把時間部分切掉
                fieldModel.value = [customFieldInfo.textValue substringWithRange:NSMakeRange(0, 10)];

                // 替代日期的分隔符號
                fieldModel.value = [fieldModel.value stringByReplacingOccurrencesOfString:@"-" withString:@"/"];
                
//                //////////////////////////////////////////////////
//                //!!如果年是1900, 把年份移掉
//                NSArray *dateComponent = [fieldModel.value componentsSeparatedByString:@"/"];
//                
//                if([[dateComponent firstObject] integerValue]==WC_ValidMinYear)
//                {
//                    NSMutableArray *newDateComponents = [NSMutableArray arrayWithArray:dateComponent];
//                    [newDateComponents removeObjectAtIndex:0];
//                    
//                    fieldModel.value = [newDateComponents componentsJoinedByString:@"/"];
//                }
            }
            else if([customFieldInfo.fieldType isEqualToString:WCTRC_CustomField_Attributes_DateTime])
            {
                fieldModel.customFieldContentType = WCCustomFieldContentType_DateTime;
                // !! 日期時間，要把秒切掉
                fieldModel.value = [customFieldInfo.textValue substringWithRange:NSMakeRange(0, 16)];
                
                // 替代日期的分隔符號
                fieldModel.value = [fieldModel.value stringByReplacingOccurrencesOfString:@"-" withString:@"/"];

            }
            else
            {
                fieldModel.customFieldContentType = WCCustomFieldContentType_Text;
            }

            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    //////////////////////////////////////////////////
    // 轉換note資料

    if([contactInfo.note length] > 0)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_Note;
            fieldModel.source = WC_FS_UserCreate;
            fieldModel.value = contactInfo.note;
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }

    
    //////////////////////////////////////////////////
    // 轉換nickname資料
    
    if([contactInfo.nickname length] > 0)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_Nickname;
            fieldModel.source = WC_FS_UserCreate;
            fieldModel.value = contactInfo.nickname;
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    
    //////////////////////////////////////////////////
    // 轉換UnifiedBusinessNo資料
    
    if([contactInfo.uniformNumber length] > 0)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        
        if(fieldModel != nil)
        {
            fieldModel.type = WC_FT_UnifiedBusinessNo;
            fieldModel.source = WC_FS_UserCreate;
            fieldModel.value = contactInfo.uniformNumber;
            
            [cardModel addField:fieldModel];
            [fieldModel release];
        }
    }
    
    //////////////////////////////////////////////////
    
    return cardModel;
}

@end
