//
//  WCTCompanyContactFetchDataController.m
//
//
//  Created by Howard on 2016/4/12.
//
//

#import "WCTCompanyContactFetchDataController.h"

// Define
#import "WCTRestObject+ParameterDefine.h"
#import "WCTCompanyContactViewController+ResourceDefine.h"
#import "WCTRestClientController+ParameterDefine.h"
#import "WCTCompanyContactViewController+ParameterDefine.h"

// Model
#import "WCCardSectionModel.h"
#import "WCTCompanyCardModel.h"
#import "WCTSettingsKey.h"

// Category
#import "NSData+Base64.h"
#import "WCTCompanyCardModel+WCTRCContactSimpleInfo.h"
#import "WCGroupModel+Tree.h"
#import "WCGroupModel+Sort.h"
#import "WCGroupModel+WCTRCCategoryInfoMultiLayer.h"
#import "WCCustomFieldInfo+WCTRCCustomFieldInfo.h"

// controller
#import "PPSettingsController.h"
#import "PPSystemInfoController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface WCTCompanyContactFetchDataController

@interface WCTCompanyContactFetchDataController ()

@property (atomic,retain) NSOperationQueue *workingOperatonQueue;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation WCTCompanyContactFetchDataController

@implementation WCTCompanyContactFetchDataController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocatin Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _workingOperatonQueue = [[NSOperationQueue alloc] init];
        
        if(_workingOperatonQueue!=nil)
        {
            [_workingOperatonQueue setMaxConcurrentOperationCount:1];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_workingOperatonQueue cancelAllOperations];
    [_workingOperatonQueue release];
    _workingOperatonQueue = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (WCTCompanyContactFetchDataController *)shareInstance
{
    static id sharedInstance = nil;
    static dispatch_once_t onceToken;
    
    dispatch_once(&onceToken, ^{
        
        sharedInstance = [[WCTCompanyContactFetchDataController alloc] init];
        
    });
    
    return sharedInstance;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private mtehods


//================================================================================
//
//================================================================================
- (WCTRCContactGetByAccountRequest *)prepareContactGetAccountRequestWithAccountGuid:(NSString *)accountGuid pageIndex:(NSInteger)pageIndex
{
    WCTRCContactGetByAccountRequest *request = nil;
    
    do
    {
        request = [[[WCTRCContactGetByAccountRequest alloc] init] autorelease];
        
        if(request==nil)
        {
            break;
        }
        
        request.accountGuid = accountGuid;
        
        //!!特殊做法， [accountGuid length]=0, 將request.accountGuid = nil, 取得所有公司聯絡人
        if([accountGuid length]<=0)
        {
            request.accountGuid = nil;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCPageInfo *pageInfo = [[[WCTRCPageInfo alloc] init] autorelease];
        
        if(pageInfo==nil)
        {
            break;
        }
        
        pageInfo.numberPerPage = WCTClientControllerNumberPerPage;
        pageInfo.pageIndex = pageIndex;
        
        //////////////////////////////////////////////////
        
        // TODO: 之後要從設定值抓排序欄位
        pageInfo.fieldOrderBy = WCTRC_ContactSortField_CreatedTime;
        request.pageInfo = pageInfo;
    }
    while (0);
    
    return request;
}


//================================================================================
//
//================================================================================
- (WCTRCContactGetByCategoryAndOwnerVoRequest *)prepareContactGetAccountRequestWithAccountGuid:(NSString *)accountGuid categoryGuid:(NSString *)categoryGuid pageIndex:(NSInteger)pageIndex
{
    WCTRCContactGetByCategoryAndOwnerVoRequest *request = nil;
    
    do
    {
        request = [[[WCTRCContactGetByCategoryAndOwnerVoRequest alloc] init] autorelease];
        
        if(request==nil)
        {
            break;
        }
        
        request.categoryOwnerAccountGuid = accountGuid;
        
        //!!特殊做法， [accountGuid length]=0, 將request.accountGuid = nil, 取得所有公司聯絡人
        if([accountGuid length]<=0)
        {
            request.categoryOwnerAccountGuid = nil;
        }
        else
        {
            request.categoryGuid = categoryGuid;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCPageInfo *pageInfo = [[[WCTRCPageInfo alloc] init] autorelease];
        
        if(pageInfo==nil)
        {
            break;
        }
        
        pageInfo.numberPerPage = WCTClientControllerNumberPerPage;
        pageInfo.pageIndex = pageIndex;
        
        //////////////////////////////////////////////////
        
        // TODO: 之後要從設定值抓排序欄位
        pageInfo.fieldOrderBy = WCTRC_ContactSortField_CreatedTime;
        request.pageInfo = pageInfo;
    }
    while (0);
    
    return request;
}


//==============================================================================
//
//==============================================================================
- (WCCardSectionModel*)cardSectionModelFromContactListpageResponseResult:(WCTRCContactListPageResponseResult *)contactListpageResponseResult
{
    WCCardSectionModel *cardSectionModel = nil;
    
    do {
        if(contactListpageResponseResult==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // 資料轉換
        cardSectionModel = [[[WCCardSectionModel alloc] init] autorelease];
        
        if(cardSectionModel==nil)
        {
            break;
        }
        
        cardSectionModel.cardArray = [NSMutableArray arrayWithCapacity:contactListpageResponseResult.data.count];
        
        if(cardSectionModel.cardArray==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //取得所有名片的下載狀態，配合API需求，紀錄所有帳號 guid
        
        NSMutableArray *contactGuids = [NSMutableArray arrayWithCapacity:contactListpageResponseResult.data.count];
        
        for(WCTRCContactSimpleInfo *simpleInfo in contactListpageResponseResult.data)
        {
            WCTCompanyCardModel *cardModel = [WCTCompanyCardModel companyCardModelWithContactSimpleInfo:simpleInfo];
            
            if(cardModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            if(simpleInfo.isDownloadedToPrivate==YES)
            {
                cardModel.downloadStatus = WCTCompanyCardModelDownloadStatus_Done;
            }
            else
            {
                cardModel.downloadStatus = WCTCompanyCardModelDownloadStatus_UnDone;
            }
            
            //////////////////////////////////////////////////
            
            [contactGuids addObject:cardModel.ID];
            [cardSectionModel.cardArray addObject:cardModel];
        }
        
        
        //////////////////////////////////////////////////
        
        if([contactGuids count]<=0)
        {
            break;
        }
    } while (0);
    
    return cardSectionModel;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)waitAllFetchDataOperationFinished
{
    [[self workingOperatonQueue] waitUntilAllOperationsAreFinished];
}


//================================================================================
//
//================================================================================
- (void)cancelFetchDataOperation
{
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        [[WCTRestClientController shareRestClientController] cancellAllRestOperation];
        
        //////////////////////////////////////////////////
        
        [[self workingOperatonQueue] cancelAllOperations];
    });
}


//================================================================================
// MARK:取得帳號下連絡人資訊
//================================================================================
- (void)fetchCardSectionModelWithContactAccountGuid:(NSString *)accountGuid categoryGuid:(NSString *)categoryGuid pageIndex:(NSInteger)pageIndex
{
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        NSUInteger totalCount = 0;
        NSError *returnError = nil;
        WCCardSectionModel *cardSectionModel = nil;
        
        WCTRCContactListPageResponseResult *reponseResult = nil;
        
        do
        {
            //////////////////////////////////////////////////

            if(blockOperation.isCancelled==YES)
            {
                returnError = PPErrorOperationCancel(nil);
                
                break;
            }
            
            //////////////////////////////////////////////////
            
            BOOL uncategoryOnly = ([categoryGuid isEqualToString:WCTCompanyContactUndownloadCategoryGuid]);

            if (uncategoryOnly)
            {
                // 取得未下載
                WCTRCContactGetByAccountRequest *request = [self prepareContactGetAccountRequestWithAccountGuid:accountGuid pageIndex:pageIndex];
                reponseResult = [[WCTRestClientController shareRestClientController] sharedContactListIsntAccountCategoryWithRequest:request
                                                                                                                               error:&returnError];
            }
            else
            {
                if ([categoryGuid length]==0)
                {
                    // 取得全部
                    WCTRCContactGetByAccountRequest *request = [self prepareContactGetAccountRequestWithAccountGuid:accountGuid pageIndex:pageIndex];
                    reponseResult = [[WCTRestClientController shareRestClientController] shareContactListWithContactGetByAccountRequest:request
                                                                                                                              withError:&returnError];
                    
                }
                else
                {
                    // 取得指定群組
                    WCTRCContactGetByCategoryAndOwnerVoRequest *request = [self prepareContactGetAccountRequestWithAccountGuid:accountGuid
                                                                                                                  categoryGuid:categoryGuid
                                                                                                                     pageIndex:pageIndex];
                    reponseResult = [[WCTRestClientController shareRestClientController] sharedContactListWithRequest:request
                                                                                                                error:&returnError];
                }
            }

            
            //////////////////////////////////////////////////
            
            if(reponseResult==nil)
            {
                break;
            }
            
            totalCount = reponseResult.totalCount;
            
            //////////////////////////////////////////////////
            
            // 資料轉換
            
            cardSectionModel = [self cardSectionModelFromContactListpageResponseResult:reponseResult];
            
            if(cardSectionModel==nil)
            {
                break;
            }            
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if([self.delegate respondsToSelector:@selector(companyContactListUnderAccount:totalCount:withError:)]==YES)
            {
                if(cardSectionModel==nil)
                {
                    [self.delegate companyContactListUnderAccount:nil totalCount:totalCount withError:returnError];
                }
                else
                {
                    [self.delegate companyContactListUnderAccount:@[cardSectionModel] totalCount:totalCount withError:returnError];
                }
            }
        });
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        [self.workingOperatonQueue addOperation:blockOperation];
    }
}



//================================================================================
// MARK: 進階搜尋API
//================================================================================
- (void)fetchCardSectionModelWithAdvancedSearchInfo:(WCTRCAdvancedSearchInfo *)advancedSearchInfo pageIndex:(NSInteger)pageIndex
{
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        NSUInteger totalCount = 0;
        NSError *returnError = nil;
        WCCardSectionModel *cardSectionModel = nil;
        
        do
        {
            //////////////////////////////////////////////////
            
            if(blockOperation.isCancelled==YES)
            {
                returnError = PPErrorOperationCancel(nil);
                
                break;
            }
            
            //////////////////////////////////////////////////
            WCTRCAdvancedSearchVoRequest *advancedSearchVoRequest = [[WCTRCAdvancedSearchVoRequest alloc] init];
            advancedSearchVoRequest.contactRangeType = WCTRC_AdvancedSearchRange_Public;
            advancedSearchVoRequest.pageSize = WCTClientControllerNumberPerPage;
            advancedSearchVoRequest.page = pageIndex;
            advancedSearchVoRequest.sortDirection = WCTRC_ContactSortDirection_Ascending;
            advancedSearchVoRequest.contactSimpleInfoSortField = WCTRC_ContactSortField_CreatedTime;
            advancedSearchVoRequest.advancedSearchInfo = advancedSearchInfo;

            WCTRCAdvancedSearchContactListResposeResult *listResult = [[WCTRestClientController shareRestClientController] advancedSearchWithRequest:advancedSearchVoRequest error:&returnError];
            [advancedSearchVoRequest release];
            //////////////////////////////////////////////////
            
            if(listResult==nil)
            {
                break;
            }
            
            totalCount = listResult.totalCount;
            
            //////////////////////////////////////////////////
            
            // 資料轉換
            
            cardSectionModel = [self cardSectionModelFromContactListpageResponseResult:listResult];
            
            if(cardSectionModel==nil)
            {
                break;
            }
        }
        while (0);
        
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if([self.delegate respondsToSelector:@selector(searchCompanyContactList:totalCount:withError:)]==YES)
            {
                if(cardSectionModel==nil)
                {
                    [self.delegate searchCompanyContactList:nil totalCount:totalCount withError:returnError];
                }
                else
                {
                    [self.delegate searchCompanyContactList:@[cardSectionModel] totalCount:totalCount withError:returnError];
                }
            }
        });
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        [self.workingOperatonQueue addOperation:blockOperation];
    }
}


//================================================================================
//
//================================================================================
- (void)contactListSearchWithSearchText:(NSString *)searchText
{
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        NSError *returnError = nil;
        WCCardSectionModel *cardSectionModel = nil;
        
        WCTRCSearchPublicContactsByKeywordResponseResult *searchContactsByKeywordResponseResult = nil;
        
        do
        {
            if([searchText length]<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            searchContactsByKeywordResponseResult = [[WCTRestClientController shareRestClientController] searchPublicContactsByKeywordWithKeyword:searchText error:&returnError];
            
            //////////////////////////////////////////////////
            
            if(searchContactsByKeywordResponseResult==nil ||
               searchContactsByKeywordResponseResult.data.count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            // 資料轉換
            cardSectionModel = [[[WCCardSectionModel alloc] init] autorelease];
            
            if(cardSectionModel==nil)
            {
                break;
            }
            
            cardSectionModel.cardArray = [NSMutableArray arrayWithCapacity:searchContactsByKeywordResponseResult.data.count];
            
            if(cardSectionModel.cardArray==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            //取得所有名片的下載狀態，配合API需求，紀錄所有帳號 guid
            
            NSMutableArray *contactGuids = [NSMutableArray arrayWithCapacity:searchContactsByKeywordResponseResult.data.count];
            
            for(WCTRCContactSimpleInfo *simpleInfo in searchContactsByKeywordResponseResult.data)
            {
                WCTCompanyCardModel *cardModel = [WCTCompanyCardModel companyCardModelWithContactSimpleInfo:simpleInfo];
                
                if(cardModel==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                if(simpleInfo.isDownloadedToPrivate==YES)
                {
                    cardModel.downloadStatus = WCTCompanyCardModelDownloadStatus_Done;
                }
                else
                {
                    cardModel.downloadStatus = WCTCompanyCardModelDownloadStatus_UnDone;
                }
                
                //////////////////////////////////////////////////
                
                [contactGuids addObject:cardModel.ID];
                [cardSectionModel.cardArray addObject:cardModel];
            }
            
            //////////////////////////////////////////////////
            
            if([contactGuids count]<=0)
            {
                break;
            }
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if([self.delegate respondsToSelector:@selector(searchCompanyContactList:totalCount:withError:)]==YES)
            {
                if(cardSectionModel==nil)
                {
                    [self.delegate searchCompanyContactList:nil totalCount:0 withError:returnError];
                }
                else
                {
                    [self.delegate searchCompanyContactList:@[cardSectionModel] totalCount:cardSectionModel.cardArray.count withError:returnError];
                }
            }
        });
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        [self.workingOperatonQueue addOperation:blockOperation];
    }
}


//================================================================================
//
//================================================================================
- (void)contactListSearchWithKeywordSortedWithKeyword:(NSString *)keyword
                                                 page:(NSUInteger)page
                                             pageSize:(NSUInteger)pageSize
                           contactsimpleinfoSortField:(NSString *)contactsimpleinfoSortField
                                        sortDirection:(NSString *)sortDirection
{
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        NSUInteger totalCount = 0;
        NSError *returnError = nil;
        WCCardSectionModel *cardSectionModel = nil;
        
        WCTRCSearchPublicContactsByKeywordSortedResponseResult *searchPublicContactsByKeywordSortedResponseResult = nil;
        
        do
        {
            if([keyword length]<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            searchPublicContactsByKeywordSortedResponseResult = [[WCTRestClientController shareRestClientController] searchPublicContactsByKeywordSortedWithKeyword:keyword
                                                                                                                                                               page:page
                                                                                                                                                           pageSize:WCTClientControllerNumberPerPage
                                                                                                                                         contactsimpleinfoSortField:contactsimpleinfoSortField
                                                                                                                                                      sortDirection:sortDirection
                                                                                                                                                              error:&returnError];
            
            //////////////////////////////////////////////////
            
            if(searchPublicContactsByKeywordSortedResponseResult==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            totalCount = searchPublicContactsByKeywordSortedResponseResult.totalCount;
            
            if(totalCount<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            // 資料轉換
            cardSectionModel = [[[WCCardSectionModel alloc] init] autorelease];
            
            if(cardSectionModel==nil)
            {
                break;
            }
            
            cardSectionModel.cardArray = [NSMutableArray arrayWithCapacity:searchPublicContactsByKeywordSortedResponseResult.data.count];
            
            if(cardSectionModel.cardArray==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            //取得所有名片的下載狀態，配合API需求，紀錄所有帳號 guid
            
            NSMutableArray *contactGuids = [NSMutableArray arrayWithCapacity:searchPublicContactsByKeywordSortedResponseResult.data.count];
            
            for(WCTRCContactSimpleInfo *simpleInfo in searchPublicContactsByKeywordSortedResponseResult.data)
            {
                WCTCompanyCardModel *cardModel = [WCTCompanyCardModel companyCardModelWithContactSimpleInfo:simpleInfo];
                
                if(cardModel==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                if(simpleInfo.isDownloadedToPrivate==YES)
                {
                    cardModel.downloadStatus = WCTCompanyCardModelDownloadStatus_Done;
                }
                else
                {
                    cardModel.downloadStatus = WCTCompanyCardModelDownloadStatus_UnDone;
                }
                
                //////////////////////////////////////////////////
                
                [contactGuids addObject:cardModel.ID];
                [cardSectionModel.cardArray addObject:cardModel];
            }
            
            //////////////////////////////////////////////////
            
            if([contactGuids count]<=0)
            {
                break;
            }
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if([self.delegate respondsToSelector:@selector(searchCompanyContactList:totalCount:withError:)]==YES)
            {
                if(cardSectionModel==nil)
                {
                    [self.delegate searchCompanyContactList:nil totalCount:totalCount withError:returnError];
                }
                else
                {
                    [self.delegate searchCompanyContactList:@[cardSectionModel] totalCount:totalCount withError:returnError];
                }
            }
        });
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        [self.workingOperatonQueue addOperation:blockOperation];
    }
}





//================================================================================
//
//================================================================================
- (void)deleteContactWithContactGuids:(NSArray *)contactGuids
                      progressHandler:(void(^)(CGFloat progress))progressHandler
                             complete:(void(^)(NSArray <WCTRCGuidWithData *> *errorDataList,NSError *error))complete
{
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        NSError *returnError = nil;
        
        WCTRCPrivateContactDeleteResponseResult *privateContactDeleteResponseResult = nil;
        
        do
        {
            if([contactGuids count]<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            privateContactDeleteResponseResult = [[WCTRestClientController shareRestClientController] deletePrivateContactWithContactGuids:contactGuids
                                                                                                                           progressHandler:progressHandler
                                                                                                                                     error:&returnError];
            
            //////////////////////////////////////////////////
            
            if(privateContactDeleteResponseResult==nil)
            {
                break;
            }
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        [returnError retain];
        
        NSArray *errorDataList = [privateContactDeleteResponseResult.data retain];
        
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(complete!=nil)
            {
                complete(errorDataList,returnError);
            }
            
            
            [returnError release];
            [errorDataList release];
        });
        
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        [self.workingOperatonQueue addOperation:blockOperation];
    }
}


//================================================================================
//
//================================================================================
- (void)shareContactsWithContactGuids:(NSArray *)contactGuids
                       toAccountGuids:(NSArray *)accountGuids
                        shareBehavior:(NSString *)shareBehavior
                      progressHandler:(void(^)(CGFloat progress))progressHandler
                             complete:(void(^)(NSError *error))complete
{
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        NSError *returnError = nil;
        
        do
        {
            if([contactGuids count]<=0 ||
               [accountGuids count]<=0 ||
               [shareBehavior length]<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            WCTRCContactShareAccountRequest *contactShareAccountRequest = [[WCTRCContactShareAccountRequest alloc] init];
            
            if(contactShareAccountRequest==nil)
            {
                break;
            }
            
            contactShareAccountRequest.contactGuids = contactGuids;
            contactShareAccountRequest.accountGuids = accountGuids;
            contactShareAccountRequest.shareBehavior = shareBehavior;
            
            //////////////////////////////////////////////////
            
            [[WCTRestClientController shareRestClientController] contactShareOperationWithContactShareAccountRequest:contactShareAccountRequest
                                                                                                                                         progressHandler:progressHandler                                    error:&returnError];
            
            [contactShareAccountRequest release];
            
            //////////////////////////////////////////////////
            
            if(returnError!=nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            [[WCTRestClientController shareRestClientController] noticeSendShareContacts:contactGuids
                                                                       toReceiveAccounts:accountGuids
                                                                                   error:&returnError];
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        [returnError retain];
        
        dispatch_async(dispatch_get_main_queue(), ^{
            if(complete!=nil)
            {
                complete(returnError);
            }
            
            [returnError release];
        });
    
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        [self.workingOperatonQueue addOperation:blockOperation];
    }
}


//================================================================================
//
//================================================================================
- (void)detailContactWithContactGuid:(NSString *)contactGuid
{
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        NSError *returnError = nil;
        
        WCTRCPrivateContactResponseResult *privateContactResponseResult = nil;
        
        do
        {
            if([contactGuid length]<=0)
            {
                break;
            }
            //////////////////////////////////////////////////
            
            privateContactResponseResult = [[WCTRestClientController shareRestClientController] privateContactWithContactGuid:contactGuid
                                                                                                                        error:&returnError];
            
            //////////////////////////////////////////////////
            
            if(privateContactResponseResult==nil)
            {
                break;
            }
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if([self.delegate respondsToSelector:@selector(detailCompanyContactInfo:withError:)]==YES)
            {
                [self.delegate detailCompanyContactInfo:privateContactResponseResult.data
                                              withError:returnError];
            }
        });
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        [self.workingOperatonQueue addOperation:blockOperation];
    }
}


//================================================================================
//
//================================================================================
- (UIImage *)contactImageWithContactGuid:(NSString *)contactGuid
                               imageType:(NSString *)imageType
                                   error:(NSError **)error
{
    UIImage *image = nil;
    
    do
    {
        if([contactGuid length]<=0 ||
           [imageType length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSData *imageData = [[WCTRestClientController shareRestClientController] privateContactImageDataWithContactGuid:contactGuid
                                                                                                  imageType:imageType
                                                                                                      error:error];
        
        if(imageData==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        image = [UIImage imageWithData:imageData];
    }
    while (0);
    
    return image;
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)categoryListWithError:(NSError **)error
{
    NSString *currentAccountID = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
    return [self categoryListWithAccountGuid:currentAccountID error:error];
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)categoryListWithAccountGuid:(NSString *)accountGuid error:(NSError **)error
{
    NSError *returnError = nil;
    NSMutableArray *validCategoryList = nil;
    
    do
    {
        validCategoryList = [NSMutableArray array];
        
        if(validCategoryList==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        WCTRCMLCategoryInfoListResponseResult *categoryInfoListResponseResult = [[WCTRestClientController shareRestClientController] multiLayerCategoryListWithAccountGuid:accountGuid
                                                                                                                                                                     error:&returnError];
        
        if([categoryInfoListResponseResult data]<=0)
        {
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        // 轉換群組資料
        for(WCTRCCategoryInfoMultiLayer *categoryInfo in categoryInfoListResponseResult.data)
        {
            if([categoryInfo.categoryType compare:WCTRC_CategoryType_Favorite]==NSOrderedSame)
            {
                continue;
            }
            
            //////////////////////////////////////////////////
            
            WCGroupModel *groupModel = [WCGroupModel modelWithWCTRCCategoryInfoMultiLayer:categoryInfo];
            
            if(groupModel!=nil)
            {
                // !! -1表示先不顯示
                groupModel.owner = accountGuid;
                groupModel.cardCount =-1;
                [validCategoryList addObject:groupModel];
            }
        }
        
        // 轉為樹狀
        WCGroupModel *rootModel = [WCGroupModel groupTreeWithGroups:validCategoryList];
        
        //////////////////////////////////////////////////
        // 排序
        rootModel.subGroups = [WCGroupModel sortTreeWithRootGroups:rootModel.subGroups];

        validCategoryList = [NSMutableArray arrayWithArray:rootModel.subGroups];
    }
    while (0);
    
    //////////////////////////////////////////////////

    if(error!=nil)
    {
        *error = returnError;
    }
    
    //////////////////////////////////////////////////

    return validCategoryList;
}


//================================================================================
//
//================================================================================
- (void)contactCategoryOperationWithContactGuids:(NSArray *)contactGuids
                                    catgoryGuids:(NSArray *)categoryGuids
                                 progressHandler:(void(^)(CGFloat progress))progressHandler
                                        complete:(void(^)(NSArray <WCTRCGuidWithData *> *errorDataList,NSError *error))complete
{
    __block NSError *returnError = nil;
    
    do
    {
        if([contactGuids count]<=0)
        {
            returnError = PPErrorParameterInvalidity(returnError);
            
            complete(nil,returnError);
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *behavior = WCTRC_Behavior_Add;
        
        //選到 Other 類別， 使用 OVERRITE + Nil Category 當參數
        if(categoryGuids==nil)
        {
            behavior = WCTRC_Behavior_Overwrite;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCContactSetCategoriesRequest *request = [[WCTRCContactSetCategoriesRequest alloc] init];
        
        if(request==nil)
        {
            break;
        }
        
        request.contactGuids = contactGuids;
        request.behavior = behavior;
        
        if([request.behavior compare:WCTRC_Behavior_Add]==NSOrderedSame)
        {
            request.categoryGuids = categoryGuids;
        }
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            WCTRCPrivateContactOperateCategoryResponseResult *result = [[WCTRestClientController shareRestClientController] privateContactOperateCategoryWithContactSetCategoriesRequest:request
                                                                                                                                                                         progressHandler:progressHandler
                                                                                                                                                                                   error:&returnError];
            
            NSArray *errorDataList = [result.data retain];

            [request release];
            
            [returnError retain];
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                complete(errorDataList,returnError);
                
                [errorDataList release];
                
                [returnError release];
            });
        });
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)setContactOwnerWithContactGuids:(NSArray *)contactGuids
                              ownerGuid:(NSString *)ownerGuid
                        progressHandler:(void(^)(CGFloat progress))progressHandler
                               complete:(void(^)(NSArray <WCTRCGuidWithData *> *errorDataList,NSError *error))complete
{
    __block NSError *returnError = nil;
    
    do
    {
        if([contactGuids count]<=0 ||
           [ownerGuid length]<=0)
        {
            returnError = PPErrorParameterInvalidity(returnError);
        
            if(complete!=nil)
            {
                complete(nil,returnError);
            }
        
            break;
        }
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            WCTRCSetOwnerOfContactResponseResult *result = [[WCTRestClientController shareRestClientController] setContactOwnerWithContactGuids:contactGuids newOwnerAccountGuid:ownerGuid progressHandler:progressHandler error:&returnError];
        
            [returnError retain];
        
            NSArray *errorDataList = [result.data retain];
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if(complete!=nil)
                {
                    complete(errorDataList,returnError);
                }
                
                [errorDataList release];
                [returnError release];
            });
        });
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (NSArray *)contactCustomFieldsWithError:(NSError **)error
{
    NSMutableArray *customFields = nil;
    
    NSError *returnError = nil;
    
    do
    {
        customFields = [NSMutableArray array];
        
        if(customFields==nil)
        {
            returnError = PPErrorParameterInvalidity(returnError);
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCCustomFieldListResponseResult *result = [[WCTRestClientController shareRestClientController] customFieldsWithCategory:WCTRC_CustomField_Category_Contact
                                                                                                                             error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
        
        
        for (WCTRCCustomFieldInfo *customFieldInfo in result.data)
        {
            WCCustomFieldInfo *localCustomFieldInfo = [WCCustomFieldInfo customFieldInfoWithWCTRCCustomFieldInfo:customFieldInfo];
            
            
            if(localCustomFieldInfo==nil)
            {
                returnError = PPErrorParameterInvalidity(returnError);
                
                break;
            }
            
            //////////////////////////////////////////////////
            
            [customFields addObject:localCustomFieldInfo];
        }
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil)
    {
        *error = returnError;
    }
    
    return customFields;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTCompanyGroupSelectVeiController data


//==============================================================================
//
//==============================================================================
- (WCGroupModel *)allSharedContactGroupModel
{
    WCGroupModel *rootModel = [[WCGroupModel alloc] init];
    rootModel.name = WCTCCV_MLS_AllCompanySharedContacts;
    rootModel.owner = @"";
    rootModel.guid = @"";
    rootModel.editable = NO;
    rootModel.cardCount = -1;
    
    return [rootModel autorelease];
}


//==============================================================================
//
//==============================================================================
- (WCGroupModel *)undownloadGroupModelWithAccountGuid:(NSString *)accountGuid
{
    WCGroupModel *undownloadGroupModel = [[WCGroupModel alloc] init];
    undownloadGroupModel.name = WCTCCV_MLS_Undownload;
    undownloadGroupModel.ID = WC_GID_Undownload;
    undownloadGroupModel.guid = WCTCompanyContactUndownloadCategoryGuid;
    undownloadGroupModel.owner = accountGuid;
    undownloadGroupModel.editable = NO;
    undownloadGroupModel.cardCount = -1;
    
    //////////////////////////////////////////////////
    // 取得未下載個數
    NSError *returnError = nil;
    WCTRCSharedContactNumberIsntAccountCategoryResponseResult *result = [[WCTRestClientController shareRestClientController] sharedContactNumberIsntAccountCategoryWithAccountGuid:accountGuid error:&returnError];
    
    if (returnError==nil)
    {
        undownloadGroupModel.cardCount = result.data;
    }
    return [undownloadGroupModel autorelease];
}

//==============================================================================
//
//==============================================================================
- (NSMutableArray *)accountTreeListWithError:(NSError **)error
{
    NSError *returnError = nil;
    NSMutableArray *accountTree = nil;
    WCTRCSharedAccountsResponseResult *viewResult = [[WCTRestClientController shareRestClientController] shareAccountsWithError:&returnError];
    if (viewResult!=nil && returnError==nil)
    {
        NSMutableArray *viewAccounts = [NSMutableArray array];
        NSUInteger allCompanyContactCount = -1;
        WCGroupModel *selfAccountModel = nil;
        NSString *selfAccountGuid = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
        
        for (NSInteger index=0; index<viewResult.data.count; index++)
        {
            @autoreleasepool
            {
                WCTRCContactSharedAccountsInfo *accountInfo = [viewResult.data objectAtIndex:index];
                
                // 用groupModel來放account
                WCGroupModel *accountModel = [[WCGroupModel alloc] init];
                accountModel.name = accountInfo.accountName;
                accountModel.cardCount = accountInfo.sharedContactCount;
                accountModel.owner = accountInfo.accountGuid;
                // !!guid用空字串表示抓全部
                accountModel.guid = @"";
                accountModel.editable = NO;

                if(accountInfo.sharedContactCount!=-1)
                {
                    // 有可檢視用戶allCompanyContactCount才會有值，才要設為0開始計算
                    if(allCompanyContactCount==-1)
                    {
                        allCompanyContactCount = 0;
                    }
                    
                    allCompanyContactCount+=accountInfo.sharedContactCount;
                }
                
                if ([accountModel.owner isEqualToString:selfAccountGuid]==NO)
                {
                    [viewAccounts addObject:accountModel];
                }
                else
                {
                    selfAccountModel = [accountModel retain];
                }
                [accountModel release];
            }
        }
        
        
        [viewAccounts sortUsingComparator:^NSComparisonResult(WCGroupModel *obj1, WCGroupModel *obj2) {
            
            return [obj1.name unicodeCompare:obj2.name];
        }];
        
        //////////////////////////////////////////////////
        // 加入自已
        if (selfAccountModel)
        {
            [viewAccounts insertObject:selfAccountModel atIndex:0];
            [selfAccountModel release];
        }
        
        //////////////////////////////////////////////////
        // 加入所有共享聯絡人
        WCGroupModel *rootModel = [self allSharedContactGroupModel];
        rootModel.cardCount = allCompanyContactCount;
        [rootModel.subGroups addObjectsFromArray:viewAccounts];
        
        accountTree = [NSMutableArray arrayWithObject:rootModel];
    }
    
    if (error!=NULL)
    {
        *error = returnError;
    }
    return accountTree;
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)groupArrayWithAccountGuid:(NSString *)accountGuid error:(NSError**)error
{
    NSError *returnErorr = nil;
    NSMutableArray *groupArray = [self categoryListWithAccountGuid:accountGuid error:&returnErorr];
    
    if (returnErorr)
    {
        if (error!=nil)
        {
            *error = returnErorr;
        }
        return nil;
    }
    

    //////////////////////////////////////////////////
    //加入未下載
    WCGroupModel *undownloadGroupModel = [self undownloadGroupModelWithAccountGuid:accountGuid];
    [groupArray addObject:undownloadGroupModel];
    
    // sort, 其他已sort, 只有這一層再sort一次就好
    BOOL forEnglish = YES;
    
    switch([PPSystemInfoController language])
    {
        case PPSystemInfoLanguage_ChineseTraditional:
        case PPSystemInfoLanguage_ChineseSimplified:
        case PPSystemInfoLanguage_Korean:
        case PPSystemInfoLanguage_Japanese:
            forEnglish = NO;
            break;
            
        default:
            break;
    }
    
    groupArray = [WCGroupModel defaultSortedGroupsWithCurrentGroups:groupArray forEnglish:forEnglish onlySortSystemGroup:NO];
    return groupArray;
}


//==============================================================================
//
//==============================================================================
- (NSDictionary <NSString*, NSNumber *> *)sharedContactNumberWithCategoryGuids:(NSArray <NSString *>*)categoryGuids ownerGuid:(NSString *)ownerGuid error:(NSError **)error
{
    NSError *returnError = nil;
    NSMutableDictionary *sharedContactNumberList = [NSMutableDictionary dictionary];
    WCTRCMLCategorySharedContactNumberWithCategoryGuidsResponseResult *result = [[WCTRestClientController shareRestClientController] sharedContactNumberWithCategoryGuids:categoryGuids
                                                                                                                                                        categoryOwnerGuid:ownerGuid
                                                                                                                                                                    error:&returnError];
    if (result!=nil && returnError==nil)
    {
        for (WCTRCGuidWithData *guidWithData in result.data)
        {            
            [sharedContactNumberList setValue:@([guidWithData.data integerValue]) forKey:guidWithData.guid];
        }
        
    }
    
    if (error!=NULL)
    {
        *error = returnError;
    }
    
    if ([sharedContactNumberList count]==0)
    {
        return nil;
    }
    return sharedContactNumberList;
}


//==============================================================================
//
//==============================================================================
- (BOOL)shouldShowSimplifyUIWithError:(NSError **)error
{
    return [[WCTRestClientController shareRestClientController] isSimplifyUIWithError:error];
}


//==============================================================================
// 取All category的count + uncategory的 count
//==============================================================================
- (NSInteger)sharedContactNumberWithOwnerGuid:(NSString *)ownerGuid error:(NSError **)error
{
    NSError *returnError = nil;
    NSInteger sharedContactNumber = -1;
    do
    {
        //////////////////////////////////////////////////
        NSString *guidOfAll = nil;
        
        WCTRCMLCategoryInfoListResponseResult *categoryInfoListResponseResult = [[WCTRestClientController shareRestClientController] multiLayerCategoryListWithAccountGuid:ownerGuid
                                                                                                                                                                     error:&returnError];
        
        if([categoryInfoListResponseResult data]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // 轉換群組資料
        for(WCTRCCategoryInfoMultiLayer *categoryInfo in categoryInfoListResponseResult.data)
        {
            if([categoryInfo.categoryType compare:WCTRC_CategoryType_All]==NSOrderedSame)
            {
                guidOfAll = categoryInfo.guid;
                break;
            }
        }

        if([guidOfAll length]==0)
        {
            returnError = PPErrorParameterInvalidity(nil);
            break;
        }
        
        
        NSDictionary *cardCountDict = [self sharedContactNumberWithCategoryGuids:@[guidOfAll] ownerGuid:ownerGuid error:&returnError];
        
        if (returnError)
        {
            break;
        }
        
        sharedContactNumber = [(NSNumber *)[cardCountDict objectForKey:guidOfAll] integerValue];
        //////////////////////////////////////////////////
        WCGroupModel *uncategory = [self undownloadGroupModelWithAccountGuid:ownerGuid];
        
        sharedContactNumber += uncategory.cardCount;
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil)
    {
        *error = returnError;
    }
    
    //////////////////////////////////////////////////
    return sharedContactNumber;
}


@end
