//
//  WCTCompanyContactAccessFlowDelegateController.m
//
//
//  Created by Howard on 2016/5/27.
//
//

#import "WCTCompanyContactAccessFlowDelegateController.h"

// Define
#import "WCTSettingsKey.h"
#import "WCSettingsKey.h"

// Controller
#import "WCContactAccessFlowController.h"
#import "WCTAccountDataController.h"
#import "WCTCompanyContactFetchDataController.h"
#import "WCMakeVirtualCardController.h"

#import "WCFieldTypeConverter.h"
#import "PPSettingsController.h"

// Model
#import "WCTAccountRelationModel.h"

// Category
#import "WCCardModel+WCTRCContactInfo.h"

@interface WCTCompanyContactAccessFlowDelegateController()

@property (nonatomic,retain) WCContactAccessFlowController *contactAccessFlowController;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCTCompanyContactAccessFlowDelegateController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountDictionary release];
    _accountDictionary = nil;
    
    [_contactAccessFlowController release];
    _contactAccessFlowController = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCContactAccessFlowController Delegate Method


//================================================================================
//
//================================================================================
- (WCDisplayNameOrder)nameOrderForContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isEasternName:(BOOL)isEasternName
{
    WCDisplayNameOrder nameOrder = (WCDisplayNameOrder)[PPSettingsController integerValueWithKey:WCSC_IV_kEasternNameOrder];
    
    if(isEasternName==NO)
    {
        nameOrder = (WCDisplayNameOrder)[PPSettingsController integerValueWithKey:WCSC_IV_kWesternNameOrder];
    }
    
    return nameOrder;
}


//================================================================================
//
//================================================================================
- (NSArray *)supportRecognizeLangugaesForContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 辨識語系
    return nil;
}


//================================================================================
//
//================================================================================
- (NSArray *)supportRecognizeFieldTypesForContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 辨識欄位
    return nil;
}


//================================================================================
//
//================================================================================
- (NSData *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardImageDataWithCardID:(NSString*)cardID imageType:(WC_ImageType)imageType
{
    // TODO: 名片圖的data
    
    return nil;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController allGroupModelsWithCardID:(NSString *)cardID
{
    // MARK: 群組選擇
    return nil;
}


//================================================================================
//
//================================================================================
- (WCCardModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                    clipRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                           originalCardModel:(WCCardModel *)originalCardModel
                                       error:(NSError **)error
{
    // MARK: 手括辨識
    return nil;
}


//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController groupNamesWithGroupIDArray:(NSArray *)groupIDArray
{
    // MARK: 群組名稱
    
    return  nil;
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isExistGroupNamed:(NSString*)groupNamed;
{
    // MARK: 群組存不存在
    
    return NO;
}


//================================================================================
//
//================================================================================
- (WCGroupModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController groupModelByNewGroupName:(NSString *)groupName;
{
    // MARK: 新增群組
    return nil;
}


//================================================================================
//
//================================================================================
- (NSArray *)contactAccessFlowControllerRequestDefaultGroupIDArray:(WCContactAccessFlowController *)contactAccessFlowController
{
    return nil;
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isCardIDExist:(NSString *)cardID
{
    BOOL result = NO;
    
    do
    {
        if([contactAccessFlowController.userInfo respondsToSelector:@selector(guid)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *existCardID = [contactAccessFlowController.userInfo performSelector:@selector(guid)];
        
        if(existCardID==nil || existCardID.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([existCardID compare:cardID options:NSCaseInsensitiveSearch]==NSOrderedSame)
        {
            result = YES;
        }
    }
    while (0);
    
    
    return result;
}


//================================================================================
//
//================================================================================
- (WCCardModel *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardModelWithCardID:(NSString *)cardID;
{
    // MARK: 回傳名片資料
    
    WCCardModel *cardModel = nil;
    
    do
    {
        if([contactAccessFlowController respondsToSelector:@selector(userInfo)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        id userInfo = [contactAccessFlowController performSelector:@selector(userInfo)];
        
        if(userInfo==nil ||
           [userInfo isKindOfClass:[WCTRCContactInfo class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCContactInfo *contactInfo = userInfo;
        
        //////////////////////////////////////////////////
        
        cardModel = [WCCardModel modelWithWCTRCContactInfo:contactInfo];
        
        //////////////////////////////////////////////////
        
        // !!過濾自己的流程要移掉，不然在看可檢視時，自己會不見
        // MARK: Howard, 把自已的 accountGuid 濾掉，不然進連絡人檢視頁面，可檢視帳號會重覆
//        NSMutableArray *accountGuids = [NSMutableArray array];
//        
//        if(accountGuids!=nil)
//        {
//            NSString *loginAccountGuid = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
//            
//            for(WCTRCAccountLessInfo *accountLessInfo in contactInfo.beSharedAccounts)
//            {
//                if([accountLessInfo.guid compare:loginAccountGuid]==NSOrderedSame)
//                {
//                    continue;
//                }
//                
//                //////////////////////////////////////////////////
//                
//                [accountGuids addObject:accountLessInfo.guid];
//            }
//            
//            //////////////////////////////////////////////////
//            
//            cardModel.sharedAccountGUIDArray = accountGuids;
//        }
    }
    while (0);
    
    return cardModel;
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController isFavoriteWithCardID:(NSString *)cardID;
{
    // MARK: 我的最愛
    
    BOOL favorite = NO;
    
    do
    {
        if([contactAccessFlowController respondsToSelector:@selector(userInfo)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        id userInfo = [contactAccessFlowController performSelector:@selector(userInfo)];
        
        if(userInfo==nil ||
           [userInfo isKindOfClass:[WCTRCContactInfo class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCContactInfo *contactInfo = userInfo;
        
        favorite = contactInfo.beFavorite;
    }
    while (0);
    
    return favorite;
}


//==============================================================================
//
//==============================================================================
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController noteWithCardID:(NSString *)cardID
{
    // MARK: note
    NSString *noteString = nil;
    do
    {
        if([contactAccessFlowController respondsToSelector:@selector(userInfo)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        id userInfo = [contactAccessFlowController performSelector:@selector(userInfo)];
        
        if(userInfo==nil ||
           [userInfo isKindOfClass:[WCTRCContactInfo class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCContactInfo *contactInfo = userInfo;
        
        noteString = contactInfo.note;
    }
    while (0);
    
    return noteString;
}

//================================================================================
//
//================================================================================
- (UIImage *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController cardImageWithCardID:(NSString*)cardID imageType:(WC_ImageType)imageType;
{
    // MARK: 名片圖
    UIImage *image = nil;
    
    do
    {
        if([contactAccessFlowController respondsToSelector:@selector(userInfo)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        id userInfo = [contactAccessFlowController performSelector:@selector(userInfo)];
        
        if(userInfo==nil ||
           [userInfo isKindOfClass:[WCTRCContactInfo class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        BOOL imageExist = NO;
        
        WCTRCContactInfo *contactInfo = userInfo;
        
        NSArray *imageInfos = contactInfo.images;
        
        // 開始檢查有無此張圖片
        
        for(WCTRCContactImageInfo *imageInfo in imageInfos)
        {
            // sha1 為空，代表沒有圖
            if([imageInfo.sha1 length]<=0)
            {
                continue;
            }
            
            //////////////////////////////////////////////////

            if(imageType==WC_IT_IDPhoto &&
               [imageInfo.type compare:WCTRC_ImageType_Logo]==NSOrderedSame)
            {
                imageExist = YES;
                
                break;
            }
            else if(imageType==WC_IT_BackSide &&
                    [imageInfo.type compare:WCTRC_ImageType_Rear]==NSOrderedSame)
            {
                imageExist = YES;
                
                break;
            }
            else if(imageType==WC_IT_FrontSide &&
                    [imageInfo.type compare:WCTRC_ImageType_Front]==NSOrderedSame)
            {
                imageExist = YES;
                
                break;
            }
        }
        
        if(imageExist==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // 連線取得圖片
        switch (imageType)
        {
            case WC_IT_BackSide:
            {
                if(image==nil)
                {
                    image = [[WCTCompanyContactFetchDataController shareInstance] contactImageWithContactGuid:cardID
                                                                                                    imageType:WCTRC_ImageType_Rear
                                                                                                        error:nil];
                }
                
                break;
            }
            case WC_IT_FrontSide:
            {
                image = [[WCTCompanyContactFetchDataController shareInstance] contactImageWithContactGuid:cardID
                                                                                                imageType:WCTRC_ImageType_Front
                                                                                                    error:nil];
                break;
            }
            case WC_IT_IDPhoto:
            {
                image = [[WCTCompanyContactFetchDataController shareInstance] contactImageWithContactGuid:cardID
                                                                                                imageType:WCTRC_ImageType_Logo
                                                                                                    error:nil];
                break;
            }
            default:
            {
                break;
            }
        }

    }
    while (0);
    
    return image;
}


//==============================================================================
// MARK: 假名片圖
//==============================================================================
- (UIImage *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController virtualCardImageWithCardID:(NSString*)cardID
{
    UIImage *image = nil;
    do
    {
        if([cardID length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([contactAccessFlowController respondsToSelector:@selector(userInfo)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        id userInfo = [contactAccessFlowController performSelector:@selector(userInfo)];
        
        if(userInfo==nil ||
           [userInfo isKindOfClass:[WCTRCContactInfo class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCContactInfo *contactInfo = userInfo;
        
        //////////////////////////////////////////////////
        
        WCCardModel *cardModel = [WCCardModel modelWithWCTRCContactInfo:contactInfo];
        
        if(cardModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        //--------------------------------
        // 建立假名片圖
        //--------------------------------
        @autoreleasepool
        {
            UIImage *IDPhoto = [[WCTCompanyContactFetchDataController shareInstance] contactImageWithContactGuid:cardID
                                                                                                       imageType:WCTRC_ImageType_Logo
                                                                                                           error:nil];
            
            //////////////////////////////////////////////////
            // 產生假名片
            WCMakeVirtualCardController  *makeVirtualCardController = [[WCMakeVirtualCardController alloc] init];
            
            if(makeVirtualCardController==nil)
            {
                break;
            }
            
            makeVirtualCardController.headImage = IDPhoto;
            makeVirtualCardController.cardModel = cardModel;
            
            image = [[makeVirtualCardController virtualCardImage] retain];
            [makeVirtualCardController release];

        }
    }
    while (0);
    
    return [image autorelease];
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
               phoneticArrayWithClickedPhonetic:(NSString *)phonetic
                                    sourceValue:(NSString *)sourceValue
                              isCompanyPhonetic:(BOOL)isCompanyPhonetic
{
    // MARK: 讀音
    return nil;
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                             action:(WCContactFlowControllerAction)action
                         withCardID:(NSString *)cardID
                              error:(NSError **)error
{
    // MARK: 動作
    
    //////////////////////////////////////////////////
    
    switch (action)
    {
        case WCContactFlowControllerAction_Delete:
        {
            // 新增連絡人不會刪除
            break;
        }
        case WCContactFlowControllerAction_SetBackFieldAsFront:
        {
            break;
        }
        case WCContactFlowControllerAction_SetBackFieldAsManul:
        {
            break;
        }
        case WCContactFlowControllerAction_SetFrontFieldAsManul:
        {
            break;
        }
        case WCContactFlowControllerAction_SwitchFavorite:
        {
            // TODO: 新增連絡人至我的最愛
            break;
        }
        case WCContactFlowControllerAction_EditSuccessful:
        {
            
            break;
        }
        case WCContactFlowControllerAction_GoBack:
        {
            
            break;
        }
        default:
        {
            break;
        }
    }
    
    return YES;
}


//================================================================================
//
//================================================================================
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                    updateCardModel:(WCCardModel *)cardModel
                     withABSourceID:(NSString *)abSourceID
                          abGroupID:(NSString *)abGroupID
                         abPersonID:(NSString *)abPersonID
                              error:(NSError **)error
{
    // MARK: 更新名片資訊
}


//================================================================================
//
//================================================================================
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                    updateCardImage:(UIImage *)cardImage
                         withCardID:(NSString *)cardID
                          imageType:(WC_ImageType)imageType
                              error:(NSError **)error
{
    // MARK: 更新名片圖
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController hasCardImageWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType
{
    BOOL existCardImage = NO;
    
    switch (imageType)
    {
        case WC_IT_BackSide:
        {
            
            break;
        }
        case WC_IT_FrontSide:
        {
            
            break;
        }
        case WC_IT_IDPhoto:
        {
            break;
        }
        default:
        {
            break;
        }
    }
    
    return existCardImage;
}


//================================================================================
//
//================================================================================
- (BOOL)autoFormatPhoneNumberWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 自動電話格式化
    BOOL result = NO;
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)appendCountryCodeWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 電話加上國碼
    BOOL result = NO;
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSInteger)contactAccessFlowControllerRequestFrontRecogLang:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 正面名片圖語系
    //    return [PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
    
    return 0;
}

//================================================================================
//
//================================================================================
- (NSInteger)contactAccessFlowControllerRequestBackRecogLang:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 反面名片圖語系
    //    return [PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage];
    return 0;
}


//================================================================================
//
//================================================================================
- (NSInteger)contactAccessFlowControllerRequestOutputTranslate:(WCContactAccessFlowController *)contactAccessFlowController
{
    // MARK: 中文名片輸出
    return 0;
}


//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowControllerRequestEnableSaveToiPhoneContact:(WCContactAccessFlowController *)contactAccessFlowController;
{
    return NO;
}


//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowControllerRequestDefaultABSourceID:(WCContactAccessFlowController *)contactAccessFlowController;
{
    return nil;
}


//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowControllerRequestDefaultABGroupID:(WCContactAccessFlowController *)contactAccessFlowController
{
    return nil;
}


//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowControllerRequestGoogleSyncAccount:(WCContactAccessFlowController *)contactAccessFlowController
{
    return nil;
}


//================================================================================
// MARK:取得所有帳號列表
//================================================================================
- (NSArray *)allAccountsWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    NSError *returnError = nil;
    NSArray *accountList = [WCTAccountDataController allAccountListWithError:&returnError];
    
    if(returnError!=nil)
    {
        // 取得帳號列表， returnError 處理
    }
    
    return accountList;
}

//================================================================================
// MARK: card id取得名片所屬的owner guid
//================================================================================
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
               requestOwnerGuidWithCardID:(NSString *)cardID
{
    NSString *ownerGuid = nil;
    
    do
    {
        if([contactAccessFlowController respondsToSelector:@selector(userInfo)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        id userInfo = [contactAccessFlowController performSelector:@selector(userInfo)];
        
        if(userInfo==nil ||
           [userInfo isKindOfClass:[WCTRCContactInfo class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCContactInfo *contactInfo = userInfo;
        
        ownerGuid = contactInfo.ownerGuid;
    }
    while(0);
    
    return ownerGuid;
}


//================================================================================
// MARK: 依card id取得可檢視用戶
//================================================================================
- (NSArray *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
      requestSharedAccountGuidWithCardID:(NSString *)cardID
{
    return nil;
}


//================================================================================
// MARK: 通知選取的可檢視用戶
//================================================================================
- (void)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
          updateVisibleAccountGuids:(NSArray *)visibleAccountGuids
                         withCardID:(NSString *)cardID
{
    
}


//================================================================================
//
//================================================================================
- (NSString *)selfAccountGuidWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    return [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
}


//================================================================================
//
//================================================================================
- (NSString *)bossAccountGuidWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
{
    NSString *bossGuid = nil;
    
    for(id key in self.accountDictionary)
    {
        WCTAccountRelationModel *accountReleationModel = [self.accountDictionary objectForKey:key];
        
        if(accountReleationModel!=nil &&
           accountReleationModel.relation==WCTAccountRelationModel_Relation_Boss)
        {
            bossGuid = accountReleationModel.guid;
            break;
        }
    }
    
    
    return bossGuid;
}


//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                  requestRelationWithGuid:(NSString *)guid
{
    NSString *relation = nil;
    
    WCTAccountRelationModel *accountReleationModel = [self.accountDictionary objectForKey:guid];
    
    if(accountReleationModel!=nil)
    {
        relation = (accountReleationModel.relation==WCTAccountRelationModel_Relation_Boss)?@"Boss":@"";
    }
    
    return relation;
}

//================================================================================
//
//================================================================================
- (NSString *)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
               requestAccountNameWithGuid:(NSString *)guid
{
    NSString *accountName = nil;
    WCTAccountRelationModel *accountReleationModel = nil;
    
    accountReleationModel = [self.accountDictionary objectForKey:guid];
    
    if(accountReleationModel!=nil)
    {
        accountName = accountReleationModel.name;
    }
    
    return accountName;
}


//================================================================================
// MARK: 取得所有自訂欄位 array of WCCustomFieldInfo
//================================================================================
- (NSArray *)contactAccessFlowControllerRequestCustomFieldInfos:(WCContactAccessFlowController *)contactAccessFlowController
{
    NSError *returnError = nil;
    
    NSArray *customFieldInfos = [[WCTCompanyContactFetchDataController shareInstance] contactCustomFieldsWithError:&returnError];
    
    
    return customFieldInfos;
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showContactInfoViewControllerWithDetailContactInfo:(WCTRCContactInfo *)detailContactInfo fromSuperViewController:(PPViewController *)superViewController
{
    do
    {
        if(superViewController==nil ||
           detailContactInfo==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.contactAccessFlowController = [[[WCContactAccessFlowController alloc] init] autorelease];
        
        self.contactAccessFlowController.userInfo = detailContactInfo;
        self.contactAccessFlowController.isInfoNeedShowGroup = NO;
        
        //////////////////////////////////////////////////
        
        [self.contactAccessFlowController showContactInfoFromViewController:superViewController
                                                        currentContactIndex:0
                                                             contactIDArray:@[detailContactInfo.guid]
                                                             interfaceStyle:ContactInfoViewControllerInterfaceStyle_CompanyContacts
                                                             needFullScreen:(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPhone)
                                                                   delegate:self];
    }
    while (0);
}


@end
